/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import b.a.lb;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.engine.managerThread.DebuggerCommand;
import com.intellij.debugger.engine.managerThread.DebuggerManagerThread;
import com.intellij.debugger.engine.managerThread.SuspendContextCommand;
import com.intellij.debugger.impl.InvokeAndWaitThread;
import com.intellij.debugger.impl.InvokeThread;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorListenerAdapter;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.sun.jdi.VMDisconnectedException;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class DebuggerManagerThreadImpl
extends InvokeAndWaitThread<DebuggerCommandImpl>
implements DebuggerManagerThread,
Disposable {
    private static final Logger e;
    static final int COMMAND_TIMEOUT = 3000;
    private volatile boolean d;
    private static final long f;

    DebuggerManagerThreadImpl(@NotNull Disposable parent, Project project2) {
        if (parent == null) {
            DebuggerManagerThreadImpl.b(0);
        }
        super(project2);
        Disposer.register((Disposable)parent, (Disposable)this);
    }

    public void dispose() {
        this.d = true;
    }

    public static DebuggerManagerThreadImpl createTestInstance(@NotNull Disposable parent, Project project2) {
        if (parent == null) {
            DebuggerManagerThreadImpl.b(1);
        }
        return new DebuggerManagerThreadImpl(parent, project2);
    }

    public static boolean isManagerThread() {
        return DebuggerManagerThreadImpl.currentThread() instanceof DebuggerManagerThreadImpl;
    }

    public static void assertIsManagerThread() {
        long l2 = f ^ 0x6D8DAC5D54DAL;
        e.assertTrue(DebuggerManagerThreadImpl.isManagerThread(), (Object)"Should be invoked in manager thread, use DebuggerManagerThreadImpl.getInstance(..).invoke...");
    }

    @Override
    public void invokeAndWait(DebuggerCommandImpl managerCommand) {
        long l2 = f ^ 0x677B11E6F793L;
        e.assertTrue(!DebuggerManagerThreadImpl.isManagerThread(), (Object)"Should be invoked outside manager thread, use DebuggerManagerThreadImpl.getInstance(..).invoke...");
        super.invokeAndWait(managerCommand);
    }

    public void invoke(DebuggerCommandImpl managerCommand) {
        if (DebuggerManagerThreadImpl.currentThread() == this) {
            this.processEvent(managerCommand);
        } else {
            this.schedule(managerCommand);
        }
    }

    public void invoke(PrioritizedTask.Priority priority, final Runnable runnable) {
        this.invoke(new DebuggerCommandImpl(priority){

            @Override
            protected void action() {
                runnable.run();
            }
        });
    }

    @Override
    public boolean pushBack(DebuggerCommandImpl managerCommand) {
        boolean bl2 = super.pushBack(managerCommand);
        if (!bl2) {
            managerCommand.notifyCancelled();
        }
        return bl2;
    }

    public void schedule(PrioritizedTask.Priority priority, final Runnable runnable) {
        this.schedule(new DebuggerCommandImpl(priority){

            @Override
            protected void action() {
                runnable.run();
            }
        });
    }

    @Override
    public boolean schedule(DebuggerCommandImpl managerCommand) {
        boolean bl2 = super.schedule(managerCommand);
        if (!bl2) {
            managerCommand.notifyCancelled();
        }
        return bl2;
    }

    public void terminateAndInvoke(DebuggerCommandImpl command, int terminateTimeoutMillis) {
        DebuggerCommandImpl debuggerCommandImpl = (DebuggerCommandImpl)this.myEvents.getCurrentEvent();
        this.invoke(command);
        if (debuggerCommandImpl != null) {
            AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> {
                if (debuggerCommandImpl == this.myEvents.getCurrentEvent()) {
                    this.getCurrentRequest().requestStop();
                    try {
                        this.getCurrentRequest().join();
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(exception);
                    }
                    finally {
                        if (!this.d) {
                            this.startNewWorkerThread();
                        }
                    }
                }
            }, (long)terminateTimeoutMillis, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void processEvent(@NotNull DebuggerCommandImpl managerCommand) {
        if (managerCommand == null) {
            DebuggerManagerThreadImpl.b(2);
        }
        DebuggerManagerThreadImpl.assertIsManagerThread();
        try {
            if (this.myEvents.isClosed()) {
                managerCommand.notifyCancelled();
            } else {
                managerCommand.run();
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            e.debug((Throwable)vMDisconnectedException);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
        catch (Exception exception) {
            e.error((Throwable)exception);
        }
    }

    public void startProgress(final DebuggerCommandImpl command, ProgressWindow progressWindow) {
        new ProgressIndicatorListenerAdapter(){

            public void cancelled() {
                command.release();
            }
        }.installToProgress((ProgressIndicatorEx)progressWindow);
        ApplicationManager.getApplication().executeOnPooledThread(() -> ProgressManager.getInstance().runProcess(() -> this.invokeAndWait(command), (ProgressIndicator)progressWindow));
    }

    void startLongProcessAndFork(Runnable process2) {
        long l2 = f ^ 0x7BFF2409104CL;
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.startNewWorkerThread();
        try {
            process2.run();
        }
        catch (Throwable throwable) {
            InvokeThread.WorkerThreadRequest workerThreadRequest = DebuggerManagerThreadImpl.getCurrentThreadRequest();
            if (e.isDebugEnabled()) {
                e.debug("Switching back to " + workerThreadRequest);
            }
            super.invokeAndWait(new DebuggerCommandImpl(workerThreadRequest){
                final /* synthetic */ InvokeThread.WorkerThreadRequest val$request;
                private static final long c = lb.a(8164588874086006237L, 290740029343775851L, MethodHandles.lookup().lookupClass()).a(185090090594401L);
                {
                    this.val$request = workerThreadRequest;
                }

                @Override
                protected void action() {
                    DebuggerManagerThreadImpl.this.switchToRequest(this.val$request);
                }

                @Override
                protected void commandCancelled() {
                    long l2 = c ^ 0xDE5EDA82FAAL;
                    e.debug("Event queue was closed, killing request");
                    this.val$request.requestStop();
                }
            });
            throw throwable;
        }
        InvokeThread.WorkerThreadRequest workerThreadRequest = DebuggerManagerThreadImpl.getCurrentThreadRequest();
        if (e.isDebugEnabled()) {
            e.debug("Switching back to " + workerThreadRequest);
        }
        super.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
    }

    public void invokeCommand(final DebuggerCommand command) {
        if (command instanceof SuspendContextCommand) {
            SuspendContextCommand suspendContextCommand = (SuspendContextCommand)command;
            this.schedule(new SuspendContextCommandImpl((SuspendContextImpl)suspendContextCommand.getSuspendContext()){
                private static final long e = lb.a(-2347066351887163957L, -7423411761686698981L, MethodHandles.lookup().lookupClass()).a(134840090051596L);

                @Override
                public void contextAction(@NotNull SuspendContextImpl suspendContext) {
                    if (suspendContext == null) {
                        5.b(0);
                    }
                    command.action();
                }

                @Override
                protected void commandCancelled() {
                    command.commandCancelled();
                }

                private static /* synthetic */ void b(int n2) {
                    long l2 = e ^ 0x3DBF2F781B12L;
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/engine/DebuggerManagerThreadImpl$5", "contextAction"));
                }
            });
        } else {
            this.schedule(new DebuggerCommandImpl(){

                @Override
                protected void action() {
                    command.action();
                }

                @Override
                protected void commandCancelled() {
                    command.commandCancelled();
                }
            });
        }
    }

    void restartIfNeeded() {
        if (this.myEvents.isClosed()) {
            this.myEvents.reopen();
            this.startNewWorkerThread();
        }
    }

    static {
        f = lb.a(-8988379814772592168L, 7460638510329793344L, MethodHandles.lookup().lookupClass()).a(17742973490614L);
        e = Logger.getInstance(DebuggerManagerThreadImpl.class);
    }

    private static /* synthetic */ void b(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = f ^ 0x3B99CB7CD0CL;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "managerCommand";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/engine/DebuggerManagerThreadImpl";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createTestInstance";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "processEvent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

