/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import b.a.lb;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.PositionManager;
import com.intellij.debugger.PositionManagerFactory;
import com.intellij.debugger.engine.AsyncStacksUtils;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.MethodFilter;
import com.intellij.debugger.engine.NamedMethodFilter;
import com.intellij.debugger.engine.RequestHint;
import com.intellij.debugger.engine.SuspendContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SuspendManagerUtil;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.engine.requests.LocatableEventRequestor;
import com.intellij.debugger.engine.requests.MethodReturnValueWatcher;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.impl.DebuggerManagerImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.requests.Requestor;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.InstrumentationTracker;
import com.intellij.debugger.ui.breakpoints.RunToCursorBreakpoint;
import com.intellij.debugger.ui.breakpoints.StackCapturingLineBreakpoint;
import com.intellij.debugger.ui.overhead.OverheadProducer;
import com.intellij.debugger.ui.overhead.OverheadTimings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.intellij.xdebugger.impl.ui.XDebugSessionTab;
import com.sun.jdi.InternalException;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.ClassUnloadEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.ThreadStartEvent;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import com.sun.jdi.event.VMStartEvent;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DebugProcessEvents
extends DebugProcessImpl {
    private static final Logger A;
    private static final String B = "REQUEST_HANDLER";
    private DebuggerEventThread C;
    private final AtomicBoolean z = new AtomicBoolean();
    private static final long D;

    public DebugProcessEvents(Project project2) {
        super(project2);
        DebuggerSettings.getInstance().addCapturePointsSettingsListener(this::k, this.myDisposable);
    }

    @Override
    protected void commitVM(VirtualMachine vm) {
        long l2 = D ^ 0x70ED0727C48CL;
        super.commitVM(vm);
        if (vm != null) {
            this.g();
            if (vm.canBeModified()) {
                this.C = new DebuggerEventThread();
                ApplicationManager.getApplication().executeOnPooledThread(ConcurrencyUtil.underThreadNameRunnable((String)"DebugProcessEvents", (Runnable)this.C));
            }
        }
    }

    private static void a(DebugProcessEvents debugProcessEvents, Event event) {
        Requestor requestor = RequestManagerImpl.findRequestor(event.request());
        Breakpoint breakpoint = null;
        if (requestor instanceof Breakpoint) {
            breakpoint = (Breakpoint)requestor;
        }
        String string = debugProcessEvents.getEventText((Pair<Breakpoint, Event>)Pair.create((Object)breakpoint, (Object)event));
        debugProcessEvents.showStatusText(string);
    }

    public String getEventText(Pair<Breakpoint, Event> descriptor2) {
        long l2 = D ^ 0x6AD2C40D4454L;
        String string = "";
        Event event = (Event)descriptor2.getSecond();
        Breakpoint breakpoint = (Breakpoint)descriptor2.getFirst();
        if (event instanceof LocatableEvent) {
            try {
                string = breakpoint != null ? breakpoint.getEventMessage((LocatableEvent)event) : DebuggerBundle.message((String)"status.generic.breakpoint.reached", (Object[])new Object[0]);
            }
            catch (InternalException internalException) {
                string = DebuggerBundle.message((String)"status.generic.breakpoint.reached", (Object[])new Object[0]);
            }
        } else if (event instanceof VMStartEvent) {
            string = DebuggerBundle.message((String)"status.process.started", (Object[])new Object[0]);
        } else if (event instanceof VMDeathEvent) {
            string = DebuggerBundle.message((String)"status.process.terminated", (Object[])new Object[0]);
        } else if (event instanceof VMDisconnectEvent) {
            string = DebuggerBundle.message((String)"status.disconnected", (Object[])new Object[]{DebuggerUtilsImpl.getConnectionDisplayName(this.getConnection())});
        }
        return string;
    }

    private static void a(SuspendContextImpl suspendContextImpl, ThreadReference threadReference) {
        ThreadReferenceProxyImpl threadReferenceProxyImpl = suspendContextImpl.getThread();
        suspendContextImpl.setThread(threadReference);
        if (threadReferenceProxyImpl == null) {
            suspendContextImpl.getDebugProcess().beforeSuspend(suspendContextImpl);
        }
    }

    private static Consumer<Event> a(Event event) {
        Object object;
        long l2 = D ^ 0x3356D0772971L;
        EventRequest eventRequest = event.request();
        Object object2 = object = eventRequest != null ? eventRequest.getProperty(B) : null;
        if (object instanceof Consumer) {
            return (Consumer)object;
        }
        return null;
    }

    private static void a(EventRequest eventRequest, Consumer<Event> consumer) {
        long l2 = D ^ 0x7F2E7C583E96L;
        eventRequest.setSuspendPolicy(0);
        eventRequest.putProperty(B, consumer);
        eventRequest.enable();
    }

    private void a(SuspendContextImpl suspendContextImpl, VMStartEvent vMStartEvent) {
        long l2 = D ^ 0x3F89F81395A0L;
        DebugProcessEvents.a(suspendContextImpl, vMStartEvent.thread());
        A.debug("enter: processVMStartEvent()");
        DebugProcessEvents.a(this, vMStartEvent);
        this.getSuspendManager().voteResume(suspendContextImpl);
    }

    private void g() {
        long l2 = D ^ 0x565C75B9F618L;
        DebuggerManagerThreadImpl.assertIsManagerThread();
        A.assertTrue(!this.isAttached());
        if (this.myState.compareAndSet(DebugProcessImpl.State.INITIAL, DebugProcessImpl.State.ATTACHED)) {
            EventRequestManager eventRequestManager;
            VirtualMachineProxyImpl virtualMachineProxyImpl = this.getVirtualMachineProxy();
            boolean bl2 = virtualMachineProxyImpl.canBeModified();
            if (bl2) {
                eventRequestManager = virtualMachineProxyImpl.eventRequestManager();
                if (virtualMachineProxyImpl.canGetMethodReturnValues()) {
                    this.myReturnValueWatcher = new MethodReturnValueWatcher(eventRequestManager, this);
                }
                DebugProcessEvents.a(eventRequestManager.createThreadStartRequest(), (Consumer<Event>)((Consumer)event -> {
                    ThreadReference threadReference = ((ThreadStartEvent)event).thread();
                    this.getVirtualMachineProxy().threadStarted(threadReference);
                    ((DebugProcessListener)this.myDebugProcessDispatcher.getMulticaster()).threadStarted((DebugProcess)this, threadReference);
                }));
                DebugProcessEvents.a(eventRequestManager.createThreadDeathRequest(), (Consumer<Event>)((Consumer)event -> {
                    ThreadReference threadReference = ((ThreadDeathEvent)event).thread();
                    this.getVirtualMachineProxy().threadStopped(threadReference);
                    ((DebugProcessListener)this.myDebugProcessDispatcher.getMulticaster()).threadStopped((DebugProcess)this, threadReference);
                }));
            }
            ((DebuggerManagerImpl)DebuggerManager.getInstance((Project)this.getProject())).getCustomPositionManagerFactories().map(function -> (PositionManager)function.fun((Object)this)).filter(Objects::nonNull).forEach(this::appendPositionManager);
            Stream.of(PositionManagerFactory.EP_NAME.getExtensions((AreaInstance)this.getProject())).map(positionManagerFactory -> positionManagerFactory.createPositionManager((DebugProcess)this)).filter(Objects::nonNull).forEach(this::appendPositionManager);
            ((DebugProcessListener)this.myDebugProcessDispatcher.getMulticaster()).processAttached((DebugProcess)this);
            if (bl2) {
                this.k();
                AsyncStacksUtils.setupAgent(this);
            }
            ApplicationManager.getApplication().runReadAction(() -> {
                XDebugSession xDebugSession = this.getSession().getXDebugSession();
                if (xDebugSession != null) {
                    xDebugSession.initBreakpoints();
                }
            });
            if (Registry.is((String)"debugger.track.instrumentation", (boolean)true) && bl2) {
                this.f();
            }
            this.showStatusText(DebuggerBundle.message((String)"status.connected", (Object[])new Object[]{DebuggerUtilsImpl.getConnectionDisplayName(this.getConnection())}));
            A.debug("leave: processVMStartEvent()");
            if (!bl2) {
                eventRequestManager = (XDebugSessionImpl)this.getSession().getXDebugSession();
                if (eventRequestManager != null) {
                    eventRequestManager.setReadOnly(true);
                    eventRequestManager.setPauseActionSupported(false);
                }
                ((DebugProcessListener)this.myDebugProcessDispatcher.getMulticaster()).paused((SuspendContext)this.getSuspendManager().pushSuspendContext(2, 0));
                UIUtil.invokeLaterIfNeeded(() -> DebugProcessEvents.a((XDebugSessionImpl)eventRequestManager));
            }
        }
    }

    private void f() {
        this.getManagerThread().invoke(PrioritizedTask.Priority.HIGH, () -> InstrumentationTracker.track(this));
    }

    private void k() {
        this.getManagerThread().invoke(PrioritizedTask.Priority.HIGH, () -> {
            StackCapturingLineBreakpoint.deleteAll(this);
            StackCapturingLineBreakpoint.createAll(this);
        });
    }

    private void a(SuspendContextImpl suspendContextImpl, @Nullable Event event) {
        if (this.isAttached() && (event == null || this.getVirtualMachineProxy().getVirtualMachine() == event.virtualMachine())) {
            try {
                DebugProcessEvents.a(suspendContextImpl, null);
                this.cancelRunToCursorBreakpoint();
            }
            finally {
                if (this.C != null) {
                    this.C.stopListening();
                    this.C = null;
                }
                this.closeProcess(false);
            }
        }
        if (event != null) {
            DebugProcessEvents.a(this, event);
        }
    }

    private void a(SuspendContextImpl suspendContextImpl, ClassPrepareEvent classPrepareEvent) {
        long l2 = D ^ 0x1A929E1826C9L;
        DebugProcessEvents.a(suspendContextImpl, classPrepareEvent.thread());
        if (A.isDebugEnabled()) {
            A.debug("Class prepared: " + classPrepareEvent.referenceType().name());
        }
        try {
            suspendContextImpl.getDebugProcess().getRequestsManager().processClassPrepared(classPrepareEvent);
        }
        finally {
            this.getSuspendManager().voteResume(suspendContextImpl);
        }
    }

    private void a(SuspendContextImpl suspendContextImpl, StepEvent stepEvent) {
        Object object;
        long l2 = D ^ 0x72B36C5778C6L;
        ThreadReference threadReference = stepEvent.thread();
        DebugProcessEvents.a(suspendContextImpl, threadReference);
        RequestHint requestHint = DebugProcessEvents.d(stepEvent);
        this.deleteStepRequests(stepEvent.thread());
        boolean bl2 = false;
        Project project2 = this.getProject();
        if (requestHint != null) {
            int n2 = requestHint.getNextStepDepth(suspendContextImpl);
            if (n2 == -100) {
                this.getSession().clearSteppingThrough();
                bl2 = true;
            } else if (n2 != 0) {
                object = suspendContextImpl.getThread();
                this.doStep(suspendContextImpl, (ThreadReferenceProxyImpl)object, requestHint.getSize(), n2, requestHint);
                bl2 = true;
            }
            if (!bl2 && requestHint.isRestoreBreakpoints()) {
                DebuggerManagerEx.getInstanceEx(project2).getBreakpointManager().enableBreakpoints(this);
            }
        }
        if (bl2) {
            this.getSuspendManager().voteResume(suspendContextImpl);
        } else {
            this.showStatusText("");
            this.stopWatchingMethodReturn();
            this.getSuspendManager().voteSuspend(suspendContextImpl);
            if (requestHint != null) {
                MethodFilter methodFilter = requestHint.getMethodFilter();
                if (methodFilter instanceof NamedMethodFilter && !requestHint.wasStepTargetMethodMatched()) {
                    object = "Method <b>" + ((NamedMethodFilter)methodFilter).getMethodName() + "()</b> has not been called";
                    XDebuggerManagerImpl.NOTIFICATION_GROUP.createNotification((String)object, MessageType.INFO).notify(project2);
                }
                if (requestHint.wasStepTargetMethodMatched() && requestHint.isResetIgnoreFilters()) {
                    this.checkPositionNotFiltered(suspendContextImpl.getThread(), (Consumer<List<ClassFilter>>)((Consumer)list2 -> this.mySession.resetIgnoreStepFiltersFlag()));
                }
            }
        }
    }

    private static RequestHint d(Event event) {
        long l2 = D ^ 0x68FF232E22ABL;
        return (RequestHint)event.request().getProperty("hint");
    }

    private void a(SuspendContextImpl suspendContextImpl, final LocatableEvent locatableEvent) {
        ThreadReference threadReference = locatableEvent.thread();
        DebugProcessEvents.a(suspendContextImpl, threadReference);
        this.getManagerThread().schedule(new SuspendContextCommandImpl(suspendContextImpl){
            private static final long e = lb.a(7467459547978760783L, 6012067492377073307L, MethodHandles.lookup().lookupClass()).a(193224684970062L);

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Override
            public void contextAction(@NotNull SuspendContextImpl suspendContext) {
                var2_2 = 1.e ^ 112784224314785L;
                if (suspendContext == null) {
                    1.b(0);
                }
                var4_3 = DebugProcessEvents.this.getSuspendManager();
                var5_4 = SuspendManagerUtil.getEvaluatingContext(var4_3, suspendContext.getThread());
                var6_5 = (LocatableEventRequestor)RequestManagerImpl.findRequestor(locatableEvent.request());
                if (var5_4 != null && !(var6_5 instanceof InstrumentationTracker.InstrumentationMethodBreakpoint) && !DebuggerSession.enableBreakpointsDuringEvaluation()) {
                    DebugProcessEvents.access$200(DebugProcessEvents.this, locatableEvent);
                    var4_3.voteResume(suspendContext);
                    return;
                }
                var7_6 = var6_5 != null && "SuspendNone".equals(var6_5.getSuspendPolicy()) != false;
                var8_7 = false;
                var9_8 = var6_5 instanceof OverheadProducer != false && var6_5 instanceof RunToCursorBreakpoint == false ? System.currentTimeMillis() : 0L;
                try {
                    v0 = var8_7 = var6_5 != null && var6_5.processLocatableEvent(this, locatableEvent) != false;
                    ** if (var9_8 <= 0L) goto lbl-1000
                }
                catch (LocatableEventRequestor.EventProcessingException var11_9) {
                    try {
                        if (DebugProcessEvents.access$900().isDebugEnabled()) {
                            DebugProcessEvents.access$900().debug(var11_9.getMessage());
                        }
                        var12_11 = new boolean[]{true};
                        DebuggerInvocationUtil.invokeAndWait(DebugProcessEvents.this.getProject(), (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, a(com.intellij.debugger.engine.requests.LocatableEventRequestor com.intellij.debugger.engine.requests.LocatableEventRequestor$EventProcessingException boolean[] ), ()V)(this, (LocatableEventRequestor)var6_5, (LocatableEventRequestor.EventProcessingException)var11_9, (boolean[])var12_11), ModalityState.NON_MODAL);
                        var8_7 = var12_11[0];
                        v1 = var7_6 = var8_7 == false;
                        ** if (var9_8 <= 0L) goto lbl-1000
                    }
                    catch (Throwable var13_12) {
                        if (var9_8 > 0L) {
                            OverheadTimings.add(DebugProcessEvents.this, (OverheadProducer)var6_5, var8_7 != false || var6_5 instanceof StackCapturingLineBreakpoint != false ? 1L : 0L, System.currentTimeMillis() - var9_8);
                        }
                        throw var13_12;
                    }
lbl-1000:
                    // 1 sources

                    {
                        OverheadTimings.add(DebugProcessEvents.this, (OverheadProducer)var6_5, var8_7 != false || var6_5 instanceof StackCapturingLineBreakpoint != false ? 1L : 0L, System.currentTimeMillis() - var9_8);
                    }
lbl-1000:
                    // 2 sources

                    {
                    }
                }
lbl-1000:
                // 1 sources

                {
                    OverheadTimings.add(DebugProcessEvents.this, (OverheadProducer)var6_5, var8_7 != false || var6_5 instanceof StackCapturingLineBreakpoint != false ? 1L : 0L, System.currentTimeMillis() - var9_8);
                }
lbl-1000:
                // 2 sources

                {
                }
                if (var8_7 && var6_5 instanceof Breakpoint) {
                    ApplicationManager.getApplication().runReadAction((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, a(com.intellij.debugger.engine.requests.LocatableEventRequestor ), ()V)(this, (LocatableEventRequestor)var6_5));
                }
                if ((var11_10 = suspendContext.getEventSet()) != null && var11_10.size() > 1 && !(var12_11 = (Object)StreamEx.of((Collection)var11_10).select(StepEvent.class).toList()).isEmpty()) {
                    v2 = var7_6 = var7_6 != false || var12_11.stream().map((Function<StepEvent, RequestHint>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, a(com.sun.jdi.event.Event ), (Lcom/sun/jdi/event/StepEvent;)Lcom/intellij/debugger/engine/RequestHint;)()).allMatch((Predicate<RequestHint>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, a(com.intellij.debugger.engine.SuspendContextImpl com.intellij.debugger.engine.RequestHint ), (Lcom/intellij/debugger/engine/RequestHint;)Z)((SuspendContextImpl)suspendContext)) != false;
                }
                if (!var8_7 || var7_6) {
                    var4_3.voteResume(suspendContext);
                } else {
                    DebugProcessEvents.this.stopWatchingMethodReturn();
                    var4_3.voteSuspend(suspendContext);
                    DebugProcessEvents.access$1000(DebugProcessEvents.this, locatableEvent);
                }
            }

            private static /* synthetic */ boolean a(@NotNull SuspendContextImpl suspendContextImpl, RequestHint requestHint) {
                if (suspendContextImpl == null) {
                    1.b(1);
                }
                if (requestHint != null) {
                    Integer n2 = requestHint.checkCurrentPosition(suspendContextImpl);
                    return n2 != null && n2 != 0;
                }
                return false;
            }

            private static /* synthetic */ RequestHint a(Event event) {
                return DebugProcessEvents.d(event);
            }

            private /* synthetic */ void a(LocatableEventRequestor locatableEventRequestor) {
                XBreakpoint xBreakpoint;
                XDebugSession xDebugSession = DebugProcessEvents.this.getSession().getXDebugSession();
                if (xDebugSession != null && (xBreakpoint = ((Breakpoint)locatableEventRequestor).getXBreakpoint()) != null) {
                    ((XDebugSessionImpl)xDebugSession).processDependencies(xBreakpoint);
                }
            }

            private /* synthetic */ void a(LocatableEventRequestor locatableEventRequestor, LocatableEventRequestor.EventProcessingException eventProcessingException, boolean[] blArray) {
                long l2 = e ^ 0x7FF5C38B7E26L;
                String string = locatableEventRequestor instanceof Breakpoint ? ((Breakpoint)locatableEventRequestor).getDisplayName() : locatableEventRequestor.getClass().getSimpleName();
                String string2 = DebuggerBundle.message((String)"error.evaluating.breakpoint.condition.or.action", (Object[])new Object[]{string, eventProcessingException.getMessage()});
                blArray[0] = Messages.showYesNoDialog((Project)DebugProcessEvents.this.getProject(), (String)string2, (String)eventProcessingException.getTitle(), (Icon)Messages.getQuestionIcon()) == 0;
            }

            private static /* synthetic */ void b(int n2) {
                Object[] objectArray;
                long l2 = e ^ 0x2F6EB8F79D5AL;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "suspendContext";
                objectArray2[1] = "com/intellij/debugger/engine/DebugProcessEvents$1";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "contextAction";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$contextAction$3";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void a(@Nullable LocatableEvent locatableEvent) {
        long l2 = D ^ 0x2FFD6CE3904L;
        if (locatableEvent != null && this.z.compareAndSet(false, true)) {
            AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> this.z.set(false), 1L, TimeUnit.SECONDS);
            XDebuggerManagerImpl.NOTIFICATION_GROUP.createNotification(DebuggerBundle.message((String)"message.breakpoint.skipped", (Object[])new Object[]{locatableEvent.location()}), MessageType.WARNING).notify(this.getProject());
        }
    }

    @Nullable
    private static LocatableEvent a(EventSet eventSet) {
        return StreamEx.of((Collection)eventSet).select(LocatableEvent.class).findFirst().orElse(null);
    }

    private void a(SuspendContextImpl suspendContextImpl) {
        DebugProcessEvents.a(suspendContextImpl, null);
        this.getSuspendManager().voteResume(suspendContextImpl);
    }

    private static /* synthetic */ void a(XDebugSessionImpl xDebugSessionImpl) {
        XDebugSessionTab.showFramesView((XDebugSessionImpl)xDebugSessionImpl);
    }

    static /* synthetic */ void access$1000(DebugProcessEvents x0, Event x1) {
        DebugProcessEvents.a(x0, x1);
    }

    static {
        D = lb.a(-3081024400458092903L, 5520183804179488548L, MethodHandles.lookup().lookupClass()).a(16548233097588L);
        A = Logger.getInstance(DebugProcessEvents.class);
    }

    private class DebuggerEventThread
    implements Runnable {
        private final VirtualMachineProxyImpl a;
        private boolean b = false;

        DebuggerEventThread() {
            this.a = DebugProcessEvents.this.getVirtualMachineProxy();
        }

        public synchronized void stopListening() {
            this.b = true;
        }

        private synchronized boolean a() {
            return this.b;
        }

        @Override
        public void run() {
            try {
                EventQueue eventQueue = this.a.eventQueue();
                while (!this.a()) {
                    try {
                        final EventSet eventSet = eventQueue.remove();
                        DebugProcessEvents.this.getManagerThread().invokeAndWait(new DebuggerCommandImpl(PrioritizedTask.Priority.HIGH){

                            @Override
                            protected void action() {
                                Object object22;
                                int n2 = 0;
                                for (Object object22 : eventSet) {
                                    if (DebugProcessEvents.this.myReturnValueWatcher != null && DebugProcessEvents.this.myReturnValueWatcher.isTrackingEnabled() && DebugProcessEvents.this.myReturnValueWatcher.processEvent((Event)object22)) {
                                        ++n2;
                                        continue;
                                    }
                                    Consumer object3 = DebugProcessEvents.a((Event)object22);
                                    if (object3 == null) continue;
                                    object3.consume(object22);
                                    ++n2;
                                }
                                if (n2 == eventSet.size()) {
                                    eventSet.resume();
                                    return;
                                }
                                LocatableEvent locatableEvent = DebugProcessEvents.a(eventSet);
                                if (eventSet.suspendPolicy() == 2) {
                                    for (SuspendContextImpl suspendContextImpl : DebugProcessEvents.this.getSuspendManager().getEventContexts()) {
                                        if (suspendContextImpl.getSuspendPolicy() != 2) continue;
                                        if (DebugProcessImpl.isResumeOnlyCurrentThread() && locatableEvent != null && !suspendContextImpl.isEvaluating()) {
                                            DebugProcessEvents.this.getSuspendManager().resume(suspendContextImpl);
                                            continue;
                                        }
                                        if (DebuggerSession.enableBreakpointsDuringEvaluation()) continue;
                                        DebugProcessEvents.this.a(locatableEvent);
                                        eventSet.resume();
                                        return;
                                    }
                                }
                                object22 = null;
                                if (DebugProcessImpl.isResumeOnlyCurrentThread() && locatableEvent != null) {
                                    for (SuspendContextImpl suspendContextImpl : DebugProcessEvents.this.getSuspendManager().getEventContexts()) {
                                        ThreadReferenceProxyImpl threadReferenceProxyImpl = DebugProcessEvents.this.getVirtualMachineProxy().getThreadReferenceProxy(locatableEvent.thread());
                                        if (suspendContextImpl.getSuspendPolicy() != 2 || !suspendContextImpl.isExplicitlyResumed(threadReferenceProxyImpl)) continue;
                                        suspendContextImpl.myResumedThreads.remove(threadReferenceProxyImpl);
                                        object22 = suspendContextImpl;
                                        ((SuspendContextImpl)((Object)object22)).myVotesToVote = eventSet.size();
                                        break;
                                    }
                                }
                                if (object22 == null) {
                                    object22 = DebugProcessEvents.this.getSuspendManager().pushSuspendContext(eventSet);
                                }
                                for (Event event : eventSet) {
                                    if (DebugProcessEvents.a(event) != null) {
                                        DebugProcessEvents.this.getSuspendManager().voteResume((SuspendContextImpl)((Object)object22));
                                        continue;
                                    }
                                    try {
                                        if (event instanceof VMStartEvent) {
                                            DebugProcessEvents.this.a((SuspendContextImpl)((Object)object22), (VMStartEvent)event);
                                            continue;
                                        }
                                        if (event instanceof VMDeathEvent || event instanceof VMDisconnectEvent) {
                                            DebugProcessEvents.this.a((SuspendContextImpl)((Object)object22), event);
                                            continue;
                                        }
                                        if (event instanceof ClassPrepareEvent) {
                                            DebugProcessEvents.this.a((SuspendContextImpl)((Object)object22), (ClassPrepareEvent)event);
                                            continue;
                                        }
                                        if (event instanceof StepEvent) {
                                            DebugProcessEvents.this.a((SuspendContextImpl)((Object)object22), (StepEvent)event);
                                            continue;
                                        }
                                        if (event instanceof LocatableEvent) {
                                            DebugProcessEvents.this.a((SuspendContextImpl)((Object)object22), (LocatableEvent)event);
                                            continue;
                                        }
                                        if (!(event instanceof ClassUnloadEvent)) continue;
                                        DebugProcessEvents.this.a((SuspendContextImpl)((Object)object22));
                                    }
                                    catch (VMDisconnectedException vMDisconnectedException) {
                                        A.debug((Throwable)vMDisconnectedException);
                                    }
                                    catch (InternalException internalException) {
                                        A.info((Throwable)internalException);
                                    }
                                    catch (Throwable throwable) {
                                        A.error(throwable);
                                    }
                                }
                            }
                        });
                    }
                    catch (InternalException internalException) {
                        A.debug((Throwable)internalException);
                    }
                    catch (ProcessCanceledException | VMDisconnectedException | InterruptedException throwable) {
                        throw throwable;
                    }
                    catch (Throwable throwable) {
                        A.debug(throwable);
                    }
                }
            }
            catch (VMDisconnectedException | InterruptedException exception) {
                this.b();
            }
            finally {
                Thread.interrupted();
            }
        }

        private void b() {
            DebugProcessEvents.this.getManagerThread().invokeAndWait(new DebuggerCommandImpl(){

                @Override
                protected void action() {
                    SuspendContextImpl suspendContextImpl = DebugProcessEvents.this.getSuspendManager().pushSuspendContext(0, 1);
                    DebugProcessEvents.this.a(suspendContextImpl, null);
                }
            });
        }
    }
}

