/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import b.a.lb;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.unscramble.ThreadDumpParser;
import com.intellij.unscramble.ThreadState;
import com.intellij.util.SmartList;
import com.intellij.xdebugger.XDebugSession;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.Location;
import com.sun.jdi.LongValue;
import com.sun.jdi.Mirror;
import com.sun.jdi.MonitorInfo;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import gnu.trove.TIntObjectHashMap;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ThreadDumpAction
extends AnAction
implements AnAction.TransparentUpdate {
    private static final long a = lb.a(2658388652106911324L, -9112979741818089505L, MethodHandles.lookup().lookupClass()).a(44708927203592L);

    public void actionPerformed(@NotNull AnActionEvent e10) {
        Project project2;
        if (e10 == null) {
            ThreadDumpAction.c(0);
        }
        if ((project2 = e10.getProject()) == null) {
            return;
        }
        DebuggerContextImpl debuggerContextImpl = DebuggerManagerEx.getInstanceEx(project2).getContext();
        final DebuggerSession debuggerSession = debuggerContextImpl.getDebuggerSession();
        if (debuggerSession != null && debuggerSession.isAttached()) {
            final DebugProcessImpl debugProcessImpl = debuggerContextImpl.getDebugProcess();
            debugProcessImpl.getManagerThread().invoke(new DebuggerCommandImpl(){

                @Override
                protected void action() {
                    VirtualMachineProxyImpl virtualMachineProxyImpl = debugProcessImpl.getVirtualMachineProxy();
                    virtualMachineProxyImpl.suspend();
                    try {
                        List<ThreadState> list2 = ThreadDumpAction.buildThreadStates(virtualMachineProxyImpl);
                        ApplicationManager.getApplication().invokeLater(() -> {
                            XDebugSession xDebugSession = debuggerSession.getXDebugSession();
                            if (xDebugSession != null) {
                                DebuggerUtilsEx.addThreadDump(project2, list2, xDebugSession.getUI(), debuggerSession);
                            }
                        }, ModalityState.NON_MODAL);
                    }
                    finally {
                        virtualMachineProxyImpl.resume();
                    }
                }
            });
        }
    }

    public static List<ThreadState> buildThreadStates(VirtualMachineProxyImpl vmProxy) {
        Object object;
        long l2 = a ^ 0x3B4D617D5DF3L;
        List<ThreadReference> list2 = vmProxy.getVirtualMachine().allThreads();
        ArrayList<ThreadState> arrayList = new ArrayList<ThreadState>();
        HashMap<String, ThreadState> hashMap = new HashMap<String, ThreadState>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        for (ThreadReference object2 : list2) {
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            object = new StringBuilder();
            boolean bl2 = true;
            int n2 = object2.status();
            if (n2 == 0) continue;
            String string = ThreadDumpAction.a(object2);
            ThreadState threadState = new ThreadState(string, ThreadDumpAction.b(n2));
            hashMap.put(string, threadState);
            arrayList.add(threadState);
            threadState.setJavaThreadState(ThreadDumpAction.a(n2));
            ((StringBuilder)object).append("\"").append(string).append("\"");
            ReferenceType referenceType = object2.referenceType();
            if (referenceType != null) {
                object6 = referenceType.fieldByName("daemon");
                if (object6 != null && (object5 = object2.getValue((Field)object6)) instanceof BooleanValue && ((BooleanValue)object5).booleanValue()) {
                    ((StringBuilder)object).append(" ").append(DebuggerBundle.message((String)"threads.export.attribute.label.daemon", (Object[])new Object[0]));
                    threadState.setDaemon(true);
                }
                if ((object5 = referenceType.fieldByName("priority")) != null && (object4 = object2.getValue((Field)object5)) instanceof IntegerValue) {
                    ((StringBuilder)object).append(" ").append(DebuggerBundle.message((String)"threads.export.attribute.label.priority", (Object[])new Object[]{((IntegerValue)object4).intValue()}));
                }
                if ((object4 = referenceType.fieldByName("tid")) != null && (object3 = object2.getValue((Field)object4)) instanceof LongValue) {
                    ((StringBuilder)object).append(" ").append(DebuggerBundle.message((String)"threads.export.attribute.label.tid", (Object[])new Object[]{Long.toHexString(((LongValue)object3).longValue())}));
                    ((StringBuilder)object).append(" nid=NA");
                }
            }
            if ((object6 = threadState.getState()) != null) {
                ((StringBuilder)object).append(" ").append((String)object6);
            }
            ((StringBuilder)object).append("\n  java.lang.Thread.State: ").append(threadState.getJavaThreadState());
            try {
                List list3;
                Mirror mirror;
                if (vmProxy.canGetOwnedMonitorInfo() && vmProxy.canGetMonitorInfo()) {
                    object5 = object2.ownedMonitors();
                    object4 = object5.iterator();
                    while (object4.hasNext()) {
                        object3 = (ObjectReference)object4.next();
                        if (!vmProxy.canGetMonitorFrameInfo()) {
                            ((StringBuilder)object).append("\n\t ").append(ThreadDumpAction.a((ObjectReference)object3));
                        }
                        List<ThreadReference> list4 = object3.waitingThreads();
                        Iterator<ThreadReference> iterator = list4.iterator();
                        while (iterator.hasNext()) {
                            mirror = iterator.next();
                            String string2 = ThreadDumpAction.a((ThreadReference)mirror);
                            hashMap2.put(string2, string);
                            ((StringBuilder)object).append("\n\t ").append(DebuggerBundle.message((String)"threads.export.attribute.label.blocks.thread", (Object[])new Object[]{string2}));
                        }
                    }
                }
                Object object7 = object5 = vmProxy.canGetCurrentContendedMonitor() ? object2.currentContendedMonitor() : null;
                if (object5 != null && vmProxy.canGetMonitorInfo() && (object4 = object5.owningThread()) != null) {
                    object3 = ThreadDumpAction.a((ThreadReference)object4);
                    hashMap2.put(string, object3);
                    ((StringBuilder)object).append("\n\t ").append(DebuggerBundle.message((String)"threads.export.attribute.label.waiting.for.thread", (Object[])new Object[]{object3, ThreadDumpAction.renderObject((ObjectReference)object5)}));
                }
                bl2 = (object4 = object2.frames()).size() == 0;
                object3 = new TIntObjectHashMap();
                if (vmProxy.canGetMonitorFrameInfo()) {
                    for (Object e10 : object2.ownedMonitorsAndFrames()) {
                        if (!(e10 instanceof MonitorInfo)) continue;
                        mirror = (MonitorInfo)e10;
                        int n3 = mirror.stackDepth();
                        list3 = (List)object3.get(n3);
                        if (list3 == null) {
                            list3 = new SmartList();
                            object3.put(n3, (Object)list3);
                        }
                        list3.add(mirror.monitor());
                    }
                }
                int n4 = object4.size();
                for (int i10 = 0; i10 < n4; ++i10) {
                    mirror = (StackFrame)object4.get(i10);
                    try {
                        Location location = mirror.location();
                        ((StringBuilder)object).append("\n\t  ").append(ThreadDumpAction.renderLocation(location));
                        list3 = (List)object3.get(i10);
                        if (list3 == null) continue;
                        for (ObjectReference objectReference : list3) {
                            ((StringBuilder)object).append("\n\t  - ").append(ThreadDumpAction.a(objectReference));
                        }
                        continue;
                    }
                    catch (InvalidStackFrameException invalidStackFrameException) {
                        ((StringBuilder)object).append("\n\t  Invalid stack frame: ").append(invalidStackFrameException.getMessage());
                    }
                }
            }
            catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                ((StringBuilder)object).append("\n\t ").append(DebuggerBundle.message((String)"threads.export.attribute.error.incompatible.state", (Object[])new Object[0]));
            }
            threadState.setStackTrace(((StringBuilder)object).toString(), bl2);
            ThreadDumpParser.inferThreadStateDetail((ThreadState)threadState);
        }
        for (String string : hashMap2.keySet()) {
            object = (ThreadState)hashMap.get(string);
            ThreadState threadState = (ThreadState)hashMap.get(hashMap2.get(string));
            if (object == null || threadState == null) continue;
            threadState.addWaitingThread((ThreadState)object);
        }
        for (ThreadState threadState : arrayList) {
            for (ThreadState threadState2 : threadState.getAwaitingThreads()) {
                if (!threadState2.isAwaitedBy(threadState)) continue;
                threadState.addDeadlockedThread(threadState2);
                threadState2.addDeadlockedThread(threadState);
            }
        }
        ThreadDumpParser.sortThreads(arrayList);
        return arrayList;
    }

    private static String a(ObjectReference objectReference) {
        long l2 = a ^ 0x1AD2C2C7317L;
        return DebuggerBundle.message((String)"threads.export.attribute.label.locked", (Object[])new Object[]{ThreadDumpAction.renderObject(objectReference)});
    }

    public static String renderObject(ObjectReference monitor) {
        String string;
        long l2 = a ^ 0x7CC0E533E2E1L;
        try {
            string = monitor.referenceType().name();
        }
        catch (Throwable throwable) {
            string = "Error getting object type: '" + throwable.getMessage() + "'";
        }
        return DebuggerBundle.message((String)"threads.export.attribute.label.object-id", (Object[])new Object[]{Long.toHexString(monitor.uniqueID()), string});
    }

    private static String a(int n2) {
        long l2 = a ^ 0x66E4421D2382L;
        switch (n2) {
            case 3: {
                return Thread.State.BLOCKED.name();
            }
            case 5: {
                return Thread.State.NEW.name();
            }
            case 1: {
                return Thread.State.RUNNABLE.name();
            }
            case 2: {
                return Thread.State.TIMED_WAITING.name();
            }
            case 4: {
                return Thread.State.WAITING.name();
            }
            case 0: {
                return Thread.State.TERMINATED.name();
            }
            case -1: {
                return "unknown";
            }
        }
        return "undefined";
    }

    private static String b(int n2) {
        long l2 = a ^ 0x58799BE9E8F3L;
        switch (n2) {
            case 3: {
                return "waiting for monitor entry";
            }
            case 5: {
                return "not started";
            }
            case 1: {
                return "runnable";
            }
            case 2: {
                return "sleeping";
            }
            case 4: {
                return "waiting";
            }
            case 0: {
                return "zombie";
            }
            case -1: {
                return "unknown";
            }
        }
        return "undefined";
    }

    public static String renderLocation(Location location) {
        long l2 = a ^ 0x5BA08F040B25L;
        return DebuggerBundle.message((String)"export.threads.stackframe.format", (Object[])new Object[]{DebuggerUtilsEx.getLocationMethodQName(location), DebuggerUtilsEx.getSourceName(location, throwable -> {
            long l2 = a ^ 0x78E418B7F679L;
            return "Unknown Source";
        }), DebuggerUtilsEx.getLineNumber(location, false)});
    }

    private static String a(ThreadReference threadReference) {
        return threadReference.name() + "@" + threadReference.uniqueID();
    }

    public void update(@NotNull AnActionEvent e10) {
        if (e10 == null) {
            ThreadDumpAction.c(1);
        }
        Presentation presentation = e10.getPresentation();
        Project project2 = e10.getProject();
        if (project2 == null) {
            presentation.setEnabled(false);
            return;
        }
        DebuggerSession debuggerSession = DebuggerManagerEx.getInstanceEx(project2).getContext().getDebuggerSession();
        presentation.setEnabled(debuggerSession != null && debuggerSession.isAttached());
    }

    private static /* synthetic */ void c(int n2) {
        Object[] objectArray;
        long l2 = a ^ 0x13C412765566L;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/debugger/actions/ThreadDumpAction";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

