/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import b.a.lb;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.actions.JvmSmartStepIntoActionHandler;
import com.intellij.debugger.actions.LambdaSmartStepTarget;
import com.intellij.debugger.actions.MethodSmartStepTarget;
import com.intellij.debugger.actions.PsiMethodListPopupStep;
import com.intellij.debugger.actions.SmartStepTarget;
import com.intellij.debugger.engine.AnonymousClassMethodFilter;
import com.intellij.debugger.engine.BasicStepMethodFilter;
import com.intellij.debugger.engine.ClassInstanceMethodFilter;
import com.intellij.debugger.engine.LambdaAsyncMethodFilter;
import com.intellij.debugger.engine.LambdaMethodFilter;
import com.intellij.debugger.engine.MethodFilter;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.List;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JvmSmartStepIntoHandler {
    public static final ExtensionPointName<JvmSmartStepIntoHandler> EP_NAME;
    private static final long c;

    @NotNull
    public abstract List<SmartStepTarget> findSmartStepTargets(SourcePosition var1);

    public abstract boolean isAvailable(SourcePosition var1);

    public boolean doSmartStep(SourcePosition position, DebuggerSession session, TextEditor fileEditor) {
        return this.handleTargets(position, session, fileEditor, this.findSmartStepTargets(position));
    }

    protected final boolean handleTargets(SourcePosition position, DebuggerSession session, TextEditor fileEditor, List<SmartStepTarget> targets) {
        long l2 = c ^ 0x766DE717D010L;
        if (!targets.isEmpty()) {
            SmartStepTarget smartStepTarget2 = targets.get(0);
            if (targets.size() == 1) {
                this.doStepInto(session, Registry.is((String)"debugger.single.smart.step.force"), smartStepTarget2);
            } else {
                Editor editor = fileEditor.getEditor();
                final PsiMethodListPopupStep psiMethodListPopupStep = new PsiMethodListPopupStep(editor, targets, smartStepTarget -> this.doStepInto(session, true, smartStepTarget));
                ListPopupImpl listPopupImpl = new ListPopupImpl((ListPopupStep)psiMethodListPopupStep);
                DebuggerUIUtil.registerExtraHandleShortcuts((ListPopupImpl)listPopupImpl, (String[])new String[]{"StepInto", "SmartStepInto"});
                listPopupImpl.setAdText(DebuggerUIUtil.getSelectionShortcutsAdText((String[])new String[]{"StepInto", "SmartStepInto"}));
                UIUtil.maybeInstall((InputMap)listPopupImpl.getList().getInputMap(0), (String)"selectNextRow", (KeyStroke)KeyStroke.getKeyStroke(9, 0));
                listPopupImpl.addListSelectionListener(new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent e10) {
                        SmartStepTarget smartStepTarget;
                        psiMethodListPopupStep.getScopeHighlighter().dropHighlight();
                        if (!e10.getValueIsAdjusting() && (smartStepTarget = (SmartStepTarget)((JBList)e10.getSource()).getSelectedValue()) != null) {
                            JvmSmartStepIntoHandler.a(psiMethodListPopupStep, smartStepTarget);
                        }
                    }
                });
                JvmSmartStepIntoHandler.a(psiMethodListPopupStep, smartStepTarget2);
                DebuggerUIUtil.showPopupForEditorLine((JBPopup)listPopupImpl, (Editor)editor, (int)position.getLine());
            }
            return true;
        }
        return false;
    }

    protected void doStepInto(DebuggerSession session, boolean force, SmartStepTarget target) {
        JvmSmartStepIntoActionHandler.doStepInto(session, force, this.createMethodFilter(target));
    }

    private static void a(PsiMethodListPopupStep psiMethodListPopupStep, SmartStepTarget smartStepTarget) {
        PsiElement psiElement = smartStepTarget.getHighlightElement();
        if (psiElement != null) {
            psiMethodListPopupStep.getScopeHighlighter().highlight(psiElement, Collections.singletonList(psiElement));
        }
    }

    @Nullable
    protected MethodFilter createMethodFilter(SmartStepTarget stepTarget) {
        long l2 = c ^ 0x10D9EDAD73F5L;
        if (stepTarget instanceof MethodSmartStepTarget) {
            PsiMethod psiMethod = ((MethodSmartStepTarget)stepTarget).getMethod();
            if (stepTarget.needsBreakpointRequest()) {
                return Registry.is((String)"debugger.async.smart.step.into") && psiMethod.getContainingClass() instanceof PsiAnonymousClass ? new ClassInstanceMethodFilter(psiMethod, stepTarget.getCallingExpressionLines()) : new AnonymousClassMethodFilter(psiMethod, stepTarget.getCallingExpressionLines());
            }
            return new BasicStepMethodFilter(psiMethod, stepTarget.getCallingExpressionLines());
        }
        if (stepTarget instanceof LambdaSmartStepTarget) {
            PsiElement psiElement;
            PsiLambdaExpression psiLambdaExpression;
            PsiElement psiElement2;
            LambdaSmartStepTarget lambdaSmartStepTarget = (LambdaSmartStepTarget)stepTarget;
            LambdaMethodFilter lambdaMethodFilter = new LambdaMethodFilter(lambdaSmartStepTarget.getLambda(), lambdaSmartStepTarget.getOrdinal(), stepTarget.getCallingExpressionLines());
            if (Registry.is((String)"debugger.async.smart.step.into") && lambdaSmartStepTarget.isAsync() && (psiElement2 = (psiLambdaExpression = ((LambdaSmartStepTarget)stepTarget).getLambda()).getParent()) instanceof PsiExpressionList && (psiElement = psiElement2.getParent()) instanceof PsiMethodCallExpression) {
                return new LambdaAsyncMethodFilter(((PsiMethodCallExpression)psiElement).resolveMethod(), LambdaUtil.getLambdaIdx((PsiExpressionList)((PsiExpressionList)psiElement2), (PsiElement)psiLambdaExpression), lambdaMethodFilter);
            }
            return lambdaMethodFilter;
        }
        return null;
    }

    static {
        c = lb.a(-2069627984136136423L, 7440213014914763696L, MethodHandles.lookup().lookupClass()).a(219032570323287L);
        long l2 = c ^ 0x4C0D903A852AL;
        EP_NAME = ExtensionPointName.create((String)"com.intellij.debugger.jvmSmartStepIntoHandler");
    }
}

