/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import b.a.lb;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.MethodBytecodeUtil;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import java.lang.invoke.MethodHandles;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JumpToObjectAction
extends DebuggerAction {
    private static final Logger b;
    private static final long c;

    public void actionPerformed(@NotNull AnActionEvent e10) {
        DebuggerTreeNodeImpl debuggerTreeNodeImpl;
        if (e10 == null) {
            JumpToObjectAction.b(0);
        }
        if ((debuggerTreeNodeImpl = JumpToObjectAction.getSelectedNode(e10.getDataContext())) == null) {
            return;
        }
        NodeDescriptorImpl nodeDescriptorImpl = debuggerTreeNodeImpl.getDescriptor();
        if (!(nodeDescriptorImpl instanceof ValueDescriptor)) {
            return;
        }
        DebuggerContextImpl debuggerContextImpl = JumpToObjectAction.getDebuggerContext(e10.getDataContext());
        DebugProcessImpl debugProcessImpl = debuggerContextImpl.getDebugProcess();
        if (debugProcessImpl == null) {
            return;
        }
        debugProcessImpl.getManagerThread().schedule(new NavigateCommand(debuggerContextImpl, (ValueDescriptor)((Object)nodeDescriptorImpl), debugProcessImpl, e10));
    }

    public void update(@NotNull AnActionEvent e10) {
        if (e10 == null) {
            JumpToObjectAction.b(1);
        }
        if (!JumpToObjectAction.isFirstStart(e10)) {
            return;
        }
        DebuggerContextImpl debuggerContextImpl = JumpToObjectAction.getDebuggerContext(e10.getDataContext());
        DebugProcessImpl debugProcessImpl = debuggerContextImpl.getDebugProcess();
        if (debugProcessImpl == null) {
            e10.getPresentation().setVisible(false);
            return;
        }
        DebuggerTreeNodeImpl debuggerTreeNodeImpl = JumpToObjectAction.getSelectedNode(e10.getDataContext());
        if (debuggerTreeNodeImpl == null) {
            e10.getPresentation().setVisible(false);
            return;
        }
        NodeDescriptorImpl nodeDescriptorImpl = debuggerTreeNodeImpl.getDescriptor();
        if (nodeDescriptorImpl instanceof ValueDescriptor) {
            debugProcessImpl.getManagerThread().schedule(new EnableCommand(debuggerContextImpl, (ValueDescriptor)((Object)nodeDescriptorImpl), debugProcessImpl, e10));
        } else {
            e10.getPresentation().setVisible(false);
        }
    }

    private static SourcePosition a(ValueDescriptor valueDescriptor, DebugProcessImpl debugProcessImpl) throws ClassNotLoadedException {
        Type type = valueDescriptor.getType();
        if (type == null) {
            return null;
        }
        try {
            if (type instanceof ArrayType) {
                type = ((ArrayType)type).componentType();
            }
            if (type instanceof ClassType) {
                Location location;
                ClassType classType = (ClassType)type;
                Method method = MethodBytecodeUtil.getLambdaMethod(classType, debugProcessImpl.getVirtualMachineProxy().getClassesByNameProvider());
                Location location2 = location = method != null ? (Location)ContainerUtil.getFirstItem(DebuggerUtilsEx.allLineLocations(method)) : null;
                if (location == null) {
                    location = (Location)ContainerUtil.getFirstItem(classType.allLineLocations());
                }
                if (location != null) {
                    SourcePosition sourcePosition = debugProcessImpl.getPositionManager().getSourcePosition(location);
                    return (SourcePosition)ReadAction.compute(() -> {
                        SourcePosition sourcePosition2;
                        PsiClass psiClass;
                        if (classType.name().indexOf(36) < 0 && (psiClass = JVMNameUtil.getClassAt(sourcePosition)) != null && (sourcePosition2 = SourcePosition.createFromElement((PsiElement)psiClass)) != null) {
                            return sourcePosition2;
                        }
                        return sourcePosition;
                    });
                }
            }
        }
        catch (AbsentInformationException | ClassNotPreparedException exception) {
            b.debug((Throwable)exception);
        }
        return null;
    }

    static {
        c = lb.a(-3676741658726650122L, 8810940439114890011L, MethodHandles.lookup().lookupClass()).a(99995270734051L);
        long l2 = c ^ 0x3214133F90FCL;
        b = Logger.getInstance((String)"#com.intellij.debugger.actions.JumpToObjectAction");
    }

    private static /* synthetic */ void b(int n2) {
        Object[] objectArray;
        long l2 = c ^ 0x124CB7A872CFL;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/debugger/actions/JumpToObjectAction";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static abstract class SourcePositionCommand
    extends SuspendContextCommandImpl {
        protected final DebuggerContextImpl myDebuggerContext;
        protected final ValueDescriptor myDescriptor;
        protected final DebugProcessImpl myDebugProcess;
        protected final AnActionEvent myActionEvent;
        private static final long e = lb.a(-5506416607804013688L, 1103754473387306850L, MethodHandles.lookup().lookupClass()).a(165522292298855L);

        public SourcePositionCommand(DebuggerContextImpl debuggerContext, ValueDescriptor descriptor2, DebugProcessImpl debugProcess, AnActionEvent actionEvent) {
            super(debuggerContext.getSuspendContext());
            this.myDebuggerContext = debuggerContext;
            this.myDescriptor = descriptor2;
            this.myDebugProcess = debugProcess;
            this.myActionEvent = actionEvent;
        }

        @Override
        public void contextAction(@NotNull SuspendContextImpl suspendContext) {
            block3: {
                if (suspendContext == null) {
                    SourcePositionCommand.b(0);
                }
                try {
                    this.doAction(JumpToObjectAction.a(this.myDescriptor, this.myDebugProcess));
                }
                catch (ClassNotLoadedException classNotLoadedException) {
                    String string = classNotLoadedException.className();
                    if (this.a(string) == null) break block3;
                    this.myDebugProcess.getManagerThread().schedule(this.createRetryCommand());
                }
            }
        }

        protected abstract SourcePositionCommand createRetryCommand();

        protected abstract void doAction(@Nullable SourcePosition var1);

        private ReferenceType a(String string) {
            EvaluationContextImpl evaluationContextImpl = this.myDebuggerContext.createEvaluationContext();
            try {
                return this.myDebugProcess.loadClass(evaluationContextImpl, string, evaluationContextImpl.getClassLoader());
            }
            catch (Throwable throwable) {
                return null;
            }
        }

        private static /* synthetic */ void b(int n2) {
            long l2 = e ^ 0x359F7849C071L;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/actions/JumpToObjectAction$SourcePositionCommand", "contextAction"));
        }
    }

    private static class EnableCommand
    extends SourcePositionCommand {
        EnableCommand(DebuggerContextImpl debuggerContext, ValueDescriptor descriptor2, DebugProcessImpl debugProcess, AnActionEvent e10) {
            super(debuggerContext, descriptor2, debugProcess, e10);
        }

        @Override
        protected EnableCommand createRetryCommand() {
            return new EnableCommand(this.myDebuggerContext, this.myDescriptor, this.myDebugProcess, this.myActionEvent);
        }

        @Override
        protected void doAction(SourcePosition sourcePosition) {
            DebuggerAction.enableAction(this.myActionEvent, sourcePosition != null);
        }
    }

    public static class NavigateCommand
    extends SourcePositionCommand {
        public NavigateCommand(DebuggerContextImpl debuggerContext, ValueDescriptor descriptor2, DebugProcessImpl debugProcess, AnActionEvent e10) {
            super(debuggerContext, descriptor2, debugProcess, e10);
        }

        @Override
        protected NavigateCommand createRetryCommand() {
            return new NavigateCommand(this.myDebuggerContext, this.myDescriptor, this.myDebugProcess, this.myActionEvent);
        }

        @Override
        protected void doAction(SourcePosition sourcePosition) {
            if (sourcePosition != null) {
                sourcePosition.navigate(true);
            }
        }
    }
}

