/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger;

import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import java.util.Objects;
import org.jdom.Element;

@Tag(value="instance-filter")
public class InstanceFilter
implements JDOMExternalizable {
    public static final InstanceFilter[] EMPTY_ARRAY = new InstanceFilter[0];
    @Attribute(value="id")
    public long ID = 0L;
    @Attribute(value="enabled")
    public boolean ENABLED = true;

    public InstanceFilter() {
    }

    protected InstanceFilter(long ID, boolean ENABLED) {
        this.ID = ID;
        this.ENABLED = ENABLED;
    }

    @Transient
    public long getId() {
        return this.ID;
    }

    @Transient
    public boolean isEnabled() {
        return this.ENABLED;
    }

    public void setId(long id2) {
        this.ID = id2;
    }

    public void setEnabled(boolean enabled) {
        this.ENABLED = enabled;
    }

    public static InstanceFilter create(long id2) {
        return new InstanceFilter(id2, true);
    }

    public static InstanceFilter create(String pattern) {
        return InstanceFilter.create(Long.parseLong(pattern));
    }

    public static InstanceFilter create(ClassFilter filter) {
        return new InstanceFilter(Long.parseLong(filter.getPattern()), filter.isEnabled());
    }

    public void readExternal(Element element) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
    }

    public static ClassFilter[] createClassFilters(InstanceFilter[] filters) {
        ClassFilter[] classFilterArray = new ClassFilter[filters.length];
        for (int i10 = 0; i10 < classFilterArray.length; ++i10) {
            InstanceFilter instanceFilter = filters[i10];
            ClassFilter classFilter = new ClassFilter();
            classFilter.setEnabled(instanceFilter.isEnabled());
            classFilter.setPattern(Long.toString(instanceFilter.getId()));
            classFilterArray[i10] = classFilter;
        }
        return classFilterArray;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        InstanceFilter instanceFilter = (InstanceFilter)o2;
        if (this.ID != instanceFilter.ID) {
            return false;
        }
        return this.ENABLED == instanceFilter.ENABLED;
    }

    public int hashCode() {
        return Objects.hash(this.ID, this.ENABLED);
    }
}

