/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.conversion;

import b.a.lb;
import com.intellij.conversion.ConversionListener;
import com.intellij.conversion.ConversionResult;
import com.intellij.conversion.ConversionService;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

public class ProjectConversionTestUtil {
    private ProjectConversionTestUtil() {
    }

    public static void assertNoConversionNeeded(String projectPath) {
        MyConversionListener myConversionListener = new MyConversionListener();
        ConversionResult conversionResult = ConversionService.getInstance().convertSilently(projectPath, (ConversionListener)myConversionListener);
        Assert.assertTrue((boolean)conversionResult.conversionNotNeeded());
        Assert.assertFalse((boolean)myConversionListener.isConversionNeeded());
        Assert.assertFalse((boolean)myConversionListener.isConverted());
    }

    public static void convert(String projectPath) {
        MyConversionListener myConversionListener = new MyConversionListener();
        ConversionResult conversionResult = ConversionService.getInstance().convertSilently(projectPath, (ConversionListener)myConversionListener);
        Assert.assertFalse((boolean)conversionResult.conversionNotNeeded());
        Assert.assertFalse((boolean)conversionResult.openingIsCanceled());
        Assert.assertTrue((boolean)myConversionListener.isConversionNeeded());
        Assert.assertTrue((boolean)myConversionListener.isConverted());
    }

    public static class MyConversionListener
    implements ConversionListener {
        private boolean a;
        private boolean b;
        private static final long c = lb.a(-1869286707482749087L, -6452280794113042400L, MethodHandles.lookup().lookupClass()).a(66590676163307L);

        public void conversionNeeded() {
            this.a = true;
        }

        public void successfullyConverted(@NotNull File backupDir) {
            if (backupDir == null) {
                MyConversionListener.a(0);
            }
            this.b = true;
        }

        public void error(@NotNull String message) {
            if (message == null) {
                MyConversionListener.a(1);
            }
            Assert.fail((String)message);
        }

        public void cannotWriteToFiles(@NotNull List<? extends File> readonlyFiles) {
            if (readonlyFiles == null) {
                MyConversionListener.a(2);
            }
        }

        public boolean isConversionNeeded() {
            return this.a;
        }

        public boolean isConverted() {
            return this.b;
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            long l2 = c ^ 0x3D22293916BDL;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "backupDir";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "readonlyFiles";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/conversion/ProjectConversionTestUtil$MyConversionListener";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "successfullyConverted";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "error";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "cannotWriteToFiles";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

