/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.server;

import b.a.lb;
import com.intellij.compiler.server.BuilderMessageHandler;
import com.intellij.compiler.server.CustomBuilderMessageHandler;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.util.SmartList;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import io.netty.channel.Channel;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.api.CmdlineProtoUtil;
import org.jetbrains.jps.api.CmdlineRemoteProto;

public abstract class DefaultMessageHandler
implements BuilderMessageHandler {
    private static final Logger b;
    public static final long CONSTANT_SEARCH_TIME_LIMIT = 60000L;
    private final Project a;
    private final ExecutorService d;
    private volatile long c;
    private static final long l;

    protected DefaultMessageHandler(Project project2) {
        long l2 = l ^ 0x6DD19B5F8B81L;
        this.d = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"DefaultMessageHandler Pool");
        this.c = 0L;
        this.a = project2;
    }

    @Override
    public void buildStarted(@NotNull UUID sessionId) {
        if (sessionId == null) {
            DefaultMessageHandler.c(0);
        }
    }

    @Override
    public final void handleBuildMessage(Channel channel, UUID sessionId, CmdlineRemoteProto.Message.BuilderMessage msg) {
        long l2 = l ^ 0x3E39974E3062L;
        switch (msg.getType()) {
            case BUILD_EVENT: {
                CmdlineRemoteProto.Message.BuilderMessage.BuildEvent buildEvent = msg.getBuildEvent();
                if (buildEvent.getEventType() == CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.Type.CUSTOM_BUILDER_MESSAGE && buildEvent.hasCustomBuilderMessage()) {
                    CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.CustomBuilderMessage customBuilderMessage = buildEvent.getCustomBuilderMessage();
                    if (!this.a.isDisposed()) {
                        ((CustomBuilderMessageHandler)this.a.getMessageBus().syncPublisher(CustomBuilderMessageHandler.TOPIC)).messageReceived(customBuilderMessage.getBuilderId(), customBuilderMessage.getMessageType(), customBuilderMessage.getMessageText());
                    }
                }
                this.handleBuildEvent(sessionId, buildEvent);
                break;
            }
            case COMPILE_MESSAGE: {
                CmdlineRemoteProto.Message.BuilderMessage.CompileMessage compileMessage = msg.getCompileMessage();
                this.handleCompileMessage(sessionId, compileMessage);
                if (compileMessage.getKind() != CmdlineRemoteProto.Message.BuilderMessage.CompileMessage.Kind.INTERNAL_BUILDER_ERROR) break;
                b.error("Internal build error:\n" + compileMessage.getText());
                break;
            }
            case CONSTANT_SEARCH_TASK: {
                CmdlineRemoteProto.Message.BuilderMessage.ConstantSearchTask constantSearchTask = msg.getConstantSearchTask();
                this.b(channel, sessionId, constantSearchTask);
            }
        }
    }

    protected abstract void handleCompileMessage(UUID var1, CmdlineRemoteProto.Message.BuilderMessage.CompileMessage var2);

    protected abstract void handleBuildEvent(UUID var1, CmdlineRemoteProto.Message.BuilderMessage.BuildEvent var2);

    private void b(Channel channel, UUID uUID, CmdlineRemoteProto.Message.BuilderMessage.ConstantSearchTask constantSearchTask) {
        ReadAction.nonBlocking(() -> this.c(channel, uUID, constantSearchTask)).inSmartMode(this.a).submit((Executor)this.d);
    }

    private void c(Channel channel, UUID uUID, CmdlineRemoteProto.Message.BuilderMessage.ConstantSearchTask constantSearchTask) {
        block14: {
            long l2 = l ^ 0x43EE0AF811BFL;
            String string = constantSearchTask.getOwnerClassName();
            String string2 = constantSearchTask.getFieldName();
            int n2 = constantSearchTask.getAccessFlags();
            boolean bl2 = constantSearchTask.getIsAccessChanged();
            boolean bl3 = constantSearchTask.getIsFieldRemoved();
            boolean bl4 = false;
            Ref ref = Ref.create((Object)Boolean.TRUE);
            Set<String> set = Collections.synchronizedSet(new HashSet());
            long l3 = System.currentTimeMillis();
            try {
                if (this.c > 60000L) {
                    ref.set((Object)Boolean.FALSE);
                    b.debug("Total constant search time exceeded time limit for this build session");
                    break block14;
                }
                if (this.a()) {
                    ref.set((Object)Boolean.FALSE);
                    b.debug("Constant search task: cannot search in dumb mode");
                    break block14;
                }
                String string3 = string.replace('$', '.');
                this.handleCompileMessage(uUID, CmdlineProtoUtil.createCompileProgressMessageResponse((String)("Searching for usages of changed/removed constants for class " + string3)).getCompileMessage());
                PsiClass[] psiClassArray = (PsiClass[])ReadAction.compute(() -> JavaPsiFacade.getInstance((Project)this.a).findClasses(string3, GlobalSearchScope.allScope((Project)this.a)));
                try {
                    if (bl3) {
                        ApplicationManager.getApplication().runReadAction(() -> {
                            if (psiClassArray.length > 0) {
                                for (PsiClass psiClass : psiClassArray) {
                                    boolean bl2;
                                    boolean bl3 = bl2 = psiClass.isValid() && this.a(psiClass, string2, n2, set);
                                    if (bl2) continue;
                                    ref.set((Object)Boolean.FALSE);
                                    break;
                                }
                            } else {
                                ref.set((Object)this.a(null, string2, n2, set));
                            }
                        });
                        break block14;
                    }
                    if (psiClassArray.length > 0) {
                        Collection collection = (Collection)ReadAction.compute(() -> {
                            SmartList smartList = new SmartList();
                            for (PsiClass psiClass : psiClassArray) {
                                if (!psiClass.isValid()) {
                                    return Collections.emptyList();
                                }
                                PsiField psiField = psiClass.findFieldByName(string2, false);
                                if (psiField == null) continue;
                                smartList.add(psiField);
                            }
                            return smartList;
                        });
                        if (collection.isEmpty()) {
                            ref.set((Object)Boolean.FALSE);
                            b.debug("Constant search task: field " + string2 + " not found in classes " + string3);
                            break block14;
                        }
                        for (PsiField psiField : collection) {
                            if (!bl2 && DefaultMessageHandler.a(n2) || this.a(psiField, bl2, set)) continue;
                            ref.set((Object)Boolean.FALSE);
                            break block14;
                        }
                        break block14;
                    }
                    ref.set((Object)Boolean.FALSE);
                    b.debug("Constant search task: class " + string3 + " not found");
                }
                catch (Throwable throwable) {
                    ref.set((Object)Boolean.FALSE);
                    b.debug("Constant search task: failed with message " + throwable.getMessage());
                }
            }
            catch (ProcessCanceledException processCanceledException) {
                bl4 = true;
                throw processCanceledException;
            }
            finally {
                this.c += System.currentTimeMillis() - l3;
                if (!bl4) {
                    DefaultMessageHandler.a(channel, uUID, string, string2, (Ref<Boolean>)ref, set);
                }
            }
        }
    }

    private static void a(Channel channel, UUID uUID, String string, String string2, Ref<Boolean> ref, Set<String> set) {
        long l2 = l ^ 0x244E92C0ADCAL;
        CmdlineRemoteProto.Message.ControllerMessage.ConstantSearchResult.Builder builder = CmdlineRemoteProto.Message.ControllerMessage.ConstantSearchResult.newBuilder();
        builder.setOwnerClassName(string);
        builder.setFieldName(string2);
        if (((Boolean)ref.get()).booleanValue()) {
            builder.setIsSuccess(true);
            builder.addAllPath(set);
            b.debug("Constant search task: " + set.size() + " affected files found");
        } else {
            builder.setIsSuccess(false);
            b.debug("Constant search task: unsuccessful");
        }
        channel.writeAndFlush((Object)CmdlineProtoUtil.toMessage((UUID)uUID, (CmdlineRemoteProto.Message.ControllerMessage)((CmdlineRemoteProto.Message.ControllerMessage)CmdlineRemoteProto.Message.ControllerMessage.newBuilder().setType(CmdlineRemoteProto.Message.ControllerMessage.Type.CONSTANT_SEARCH_RESULT).setConstantSearchResult((CmdlineRemoteProto.Message.ControllerMessage.ConstantSearchResult)builder.build()).build())));
    }

    private boolean a() {
        DumbService dumbService = DumbService.getInstance((Project)this.a);
        boolean bl2 = dumbService.isDumb();
        if (bl2) {
            for (int i10 = 0; i10 < 5; ++i10) {
                TimeoutUtil.sleep((long)10L);
                bl2 = dumbService.isDumb();
                if (!bl2) break;
            }
        }
        return bl2;
    }

    private boolean a(@Nullable PsiClass psiClass, String string, int n2, final Set<? super String> set) {
        long l2 = l ^ 0x421C366B1B93L;
        PsiSearchHelper psiSearchHelper = PsiSearchHelper.getInstance((Project)this.a);
        final Ref ref = new Ref((Object)Boolean.TRUE);
        final PsiFile psiFile = psiClass != null ? psiClass.getContainingFile() : null;
        SearchScope searchScope = this.a(psiClass, n2);
        if (DefaultMessageHandler.a(searchScope)) {
            b.debug("Constant search tasks: there may be usages of " + (psiClass != null ? psiClass.getQualifiedName() + "::" : "") + string + " in unloaded modules");
            return false;
        }
        DefaultMessageHandler.a(psiSearchHelper, (PsiElementProcessor<? super PsiIdentifier>)new PsiElementProcessor<PsiIdentifier>(){
            private static final long a = lb.a(-3188571493237515001L, -7114234797873625924L, MethodHandles.lookup().lookupClass()).a(209946172613274L);

            public boolean execute(@NotNull PsiIdentifier identifier) {
                long l2 = a ^ 0x3A9A9383FD20L;
                if (identifier == null) {
                    1.a(0);
                }
                try {
                    VirtualFile virtualFile;
                    PsiFile psiFile2;
                    PsiClass psiClass;
                    PsiElement psiElement = identifier.getParent();
                    if (psiElement instanceof PsiReferenceExpression && (psiClass = DefaultMessageHandler.a(psiElement)) != null && psiClass.getQualifiedName() != null && (psiFile2 = psiClass.getContainingFile()) != null && !psiFile2.equals(psiFile) && (virtualFile = psiFile2.getOriginalFile().getVirtualFile()) != null) {
                        set.add(virtualFile.getPath());
                    }
                    return true;
                }
                catch (PsiInvalidElementAccessException psiInvalidElementAccessException) {
                    ref.set((Object)Boolean.FALSE);
                    b.debug("Constant search task: PIEAE thrown while searching of usages of removed constant");
                    return false;
                }
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x4BA16B8E24D9L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "com/intellij/compiler/server/DefaultMessageHandler$1", "execute"));
            }
        }, string, searchScope, (short)1);
        return (Boolean)ref.get();
    }

    private SearchScope a(PsiClass psiClass, int n2) {
        PsiFile psiFile;
        GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)this.a);
        if (psiClass != null && DefaultMessageHandler.b(n2) && (psiFile = psiClass.getContainingFile()) instanceof PsiJavaFile) {
            String string = ((PsiJavaFile)psiFile).getPackageName();
            PsiPackage psiPackage = JavaPsiFacade.getInstance((Project)this.a).findPackage(string);
            if (psiPackage != null) {
                globalSearchScope = PackageScope.packageScope((PsiPackage)psiPackage, (boolean)false);
                globalSearchScope = globalSearchScope.intersectWith(psiClass.getUseScope());
            }
        }
        return globalSearchScope;
    }

    private static boolean a(PsiSearchHelper psiSearchHelper, @NotNull PsiElementProcessor<? super PsiIdentifier> psiElementProcessor, @NotNull String string, @NotNull SearchScope searchScope, short s2) {
        if (psiElementProcessor == null) {
            DefaultMessageHandler.c(1);
        }
        if (string == null) {
            DefaultMessageHandler.c(2);
        }
        if (searchScope == null) {
            DefaultMessageHandler.c(3);
        }
        TextOccurenceProcessor textOccurenceProcessor = (psiElement, n2) -> {
            if (psiElementProcessor == null) {
                DefaultMessageHandler.c(4);
            }
            return !(psiElement instanceof PsiIdentifier) || psiElementProcessor.execute((PsiElement)((PsiIdentifier)psiElement));
        };
        SearchScope searchScope2 = searchScope instanceof GlobalSearchScope ? GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)((GlobalSearchScope)searchScope), (FileType[])new FileType[]{JavaFileType.INSTANCE}) : searchScope;
        return psiSearchHelper.processElementsWithWord(textOccurenceProcessor, searchScope2, string, s2, true, false);
    }

    private boolean a(PsiField psiField, boolean bl2, Set<? super String> set) throws ProcessCanceledException {
        return (Boolean)ReadAction.compute(() -> {
            if (psiField.isValid()) {
                Collection<PsiReferenceExpression> collection;
                PsiFile psiFile = psiField.getContainingFile();
                HashSet<PsiFile> hashSet = new HashSet<PsiFile>();
                if (psiFile != null) {
                    hashSet.add(psiFile);
                }
                if ((collection = this.a(psiField, bl2)) == null) {
                    return false;
                }
                for (PsiReferenceExpression psiReferenceExpression : collection) {
                    VirtualFile virtualFile;
                    PsiElement psiElement = psiReferenceExpression.getElement();
                    PsiFile psiFile2 = psiElement.getContainingFile();
                    if (psiFile2 == null || !hashSet.add(psiFile2) || (virtualFile = psiFile2.getOriginalFile().getVirtualFile()) == null) continue;
                    set.add(virtualFile.getPath());
                }
            }
            return true;
        });
    }

    @Nullable(value="returns null if search failed")
    private Collection<PsiReferenceExpression> a(final PsiField psiField, boolean bl2) {
        long l2 = l ^ 0x73B280016150L;
        final SmartList smartList = new SmartList();
        SearchScope searchScope = (bl2 ? psiField.getContainingFile() : psiField).getUseScope();
        if (DefaultMessageHandler.a(searchScope)) {
            PsiClass psiClass = psiField.getContainingClass();
            b.debug("Constant search tasks: there may be usages of " + (psiClass != null ? psiClass.getQualifiedName() + "::" : "") + psiField.getName() + " in unloaded modules");
            return null;
        }
        DefaultMessageHandler.a(PsiSearchHelper.getInstance((Project)this.a), (PsiElementProcessor<? super PsiIdentifier>)new PsiElementProcessor<PsiIdentifier>(){
            private static final long a = lb.a(-2237603484887750222L, 4855436214251825973L, MethodHandles.lookup().lookupClass()).a(265395310557938L);

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean execute(@NotNull PsiIdentifier identifier) {
                PsiReferenceExpression psiReferenceExpression;
                PsiElement psiElement;
                if (identifier == null) {
                    2.a(0);
                }
                if ((psiElement = identifier.getParent()) instanceof PsiReferenceExpression && (psiReferenceExpression = (PsiReferenceExpression)psiElement).isReferenceTo((PsiElement)psiField)) {
                    SmartList smartList2 = smartList;
                    synchronized (smartList2) {
                        smartList.add((Object)psiReferenceExpression);
                    }
                }
                return true;
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x5FB1B996EB6L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "com/intellij/compiler/server/DefaultMessageHandler$2", "execute"));
            }
        }, psiField.getName(), searchScope, (short)1);
        return smartList;
    }

    @Nullable
    private static PsiClass a(PsiElement psiElement) {
        while (!(psiElement instanceof PsiFile)) {
            if (psiElement instanceof PsiClass && psiElement.getParent() instanceof PsiJavaFile) {
                PsiClass psiClass = (PsiClass)psiElement;
                if (JspPsiUtil.isInJspFile((PsiElement)psiClass)) {
                    return null;
                }
                PsiFile psiFile = psiClass.getContainingFile();
                if (psiFile == null) {
                    return null;
                }
                return JavaLanguage.INSTANCE.equals(psiFile.getLanguage()) ? psiClass : null;
            }
            psiElement = psiElement.getParent();
        }
        return null;
    }

    private static boolean a(SearchScope searchScope) {
        if (searchScope instanceof LocalSearchScope) {
            return false;
        }
        if (searchScope instanceof GlobalSearchScope) {
            return !((GlobalSearchScope)searchScope).getUnloadedModulesBelongingToScope().isEmpty();
        }
        return true;
    }

    private static boolean b(int n2) {
        return (1 & n2) == 0 && (4 & n2) == 0 && (2 & n2) == 0;
    }

    private static boolean a(int n2) {
        return (2 & n2) != 0;
    }

    static {
        l = lb.a(598614409872551310L, -1655519423783367866L, MethodHandles.lookup().lookupClass()).a(135879119739602L);
        long l2 = l ^ 0x521D5863D9D7L;
        b = Logger.getInstance((String)"#com.intellij.compiler.server.DefaultMessageHandler");
    }

    private static /* synthetic */ void c(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = l ^ 0x143B086F3A7DL;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionId";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
        }
        objectArray2[1] = "com/intellij/compiler/server/DefaultMessageHandler";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildStarted";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "processIdentifiers";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$processIdentifiers$4";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

