/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.server;

import b.a.lb;
import com.intellij.compiler.CompilerMessageImpl;
import com.intellij.compiler.ProblemsView;
import com.intellij.compiler.impl.CompileDriver;
import com.intellij.compiler.server.AutomakeCompileContext;
import com.intellij.compiler.server.DefaultMessageHandler;
import com.intellij.notification.Notification;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.compiler.CompilationStatusListener;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerMessage;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.CompilerTopics;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.problems.Problem;
import com.intellij.problems.WolfTheProblemSolver;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.UUID;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.api.CmdlineRemoteProto;

class AutoMakeMessageHandler
extends DefaultMessageHandler {
    private static final Key<Notification> j;
    private CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.Status i;
    private final Project g;
    private final WolfTheProblemSolver e;
    private volatile boolean h = false;
    private final AutomakeCompileContext f;
    private static final long k;

    AutoMakeMessageHandler(Project project2) {
        super(project2);
        this.g = project2;
        this.i = CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.Status.SUCCESS;
        this.e = WolfTheProblemSolver.getInstance((Project)project2);
        this.f = new AutomakeCompileContext(project2);
    }

    public boolean unprocessedFSChangesDetected() {
        return this.h;
    }

    @Override
    protected void handleBuildEvent(UUID sessionId, CmdlineRemoteProto.Message.BuilderMessage.BuildEvent event) {
        long l2 = k ^ 0x724AF0DC3754L;
        if (this.g.isDisposed()) {
            return;
        }
        switch (event.getEventType()) {
            case BUILD_COMPLETED: {
                this.f.getProgressIndicator().stop();
                if (event.hasCompletionStatus()) {
                    CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.Status status;
                    this.i = status = event.getCompletionStatus();
                    if (status == CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.Status.CANCELED) {
                        this.f.getProgressIndicator().cancel();
                    }
                }
                int n2 = this.f.getMessageCount(CompilerMessageCategory.ERROR);
                int n3 = this.f.getMessageCount(CompilerMessageCategory.WARNING);
                SwingUtilities.invokeLater(() -> {
                    if (this.g.isDisposed()) {
                        return;
                    }
                    CompilationStatusListener compilationStatusListener = (CompilationStatusListener)this.g.getMessageBus().syncPublisher(CompilerTopics.COMPILATION_STATUS);
                    compilationStatusListener.automakeCompilationFinished(n2, n3, (CompileContext)this.f);
                });
                return;
            }
            case FILES_GENERATED: {
                CompilationStatusListener compilationStatusListener = (CompilationStatusListener)this.g.getMessageBus().syncPublisher(CompilerTopics.COMPILATION_STATUS);
                for (CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.GeneratedFile generatedFile : event.getGeneratedFilesList()) {
                    String string = FileUtil.toSystemIndependentName((String)generatedFile.getOutputRoot());
                    String string2 = FileUtil.toSystemIndependentName((String)generatedFile.getRelativePath());
                    compilationStatusListener.fileGenerated(string, string2);
                }
                return;
            }
            case CUSTOM_BUILDER_MESSAGE: {
                CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.CustomBuilderMessage customBuilderMessage;
                if (event.hasCustomBuilderMessage() && "JPS".equals((customBuilderMessage = event.getCustomBuilderMessage()).getBuilderId()) && "!unprocessed_fs_changes_detected!".equals(customBuilderMessage.getMessageType())) {
                    this.h = true;
                }
                return;
            }
        }
    }

    @Override
    protected void handleCompileMessage(UUID sessionId, CmdlineRemoteProto.Message.BuilderMessage.CompileMessage message) {
        long l2 = k ^ 0x29685D66765EL;
        if (this.g.isDisposed()) {
            return;
        }
        CmdlineRemoteProto.Message.BuilderMessage.CompileMessage.Kind kind = message.getKind();
        if (kind == CmdlineRemoteProto.Message.BuilderMessage.CompileMessage.Kind.PROGRESS) {
            ProblemsView problemsView = ProblemsView.SERVICE.getInstance(this.g);
            if (message.hasDone()) {
                problemsView.setProgress(message.getText(), message.getDone());
            } else {
                problemsView.setProgress(message.getText());
            }
        } else {
            CompilerMessageCategory compilerMessageCategory = CompileDriver.convertToCategory(kind, null);
            if (compilerMessageCategory != null) {
                String string = message.hasSourceFilePath() ? message.getSourceFilePath() : null;
                String string2 = string != null ? VirtualFileManager.constructUrl((String)"file", (String)FileUtil.toSystemIndependentName((String)string)) : null;
                long l3 = message.hasLine() ? message.getLine() : -1L;
                long l5 = message.hasColumn() ? message.getColumn() : -1L;
                CompilerMessage compilerMessage = this.f.createAndAddMessage(compilerMessageCategory, message.getText(), string2, (int)l3, (int)l5, null);
                if (compilerMessageCategory == CompilerMessageCategory.ERROR || kind == CmdlineRemoteProto.Message.BuilderMessage.CompileMessage.Kind.JPS_INFO) {
                    if (compilerMessageCategory == CompilerMessageCategory.ERROR) {
                        ReadAction.run(() -> this.a(this.g, message));
                    }
                    if (compilerMessage != null) {
                        ProblemsView.SERVICE.getInstance(this.g).addMessage(compilerMessage, sessionId);
                    }
                }
            }
        }
    }

    @Override
    public void handleFailure(@NotNull UUID sessionId, CmdlineRemoteProto.Message.Failure failure) {
        String string;
        long l2 = k ^ 0x1CB2283F8CAAL;
        if (sessionId == null) {
            AutoMakeMessageHandler.a(0);
        }
        if (this.g.isDisposed()) {
            return;
        }
        String string2 = string = failure.hasDescription() ? failure.getDescription() : null;
        if (string == null) {
            string = failure.hasStacktrace() ? failure.getStacktrace() : "";
        }
        String string3 = "Auto build failure: " + string;
        CompilerManager.NOTIFICATION_GROUP.createNotification(string3, MessageType.INFO);
        ProblemsView.SERVICE.getInstance(this.g).addMessage(new CompilerMessageImpl(this.g, CompilerMessageCategory.ERROR, string3), sessionId);
    }

    @Override
    public void sessionTerminated(@NotNull UUID sessionId) {
        Object object;
        long l2 = k ^ 0x33C97BA4D3CAL;
        if (sessionId == null) {
            AutoMakeMessageHandler.a(1);
        }
        String string = null;
        switch (this.i) {
            case SUCCESS: {
                break;
            }
            case UP_TO_DATE: {
                break;
            }
            case ERRORS: {
                string = "Auto build completed with errors";
                break;
            }
        }
        if (string != null) {
            object = CompilerManager.NOTIFICATION_GROUP.createNotification(string, MessageType.INFO);
            if (!this.g.isDisposed()) {
                object.notify(this.g);
            }
            this.g.putUserData(j, object);
        } else {
            object = (Notification)this.g.getUserData(j);
            if (object != null) {
                object.expire();
                this.g.putUserData(j, null);
            }
        }
        if (!this.g.isDisposed()) {
            object = ProblemsView.SERVICE.getInstance(this.g);
            ((ProblemsView)object).clearProgress();
            ((ProblemsView)object).clearOldMessages(null, sessionId);
        }
    }

    private void a(Project project2, CmdlineRemoteProto.Message.BuilderMessage.CompileMessage compileMessage) {
        VirtualFile virtualFile;
        String string = compileMessage.getSourceFilePath();
        if (string != null && !project2.isDisposed() && (virtualFile = LocalFileSystem.getInstance().findFileByPath(string)) != null) {
            int n2 = (int)compileMessage.getLine();
            int n3 = (int)compileMessage.getColumn();
            if (n2 > 0 && n3 > 0) {
                Problem problem = this.e.convertToProblem(virtualFile, n2, n3, new String[]{compileMessage.getText()});
                this.e.weHaveGotProblems(virtualFile, Collections.singletonList(problem));
            } else {
                this.e.queue(virtualFile);
            }
        }
    }

    static {
        k = lb.a(-7592567276641181347L, 2482170100126918033L, MethodHandles.lookup().lookupClass()).a(207434608545169L);
        long l2 = k ^ 0x265959916F91L;
        j = Key.create((String)"LAST_AUTO_MAKE_NOTIFICATION");
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        long l2 = k ^ 0x30F9BF3B100BL;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "sessionId";
        objectArray2[1] = "com/intellij/compiler/server/AutoMakeMessageHandler";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "handleFailure";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "sessionTerminated";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

