/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import b.a.lb;
import com.intellij.CommonBundle;
import com.intellij.compiler.CompilerMessageImpl;
import com.intellij.compiler.CompilerWorkspaceConfiguration;
import com.intellij.compiler.ModuleCompilerUtil;
import com.intellij.compiler.ModuleSourceSet;
import com.intellij.compiler.ProblemsView;
import com.intellij.compiler.impl.BuildTargetScopeProvider;
import com.intellij.compiler.impl.CompileContextImpl;
import com.intellij.compiler.impl.CompileScopeUtil;
import com.intellij.compiler.impl.CompilerCacheManager;
import com.intellij.compiler.impl.CompilerUtil;
import com.intellij.compiler.impl.ExitStatus;
import com.intellij.compiler.impl.ProjectCompileScope;
import com.intellij.compiler.progress.CompilerTask;
import com.intellij.compiler.server.BuildManager;
import com.intellij.compiler.server.DefaultMessageHandler;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.compiler.CompilationStatusListener;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompileStatusNotification;
import com.intellij.openapi.compiler.CompileTask;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.compiler.CompilerFilter;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerMessage;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.compiler.CompilerTopics;
import com.intellij.openapi.compiler.DummyCompileContext;
import com.intellij.openapi.compiler.ex.CompilerPathsEx;
import com.intellij.openapi.deployment.DeploymentUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.EffectiveLanguageLevelUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ui.configuration.DefaultModuleConfigurationEditorFactory;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.impl.compiler.ArtifactCompilerUtil;
import com.intellij.packaging.impl.compiler.ArtifactsCompiler;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.util.Chunk;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.text.DateFormatUtil;
import gnu.trove.THashSet;
import java.lang.invoke.MethodHandles;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.api.CmdlineProtoUtil;
import org.jetbrains.jps.api.CmdlineRemoteProto;
import org.jetbrains.jps.api.TaskFuture;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class CompileDriver {
    private static final Logger f;
    private static final Key<Boolean> g;
    private static final Key<ExitStatus> h;
    private static final long e = 60000L;
    private final Project a;
    private final Map<Module, String> d = new HashMap<Module, String>();
    private final Map<Module, String> c = new HashMap<Module, String>();
    private CompilerFilter b = CompilerFilter.ALL;
    private static final long i;

    public CompileDriver(Project project2) {
        this.a = project2;
    }

    public void setCompilerFilter(CompilerFilter compilerFilter) {
        this.b = compilerFilter == null ? CompilerFilter.ALL : compilerFilter;
    }

    public void rebuild(CompileStatusNotification callback) {
        this.a(callback, new ProjectCompileScope(this.a));
    }

    public void make(CompileScope scope, CompileStatusNotification callback) {
        this.make(scope, false, callback);
    }

    public void make(CompileScope scope, boolean withModalProgress, CompileStatusNotification callback) {
        if (this.b(scope)) {
            this.a(scope, false, false, withModalProgress, callback, null);
        } else {
            callback.finished(true, 0, 0, (CompileContext)DummyCompileContext.getInstance());
        }
    }

    public boolean isUpToDate(CompileScope scope) {
        long l2 = i ^ 0x30724AA471D5L;
        if (f.isDebugEnabled()) {
            f.debug("isUpToDate operation started");
        }
        CompilerTask compilerTask = new CompilerTask(this.a, "Classes up-to-date check", true, false, false, CompileDriver.a(scope));
        CompileContextImpl compileContextImpl = new CompileContextImpl(this.a, compilerTask, scope, true, false);
        Ref ref = new Ref();
        compilerTask.start(() -> {
            ProgressIndicator progressIndicator = compileContextImpl.getProgressIndicator();
            if (progressIndicator.isCanceled() || this.a.isDisposed()) {
                return;
            }
            try {
                TaskFuture taskFuture = this.a(compileContextImpl, true);
                if (taskFuture != null) {
                    while (!taskFuture.waitFor(200L, TimeUnit.MILLISECONDS)) {
                        if (!progressIndicator.isCanceled()) continue;
                        taskFuture.cancel(false);
                    }
                }
            }
            catch (Throwable throwable) {
                f.error(throwable);
            }
            finally {
                ref.set(h.get((UserDataHolder)compileContextImpl));
                if (!this.a.isDisposed()) {
                    CompilerCacheManager.getInstance(this.a).flushCaches();
                }
            }
        }, null);
        if (f.isDebugEnabled()) {
            f.debug("isUpToDate operation finished");
        }
        return ExitStatus.UP_TO_DATE.equals(ref.get());
    }

    public void compile(CompileScope scope, CompileStatusNotification callback) {
        if (this.b(scope)) {
            this.a(scope, false, true, callback, null);
        } else {
            callback.finished(true, 0, 0, (CompileContext)DummyCompileContext.getInstance());
        }
    }

    private void a(CompileStatusNotification compileStatusNotification, CompileScope compileScope) {
        if (this.b(compileScope)) {
            this.a(compileScope, true, false, compileStatusNotification, null);
        } else {
            compileStatusNotification.finished(true, 0, 0, (CompileContext)DummyCompileContext.getInstance());
        }
    }

    public static void setCompilationStartedAutomatically(CompileScope scope) {
        scope.putUserData(g, (Object)Boolean.TRUE);
    }

    private static boolean a(CompileScope compileScope) {
        return Boolean.TRUE.equals(compileScope.getUserData(g));
    }

    private List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> a(@NotNull CompileContextImpl compileContextImpl, CompileScope compileScope, Collection<String> collection) {
        if (compileContextImpl == null) {
            CompileDriver.a(0);
        }
        List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> list2 = new ArrayList<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope>();
        boolean bl2 = !compileContextImpl.isMake();
        List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> list3 = CompileScopeUtil.getBaseScopeForExternalBuild(compileScope);
        if (list3 != null) {
            list2.addAll(list3);
        } else if (!compileContextImpl.isRebuild() && !CompileScopeUtil.allProjectModulesAffected(compileContextImpl)) {
            CompileScopeUtil.addScopesForModules(Arrays.asList(compileScope.getAffectedModules()), compileScope.getAffectedUnloadedModules(), list2, bl2);
        } else {
            list2.addAll(CmdlineProtoUtil.createAllModulesScopes((boolean)bl2));
        }
        if (collection.isEmpty()) {
            list2 = this.a(compileScope, list2, bl2);
        }
        return list2;
    }

    private List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> a(CompileScope compileScope, List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> list2, boolean bl2) {
        for (BuildTargetScopeProvider buildTargetScopeProvider : (BuildTargetScopeProvider[])BuildTargetScopeProvider.EP_NAME.getExtensions()) {
            List list3 = (List)ReadAction.compute(() -> this.a.isDisposed() ? Collections.emptyList() : buildTargetScopeProvider.getBuildTargetScopes(compileScope, this.a, bl2));
            list2 = CompileScopeUtil.mergeScopes(list2, list3);
        }
        return list2;
    }

    @Nullable
    private TaskFuture a(final @NotNull CompileContextImpl compileContextImpl, boolean bl2) throws Exception {
        Map map2;
        HashMap<String, String> hashMap;
        long l2 = i ^ 0x5779A5E540E6L;
        if (compileContextImpl == null) {
            CompileDriver.a(1);
        }
        CompileScope compileScope = compileContextImpl.getCompileScope();
        List<String> list2 = CompileScopeUtil.fetchFiles(compileContextImpl);
        List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> list3 = this.a(compileContextImpl, compileScope, list2);
        if (bl2) {
            hashMap = new HashMap<String, String>();
        } else {
            map2 = compileScope.exportUserData();
            if (!map2.isEmpty()) {
                hashMap = new HashMap();
                for (Map.Entry object2 : map2.entrySet()) {
                    String string = ((Key)object2.getKey()).toString();
                    String string2 = object2.getValue().toString();
                    hashMap.put(string, string2);
                }
            } else {
                hashMap = new HashMap();
            }
        }
        if (!compileScope.getAffectedUnloadedModules().isEmpty()) {
            hashMap.put("load_unloaded_modules", Boolean.TRUE.toString());
        }
        map2 = this.a.getMessageBus();
        Iterator iterator = ArtifactCompilerUtil.containsArtifacts(list3) ? ArtifactCompilerUtil.createOutputToArtifactMap(this.a) : null;
        BuildManager buildManager = BuildManager.getInstance();
        buildManager.cancelAutoMakeTasks(this.a);
        return buildManager.scheduleBuild(this.a, compileContextImpl.isRebuild(), compileContextImpl.isMake(), bl2, list3, list2, hashMap, new DefaultMessageHandler(this.a, (MessageBus)map2, (MultiMap)iterator){
            final /* synthetic */ MessageBus val$messageBus;
            final /* synthetic */ MultiMap val$outputToArtifact;
            private static final long e = lb.a(340722537946264781L, -9133989126500969862L, MethodHandles.lookup().lookupClass()).a(78917692863136L);
            {
                this.val$messageBus = messageBus;
                this.val$outputToArtifact = multiMap;
                super(project2);
            }

            @Override
            public void sessionTerminated(@NotNull UUID sessionId) {
                if (sessionId == null) {
                    1.a(0);
                }
                if (compileContextImpl.shouldUpdateProblemsView()) {
                    ProblemsView problemsView = ProblemsView.SERVICE.getInstance(CompileDriver.this.a);
                    problemsView.clearProgress();
                    problemsView.clearOldMessages(compileContextImpl.getCompileScope(), compileContextImpl.getSessionId());
                }
            }

            @Override
            public void handleFailure(@NotNull UUID sessionId, CmdlineRemoteProto.Message.Failure failure) {
                String string;
                if (sessionId == null) {
                    1.a(1);
                }
                compileContextImpl.addMessage(CompilerMessageCategory.ERROR, failure.hasDescription() ? failure.getDescription() : "", null, -1, -1);
                String string2 = string = failure.hasStacktrace() ? failure.getStacktrace() : null;
                if (string != null) {
                    f.info(string);
                }
                compileContextImpl.putUserData(h, ExitStatus.ERRORS);
            }

            @Override
            protected void handleCompileMessage(UUID sessionId, CmdlineRemoteProto.Message.BuilderMessage.CompileMessage message) {
                long l2 = e ^ 0x5BB74B9F7223L;
                CmdlineRemoteProto.Message.BuilderMessage.CompileMessage.Kind kind = message.getKind();
                String string = message.getText();
                if (kind == CmdlineRemoteProto.Message.BuilderMessage.CompileMessage.Kind.PROGRESS) {
                    ProgressIndicator progressIndicator = compileContextImpl.getProgressIndicator();
                    progressIndicator.setText(string);
                    if (message.hasDone()) {
                        progressIndicator.setFraction((double)message.getDone());
                    }
                } else {
                    String string2;
                    CompilerMessageCategory compilerMessageCategory = CompileDriver.convertToCategory(kind, CompilerMessageCategory.INFORMATION);
                    String string3 = string2 = message.hasSourceFilePath() ? message.getSourceFilePath() : null;
                    if (string2 != null) {
                        string2 = FileUtil.toSystemIndependentName((String)string2);
                    }
                    long l3 = message.hasLine() ? message.getLine() : -1L;
                    long l5 = message.hasColumn() ? message.getColumn() : -1L;
                    String string4 = string2 != null ? VirtualFileManager.constructUrl((String)"file", (String)string2) : null;
                    compileContextImpl.addMessage(compilerMessageCategory, string, string4, (int)l3, (int)l5);
                    if (compileContextImpl.shouldUpdateProblemsView() && kind == CmdlineRemoteProto.Message.BuilderMessage.CompileMessage.Kind.JPS_INFO) {
                        Project project2 = compileContextImpl.getProject();
                        ProblemsView.SERVICE.getInstance(project2).addMessage(new CompilerMessageImpl(project2, compilerMessageCategory, string), compileContextImpl.getSessionId());
                    }
                }
            }

            @Override
            protected void handleBuildEvent(UUID sessionId, CmdlineRemoteProto.Message.BuilderMessage.BuildEvent event) {
                long l2 = e ^ 0x95E6253329L;
                CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.Type type = event.getEventType();
                switch (type) {
                    case FILES_GENERATED: {
                        List list2 = event.getGeneratedFilesList();
                        CompilationStatusListener compilationStatusListener = !CompileDriver.this.a.isDisposed() ? (CompilationStatusListener)this.val$messageBus.syncPublisher(CompilerTopics.COMPILATION_STATUS) : null;
                        THashSet tHashSet = this.val$outputToArtifact != null ? new THashSet(FileUtil.PATH_HASHING_STRATEGY) : null;
                        for (CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.GeneratedFile generatedFile : list2) {
                            Collection collection;
                            String string = FileUtil.toSystemIndependentName((String)generatedFile.getOutputRoot());
                            String string2 = FileUtil.toSystemIndependentName((String)generatedFile.getRelativePath());
                            if (compilationStatusListener != null) {
                                compilationStatusListener.fileGenerated(string, string2);
                            }
                            if (this.val$outputToArtifact == null || (collection = this.val$outputToArtifact.get((Object)string)).isEmpty()) continue;
                            for (Artifact artifact : collection) {
                                ArtifactsCompiler.addChangedArtifact(compileContextImpl, artifact);
                            }
                            tHashSet.add(FileUtil.toSystemDependentName((String)DeploymentUtil.appendToPath((String)string, (String)string2)));
                        }
                        if (tHashSet == null || tHashSet.isEmpty()) break;
                        ArtifactsCompiler.addWrittenPaths(compileContextImpl, (Set<String>)tHashSet);
                        break;
                    }
                    case BUILD_COMPLETED: {
                        ExitStatus exitStatus = ExitStatus.SUCCESS;
                        if (event.hasCompletionStatus()) {
                            CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.Status status = event.getCompletionStatus();
                            switch (status) {
                                case CANCELED: {
                                    exitStatus = ExitStatus.CANCELLED;
                                    break;
                                }
                                case ERRORS: {
                                    exitStatus = ExitStatus.ERRORS;
                                    break;
                                }
                                case SUCCESS: {
                                    exitStatus = ExitStatus.SUCCESS;
                                    break;
                                }
                                case UP_TO_DATE: {
                                    exitStatus = ExitStatus.UP_TO_DATE;
                                }
                            }
                        }
                        compileContextImpl.putUserDataIfAbsent(h, exitStatus);
                        break;
                    }
                    case CUSTOM_BUILDER_MESSAGE: {
                        String string;
                        CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.CustomBuilderMessage customBuilderMessage;
                        if (!event.hasCustomBuilderMessage() || !"JPS".equals((customBuilderMessage = event.getCustomBuilderMessage()).getBuilderId()) || !"!unprocessed_fs_changes_detected!".equals(customBuilderMessage.getMessageType()) || StringUtil.isEmpty((String)(string = customBuilderMessage.getMessageText()))) break;
                        compileContextImpl.addMessage(CompilerMessageCategory.INFORMATION, string, null, -1, -1);
                    }
                }
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                long l2 = e ^ 0x1798663302B5L;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "sessionId";
                objectArray2[1] = "com/intellij/compiler/impl/CompileDriver$1";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "sessionTerminated";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "handleFailure";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void a(CompileScope compileScope, boolean bl2, boolean bl3, CompileStatusNotification compileStatusNotification, CompilerMessage compilerMessage) {
        this.a(compileScope, bl2, bl3, false, compileStatusNotification, compilerMessage);
    }

    private void a(CompileScope compileScope, boolean bl2, boolean bl3, boolean bl4, CompileStatusNotification compileStatusNotification, CompilerMessage compilerMessage) {
        long l2 = i ^ 0x501EB4B5FB7BL;
        ApplicationManager.getApplication().assertIsDispatchThread();
        String string = CompilerBundle.message((String)(bl3 ? "compiler.content.name.compile" : "compiler.content.name.make"), (Object[])new Object[0]);
        boolean bl5 = ApplicationManager.getApplication().isUnitTestMode();
        CompilerTask compilerTask = new CompilerTask(this.a, string, bl5, !bl4, true, CompileDriver.a(compileScope), bl4);
        StatusBar.Info.set((String)"", (Project)this.a, (String)"Compiler");
        this.a.save();
        if (!bl5) {
            ApplicationManager.getApplication().saveSettings();
        }
        PsiDocumentManager.getInstance((Project)this.a).commitAllDocuments();
        FileDocumentManager.getInstance().saveAllDocuments();
        CompileContextImpl compileContextImpl = new CompileContextImpl(this.a, compilerTask, compileScope, !bl2 && !bl3, bl2);
        Runnable runnable = () -> {
            long l2 = i ^ 0x523E261AF69EL;
            ProgressIndicator progressIndicator = compileContextImpl.getProgressIndicator();
            if (progressIndicator.isCanceled() || this.a.isDisposed()) {
                if (compileStatusNotification != null) {
                    compileStatusNotification.finished(true, 0, 0, (CompileContext)compileContextImpl);
                }
                return;
            }
            CompilerCacheManager compilerCacheManager = CompilerCacheManager.getInstance(this.a);
            try {
                f.info("COMPILATION STARTED (BUILD PROCESS)");
                if (compilerMessage != null) {
                    compileContextImpl.addMessage(compilerMessage);
                }
                if (bl2) {
                    CompilerUtil.runInContext(compileContextImpl, "Clearing build system data...", () -> compilerCacheManager.clearCaches(compileContextImpl));
                }
                boolean bl3 = this.a((CompileContext)compileContextImpl, true);
                int n2 = compileContextImpl.getMessageCount(CompilerMessageCategory.ERROR);
                if (!bl3 || n2 > 0) {
                    h.set((UserDataHolder)compileContextImpl, (Object)(n2 > 0 ? ExitStatus.ERRORS : ExitStatus.CANCELLED));
                    return;
                }
                TaskFuture taskFuture = this.a(compileContextImpl, false);
                if (taskFuture != null) {
                    while (!taskFuture.waitFor(200L, TimeUnit.MILLISECONDS)) {
                        if (!progressIndicator.isCanceled()) continue;
                        taskFuture.cancel(false);
                    }
                    if (!this.a((CompileContext)compileContextImpl, false)) {
                        h.set((UserDataHolder)compileContextImpl, (Object)ExitStatus.CANCELLED);
                    }
                    if (compileContextImpl.getMessageCount(CompilerMessageCategory.ERROR) > 0) {
                        h.set((UserDataHolder)compileContextImpl, (Object)ExitStatus.ERRORS);
                    }
                }
            }
            catch (ProcessCanceledException processCanceledException) {
                compileContextImpl.putUserDataIfAbsent(h, ExitStatus.CANCELLED);
            }
            catch (Throwable throwable) {
                f.error(throwable);
            }
            finally {
                compilerCacheManager.flushCaches();
                long l3 = this.a(compileContextImpl, compileStatusNotification, (ExitStatus)h.get((UserDataHolder)compileContextImpl));
                CompilerUtil.logDuration("\tCOMPILATION FINISHED (BUILD PROCESS); Errors: " + compileContextImpl.getMessageCount(CompilerMessageCategory.ERROR) + "; warnings: " + compileContextImpl.getMessageCount(CompilerMessageCategory.WARNING), l3);
            }
        };
        compilerTask.start(runnable, () -> {
            int n2;
            long l2 = i ^ 0x761B64D3AE22L;
            if (bl2 && (n2 = Messages.showOkCancelDialog((Project)this.a, (String)"You are about to rebuild the whole project.\nRun 'Build Project' instead?", (String)"Confirm Project Rebuild", (String)"Build", (String)"Rebuild", (Icon)Messages.getQuestionIcon())) == 0) {
                this.a(compileScope, false, false, compileStatusNotification, null);
                return;
            }
            this.a(compileScope, bl2, bl3, compileStatusNotification, compilerMessage);
        });
    }

    @Nullable
    public static ExitStatus getExternalBuildExitStatus(CompileContext context) {
        return (ExitStatus)context.getUserData(h);
    }

    private long a(CompileContextImpl compileContextImpl, CompileStatusNotification compileStatusNotification, ExitStatus exitStatus) {
        long l2 = i ^ 0x6EC57F80367BL;
        long l3 = System.currentTimeMillis() - compileContextImpl.getStartCompilationStamp();
        if (!this.a.isDisposed()) {
            HashSet hashSet;
            Module[] moduleArray = compileContextImpl.getCompileScope().getAffectedModules();
            if (exitStatus != ExitStatus.UP_TO_DATE && exitStatus != ExitStatus.CANCELLED && !(hashSet = ContainerUtil.newHashSet((Object[])CompilerPathsEx.getOutputPaths((Module[])moduleArray))).isEmpty()) {
                ProgressIndicator progressIndicator = compileContextImpl.getProgressIndicator();
                progressIndicator.setText("Synchronizing output directories...");
                CompilerUtil.refreshOutputRoots(hashSet);
                progressIndicator.setText("");
            }
        }
        SwingUtilities.invokeLater(() -> {
            long l3 = i ^ 0x104575297B04L;
            int n2 = 0;
            int n3 = 0;
            try {
                n2 = compileContextImpl.getMessageCount(CompilerMessageCategory.ERROR);
                n3 = compileContextImpl.getMessageCount(CompilerMessageCategory.WARNING);
                if (compileStatusNotification != null) {
                    compileStatusNotification.finished(exitStatus == ExitStatus.CANCELLED, n2, n3, (CompileContext)compileContextImpl);
                }
            }
            catch (Throwable throwable) {
                if (compileStatusNotification != null) {
                    compileStatusNotification.finished(exitStatus == ExitStatus.CANCELLED, n2, n3, (CompileContext)compileContextImpl);
                }
                throw throwable;
            }
            if (!this.a.isDisposed()) {
                MessageType messageType;
                String string = CompileDriver.a(exitStatus, n3, n2, l3);
                MessageType messageType2 = n2 > 0 ? MessageType.ERROR : (messageType = n3 > 0 ? MessageType.WARNING : MessageType.INFO);
                if (l3 > 60000L && CompilerWorkspaceConfiguration.getInstance((Project)this.a).DISPLAY_NOTIFICATION_POPUP) {
                    ToolWindowManager.getInstance((Project)this.a).notifyByBalloon(ToolWindowId.MESSAGES_WINDOW, messageType, string);
                }
                String string2 = exitStatus != ExitStatus.UP_TO_DATE ? "<a href='#'>" + string + "</a>" : string;
                Notification notification = CompilerManager.NOTIFICATION_GROUP.createNotification("", string2, messageType.toNotificationType(), (NotificationListener)new MessagesActivationListener(compileContextImpl)).setImportant(false);
                compileContextImpl.getBuildSession().registerCloseAction(() -> ((Notification)notification).expire());
                notification.notify(this.a);
                if (exitStatus != ExitStatus.UP_TO_DATE && compileContextImpl.getMessageCount(null) > 0) {
                    String string3 = DateFormatUtil.formatDateTime((Date)new Date()) + " - " + string;
                    compileContextImpl.addMessage(CompilerMessageCategory.INFORMATION, string3, null, -1, -1);
                }
            }
        });
        return l3;
    }

    private static String a(ExitStatus exitStatus, int n2, int n3, long l2) {
        String string;
        long l3 = i ^ 0x4F0DA6B18F23L;
        if (exitStatus == ExitStatus.CANCELLED) {
            string = CompilerBundle.message((String)"status.compilation.aborted", (Object[])new Object[0]);
        } else if (exitStatus == ExitStatus.UP_TO_DATE) {
            string = CompilerBundle.message((String)"status.all.up.to.date", (Object[])new Object[0]);
        } else {
            string = exitStatus == ExitStatus.SUCCESS ? (n2 > 0 ? CompilerBundle.message((String)"status.compilation.completed.successfully.with.warnings", (Object[])new Object[]{n2}) : CompilerBundle.message((String)"status.compilation.completed.successfully", (Object[])new Object[0])) : CompilerBundle.message((String)"status.compilation.completed.successfully.with.warnings.and.errors", (Object[])new Object[]{n3, n2});
            string = string + " in " + StringUtil.formatDuration((long)l2);
        }
        return string;
    }

    private String a(Module module2, boolean bl2) {
        Map<Module, String> map2 = bl2 ? this.c : this.d;
        return map2.computeIfAbsent(module2, module3 -> CompilerPaths.getModuleOutputPath((Module)module2, (boolean)bl2));
    }

    public void executeCompileTask(CompileTask task, CompileScope scope, String contentName, Runnable onTaskFinished) {
        CompilerTask compilerTask = new CompilerTask(this.a, contentName, false, false, true, CompileDriver.a(scope));
        CompileContextImpl compileContextImpl = new CompileContextImpl(this.a, compilerTask, scope, false, false);
        FileDocumentManager.getInstance().saveAllDocuments();
        compilerTask.start(() -> {
            try {
                task.execute((CompileContext)compileContextImpl);
            }
            catch (ProcessCanceledException processCanceledException) {
            }
            finally {
                if (onTaskFinished != null) {
                    onTaskFinished.run();
                }
            }
        }, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean a(CompileContext compileContext, boolean bl2) {
        long l2 = i ^ 0x764E7AE455F5L;
        if (this.a.isDisposed()) {
            return false;
        }
        CompilerManager compilerManager = CompilerManager.getInstance((Project)this.a);
        ProgressIndicator progressIndicator = compileContext.getProgressIndicator();
        progressIndicator.pushState();
        try {
            StatusBar statusBar;
            Object object = statusBar = bl2 ? compilerManager.getBeforeTasks() : compilerManager.getAfterTasks();
            if (((CompileTask[])statusBar).length > 0) {
                progressIndicator.setText(CompilerBundle.message((String)(bl2 ? "progress.executing.precompile.tasks" : "progress.executing.postcompile.tasks"), (Object[])new Object[0]));
                for (StatusBar statusBar2 : statusBar) {
                    if (statusBar2.execute(compileContext)) continue;
                    boolean bl3 = false;
                    return bl3;
                }
            }
        }
        finally {
            progressIndicator.popState();
            StatusBar statusBar = WindowManager.getInstance().getStatusBar(this.a);
            if (statusBar != null) {
                statusBar.setInfo("");
            }
            if (progressIndicator instanceof CompilerTask) {
                ApplicationManager.getApplication().invokeLater(((CompilerTask)progressIndicator)::showCompilerContent);
            }
        }
        return true;
    }

    private boolean b(CompileScope compileScope) {
        long l2 = i ^ 0x70EB9C34BE74L;
        try {
            CompilerModuleExtension compilerModuleExtension;
            String string;
            Module[] moduleArray = compileScope.getAffectedModules();
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            CompilerManager compilerManager = CompilerManager.getInstance((Project)this.a);
            boolean bl2 = false;
            boolean bl3 = false;
            for (Module object2 : moduleArray) {
                if (!compilerManager.isValidationEnabled(object2)) continue;
                boolean bl4 = CompileDriver.a(object2, JavaSourceRootType.SOURCE);
                boolean bl5 = CompileDriver.a(object2, JavaSourceRootType.TEST_SOURCE);
                if (!bl4 && !bl5) continue;
                Sdk sdk = ModuleRootManager.getInstance((Module)object2).getSdk();
                if (sdk == null) {
                    bl2 |= ModuleRootManager.getInstance((Module)object2).isSdkInherited();
                    arrayList2.add(object2.getName());
                }
                String string2 = this.a(object2, false);
                string = this.a(object2, true);
                if (string2 == null && string == null) {
                    compilerModuleExtension = CompilerModuleExtension.getInstance((Module)object2);
                    bl3 |= compilerModuleExtension != null && compilerModuleExtension.isCompilerOutputPathInherited();
                    arrayList.add(object2.getName());
                    continue;
                }
                if (string2 == null && bl4) {
                    arrayList.add(object2.getName());
                }
                if (string != null || !bl5) continue;
                arrayList.add(object2.getName());
            }
            if (!arrayList2.isEmpty()) {
                this.a("error.jdk.not.specified", bl2, arrayList2, ProjectBundle.message((String)"modules.classpath.title", (Object[])new Object[0]));
                return false;
            }
            if (!arrayList.isEmpty()) {
                this.a("error.output.not.specified", bl3, arrayList, DefaultModuleConfigurationEditorFactory.getInstance().getOutputEditorDisplayName());
                return false;
            }
            List list2 = ModuleCompilerUtil.getCyclicDependencies((Project)this.a, Arrays.asList(moduleArray));
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                Chunk chunk = (Chunk)iterator.next();
                Set set = chunk.getNodes();
                if (set.size() <= 1) continue;
                CompilerModuleExtension compilerModuleExtension2 = null;
                LanguageLevel languageLevel = null;
                for (String string2 : set) {
                    string = string2.getModule();
                    compilerModuleExtension = ModuleRootManager.getInstance((Module)string).getSdk();
                    if (compilerModuleExtension2 == null) {
                        compilerModuleExtension2 = compilerModuleExtension;
                    } else if (!compilerModuleExtension2.equals(compilerModuleExtension)) {
                        this.a(ModuleSourceSet.getModules((Collection)set));
                        return false;
                    }
                    LanguageLevel languageLevel2 = EffectiveLanguageLevelUtil.getEffectiveLanguageLevel((Module)string);
                    if (languageLevel == null) {
                        languageLevel = languageLevel2;
                        continue;
                    }
                    if (languageLevel.equals((Object)languageLevel2)) continue;
                    this.b(ModuleSourceSet.getModules((Collection)set));
                    return false;
                }
            }
            return true;
        }
        catch (Throwable throwable) {
            f.info(throwable);
            return false;
        }
    }

    private void b(Set<Module> set) {
        long l2 = i ^ 0x6FB4B5EBB8ECL;
        Module module2 = (Module)ContainerUtil.getFirstItem(set);
        f.assertTrue(module2 != null);
        String string = module2.getName();
        String string2 = CompileDriver.a(set);
        Messages.showMessageDialog((Project)this.a, (String)CompilerBundle.message((String)"error.chunk.modules.must.have.same.language.level", (Object[])new Object[]{string2}), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
        this.a(string, null);
    }

    private void a(Set<Module> set) {
        long l2 = i ^ 0x45D3346B8EBEL;
        Module module2 = (Module)ContainerUtil.getFirstItem(set);
        f.assertTrue(module2 != null);
        String string = module2.getName();
        String string2 = CompileDriver.a(set);
        Messages.showMessageDialog((Project)this.a, (String)CompilerBundle.message((String)"error.chunk.modules.must.have.same.jdk", (Object[])new Object[]{string2}), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
        this.a(string, null);
    }

    private static String a(Collection<Module> collection) {
        return StringUtil.join(collection, module2 -> "\"" + module2.getName() + "\"", (String)"\n");
    }

    private static boolean a(Module module2, JavaSourceRootType javaSourceRootType) {
        return !ModuleRootManager.getInstance((Module)module2).getSourceRoots((JpsModuleSourceRootType)javaSourceRootType).isEmpty();
    }

    private void a(@NonNls String string, boolean bl2, List<String> list2, String string2) {
        long l2 = i ^ 0x30A5E1CCE210L;
        String string3 = null;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 10;
        for (String string4 : list2.size() > 10 ? list2.subList(0, 10) : list2) {
            if (string3 == null && !bl2) {
                string3 = string4;
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",\n");
            }
            stringBuilder.append("\"");
            stringBuilder.append(string4);
            stringBuilder.append("\"");
        }
        if (list2.size() > 10) {
            stringBuilder.append(",\n...");
        }
        String string5 = CompilerBundle.message((String)string, (Object[])new Object[]{list2.size(), stringBuilder.toString()});
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            f.error(string5);
        }
        Messages.showMessageDialog((Project)this.a, (String)string5, (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
        this.a(string3, string2);
    }

    private void a(@Nullable String string, @Nullable String string2) {
        ProjectSettingsService projectSettingsService = ProjectSettingsService.getInstance((Project)this.a);
        if (string != null) {
            projectSettingsService.showModuleConfigurationDialog(string, string2);
        } else {
            projectSettingsService.openProjectSettings();
        }
    }

    public static CompilerMessageCategory convertToCategory(CmdlineRemoteProto.Message.BuilderMessage.CompileMessage.Kind kind, CompilerMessageCategory defaultCategory) {
        switch (kind) {
            case ERROR: 
            case INTERNAL_BUILDER_ERROR: {
                return CompilerMessageCategory.ERROR;
            }
            case WARNING: {
                return CompilerMessageCategory.WARNING;
            }
            case INFO: {
                return CompilerMessageCategory.INFORMATION;
            }
            case JPS_INFO: {
                return CompilerMessageCategory.INFORMATION;
            }
            case OTHER: {
                return CompilerMessageCategory.INFORMATION;
            }
        }
        return defaultCategory;
    }

    static {
        i = lb.a(177951815154665018L, -3442687661003919721L, MethodHandles.lookup().lookupClass()).a(50628008442682L);
        long l2 = i ^ 0x62E492CA7D4FL;
        f = Logger.getInstance((String)"#com.intellij.compiler.impl.CompileDriver");
        g = Key.create((String)"compilation_started_automatically");
        h = Key.create((String)"COMPILE_SERVER_BUILD_STATUS");
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        long l2 = i ^ 0x7400ADA93301L;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "compileContext";
        objectArray2[1] = "com/intellij/compiler/impl/CompileDriver";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getBuildScopes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "compileInExternalProcess";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MessagesActivationListener
    extends NotificationListener.Adapter {
        private final WeakReference<Project> b;
        private final Object a;
        private static final long c = lb.a(8452528157130591331L, -2752582472868327092L, MethodHandles.lookup().lookupClass()).a(67696523740050L);

        MessagesActivationListener(CompileContextImpl compileContext) {
            this.b = new WeakReference<Project>(compileContext.getProject());
            this.a = compileContext.getBuildSession().getContentId();
        }

        protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e10) {
            Project project2;
            if (notification == null) {
                MessagesActivationListener.a(0);
            }
            if (e10 == null) {
                MessagesActivationListener.a(1);
            }
            if ((project2 = (Project)this.b.get()) != null && !project2.isDisposed() && CompilerTask.showCompilerContent(project2, this.a)) {
                ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project2).getToolWindow(ToolWindowId.MESSAGES_WINDOW);
                if (toolWindow != null) {
                    toolWindow.activate(null, false);
                }
            } else {
                notification.expire();
            }
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            long l2 = c ^ 0x3DE8BC249A2L;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "notification";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "e";
                    break;
                }
            }
            objectArray[1] = "com/intellij/compiler/impl/CompileDriver$MessagesActivationListener";
            objectArray[2] = "hyperlinkActivated";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

