/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.chainsSearch;

import b.a.lb;
import com.intellij.compiler.chainsSearch.ChainOperation;
import com.intellij.compiler.chainsSearch.MethodCall;
import com.intellij.compiler.chainsSearch.RefChainOperation;
import com.intellij.compiler.chainsSearch.TypeCast;
import com.intellij.compiler.chainsSearch.context.ChainCompletionContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OperationChain {
    private static final Logger c;
    @NotNull
    private final ChainOperation[] d;
    private final RefChainOperation e;
    private final MethodCall b;
    private final int a;
    private final PsiClass f;
    private static final long g;

    @Nullable
    public static OperationChain create(@NotNull RefChainOperation operation, int weight, @NotNull ChainCompletionContext context) {
        if (operation == null) {
            OperationChain.a(0);
        }
        if (context == null) {
            OperationChain.a(1);
        }
        if (operation instanceof MethodCall) {
            PsiClass psiClass;
            MethodCall methodCall = (MethodCall)operation;
            PsiClass psiClass2 = context.resolvePsiClass(methodCall.getQualifierDef());
            if (psiClass2 == null || !methodCall.isStatic() && InheritanceUtil.isInheritorOrSelf((PsiClass)context.getTarget().getTargetClass(), (PsiClass)psiClass2, (boolean)true)) {
                return null;
            }
            PsiMethod[] psiMethodArray = context.resolve(methodCall);
            if (psiMethodArray.length == 0) {
                return null;
            }
            Set set = Arrays.stream(psiMethodArray).flatMap(psiMethod -> Arrays.stream(psiMethod.getParameterList().getParameters())).map(psiParameter -> PsiUtil.resolveClassInType((PsiType)psiParameter.getType())).collect(Collectors.toSet());
            if (set.contains(psiClass = context.getTarget().getTargetClass())) {
                return null;
            }
            set.add(psiClass);
            return new OperationChain(psiClass2, new ChainOperation[]{new ChainOperation.MethodCall(psiMethodArray)}, methodCall, methodCall, weight);
        }
        TypeCast typeCast = (TypeCast)operation;
        PsiClass psiClass = context.resolvePsiClass(typeCast.getCompilerRef());
        PsiClass psiClass3 = context.resolvePsiClass(typeCast.getCastTypeRef());
        if (psiClass == null || psiClass3 == null) {
            return null;
        }
        return new OperationChain(psiClass, new ChainOperation[]{new ChainOperation.TypeCast(psiClass, psiClass3)}, typeCast, null, weight);
    }

    private OperationChain(@NotNull PsiClass qualifierClass, @NotNull ChainOperation[] reverseOperations, RefChainOperation signature, MethodCall headMethodSign, int weight) {
        if (qualifierClass == null) {
            OperationChain.a(2);
        }
        if (reverseOperations == null) {
            OperationChain.a(3);
        }
        this.f = qualifierClass;
        this.d = reverseOperations;
        this.e = signature;
        this.b = headMethodSign;
        this.a = weight;
    }

    public boolean hasCast() {
        return Arrays.stream(this.d).anyMatch(chainOperation -> chainOperation instanceof ChainOperation.TypeCast);
    }

    @Nullable
    public MethodCall getHeadMethodCall() {
        return this.b;
    }

    @NotNull
    public RefChainOperation getHead() {
        RefChainOperation refChainOperation = this.e;
        if (refChainOperation == null) {
            OperationChain.a(4);
        }
        return refChainOperation;
    }

    public int length() {
        return this.d.length;
    }

    public PsiClass getQualifierClass() {
        return this.f;
    }

    @NotNull
    public PsiMethod[] getFirst() {
        PsiMethod[] psiMethodArray = ((ChainOperation.MethodCall)this.d[0]).getCandidates();
        if (psiMethodArray == null) {
            OperationChain.a(5);
        }
        return psiMethodArray;
    }

    public ChainOperation[] getPath() {
        return (ChainOperation[])ArrayUtil.reverseArray((Object[])this.d);
    }

    public int getChainWeight() {
        return this.a;
    }

    @Nullable
    OperationChain continuationWithMethod(@NotNull MethodCall signature, int weight, @NotNull ChainCompletionContext context) {
        OperationChain operationChain;
        if (signature == null) {
            OperationChain.a(6);
        }
        if (context == null) {
            OperationChain.a(7);
        }
        if ((operationChain = OperationChain.create(signature, weight, context)) == null) {
            return null;
        }
        ChainOperation[] chainOperationArray = new ChainOperation[this.length() + 1];
        System.arraycopy(this.d, 0, chainOperationArray, 0, this.d.length);
        chainOperationArray[this.length()] = operationChain.getPath()[0];
        return new OperationChain(operationChain.getQualifierClass(), chainOperationArray, operationChain.getHead(), signature, Math.min(weight, this.getChainWeight()));
    }

    @Nullable
    OperationChain continuationWithCast(@NotNull TypeCast cast, @NotNull ChainCompletionContext context) {
        OperationChain operationChain;
        if (cast == null) {
            OperationChain.a(8);
        }
        if (context == null) {
            OperationChain.a(9);
        }
        if ((operationChain = OperationChain.create(cast, 0, context)) == null) {
            return null;
        }
        ChainOperation[] chainOperationArray = new ChainOperation[this.length() + 1];
        System.arraycopy(this.d, 0, chainOperationArray, 0, this.d.length);
        chainOperationArray[this.length()] = operationChain.getPath()[0];
        return new OperationChain(operationChain.getQualifierClass(), chainOperationArray, operationChain.getHead(), this.b, this.getChainWeight());
    }

    @NotNull
    OperationChain removeHeadCast(@NotNull ChainCompletionContext context) {
        if (context == null) {
            OperationChain.a(10);
        }
        c.assertTrue(this.getHead() instanceof TypeCast);
        ChainOperation[] chainOperationArray = new ChainOperation[this.length() - 1];
        System.arraycopy(this.d, 0, chainOperationArray, 0, this.length() - 1);
        OperationChain operationChain = new OperationChain(Objects.requireNonNull(context.resolvePsiClass(this.b.getQualifierDef())), chainOperationArray, this.b, this.b, this.getChainWeight());
        if (operationChain == null) {
            OperationChain.a(11);
        }
        return operationChain;
    }

    public String toString() {
        long l2 = g ^ 0x2CD813710965L;
        Object[] objectArray = this.getPath();
        return Arrays.toString(objectArray) + " on " + this.f.getName();
    }

    public static CompareResult compare(@NotNull OperationChain left, @NotNull OperationChain right) {
        int n2;
        long l2 = g ^ 0x62A41B11CF7AL;
        if (left == null) {
            OperationChain.a(12);
        }
        if (right == null) {
            OperationChain.a(13);
        }
        if (left.length() == 0 || right.length() == 0) {
            throw new IllegalStateException("chains can't be empty");
        }
        int n3 = 0;
        for (n2 = 0; n3 < left.length() && n2 < right.length(); ++n3, ++n2) {
            ChainOperation chainOperation = left.d[n3];
            ChainOperation chainOperation2 = right.d[n3];
            if (OperationChain.lookSimilar(chainOperation, chainOperation2)) continue;
            return CompareResult.NOT_EQUAL;
        }
        if (n3 < left.length() && n2 == right.length()) {
            return CompareResult.LEFT_CONTAINS_RIGHT;
        }
        if (n3 == left.length() && n2 < right.length()) {
            return CompareResult.RIGHT_CONTAINS_LEFT;
        }
        return CompareResult.EQUAL;
    }

    static boolean lookSimilar(ChainOperation op1, ChainOperation op2) {
        HashSet hashSet;
        long l2 = g ^ 0x53DE3EEBC5D9L;
        if (op1 instanceof ChainOperation.TypeCast || op2 instanceof ChainOperation.TypeCast) {
            return false;
        }
        Object[] objectArray = ((ChainOperation.MethodCall)op1).getCandidates();
        Object[] objectArray2 = ((ChainOperation.MethodCall)op2).getCandidates();
        PsiMethod psiMethod2 = objectArray[0];
        PsiMethod psiMethod3 = objectArray2[0];
        if (psiMethod2.hasModifierProperty("static") || psiMethod3.hasModifierProperty("static")) {
            return false;
        }
        if (!psiMethod2.getName().equals(psiMethod3.getName()) || psiMethod2.getParameterList().getParametersCount() != psiMethod3.getParameterList().getParametersCount()) {
            return false;
        }
        HashSet hashSet2 = ContainerUtil.newHashSet((Object[])objectArray);
        if (ContainerUtil.intersects((Collection)hashSet2, (Collection)(hashSet = ContainerUtil.newHashSet((Object[])objectArray2)))) {
            return true;
        }
        Set set = hashSet2.stream().flatMap(psiMethod -> Arrays.stream(psiMethod.findDeepestSuperMethods())).collect(Collectors.toSet());
        return hashSet.stream().flatMap(psiMethod -> Arrays.stream(psiMethod.findDeepestSuperMethods())).anyMatch(set::contains);
    }

    static {
        g = lb.a(3395110090627189439L, -3744701218875700265L, MethodHandles.lookup().lookupClass()).a(89493715191539L);
        c = Logger.getInstance(OperationChain.class);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = g ^ 0x3009CD39664L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 11: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
            case 1: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reverseOperations";
                break;
            }
            case 4: 
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/chainsSearch/OperationChain";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cast";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/chainsSearch/OperationChain";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getHead";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFirst";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "removeHeadCast";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 11: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "continuationWithMethod";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "continuationWithCast";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeHeadCast";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "compare";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class CompareResult
    extends Enum<CompareResult> {
        public static final /* enum */ CompareResult LEFT_CONTAINS_RIGHT;
        public static final /* enum */ CompareResult RIGHT_CONTAINS_LEFT;
        public static final /* enum */ CompareResult EQUAL;
        public static final /* enum */ CompareResult NOT_EQUAL;
        private static final /* synthetic */ CompareResult[] a;

        public static CompareResult[] values() {
            return (CompareResult[])a.clone();
        }

        public static CompareResult valueOf(String name2) {
            return Enum.valueOf(CompareResult.class, name2);
        }

        static {
            long l2 = lb.a(-6987763014436078399L, -3694264764774997497L, MethodHandles.lookup().lookupClass()).a(236632924284733L) ^ 0xCE54474366AL;
            LEFT_CONTAINS_RIGHT = new CompareResult();
            RIGHT_CONTAINS_LEFT = new CompareResult();
            EQUAL = new CompareResult();
            NOT_EQUAL = new CompareResult();
            a = new CompareResult[]{LEFT_CONTAINS_RIGHT, RIGHT_CONTAINS_LEFT, EQUAL, NOT_EQUAL};
        }
    }
}

