/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler;

import b.a.lb;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.compiler.CompileTaskBean;
import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.impl.CompileDriver;
import com.intellij.compiler.impl.CompositeScope;
import com.intellij.compiler.impl.FileProcessingCompilerAdapterTask;
import com.intellij.compiler.impl.ModuleCompileScope;
import com.intellij.compiler.impl.OneProjectItemCompileScope;
import com.intellij.compiler.impl.ProjectCompileScope;
import com.intellij.compiler.server.BuildManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.ClassObject;
import com.intellij.openapi.compiler.CompilationException;
import com.intellij.openapi.compiler.CompilationStatusListener;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompileStatusNotification;
import com.intellij.openapi.compiler.CompileTask;
import com.intellij.openapi.compiler.Compiler;
import com.intellij.openapi.compiler.CompilerFactory;
import com.intellij.openapi.compiler.CompilerFilter;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.compiler.CompilerTopics;
import com.intellij.openapi.compiler.FileProcessingCompiler;
import com.intellij.openapi.compiler.SourceInstrumentingCompiler;
import com.intellij.openapi.compiler.TranslatingCompiler;
import com.intellij.openapi.compiler.Validator;
import com.intellij.openapi.compiler.util.InspectionValidator;
import com.intellij.openapi.compiler.util.InspectionValidatorWrapper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiManager;
import com.intellij.util.SmartList;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.net.NetUtils;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Array;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.api.CanceledStatus;
import org.jetbrains.jps.builders.impl.java.JavacCompilerTool;
import org.jetbrains.jps.builders.java.JavaCompilingTool;
import org.jetbrains.jps.incremental.BinaryContent;
import org.jetbrains.jps.javac.DiagnosticOutputConsumer;
import org.jetbrains.jps.javac.ExternalJavacManager;
import org.jetbrains.jps.javac.OutputFileConsumer;
import org.jetbrains.jps.javac.OutputFileObject;

public class CompilerManagerImpl
extends CompilerManager {
    private static final Logger g;
    private final Project i;
    private final List<Compiler> h = new ArrayList<Compiler>();
    private final List<CompileTask> j = new ArrayList<CompileTask>();
    private final List<CompileTask> d = new ArrayList<CompileTask>();
    private final Set<FileType> a = new HashSet<FileType>();
    private final CompilationStatusListener f;
    private final Semaphore k = new Semaphore(1, true);
    private final Set<ModuleType> c = new HashSet<ModuleType>();
    private final Set<LocalFileSystem.WatchRequest> e;
    private volatile ExternalJavacManager l;
    private final Map<CompilationStatusListener, MessageBusConnection> b = new HashMap<CompilationStatusListener, MessageBusConnection>();
    private static final long m;

    public CompilerManagerImpl(Project project2, MessageBus messageBus) {
        Compiler compiler2;
        this.i = project2;
        this.f = (CompilationStatusListener)messageBus.syncPublisher(CompilerTopics.COMPILATION_STATUS);
        for (Compiler compiler2 : Compiler.EP_NAME.getExtensions((AreaInstance)this.i)) {
            this.addCompiler(compiler2);
        }
        for (Compiler compiler2 : CompilerFactory.EP_NAME.getExtensionList((AreaInstance)project2)) {
            Compiler[] compilerArray;
            for (Compiler compiler3 : compilerArray = compiler2.createCompilers((CompilerManager)this)) {
                this.addCompiler(compiler3);
            }
        }
        for (Compiler compiler2 : InspectionValidator.EP_NAME.getExtensionList((AreaInstance)project2)) {
            this.addCompiler((Compiler)new InspectionValidatorWrapper(this, InspectionManager.getInstance((Project)project2), InspectionProjectProfileManager.getInstance((Project)project2), PsiDocumentManager.getInstance((Project)project2), PsiManager.getInstance((Project)project2), (InspectionValidator)compiler2));
        }
        this.addCompilableFileType((FileType)StdFileTypes.JAVA);
        File file = CompilerPaths.getGeneratedDataDirectory((Project)project2);
        file.mkdirs();
        compiler2 = LocalFileSystem.getInstance();
        this.e = compiler2.addRootsToWatch(Collections.singletonList(FileUtil.toCanonicalPath((String)file.getPath())), true);
        Disposer.register((Disposable)project2, () -> this.a((LocalFileSystem)compiler2, project2));
    }

    /*
     * WARNING - void declaration
     */
    public boolean waitForExternalJavacToTerminate(long time, @NotNull TimeUnit timeUnit) {
        void unit;
        ExternalJavacManager externalJavacManager;
        if (timeUnit == null) {
            CompilerManagerImpl.a(0);
        }
        return (externalJavacManager = this.l) == null || externalJavacManager.waitForAllProcessHandlers(time, (TimeUnit)unit);
    }

    /*
     * WARNING - void declaration
     */
    public boolean awaitNettyThreadPoolTermination(long time, @NotNull TimeUnit timeUnit) {
        void unit;
        ExternalJavacManager externalJavacManager;
        if (timeUnit == null) {
            CompilerManagerImpl.a(1);
        }
        return (externalJavacManager = this.l) == null || externalJavacManager.awaitNettyThreadPoolTermination(time, (TimeUnit)unit);
    }

    public Semaphore getCompilationSemaphore() {
        return this.k;
    }

    public boolean isCompilationActive() {
        return this.k.availablePermits() == 0;
    }

    public final void addCompiler(@NotNull Compiler compiler) {
        if (compiler == null) {
            CompilerManagerImpl.a(2);
        }
        this.h.add(compiler);
        if (compiler instanceof SourceInstrumentingCompiler) {
            this.addBeforeTask(new FileProcessingCompilerAdapterTask((FileProcessingCompiler)compiler));
        } else if (compiler instanceof Validator) {
            this.addAfterTask(new FileProcessingCompilerAdapterTask((FileProcessingCompiler)compiler));
        }
    }

    @Deprecated
    public void addTranslatingCompiler(@NotNull TranslatingCompiler compiler, Set<FileType> inputTypes, Set<FileType> outputTypes) {
        if (compiler == null) {
            CompilerManagerImpl.a(3);
        }
    }

    public final void removeCompiler(@NotNull Compiler compiler) {
        if (compiler == null) {
            CompilerManagerImpl.a(4);
        }
        for (List list2 : Arrays.asList(this.j, this.d)) {
            list2.removeIf(compileTask -> {
                if (compiler == null) {
                    CompilerManagerImpl.a(45);
                }
                return compileTask instanceof FileProcessingCompilerAdapterTask && ((FileProcessingCompilerAdapterTask)compileTask).getCompiler() == compiler;
            });
        }
    }

    @NotNull
    public <T extends Compiler> T[] getCompilers(@NotNull Class<T> compilerClass) {
        if (compilerClass == null) {
            CompilerManagerImpl.a(5);
        }
        Compiler[] compilerArray = this.a(compilerClass, CompilerFilter.ALL);
        if (compilerArray == null) {
            CompilerManagerImpl.a(6);
        }
        return compilerArray;
    }

    @NotNull
    private <T extends Compiler> T[] a(@NotNull Class<T> clazz, CompilerFilter compilerFilter) {
        if (clazz == null) {
            CompilerManagerImpl.a(7);
        }
        ArrayList<Compiler> arrayList = new ArrayList<Compiler>(this.h.size());
        for (Compiler compiler : this.h) {
            if (!clazz.isAssignableFrom(compiler.getClass()) || !compilerFilter.acceptCompiler(compiler)) continue;
            arrayList.add(compiler);
        }
        Compiler[] compilerArray = (Compiler[])Array.newInstance(clazz, arrayList.size());
        Compiler[] compilerArray2 = arrayList.toArray(compilerArray);
        if (compilerArray2 == null) {
            CompilerManagerImpl.a(8);
        }
        return compilerArray2;
    }

    public void addCompilableFileType(@NotNull FileType type) {
        if (type == null) {
            CompilerManagerImpl.a(9);
        }
        this.a.add(type);
    }

    public void removeCompilableFileType(@NotNull FileType type) {
        if (type == null) {
            CompilerManagerImpl.a(10);
        }
        this.a.remove(type);
    }

    public boolean isCompilableFileType(@NotNull FileType type) {
        if (type == null) {
            CompilerManagerImpl.a(11);
        }
        return this.a.contains(type);
    }

    public final void addBeforeTask(@NotNull CompileTask task) {
        if (task == null) {
            CompilerManagerImpl.a(12);
        }
        this.j.add(task);
    }

    public final void addAfterTask(@NotNull CompileTask task) {
        if (task == null) {
            CompilerManagerImpl.a(13);
        }
        this.d.add(task);
    }

    @NotNull
    public CompileTask[] getBeforeTasks() {
        CompileTask[] compileTaskArray = this.a(this.j, CompileTaskBean.CompileTaskExecutionPhase.BEFORE);
        if (compileTaskArray == null) {
            CompilerManagerImpl.a(14);
        }
        return compileTaskArray;
    }

    private CompileTask[] a(List<CompileTask> list2, CompileTaskBean.CompileTaskExecutionPhase compileTaskExecutionPhase) {
        ArrayList<CompileTask> arrayList = new ArrayList<CompileTask>(list2);
        for (CompileTaskBean compileTaskBean : (CompileTaskBean[])CompileTaskBean.EP_NAME.getExtensions((AreaInstance)this.i)) {
            if (compileTaskBean.myExecutionPhase != compileTaskExecutionPhase) continue;
            arrayList.add(compileTaskBean.getTaskInstance());
        }
        return arrayList.toArray(new CompileTask[0]);
    }

    @NotNull
    public CompileTask[] getAfterTasks() {
        CompileTask[] compileTaskArray = this.a(this.d, CompileTaskBean.CompileTaskExecutionPhase.AFTER);
        if (compileTaskArray == null) {
            CompilerManagerImpl.a(15);
        }
        return compileTaskArray;
    }

    public void compile(@NotNull VirtualFile[] files, CompileStatusNotification callback) {
        if (files == null) {
            CompilerManagerImpl.a(16);
        }
        this.compile(this.createFilesCompileScope(files), callback);
    }

    public void compile(@NotNull Module module2, CompileStatusNotification callback) {
        if (module2 == null) {
            CompilerManagerImpl.a(17);
        }
        new CompileDriver(this.i).compile(this.createModuleCompileScope(module2, false), new ListenerNotificator(callback));
    }

    public void compile(@NotNull CompileScope scope, CompileStatusNotification callback) {
        if (scope == null) {
            CompilerManagerImpl.a(18);
        }
        new CompileDriver(this.i).compile(scope, new ListenerNotificator(callback));
    }

    public void make(CompileStatusNotification callback) {
        new CompileDriver(this.i).make(this.createProjectCompileScope(this.i), new ListenerNotificator(callback));
    }

    public void make(@NotNull Module module2, CompileStatusNotification callback) {
        if (module2 == null) {
            CompilerManagerImpl.a(19);
        }
        new CompileDriver(this.i).make(this.createModuleCompileScope(module2, true), new ListenerNotificator(callback));
    }

    public void make(@NotNull Project project2, @NotNull Module[] modules, CompileStatusNotification callback) {
        if (project2 == null) {
            CompilerManagerImpl.a(20);
        }
        if (modules == null) {
            CompilerManagerImpl.a(21);
        }
        new CompileDriver(this.i).make(this.createModuleGroupCompileScope(project2, modules, true), new ListenerNotificator(callback));
    }

    public void make(@NotNull CompileScope scope, CompileStatusNotification callback) {
        if (scope == null) {
            CompilerManagerImpl.a(22);
        }
        new CompileDriver(this.i).make(scope, new ListenerNotificator(callback));
    }

    public void makeWithModalProgress(@NotNull CompileScope scope, @Nullable CompileStatusNotification callback) {
        if (scope == null) {
            CompilerManagerImpl.a(23);
        }
        new CompileDriver(this.i).make(scope, true, new ListenerNotificator(callback));
    }

    public boolean isUpToDate(@NotNull CompileScope scope) {
        if (scope == null) {
            CompilerManagerImpl.a(24);
        }
        return new CompileDriver(this.i).isUpToDate(scope);
    }

    public void rebuild(CompileStatusNotification callback) {
        new CompileDriver(this.i).rebuild(new ListenerNotificator(callback));
    }

    public void executeTask(@NotNull CompileTask task, @NotNull CompileScope scope, String contentName, Runnable onTaskFinished) {
        if (task == null) {
            CompilerManagerImpl.a(25);
        }
        if (scope == null) {
            CompilerManagerImpl.a(26);
        }
        CompileDriver compileDriver = new CompileDriver(this.i);
        compileDriver.executeCompileTask(task, scope, contentName, onTaskFinished);
    }

    public void addCompilationStatusListener(@NotNull CompilationStatusListener listener) {
        if (listener == null) {
            CompilerManagerImpl.a(27);
        }
        MessageBusConnection messageBusConnection = this.i.getMessageBus().connect();
        this.b.put(listener, messageBusConnection);
        messageBusConnection.subscribe(CompilerTopics.COMPILATION_STATUS, (Object)listener);
    }

    public void addCompilationStatusListener(@NotNull CompilationStatusListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            CompilerManagerImpl.a(28);
        }
        if (parentDisposable == null) {
            CompilerManagerImpl.a(29);
        }
        MessageBusConnection messageBusConnection = this.i.getMessageBus().connect(parentDisposable);
        messageBusConnection.subscribe(CompilerTopics.COMPILATION_STATUS, (Object)listener);
    }

    public void removeCompilationStatusListener(@NotNull CompilationStatusListener listener) {
        MessageBusConnection messageBusConnection;
        if (listener == null) {
            CompilerManagerImpl.a(30);
        }
        if ((messageBusConnection = this.b.remove(listener)) != null) {
            messageBusConnection.disconnect();
        }
    }

    public boolean isExcludedFromCompilation(@NotNull VirtualFile file) {
        if (file == null) {
            CompilerManagerImpl.a(31);
        }
        return CompilerConfiguration.getInstance((Project)this.i).isExcludedFromCompilation(file);
    }

    @NotNull
    public CompileScope createFilesCompileScope(@NotNull VirtualFile[] files) {
        if (files == null) {
            CompilerManagerImpl.a(32);
        }
        CompileScope[] compileScopeArray = new CompileScope[files.length];
        for (int i10 = 0; i10 < files.length; ++i10) {
            compileScopeArray[i10] = new OneProjectItemCompileScope(this.i, files[i10]);
        }
        CompositeScope compositeScope = new CompositeScope(compileScopeArray);
        if (compositeScope == null) {
            CompilerManagerImpl.a(33);
        }
        return compositeScope;
    }

    @NotNull
    public CompileScope createModuleCompileScope(@NotNull Module module2, boolean includeDependentModules) {
        if (module2 == null) {
            CompilerManagerImpl.a(34);
        }
        CompileScope compileScope = this.createModulesCompileScope(new Module[]{module2}, includeDependentModules);
        if (compileScope == null) {
            CompilerManagerImpl.a(35);
        }
        return compileScope;
    }

    @NotNull
    public CompileScope createModulesCompileScope(@NotNull Module[] modules, boolean includeDependentModules) {
        if (modules == null) {
            CompilerManagerImpl.a(36);
        }
        CompileScope compileScope = this.createModulesCompileScope(modules, includeDependentModules, false);
        if (compileScope == null) {
            CompilerManagerImpl.a(37);
        }
        return compileScope;
    }

    @NotNull
    public CompileScope createModulesCompileScope(@NotNull Module[] modules, boolean includeDependentModules, boolean includeRuntimeDependencies) {
        if (modules == null) {
            CompilerManagerImpl.a(38);
        }
        ModuleCompileScope moduleCompileScope = new ModuleCompileScope(this.i, modules, includeDependentModules, includeRuntimeDependencies);
        if (moduleCompileScope == null) {
            CompilerManagerImpl.a(39);
        }
        return moduleCompileScope;
    }

    @NotNull
    public CompileScope createModuleGroupCompileScope(@NotNull Project project2, @NotNull Module[] modules, boolean includeDependentModules) {
        if (project2 == null) {
            CompilerManagerImpl.a(40);
        }
        if (modules == null) {
            CompilerManagerImpl.a(41);
        }
        ModuleCompileScope moduleCompileScope = new ModuleCompileScope(project2, modules, includeDependentModules);
        if (moduleCompileScope == null) {
            CompilerManagerImpl.a(42);
        }
        return moduleCompileScope;
    }

    @NotNull
    public CompileScope createProjectCompileScope(@NotNull Project project2) {
        if (project2 == null) {
            CompilerManagerImpl.a(43);
        }
        ProjectCompileScope projectCompileScope = new ProjectCompileScope(project2);
        if (projectCompileScope == null) {
            CompilerManagerImpl.a(44);
        }
        return projectCompileScope;
    }

    public void setValidationEnabled(ModuleType moduleType, boolean enabled) {
        if (enabled) {
            this.c.remove(moduleType);
        } else {
            this.c.add(moduleType);
        }
    }

    public boolean isValidationEnabled(Module module2) {
        if (this.c.isEmpty()) {
            return true;
        }
        return !this.c.contains(ModuleType.get((Module)module2));
    }

    public Collection<ClassObject> compileJavaCode(List<String> options, Collection<File> platformCp, Collection<File> classpath, Collection<File> upgradeModulePath, Collection<File> modulePath, Collection<File> sourcePath, Collection<File> files, File outputDir) throws IOException, CompilationException {
        boolean bl2;
        File file2;
        Object object;
        long l2 = m ^ 0x341308F758FFL;
        Pair<Sdk, JavaSdkVersion> pair2 = BuildManager.getJavacRuntimeSdk(this.i);
        Sdk sdk = (Sdk)pair2.getFirst();
        SdkTypeId sdkTypeId = sdk.getSdkType();
        String string = null;
        if (sdkTypeId instanceof JavaSdkType && !CompilerManagerImpl.a(string = sdk.getHomePath())) {
            object = ((JavaSdkType)sdkTypeId).getBinPath(sdk);
            String string2 = string = object != null ? new File((String)object).getParent() : null;
            if (!CompilerManagerImpl.a(string)) {
                string = null;
            }
        }
        if (string == null) {
            throw new IOException("Was not able to determine JDK for project " + this.i.getName());
        }
        object = new OutputCollector();
        DiagnosticCollector diagnosticCollector = new DiagnosticCollector();
        THashSet tHashSet = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
        if (!sourcePath.isEmpty()) {
            tHashSet.addAll(sourcePath);
        } else {
            for (File file2 : files) {
                File file3 = file2.getParentFile();
                if (file3 == null) continue;
                tHashSet.add(file3);
            }
        }
        Map<File, THashSet> map2 = Collections.singletonMap(outputDir, tHashSet);
        file2 = this.a();
        boolean bl3 = bl2 = file2 != null && file2.forkJavac(string, -1, Collections.emptyList(), options, platformCp, classpath, upgradeModulePath, modulePath, sourcePath, files, map2, diagnosticCollector, (OutputFileConsumer)object, (JavaCompilingTool)new JavacCompilerTool(), CanceledStatus.NULL);
        if (!bl2) {
            SmartList smartList = new SmartList();
            for (Diagnostic<? extends JavaFileObject> diagnostic : diagnosticCollector.getDiagnostics()) {
                JavaFileObject javaFileObject = diagnostic.getSource();
                URI uRI = javaFileObject != null ? javaFileObject.toUri() : null;
                smartList.add(new CompilationException.Message(CompilerManagerImpl.a(diagnostic.getKind()), diagnostic.getMessage(Locale.US), uRI != null ? uRI.toURL().toString() : null, (int)diagnostic.getLineNumber(), (int)diagnostic.getColumnNumber()));
            }
            throw new CompilationException("Compilation failed", (Collection)smartList);
        }
        ArrayList<ClassObject> arrayList = new ArrayList<ClassObject>();
        for (OutputFileObject outputFileObject : ((OutputCollector)object).getCompiledClasses()) {
            BinaryContent binaryContent = outputFileObject.getContent();
            arrayList.add(new CompiledClass(outputFileObject.getName(), outputFileObject.getClassName(), binaryContent != null ? binaryContent.toByteArray() : null));
        }
        return arrayList;
    }

    private static boolean a(@Nullable String string) {
        return string != null && (JdkUtil.checkForJre((String)string) || JdkUtil.checkForJdk((String)string));
    }

    private static CompilerMessageCategory a(Diagnostic.Kind kind) {
        switch (kind) {
            case ERROR: {
                return CompilerMessageCategory.ERROR;
            }
            case MANDATORY_WARNING: {
                return CompilerMessageCategory.WARNING;
            }
            case WARNING: {
                return CompilerMessageCategory.WARNING;
            }
            case NOTE: {
                return CompilerMessageCategory.INFORMATION;
            }
        }
        return CompilerMessageCategory.INFORMATION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private ExternalJavacManager a() throws IOException {
        ExternalJavacManager externalJavacManager = this.l;
        if (externalJavacManager == null) {
            CompilerManagerImpl compilerManagerImpl = this;
            synchronized (compilerManagerImpl) {
                externalJavacManager = this.l;
                if (externalJavacManager == null) {
                    File file = this.getJavacCompilerWorkingDir();
                    if (file == null) {
                        return null;
                    }
                    int n2 = NetUtils.findAvailableSocketPort();
                    externalJavacManager = new ExternalJavacManager(file);
                    externalJavacManager.start(n2);
                    this.l = externalJavacManager;
                }
            }
        }
        return externalJavacManager;
    }

    @Nullable
    public File getJavacCompilerWorkingDir() {
        File file = BuildManager.getInstance().getProjectSystemDirectory(this.i);
        if (file == null) {
            return null;
        }
        file.mkdirs();
        return file;
    }

    private /* synthetic */ void a(LocalFileSystem localFileSystem, Project project2) {
        ExternalJavacManager externalJavacManager = this.l;
        this.l = null;
        if (externalJavacManager != null) {
            externalJavacManager.stop();
        }
        localFileSystem.removeWatchedRoots(this.e);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            FileUtil.delete((File)CompilerPaths.getCompilerSystemDirectory((Project)project2));
        }
    }

    static {
        m = lb.a(214906905247454428L, 6648953028753105682L, MethodHandles.lookup().lookupClass()).a(249481420307733L);
        long l2 = m ^ 0x404B6166F3BFL;
        g = Logger.getInstance((String)"#com.intellij.compiler.CompilerManagerImpl");
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = m ^ 0x44A9CE0FE834L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: 
            case 14: 
            case 15: 
            case 33: 
            case 35: 
            case 37: 
            case 39: 
            case 42: 
            case 44: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 6: 
            case 8: 
            case 14: 
            case 15: 
            case 33: 
            case 35: 
            case 37: 
            case 39: 
            case 42: 
            case 44: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compiler";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerClass";
                break;
            }
            case 6: 
            case 8: 
            case 14: 
            case 15: 
            case 33: 
            case 35: 
            case 37: 
            case 39: 
            case 42: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/CompilerManagerImpl";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 12: 
            case 13: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 16: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 17: 
            case 19: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 20: 
            case 40: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 21: 
            case 36: 
            case 38: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 27: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/CompilerManagerImpl";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompilers";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getBeforeTasks";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getAfterTasks";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "createFilesCompileScope";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "createModuleCompileScope";
                break;
            }
            case 37: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "createModulesCompileScope";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "createModuleGroupCompileScope";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "createProjectCompileScope";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "waitForExternalJavacToTerminate";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "awaitNettyThreadPoolTermination";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addCompiler";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addTranslatingCompiler";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeCompiler";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCompilers";
                break;
            }
            case 6: 
            case 8: 
            case 14: 
            case 15: 
            case 33: 
            case 35: 
            case 37: 
            case 39: 
            case 42: 
            case 44: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addCompilableFileType";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeCompilableFileType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isCompilableFileType";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addBeforeTask";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addAfterTask";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "compile";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "make";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "makeWithModalProgress";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isUpToDate";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "executeTask";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "addCompilationStatusListener";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "removeCompilationStatusListener";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isExcludedFromCompilation";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "createFilesCompileScope";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "createModuleCompileScope";
                break;
            }
            case 36: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "createModulesCompileScope";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "createModuleGroupCompileScope";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "createProjectCompileScope";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "lambda$removeCompiler$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: 
            case 14: 
            case 15: 
            case 33: 
            case 35: 
            case 37: 
            case 39: 
            case 42: 
            case 44: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class OutputCollector
    implements OutputFileConsumer {
        private final List<OutputFileObject> a = new ArrayList<OutputFileObject>();
        private static final long b = lb.a(4021203958955581114L, -8096571820602088129L, MethodHandles.lookup().lookupClass()).a(168591510015598L);

        private OutputCollector() {
        }

        public void save(@NotNull OutputFileObject fileObject) {
            if (fileObject == null) {
                OutputCollector.a(0);
            }
            this.a.add(fileObject);
        }

        List<OutputFileObject> getCompiledClasses() {
            return this.a;
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = b ^ 0x4FB8DC91C1F8L;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileObject", "com/intellij/compiler/CompilerManagerImpl$OutputCollector", "save"));
        }
    }

    private static class DiagnosticCollector
    implements DiagnosticOutputConsumer {
        private final List<Diagnostic<? extends JavaFileObject>> a = new ArrayList<Diagnostic<? extends JavaFileObject>>();
        private static final long b = lb.a(-358725849140480887L, 191721855917895869L, MethodHandles.lookup().lookupClass()).a(20874859947536L);

        private DiagnosticCollector() {
        }

        public void outputLineAvailable(String line) {
            long l2 = b ^ 0x1541CE19617AL;
            if (line != null && line.startsWith("JAVAC_PROCESS[STDERR]")) {
                g.info(line.trim());
            }
        }

        public void registerImports(String className, Collection<String> imports, Collection<String> staticImports) {
        }

        public void javaFileLoaded(File file) {
        }

        public void customOutputData(String pluginId, String dataName, byte[] data) {
        }

        public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
            this.a.add(diagnostic);
        }

        public List<Diagnostic<? extends JavaFileObject>> getDiagnostics() {
            return this.a;
        }
    }

    private class ListenerNotificator
    implements CompileStatusNotification {
        @Nullable
        private final CompileStatusNotification a;
        private static final long b = lb.a(465150035550604993L, -6018386352979763100L, MethodHandles.lookup().lookupClass()).a(84205957540592L);

        private ListenerNotificator(CompileStatusNotification delegate) {
            this.a = delegate;
        }

        public void finished(boolean aborted, int errors, int warnings, @NotNull CompileContext compileContext) {
            if (compileContext == null) {
                ListenerNotificator.a(0);
            }
            if (!CompilerManagerImpl.this.i.isDisposed()) {
                CompilerManagerImpl.this.f.compilationFinished(aborted, errors, warnings, compileContext);
            }
            if (this.a != null) {
                this.a.finished(aborted, errors, warnings, compileContext);
            }
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = b ^ 0x1BA69FFC4A62L;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compileContext", "com/intellij/compiler/CompilerManagerImpl$ListenerNotificator", "finished"));
        }
    }

    private static class CompiledClass
    implements ClassObject {
        private final String a;
        private final String c;
        private final byte[] b;

        CompiledClass(String path, String className, byte[] bytes) {
            this.a = path;
            this.c = className;
            this.b = bytes;
        }

        public String getPath() {
            return this.a;
        }

        public String getClassName() {
            return this.c;
        }

        @Nullable
        public byte[] getContent() {
            return this.b;
        }

        public String toString() {
            return this.getClassName();
        }
    }
}

