/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.unwrap;

import b.a.lb;
import com.intellij.codeInsight.unwrap.UnwrapHandler;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.LightPlatformCodeInsightTestCase;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class UnwrapTestCase
extends LightPlatformCodeInsightTestCase {
    private static final long a = lb.a(2145404729152810745L, 6661891012572524699L, MethodHandles.lookup().lookupClass()).a(92571939783409L);

    protected void assertUnwrapped(String codeBefore, String expectedCodeAfter) throws Exception {
        this.assertUnwrapped(codeBefore, expectedCodeAfter, 0);
    }

    protected void assertUnwrapped(String codeBefore, String expectedCodeAfter, final int option) throws Exception {
        this.configureCode(codeBefore);
        UnwrapHandler unwrapHandler = new UnwrapHandler(){

            protected void selectOption(List<UnwrapHandler.MyUnwrapAction> options, Editor editor, PsiFile file) {
                if (options.isEmpty()) {
                    return;
                }
                options.get(option).perform();
            }
        };
        unwrapHandler.invoke(UnwrapTestCase.getProject(), UnwrapTestCase.getEditor(), UnwrapTestCase.getFile());
        this.checkResultByText(this.createCode(expectedCodeAfter));
    }

    protected void assertOptions(String code, String ... expectedOptions) throws IOException {
        this.configureCode(code);
        final ArrayList arrayList = new ArrayList();
        UnwrapHandler unwrapHandler = new UnwrapHandler(){

            protected void selectOption(List<UnwrapHandler.MyUnwrapAction> options, Editor editor, PsiFile file) {
                for (AnAction anAction : options) {
                    arrayList.add(anAction.getTemplatePresentation().getText());
                }
            }
        };
        unwrapHandler.invoke(UnwrapTestCase.getProject(), UnwrapTestCase.getEditor(), UnwrapTestCase.getFile());
        UnwrapTestCase.assertEquals(Arrays.asList(expectedOptions), arrayList);
    }

    protected void configureCode(String codeBefore) throws IOException {
        UnwrapTestCase.configureFromFileText(this.getFileNameToCreate(), this.createCode(codeBefore));
    }

    protected String getFileNameToCreate() {
        long l2 = a ^ 0x12A881BAF15L;
        return "A.java";
    }

    protected String createCode(String codeBefore) {
        long l2 = a ^ 0x1F1B20DE9859L;
        return "public class A {\n    void foo() {\n" + this.indentTwice(codeBefore) + "    }\n}";
    }

    protected String indentTwice(String code) {
        return this.indent(this.indent(code));
    }

    protected String indent(String code) {
        long l2 = a ^ 0x61B21FDBD118L;
        String string = "";
        for (String string2 : StringUtil.tokenize((String)code, (String)"\n")) {
            string = string + "    " + string2 + "\n";
        }
        return string;
    }
}

