/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.view;

import com.intellij.cdi.beans.AbstractCdiBeanDescriptor;
import com.intellij.cdi.beans.InjectionPointDescriptor;
import com.intellij.cdi.utils.CdiInjectionUtils;
import com.intellij.cdi.view.CdiBeansRecursivePanel;
import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.ui.FinderRecursivePanel;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CdiInjectionPointsPanel
extends FinderRecursivePanel<InjectionPointDescriptor> {
    @NotNull
    private final CdiBeansRecursivePanel myParent;
    private final Module myModule;

    public CdiInjectionPointsPanel(@NotNull CdiBeansRecursivePanel parent, @Nullable Module module) {
        if (parent == null) {
            CdiInjectionPointsPanel.$$$reportNull$$$0(0);
        }
        super((FinderRecursivePanel)parent);
        this.myParent = parent;
        this.myModule = module;
    }

    @Nullable
    protected JComponent createRightComponent(InjectionPointDescriptor ip) {
        PsiElement element = CdiInjectionPointsPanel.getPsiElement(ip);
        if (element != null) {
            return this.getDocumentationComponent(element);
        }
        return super.createRightComponent((Object)ip);
    }

    private JComponent getDocumentationComponent(@NotNull PsiElement element) {
        if (element == null) {
            CdiInjectionPointsPanel.$$$reportNull$$$0(1);
        }
        return DocumentationComponent.createAndFetch((Project)this.getProject(), (PsiElement)element, (Disposable)this);
    }

    protected JComponent createDefaultRightComponent() {
        AbstractCdiBeanDescriptor value = (AbstractCdiBeanDescriptor)this.myParent.getSelectedValue();
        if (value != null) {
            return this.getDocumentationComponent((PsiElement)value.getAnnotatedItem());
        }
        return super.createDefaultRightComponent();
    }

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            CdiInjectionPointsPanel.$$$reportNull$$$0(2);
        }
        InjectionPointDescriptor jamElement = (InjectionPointDescriptor)this.getSelectedValue();
        PsiElement element = CdiInjectionPointsPanel.getPsiElement(jamElement);
        if (CommonDataKeys.NAVIGATABLE.is(dataId) && element != null) {
            return element;
        }
        return super.getData(dataId);
    }

    @Nullable
    private static PsiElement getPsiElement(InjectionPointDescriptor jamElement) {
        if (jamElement == null) {
            return null;
        }
        return jamElement.getOwner();
    }

    @NotNull
    protected String getItemText(InjectionPointDescriptor ip) {
        String string = ip.getType().getCanonicalText();
        if (string == null) {
            CdiInjectionPointsPanel.$$$reportNull$$$0(3);
        }
        return string;
    }

    protected void doCustomizeCellRenderer(SimpleColoredComponent comp, JList list, InjectionPointDescriptor ip, int index, boolean selected, boolean hasFocus) {
        comp.clear();
        comp.setIcon(this.getItemIcon(ip));
        PsiModifierListOwner owner = ip.getOwner();
        if (owner instanceof PsiVariable) {
            String fieldName = PsiFormatUtil.formatVariable((PsiVariable)((PsiVariable)owner), (int)3, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            comp.append(fieldName);
            String annotations = CdiInjectionPointsPanel.getQualifierAnnotations(ip);
            if (!StringUtil.isEmpty((String)annotations)) {
                comp.append(annotations, SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
            }
        }
        super.doCustomizeCellRenderer(comp, list, (Object)ip, index, selected, hasFocus);
    }

    @NotNull
    private static String getQualifierAnnotations(InjectionPointDescriptor ip) {
        StringBuilder buffer = new StringBuilder();
        for (PsiAnnotation psiAnnotation : ip.getQualifierAnnotations()) {
            String fqName = psiAnnotation.getQualifiedName();
            if (fqName == null) continue;
            buffer.append("@");
            buffer.append(StringUtil.getShortName((String)fqName));
            buffer.append(" ");
        }
        String string = buffer.toString();
        if (string == null) {
            CdiInjectionPointsPanel.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    protected Icon getItemIcon(InjectionPointDescriptor ip) {
        return ip.getOwner() instanceof PsiParameter ? AllIcons.Nodes.Parameter : AllIcons.Nodes.Field;
    }

    @NotNull
    protected List<InjectionPointDescriptor> getListItems() {
        ArrayList<InjectionPointDescriptor> points = new ArrayList<InjectionPointDescriptor>();
        AbstractCdiBeanDescriptor beanDescriptor = (AbstractCdiBeanDescriptor)this.myParent.getSelectedValue();
        if (beanDescriptor == null) {
            List<InjectionPointDescriptor> list = Collections.emptyList();
            if (list == null) {
                CdiInjectionPointsPanel.$$$reportNull$$$0(5);
            }
            return list;
        }
        Object item = beanDescriptor.getAnnotatedItem();
        if (item instanceof PsiClass) {
            points.addAll(CdiInjectionUtils.getInjectionPoints((PsiClass)item));
        }
        if (item instanceof PsiMethod) {
            points.addAll(CdiInjectionUtils.getInjectionPoints((PsiMethod)item));
        }
        Collections.sort(points, (o1, o2) -> {
            String value1 = o1.getType().getCanonicalText();
            String value2 = o2.getType().getCanonicalText();
            return value1.compareTo(value2);
        });
        ArrayList<InjectionPointDescriptor> arrayList = points;
        if (arrayList == null) {
            CdiInjectionPointsPanel.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    protected boolean hasChildren(InjectionPointDescriptor ip) {
        return false;
    }

    public Module getModule() {
        return this.myModule;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cdi/view/CdiInjectionPointsPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cdi/view/CdiInjectionPointsPanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifierAnnotations";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getListItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentationComponent";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

