/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.view;

import com.intellij.cdi.CdiProjectComponent;
import com.intellij.cdi.beans.AbstractCdiBeanDescriptor;
import com.intellij.cdi.beans.ManagedBeanDescriptor;
import com.intellij.cdi.beans.ProducerBeanDescriptor;
import com.intellij.cdi.diagram.CdiDiagramProvider;
import com.intellij.cdi.toolWindow.tree.nodes.CdiViewSettings;
import com.intellij.cdi.view.CdiBeansRecursivePanel;
import com.intellij.cdi.view.actions.ShowGraphAction;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiClass;
import com.intellij.ui.FinderRecursivePanel;
import com.intellij.ui.JBColor;
import com.intellij.uml.UmlFileEditorImpl;
import com.intellij.uml.UmlGraphBuilderFactory;
import com.intellij.uml.components.UmlGraphZoomableViewport;
import com.intellij.uml.utils.UmlUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CdiBeansDiagramRecursivePanel
extends CdiBeansRecursivePanel {
    @Nullable
    private DiagramBuilder builder;
    private final ShowGraphAction myShowGraphAction;
    private final CdiDiagramProvider myProvider;

    public CdiBeansDiagramRecursivePanel(@NotNull FinderRecursivePanel parent, @Nullable Module module, @NotNull DefaultActionGroup actions, @NotNull CdiDiagramProvider provider) {
        if (parent == null) {
            CdiBeansDiagramRecursivePanel.$$$reportNull$$$0(0);
        }
        if (actions == null) {
            CdiBeansDiagramRecursivePanel.$$$reportNull$$$0(1);
        }
        if (provider == null) {
            CdiBeansDiagramRecursivePanel.$$$reportNull$$$0(2);
        }
        super(parent, module, actions);
        this.myProvider = provider;
        this.myShowGraphAction = new ShowGraphAction(this);
        actions.add((AnAction)this.myShowGraphAction);
    }

    @Override
    @Nullable
    protected JComponent createRightComponent(AbstractCdiBeanDescriptor beanDescriptor) {
        if (this.isShowGraph()) {
            try {
                return this.createGraphView(beanDescriptor);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.createRightComponent(beanDescriptor);
    }

    public JComponent createGraphView(AbstractCdiBeanDescriptor beanDescriptor) {
        PsiClass aClass;
        AbstractCdiBeanDescriptor descriptor = beanDescriptor;
        if (descriptor instanceof ProducerBeanDescriptor && (aClass = descriptor.getAnnotatedItem().getContainingClass()) != null) {
            descriptor = new ManagedBeanDescriptor(aClass);
        }
        FinderRecursivePanel.DisposablePanel panel = new FinderRecursivePanel.DisposablePanel((LayoutManager)new BorderLayout(), (Disposable)this);
        this.builder = UmlGraphBuilderFactory.create((Project)this.getProject(), (DiagramProvider)this.myProvider, (Object)descriptor, null);
        Disposer.register((Disposable)panel, (Disposable)this.builder);
        this.builder.getView().setFitContentOnResize(true);
        panel.add((Component)this.createSimpleBeanGraphView(this.builder), (Object)"Center");
        return panel;
    }

    @Override
    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            CdiBeansDiagramRecursivePanel.$$$reportNull$$$0(3);
        }
        if (this.builder != null) {
            return UmlFileEditorImpl.getData((String)dataId, (DiagramBuilder)this.builder);
        }
        return super.getData(dataId);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.myActions.remove((AnAction)this.myShowGraphAction);
    }

    public boolean isShowGraph() {
        CdiViewSettings viewSettings = CdiProjectComponent.getInstance(this.getProject()).getState();
        return viewSettings != null && viewSettings.showGraph;
    }

    public void setSecondComponent(@Nullable JComponent component) {
        super.setSecondComponent(component);
        UmlUtils.refreshDataModelInSmartMode((DiagramBuilder)this.builder);
    }

    private JComponent createSimpleBeanGraphView(@NotNull DiagramBuilder builder) {
        if (builder == null) {
            CdiBeansDiagramRecursivePanel.$$$reportNull$$$0(4);
        }
        builder.getPresentationModel().registerActions();
        Graph2DView view = builder.getView();
        GraphViewUtil.addDataProvider((Graph2DView)view, (DataProvider)this);
        view.getCanvasComponent().setBackground((Color)JBColor.GRAY);
        return new UmlGraphZoomableViewport(builder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        objectArray2[1] = "com/intellij/cdi/view/CdiBeansDiagramRecursivePanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getData";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createSimpleBeanGraphView";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

