/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.jam;

import com.intellij.cdi.jam.CdiNamedBean;
import com.intellij.cdi.jam.CdiSemContributor;
import com.intellij.cdi.jam.events.CdiObserves;
import com.intellij.cdi.jam.inject.CdiInject;
import com.intellij.cdi.jam.lifecycle.CdiDispose;
import com.intellij.cdi.jam.producers.CdiProduces;
import com.intellij.cdi.jam.specialization.CdiSpecializes;
import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.jam.JamService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class CdiJamModel {
    private final Module myModule;

    public static CdiJamModel getModel(@NotNull Module module) {
        if (module == null) {
            CdiJamModel.$$$reportNull$$$0(0);
        }
        return new CdiJamModel(module);
    }

    private CdiJamModel(@NotNull Module module) {
        if (module == null) {
            CdiJamModel.$$$reportNull$$$0(1);
        }
        this.myModule = module;
    }

    public List<CdiNamedBean> getNamedBeans() {
        return this.getNamedBeans(GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this.myModule));
    }

    public List<CdiNamedBean> getNamedBeans(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            CdiJamModel.$$$reportNull$$$0(2);
        }
        JamService service = JamService.getJamService((Project)this.myModule.getProject());
        ArrayList<CdiNamedBean> beanCdis = new ArrayList<CdiNamedBean>();
        beanCdis.addAll(service.getJamClassElements(CdiSemContributor.NAMED_JAM_KEY, "javax.inject.Named", scope));
        beanCdis.addAll(service.getJamMethodElements(CdiSemContributor.NAMED_JAM_KEY, "javax.inject.Named", scope));
        beanCdis.addAll(service.getJamFieldElements(CdiSemContributor.NAMED_JAM_KEY, "javax.inject.Named", scope));
        Collection<PsiClass> stereotypeAnnotationClasses = CdiCommonUtils.getStereotypeAnnotationClasses(this.myModule, "javax.inject.Named");
        for (String annoFQN : CdiCommonUtils.getQualifiedNames(stereotypeAnnotationClasses)) {
            beanCdis.addAll(service.getJamClassElements(CdiSemContributor.NAMED_JAM_KEY, annoFQN, scope));
            beanCdis.addAll(service.getJamMethodElements(CdiSemContributor.NAMED_JAM_KEY, annoFQN, scope));
            beanCdis.addAll(service.getJamFieldElements(CdiSemContributor.NAMED_JAM_KEY, annoFQN, scope));
        }
        return beanCdis;
    }

    public Set<CdiObserves> getObserves() {
        return this.getObserves(GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this.myModule));
    }

    public Set<CdiObserves> getObserves(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            CdiJamModel.$$$reportNull$$$0(3);
        }
        HashSet observes = ContainerUtil.newHashSet();
        JamService service = JamService.getJamService((Project)this.myModule.getProject());
        observes.addAll(service.getJamParameterElements(CdiObserves.OBSERVES_JAM_KEY, "javax.enterprise.event.Observes", scope));
        observes.addAll(service.getJamParameterElements(CdiObserves.OBSERVES_JAM_KEY, "javax.enterprise.event.ObservesAsync", scope));
        return observes;
    }

    public List<CdiDispose> getDisposes(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            CdiJamModel.$$$reportNull$$$0(4);
        }
        JamService service = JamService.getJamService((Project)this.myModule.getProject());
        return service.getJamParameterElements(CdiDispose.META.getJamKey(), "javax.enterprise.inject.Disposes", scope);
    }

    @NotNull
    public List<CdiInject> getInjects(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            CdiJamModel.$$$reportNull$$$0(5);
        }
        JamService service = JamService.getJamService((Project)this.myModule.getProject());
        ArrayList<CdiInject> injects = new ArrayList<CdiInject>();
        injects.addAll(service.getJamFieldElements(CdiInject.FIELD_META, "javax.inject.Inject", scope));
        injects.addAll(service.getJamMethodElements(CdiInject.METHOD_META, "javax.inject.Inject", scope));
        ArrayList<CdiInject> arrayList = injects;
        if (arrayList == null) {
            CdiJamModel.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @NotNull
    public List<CdiProduces> getProduces() {
        List<CdiProduces> list = this.getProduces(GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this.myModule));
        if (list == null) {
            CdiJamModel.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    public List<CdiProduces> getProduces(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            CdiJamModel.$$$reportNull$$$0(8);
        }
        List<CdiProduces> list = this.getProduces(scope, true, true);
        if (list == null) {
            CdiJamModel.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    public List<CdiProduces> getProduces(@NotNull GlobalSearchScope scope, boolean methods, boolean fields) {
        if (scope == null) {
            CdiJamModel.$$$reportNull$$$0(10);
        }
        JamService service = JamService.getJamService((Project)this.myModule.getProject());
        ArrayList<CdiProduces> produces = new ArrayList<CdiProduces>();
        if (fields) {
            produces.addAll(service.getJamFieldElements(CdiProduces.FIELD_META, "javax.enterprise.inject.Produces", scope));
        }
        if (methods) {
            produces.addAll(service.getJamMethodElements(CdiProduces.METHOD_META, "javax.enterprise.inject.Produces", scope));
        }
        ArrayList<CdiProduces> arrayList = produces;
        if (arrayList == null) {
            CdiJamModel.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    public List<CdiSpecializes> getSpecializeses() {
        JamService service = JamService.getJamService((Project)this.myModule.getProject());
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this.myModule);
        ArrayList<CdiSpecializes> specializeses = new ArrayList<CdiSpecializes>();
        specializeses.addAll(service.getJamClassElements(CdiSpecializes.CLASS_META, "javax.enterprise.inject.Specializes", scope));
        specializeses.addAll(service.getJamMethodElements(CdiSpecializes.METHOD_META, "javax.enterprise.inject.Specializes", scope));
        return specializeses;
    }

    public List<CdiSpecializes> getSpecializes(PsiClass psiClass) {
        JamService service = JamService.getJamService((Project)this.myModule.getProject());
        return service.getAnnotatedMembersList(psiClass, CdiSpecializes.SEM_KEY, true, true, false, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cdi/jam/CdiJamModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cdi/jam/CdiJamModel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInjects";
                break;
            }
            case 7: 
            case 9: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getProduces";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getModel";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getNamedBeans";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getObserves";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDisposes";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getInjects";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getProduces";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

