/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.highlighting;

import com.intellij.cdi.beans.CdiBeanDescriptor;
import com.intellij.cdi.beans.ManagedBeanDescriptor;
import com.intellij.cdi.beans.ProducerBeanDescriptor;
import com.intellij.cdi.highlighting.CdiBaseInspection;
import com.intellij.cdi.resources.CdiInspectionBundle;
import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.cdi.utils.CdiInjectionUtils;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class CdiUnknownProducersForDisposerMethodInspection
extends CdiBaseInspection {
    @Override
    protected void checkManagedBean(ManagedBeanDescriptor descriptor, ProblemsHolder holder) {
        List<PsiMethod> methods = CdiCommonUtils.getDisposerMethods(descriptor.getAnnotatedItem());
        for (PsiMethod method : methods) {
            for (PsiParameter psiParameter : CdiUnknownProducersForDisposerMethodInspection.getDisposeParameters(method)) {
                PsiAnnotation annotation;
                if (CdiUnknownProducersForDisposerMethodInspection.getProducerDescriptors(psiParameter).size() != 0 || (annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)psiParameter, (String[])new String[]{"javax.enterprise.inject.Disposes"})) == null) continue;
                holder.registerProblem((PsiElement)annotation, CdiInspectionBundle.message("CdiUnknownProducersForDisposerMethodInspection.cannot.find.corresponding.producers", new Object[0]), new LocalQuickFix[0]);
            }
        }
    }

    @NotNull
    public static Set<CdiBeanDescriptor> getProducerDescriptors(@NotNull PsiParameter psiParameter) {
        if (psiParameter == null) {
            CdiUnknownProducersForDisposerMethodInspection.$$$reportNull$$$0(0);
        }
        Set<CdiBeanDescriptor> beans = CdiInjectionUtils.getInjectedBeans((PsiModifierListOwner)psiParameter, psiParameter.getType(), true, true, true);
        Set<CdiBeanDescriptor> set = beans.stream().filter(ds -> ds instanceof ProducerBeanDescriptor).collect(Collectors.toSet());
        if (set == null) {
            CdiUnknownProducersForDisposerMethodInspection.$$$reportNull$$$0(1);
        }
        return set;
    }

    private static Set<PsiParameter> getDisposeParameters(@NotNull PsiMethod method) {
        if (method == null) {
            CdiUnknownProducersForDisposerMethodInspection.$$$reportNull$$$0(2);
        }
        HashSet<PsiParameter> disposedParameters = new HashSet<PsiParameter>();
        for (PsiParameter psiParameter : method.getParameterList().getParameters()) {
            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)psiParameter, (String)"javax.enterprise.inject.Disposes", (int)0)) continue;
            disposedParameters.add(psiParameter);
        }
        return disposedParameters;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = CdiInspectionBundle.message("inspection.name.disposer.method.to.produces.errors", new Object[0]);
        if (string == null) {
            CdiUnknownProducersForDisposerMethodInspection.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            CdiUnknownProducersForDisposerMethodInspection.$$$reportNull$$$0(4);
        }
        return highlightDisplayLevel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiParameter";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cdi/highlighting/CdiUnknownProducersForDisposerMethodInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cdi/highlighting/CdiUnknownProducersForDisposerMethodInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProducerDescriptors";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getProducerDescriptors";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDisposeParameters";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

