/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.highlighting;

import com.intellij.cdi.highlighting.CdiBaseInspection;
import com.intellij.cdi.resources.CdiInspectionBundle;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.javaee.model.annotations.AnnotationGenericValue;
import com.intellij.javaee.model.annotations.AnnotationModelUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class CdiTypedAnnotationInspection
extends CdiBaseInspection {
    @Override
    protected void checkClass(PsiClass aClass, ProblemsHolder holder, @NotNull Module module) {
        if (module == null) {
            CdiTypedAnnotationInspection.$$$reportNull$$$0(0);
        }
        CdiTypedAnnotationInspection.checkPsiClassTypes(aClass, (PsiType)JavaPsiFacade.getElementFactory((Project)aClass.getProject()).createType(aClass), holder);
        for (PsiMethod psiMethod : aClass.getMethods()) {
            CdiTypedAnnotationInspection.checkProducerMembers((PsiMember)psiMethod, psiMethod.getReturnType(), holder);
        }
        for (PsiMethod psiMethod : aClass.getFields()) {
            CdiTypedAnnotationInspection.checkProducerMembers((PsiMember)psiMethod, psiMethod.getType(), holder);
        }
    }

    private static void checkPsiClassTypes(PsiClass owner, PsiType psiType, ProblemsHolder holder) {
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)owner, (String[])new String[]{"javax.enterprise.inject.Typed"});
        if (annotation != null) {
            CdiTypedAnnotationInspection.checkTypeCorrespondToBeanType(psiType, holder, annotation);
        }
    }

    private static void checkProducerMembers(PsiMember owner, PsiType psiType, ProblemsHolder holder) {
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)owner, (String[])new String[]{"javax.enterprise.inject.Typed"});
        if (annotation != null) {
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)owner, (String)"javax.enterprise.inject.Produces", (int)1)) {
                CdiTypedAnnotationInspection.checkTypeCorrespondToBeanType(psiType, holder, annotation);
            } else {
                holder.registerProblem((PsiElement)annotation, CdiInspectionBundle.message("CdiTypedAnnotationInspection.non.producer", new Object[0]), new LocalQuickFix[0]);
            }
        }
    }

    private static void checkTypeCorrespondToBeanType(PsiType psiType, ProblemsHolder holder, PsiAnnotation annotation) {
        boolean isAssignable = true;
        List values = AnnotationModelUtil.getPsiClassArrayValue((PsiAnnotation)annotation, (String)"value");
        for (AnnotationGenericValue genericValue : values) {
            PsiClassType type;
            PsiClass typedClass = (PsiClass)genericValue.getValue();
            if (typedClass == null || (type = JavaPsiFacade.getElementFactory((Project)typedClass.getProject()).createType(typedClass)).isAssignableFrom(psiType)) continue;
            isAssignable = false;
            break;
        }
        if (!isAssignable) {
            holder.registerProblem((PsiElement)annotation, CdiInspectionBundle.message("CdiTypedAnnotationInspection.incorrect.bean.type", new Object[0]), new LocalQuickFix[0]);
        }
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            CdiTypedAnnotationInspection.$$$reportNull$$$0(1);
        }
        return highlightDisplayLevel;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = CdiInspectionBundle.message("inspection.name.typed.annotation", new Object[0]);
        if (string == null) {
            CdiTypedAnnotationInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("CdiTypedAnnotationInspection" == null) {
            CdiTypedAnnotationInspection.$$$reportNull$$$0(3);
        }
        return "CdiTypedAnnotationInspection";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cdi/highlighting/CdiTypedAnnotationInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cdi/highlighting/CdiTypedAnnotationInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

