/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.dependencies;

import com.intellij.cdi.dependencies.CdiDependenciesDataModel;
import com.intellij.cdi.dependencies.CdiDependenciesPresentation;
import com.intellij.cdi.dependencies.edges.CdiEdge;
import com.intellij.cdi.dependencies.nodes.CdiNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.GraphBuilderFactory;
import com.intellij.openapi.graph.builder.GraphDataModel;
import com.intellij.openapi.graph.builder.GraphPresentationModel;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiClass;
import java.awt.BorderLayout;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CdiDependenciesGraphComponent
extends JPanel
implements DataProvider,
Disposable {
    @NonNls
    public static final String WEB_BEANS_DEPENDENCIES_GRAPH_COMPONENT = "WEB_BEANS_DEPENDENCIES_GRAPH_COMPONENT";
    private final GraphBuilder<CdiNode, CdiEdge> myBuilder;
    private final PsiClass myPsiClass;
    private final CdiDependenciesDataModel myDataModel;
    private final CdiDependenciesPresentation myPresentationModel;

    public CdiDependenciesGraphComponent(PsiClass psiClass) {
        this.myPsiClass = psiClass;
        Project project = psiClass.getProject();
        Graph2D graph = GraphManager.getGraphManager().createGraph2D();
        Graph2DView view = GraphManager.getGraphManager().createGraph2DView();
        this.myDataModel = new CdiDependenciesDataModel(this.myPsiClass);
        this.myPresentationModel = new CdiDependenciesPresentation(graph, this.myDataModel);
        this.myBuilder = GraphBuilderFactory.getInstance((Project)project).createGraphBuilder(graph, view, (GraphDataModel)this.myDataModel, (GraphPresentationModel)this.myPresentationModel);
        this.setLayout(new BorderLayout());
        this.add(this.myBuilder.getView().getComponent(), "Center");
        GraphViewUtil.addDataProvider((Graph2DView)view, (DataProvider)new MyDataProvider(this.myBuilder));
        Disposer.register((Disposable)this, this.myBuilder);
        this.myBuilder.initialize();
    }

    public GraphBuilder<CdiNode, CdiEdge> getBuilder() {
        return this.myBuilder;
    }

    public void dispose() {
    }

    public PsiClass getPsiClass() {
        return this.myPsiClass;
    }

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            CdiDependenciesGraphComponent.$$$reportNull$$$0(0);
        }
        if (dataId.equals(WEB_BEANS_DEPENDENCIES_GRAPH_COMPONENT)) {
            return this;
        }
        return null;
    }

    public CdiDependenciesDataModel getDataModel() {
        return this.myDataModel;
    }

    public CdiDependenciesPresentation getPresentationModel() {
        return this.myPresentationModel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/cdi/dependencies/CdiDependenciesGraphComponent", "getData"));
    }

    private class MyDataProvider
    implements DataProvider {
        private final Project myProject;
        private final Graph2D myGraph;

        MyDataProvider(GraphBuilder<CdiNode, CdiEdge> builder) {
            if (builder == null) {
                MyDataProvider.$$$reportNull$$$0(0);
            }
            this.myProject = builder.getProject();
            this.myGraph = builder.getGraph();
        }

        @Nullable
        public Object getData(@NotNull @NonNls String dataId) {
            if (dataId == null) {
                MyDataProvider.$$$reportNull$$$0(1);
            }
            if (dataId.equals(CommonDataKeys.PROJECT.getName())) {
                return this.myProject;
            }
            if (dataId.equals(CommonDataKeys.PSI_ELEMENT.getName())) {
                for (Node node : this.myGraph.getNodeArray()) {
                    CdiNode cdiNode;
                    if (!this.myGraph.getRealizer(node).isSelected() || (cdiNode = (CdiNode)CdiDependenciesGraphComponent.this.myBuilder.getNodeObject(node)) == null) continue;
                    return cdiNode.getIdentifyingElement();
                }
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/cdi/dependencies/CdiDependenciesGraphComponent$MyDataProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

