/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.checker;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.TypeCapabilitiesKt;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.TypeCheckerProcedureCallbacksImpl;
import org.jetbrains.kotlin.types.checker.TypeCheckingProcedureCallbacks;
import org.jetbrains.kotlin.types.checker.UtilsKt;

public class TypeCheckingProcedure {
    private final TypeCheckingProcedureCallbacks constraints;

    @Nullable
    public static KotlinType findCorrespondingSupertype(@NotNull KotlinType subtype, @NotNull KotlinType supertype2) {
        return TypeCheckingProcedure.findCorrespondingSupertype(subtype, supertype2, new TypeCheckerProcedureCallbacksImpl());
    }

    @Nullable
    public static KotlinType findCorrespondingSupertype(@NotNull KotlinType subtype, @NotNull KotlinType supertype2, @NotNull TypeCheckingProcedureCallbacks typeCheckingProcedureCallbacks) {
        return UtilsKt.findCorrespondingSupertype(subtype, supertype2, typeCheckingProcedureCallbacks);
    }

    @NotNull
    private static KotlinType getOutType(@NotNull TypeParameterDescriptor parameter, @NotNull TypeProjection argument2) {
        boolean isInProjected = argument2.getProjectionKind() == Variance.IN_VARIANCE || parameter.getVariance() == Variance.IN_VARIANCE;
        return isInProjected ? DescriptorUtilsKt.getBuiltIns(parameter).getNullableAnyType() : argument2.getType();
    }

    @NotNull
    private static KotlinType getInType(@NotNull TypeParameterDescriptor parameter, @NotNull TypeProjection argument2) {
        boolean isOutProjected = argument2.getProjectionKind() == Variance.OUT_VARIANCE || parameter.getVariance() == Variance.OUT_VARIANCE;
        return isOutProjected ? DescriptorUtilsKt.getBuiltIns(parameter).getNothingType() : argument2.getType();
    }

    public TypeCheckingProcedure(TypeCheckingProcedureCallbacks constraints) {
        this.constraints = constraints;
    }

    public boolean equalTypes(@NotNull KotlinType type1, @NotNull KotlinType type2) {
        TypeConstructor constructor2;
        if (type1 == type2) {
            return true;
        }
        if (FlexibleTypesKt.isFlexible(type1)) {
            if (FlexibleTypesKt.isFlexible(type2)) {
                return !KotlinTypeKt.isError(type1) && !KotlinTypeKt.isError(type2) && this.isSubtypeOf(type1, type2) && this.isSubtypeOf(type2, type1);
            }
            return this.heterogeneousEquivalence(type2, type1);
        }
        if (FlexibleTypesKt.isFlexible(type2)) {
            return this.heterogeneousEquivalence(type1, type2);
        }
        if (type1.isMarkedNullable() != type2.isMarkedNullable()) {
            return false;
        }
        if (type1.isMarkedNullable()) {
            return this.constraints.assertEqualTypes(TypeUtils.makeNotNullable(type1), TypeUtils.makeNotNullable(type2), this);
        }
        TypeConstructor constructor1 = type1.getConstructor();
        if (!this.constraints.assertEqualTypeConstructors(constructor1, constructor2 = type2.getConstructor())) {
            return false;
        }
        List<TypeProjection> type1Arguments = type1.getArguments();
        List<TypeProjection> type2Arguments = type2.getArguments();
        if (type1Arguments.size() != type2Arguments.size()) {
            return false;
        }
        for (int i2 = 0; i2 < type1Arguments.size(); ++i2) {
            TypeProjection typeProjection1 = type1Arguments.get(i2);
            TypeProjection typeProjection2 = type2Arguments.get(i2);
            if (typeProjection1.isStarProjection() && typeProjection2.isStarProjection()) continue;
            TypeParameterDescriptor typeParameter1 = constructor1.getParameters().get(i2);
            TypeParameterDescriptor typeParameter2 = constructor2.getParameters().get(i2);
            if (this.capture(typeProjection1, typeProjection2, typeParameter1)) continue;
            if (TypeCheckingProcedure.getEffectiveProjectionKind(typeParameter1, typeProjection1) != TypeCheckingProcedure.getEffectiveProjectionKind(typeParameter2, typeProjection2)) {
                return false;
            }
            if (this.constraints.assertEqualTypes(typeProjection1.getType(), typeProjection2.getType(), this)) continue;
            return false;
        }
        return true;
    }

    protected boolean heterogeneousEquivalence(KotlinType inflexibleType, KotlinType flexibleType) {
        assert (!FlexibleTypesKt.isFlexible(inflexibleType)) : "Only inflexible types are allowed here: " + inflexibleType;
        return this.isSubtypeOf(FlexibleTypesKt.asFlexibleType(flexibleType).getLowerBound(), inflexibleType) && this.isSubtypeOf(inflexibleType, FlexibleTypesKt.asFlexibleType(flexibleType).getUpperBound());
    }

    public static EnrichedProjectionKind getEffectiveProjectionKind(@NotNull TypeParameterDescriptor typeParameter, @NotNull TypeProjection typeArgument) {
        Variance a = typeParameter.getVariance();
        Variance b = typeArgument.getProjectionKind();
        if (b == Variance.INVARIANT) {
            Variance t = a;
            a = b;
            b = t;
        }
        if (a == Variance.IN_VARIANCE && b == Variance.OUT_VARIANCE) {
            return EnrichedProjectionKind.STAR;
        }
        if (a == Variance.OUT_VARIANCE && b == Variance.IN_VARIANCE) {
            return EnrichedProjectionKind.STAR;
        }
        return EnrichedProjectionKind.fromVariance(b);
    }

    public boolean isSubtypeOf(@NotNull KotlinType subtype, @NotNull KotlinType supertype2) {
        if (TypeCapabilitiesKt.sameTypeConstructors(subtype, supertype2)) {
            return !subtype.isMarkedNullable() || supertype2.isMarkedNullable();
        }
        KotlinType subtypeRepresentative = TypeCapabilitiesKt.getSubtypeRepresentative(subtype);
        KotlinType supertypeRepresentative = TypeCapabilitiesKt.getSupertypeRepresentative(supertype2);
        if (subtypeRepresentative != subtype || supertypeRepresentative != supertype2) {
            return this.isSubtypeOf(subtypeRepresentative, supertypeRepresentative);
        }
        return this.isSubtypeOfForRepresentatives(subtype, supertype2);
    }

    private boolean isSubtypeOfForRepresentatives(KotlinType subtype, KotlinType supertype2) {
        if (KotlinTypeKt.isError(subtype) || KotlinTypeKt.isError(supertype2)) {
            return true;
        }
        if (!supertype2.isMarkedNullable() && subtype.isMarkedNullable()) {
            return false;
        }
        if (KotlinBuiltIns.isNothingOrNullableNothing(subtype)) {
            return true;
        }
        KotlinType closestSupertype = TypeCheckingProcedure.findCorrespondingSupertype(subtype, supertype2, this.constraints);
        if (closestSupertype == null) {
            return this.constraints.noCorrespondingSupertype(subtype, supertype2);
        }
        if (!supertype2.isMarkedNullable() && closestSupertype.isMarkedNullable()) {
            return false;
        }
        return this.checkSubtypeForTheSameConstructor(closestSupertype, supertype2);
    }

    private boolean checkSubtypeForTheSameConstructor(@NotNull KotlinType subtype, @NotNull KotlinType supertype2) {
        TypeConstructor constructor2 = subtype.getConstructor();
        List<TypeProjection> subArguments = subtype.getArguments();
        List<TypeProjection> superArguments = supertype2.getArguments();
        if (subArguments.size() != superArguments.size()) {
            return false;
        }
        List<TypeParameterDescriptor> parameters2 = constructor2.getParameters();
        for (int i2 = 0; i2 < parameters2.size(); ++i2) {
            boolean argumentIsErrorType;
            TypeParameterDescriptor parameter = parameters2.get(i2);
            TypeProjection superArgument = superArguments.get(i2);
            TypeProjection subArgument = subArguments.get(i2);
            if (superArgument.isStarProjection() || this.capture(subArgument, superArgument, parameter)) continue;
            boolean bl = argumentIsErrorType = KotlinTypeKt.isError(subArgument.getType()) || KotlinTypeKt.isError(superArgument.getType());
            if (!argumentIsErrorType && parameter.getVariance() == Variance.INVARIANT && subArgument.getProjectionKind() == Variance.INVARIANT && superArgument.getProjectionKind() == Variance.INVARIANT) {
                if (this.constraints.assertEqualTypes(subArgument.getType(), superArgument.getType(), this)) continue;
                return false;
            }
            KotlinType superOut = TypeCheckingProcedure.getOutType(parameter, superArgument);
            KotlinType subOut = TypeCheckingProcedure.getOutType(parameter, subArgument);
            if (!this.constraints.assertSubtype(subOut, superOut, this)) {
                return false;
            }
            KotlinType superIn = TypeCheckingProcedure.getInType(parameter, superArgument);
            KotlinType subIn = TypeCheckingProcedure.getInType(parameter, subArgument);
            if (superArgument.getProjectionKind() != Variance.OUT_VARIANCE) {
                if (this.constraints.assertSubtype(superIn, subIn, this)) continue;
                return false;
            }
            assert (KotlinBuiltIns.isNothing(superIn)) : "In component must be Nothing for out-projection";
        }
        return true;
    }

    private boolean capture(@NotNull TypeProjection subtypeArgumentProjection, @NotNull TypeProjection supertypeArgumentProjection, @NotNull TypeParameterDescriptor parameter) {
        if (parameter.getVariance() != Variance.INVARIANT) {
            return false;
        }
        if (subtypeArgumentProjection.getProjectionKind() != Variance.INVARIANT && supertypeArgumentProjection.getProjectionKind() == Variance.INVARIANT) {
            return this.constraints.capture(supertypeArgumentProjection.getType(), subtypeArgumentProjection);
        }
        return false;
    }

    public static enum EnrichedProjectionKind {
        IN,
        OUT,
        INV,
        STAR;


        @NotNull
        public static EnrichedProjectionKind fromVariance(@NotNull Variance variance) {
            switch (variance) {
                case INVARIANT: {
                    return INV;
                }
                case IN_VARIANCE: {
                    return IN;
                }
                case OUT_VARIANCE: {
                    return OUT;
                }
            }
            throw new IllegalStateException("Unknown variance");
        }
    }
}

