/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.storage.version;

import java.io.File;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.incremental.storage.version.CacheAttributesManager;
import org.jetbrains.kotlin.incremental.storage.version.CacheVersion;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmBytecodeBinaryVersion;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmMetadataVersion;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\n\u0010\u000e\u001a\u0004\u0018\u00010\u0002H\u0016J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0002H\u0016R\u0016\u0010\b\u001a\u0004\u0018\u00010\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/incremental/storage/version/CacheVersionManager;", "Lorg/jetbrains/kotlin/incremental/storage/version/CacheAttributesManager;", "Lorg/jetbrains/kotlin/incremental/storage/version/CacheVersion;", "versionFile", "Ljava/io/File;", "expectedOwnVersion", "", "(Ljava/io/File;Ljava/lang/Integer;)V", "expected", "getExpected", "()Lorg/jetbrains/kotlin/incremental/storage/version/CacheVersion;", "versionFileForTesting", "getVersionFileForTesting", "()Ljava/io/File;", "loadActual", "writeActualVersion", "", "values", "kotlin-build-common"})
public final class CacheVersionManager
implements CacheAttributesManager<CacheVersion> {
    @Nullable
    private final CacheVersion expected;
    private final File versionFile;

    @Override
    @Nullable
    public CacheVersion getExpected() {
        return this.expected;
    }

    @Override
    @Nullable
    public CacheVersion loadActual() {
        String string;
        if (!this.versionFile.exists()) {
            string = null;
        } else {
            Object object;
            try {
                int n;
                object = FilesKt.readText$default((File)this.versionFile, null, (int)1, null);
                int n2 = n = Integer.parseInt((String)object);
                object = new CacheVersion(n2);
            }
            catch (NumberFormatException e) {
                object = null;
            }
            catch (IOException e) {
                object = null;
            }
            string = object;
        }
        return string;
    }

    @Override
    public void writeActualVersion(@Nullable CacheVersion values) {
        if (values == null) {
            this.versionFile.delete();
        } else {
            this.versionFile.getParentFile().mkdirs();
            FilesKt.writeText$default((File)this.versionFile, (String)String.valueOf(values.getVersion()), null, (int)2, null);
        }
    }

    @NotNull
    public final File getVersionFileForTesting() {
        return this.versionFile;
    }

    public CacheVersionManager(@NotNull File versionFile, @Nullable Integer expectedOwnVersion) {
        CacheVersion cacheVersion;
        Intrinsics.checkParameterIsNotNull((Object)versionFile, (String)"versionFile");
        this.versionFile = versionFile;
        if (expectedOwnVersion == null) {
            cacheVersion = null;
        } else {
            JvmMetadataVersion metadata = JvmMetadataVersion.INSTANCE;
            JvmBytecodeBinaryVersion bytecode2 = JvmBytecodeBinaryVersion.INSTANCE;
            cacheVersion = new CacheVersion(expectedOwnVersion * 1000000 + bytecode2.getMajor() * 10000 + bytecode2.getMinor() * 100 + metadata.getMajor() * 1000 + metadata.getMinor());
        }
        this.expected = cacheVersion;
    }

    @Override
    public boolean isCompatible(@NotNull CacheVersion actual, @NotNull CacheVersion expected) {
        Intrinsics.checkParameterIsNotNull((Object)actual, (String)"actual");
        Intrinsics.checkParameterIsNotNull((Object)expected, (String)"expected");
        return CacheAttributesManager.DefaultImpls.isCompatible(this, actual, expected);
    }
}

