/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters1;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.DescriptorToSourceUtilsIde;
import org.jetbrains.kotlin.idea.core.KotlinNameSuggester;
import org.jetbrains.kotlin.idea.core.UtilsKt;
import org.jetbrains.kotlin.idea.quickfix.AddFunctionParametersFix;
import org.jetbrains.kotlin.idea.quickfix.ChangeFunctionSignatureFix;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactoryWithDelegate;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinChangeSignatureConfiguration;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinChangeSignatureKt;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinMethodDescriptor;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinMutableMethodDescriptor;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.ValueArgumentName;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u00192\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0019B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J$\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00100\u000fH\u0004J\"\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\b\u0010\u0018\u001a\u00020\u0010H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeFunctionSignatureFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lcom/intellij/psi/PsiElement;", "element", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "(Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;)V", "getFunctionDescriptor", "()Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "getFamilyName", "", "getNewArgumentName", "argument", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "validator", "Lkotlin/Function1;", "", "isAvailable", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "startInWriteAction", "Companion", "idea"})
public abstract class ChangeFunctionSignatureFix
extends KotlinQuickFixAction<PsiElement> {
    @NotNull
    private final FunctionDescriptor functionDescriptor;
    @NotNull
    private static final String FAMILY_NAME = "Change signature of function/constructor";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getFamilyName() {
        return FAMILY_NAME;
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        boolean bl;
        Collection declarations2;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Collection collection = declarations2 = DescriptorToSourceUtilsIde.getAllDeclarations$default(DescriptorToSourceUtilsIde.INSTANCE, project, this.functionDescriptor, null, 4, null);
        if (collection.isEmpty()) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        Iterable $receiver$iv = declarations2;
        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $receiver$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            Object element$iv = iterator2.next();
            PsiElement it = (PsiElement)element$iv;
            if (!it.isValid()) return false;
            if (!KotlinRefactoringUtilKt.canRefactor(it)) return false;
            bl = true;
        } while (bl);
        return false;
    }

    @NotNull
    protected final String getNewArgumentName(@NotNull ValueArgument argument2, @NotNull Function1<? super String, Boolean> validator2) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)argument2, (String)"argument");
        Intrinsics.checkParameterIsNotNull(validator2, (String)"validator");
        ValueArgumentName argumentName2 = argument2.getArgumentName();
        KtExpression expression2 = argument2.getArgumentExpression();
        if (argumentName2 != null) {
            String string2 = argumentName2.getAsName().asString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"argumentName.asName.asString()");
            string = KotlinNameSuggester.INSTANCE.suggestNameByName(string2, validator2);
        } else if (expression2 != null) {
            BindingContext bindingContext2 = ResolutionUtils.analyze(expression2, BodyResolveMode.PARTIAL);
            string = (String)CollectionsKt.first((Iterable)KotlinNameSuggester.INSTANCE.suggestNamesByExpressionAndType(expression2, null, bindingContext2, validator2, "param"));
        } else {
            string = KotlinNameSuggester.INSTANCE.suggestNameByName("param", validator2);
        }
        return string;
    }

    @NotNull
    protected final FunctionDescriptor getFunctionDescriptor() {
        return this.functionDescriptor;
    }

    public ChangeFunctionSignatureFix(@NotNull PsiElement element3, @NotNull FunctionDescriptor functionDescriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)functionDescriptor2, (String)"functionDescriptor");
        super(element3);
        this.functionDescriptor = functionDescriptor2;
    }

    static {
        FAMILY_NAME = FAMILY_NAME;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0018B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0003H\u0014J\u001a\u0010\r\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017R\u0014\u0010\u0005\u001a\u00020\u0006X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeFunctionSignatureFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactoryWithDelegate;", "Lorg/jetbrains/kotlin/psi/KtCallElement;", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "()V", "FAMILY_NAME", "", "getFAMILY_NAME", "()Ljava/lang/String;", "createFix", "Lorg/jetbrains/kotlin/idea/quickfix/ChangeFunctionSignatureFix;", "originalElement", "data", "extractFixData", "element", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "getElementOfInterest", "runRemoveParameter", "", "parameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "context", "Lcom/intellij/psi/PsiElement;", "RemoveParameterFix", "idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactoryWithDelegate<KtCallElement, CallableDescriptor> {
        @Override
        @Nullable
        public KtCallElement getElementOfInterest(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement2 = diagnostic.getPsiElement();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"diagnostic.psiElement");
            PsiElement $receiver$iv = psiElement2;
            return (KtCallElement)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtCallElement.class, (boolean)false);
        }

        @Override
        @Nullable
        public CallableDescriptor extractFixData(@NotNull KtCallElement element3, @NotNull Diagnostic diagnostic) {
            Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            Object d = DiagnosticFactory.cast(diagnostic, Errors.TOO_MANY_ARGUMENTS, Errors.NO_VALUE_FOR_PARAMETER);
            Intrinsics.checkExpressionValueIsNotNull(d, (String)"DiagnosticFactory.cast(d\u2026s.NO_VALUE_FOR_PARAMETER)");
            return (CallableDescriptor)((DiagnosticWithParameters1)d).getA();
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        protected ChangeFunctionSignatureFix createFix(@NotNull KtCallElement originalElement2, @NotNull CallableDescriptor data) {
            FunctionDescriptor functionDescriptor2;
            Intrinsics.checkParameterIsNotNull((Object)originalElement2, (String)"originalElement");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            CallableDescriptor callableDescriptor = data;
            if (!(callableDescriptor instanceof FunctionDescriptor)) {
                callableDescriptor = null;
            }
            if ((functionDescriptor2 = (FunctionDescriptor)callableDescriptor) == null) {
                CallableDescriptor callableDescriptor2 = data;
                if (!(callableDescriptor2 instanceof ValueParameterDescriptor)) {
                    callableDescriptor2 = null;
                }
                ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)callableDescriptor2;
                CallableDescriptor callableDescriptor3 = valueParameterDescriptor != null ? valueParameterDescriptor.getContainingDeclaration() : null;
                if (!(callableDescriptor3 instanceof FunctionDescriptor)) {
                    callableDescriptor3 = null;
                }
                functionDescriptor2 = (FunctionDescriptor)callableDescriptor3;
            }
            if (functionDescriptor2 == null) {
                return null;
            }
            FunctionDescriptor functionDescriptor3 = functionDescriptor2;
            if (functionDescriptor3.getKind() == CallableMemberDescriptor.Kind.SYNTHESIZED) {
                return null;
            }
            if (data instanceof ValueParameterDescriptor) {
                return new RemoveParameterFix((PsiElement)originalElement2, functionDescriptor3, (ValueParameterDescriptor)data);
            }
            List<ValueParameterDescriptor> list2 = functionDescriptor3.getValueParameters();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"functionDescriptor.valueParameters");
            List<ValueParameterDescriptor> parameters2 = list2;
            List<? extends ValueArgument> list3 = originalElement2.getValueArguments();
            Intrinsics.checkExpressionValueIsNotNull(list3, (String)"originalElement.valueArguments");
            List<? extends ValueArgument> arguments2 = list3;
            if (arguments2.size() > parameters2.size()) {
                boolean bl;
                block14: {
                    Map<ValueArgument, ValueParameterDescriptor> argumentToParameter;
                    BindingContext bindingContext2 = ResolutionUtils.analyze$default(originalElement2, null, 1, null);
                    Call call2 = CallUtilKt.getCall(originalElement2, bindingContext2);
                    if (call2 == null) {
                        return null;
                    }
                    Call call3 = call2;
                    Map<ValueArgument, ValueParameterDescriptor> $receiver$iv = argumentToParameter = UtilsKt.mapArgumentsToParameters(call3, functionDescriptor3);
                    if ($receiver$iv.isEmpty()) {
                        bl = false;
                    } else {
                        Map<ValueArgument, ValueParameterDescriptor> map2 = $receiver$iv;
                        Iterator<Map.Entry<ValueArgument, ValueParameterDescriptor>> iterator2 = map2.entrySet().iterator();
                        while (iterator2.hasNext()) {
                            KotlinType argumentType;
                            KotlinType kotlinType;
                            void argument2;
                            Map.Entry<ValueArgument, ValueParameterDescriptor> element$iv;
                            Map.Entry<ValueArgument, ValueParameterDescriptor> it;
                            Map.Entry<ValueArgument, ValueParameterDescriptor> entry = it = (element$iv = iterator2.next());
                            Object object = entry;
                            ValueArgument valueArgument = object.getKey();
                            object = entry;
                            ValueParameterDescriptor parameter = object.getValue();
                            KtExpression ktExpression = argument2.getArgumentExpression();
                            if (ktExpression != null) {
                                Object it2 = object = ktExpression;
                                kotlinType = bindingContext2.getType((KtExpression)it2);
                            } else {
                                kotlinType = argumentType = null;
                            }
                            boolean bl2 = argumentType == null || !KotlinTypeChecker.DEFAULT.isSubtypeOf(argumentType, parameter.getType());
                            if (!bl2) continue;
                            bl = true;
                            break block14;
                        }
                        bl = false;
                    }
                }
                boolean hasTypeMismatches = bl;
                return new AddFunctionParametersFix(originalElement2, functionDescriptor3, hasTypeMismatches);
            }
            return null;
        }

        @NotNull
        public final String getFAMILY_NAME() {
            return FAMILY_NAME;
        }

        public final void runRemoveParameter(@NotNull ValueParameterDescriptor parameterDescriptor, @NotNull PsiElement context) {
            Intrinsics.checkParameterIsNotNull((Object)parameterDescriptor, (String)"parameterDescriptor");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            CallableDescriptor callableDescriptor = parameterDescriptor.getContainingDeclaration();
            if (callableDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.FunctionDescriptor");
            }
            FunctionDescriptor functionDescriptor2 = (FunctionDescriptor)callableDescriptor;
            Project project = context.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"context.project");
            KotlinChangeSignatureKt.runChangeSignature(project, functionDescriptor2, new KotlinChangeSignatureConfiguration(parameterDescriptor){
                final /* synthetic */ ValueParameterDescriptor $parameterDescriptor;

                @NotNull
                public KotlinMethodDescriptor configure(@NotNull KotlinMethodDescriptor originalDescriptor) {
                    Intrinsics.checkParameterIsNotNull((Object)originalDescriptor, (String)"originalDescriptor");
                    return KotlinChangeSignatureKt.modify(originalDescriptor, (Function1<? super KotlinMutableMethodDescriptor, Unit>)((Function1)new Function1<KotlinMutableMethodDescriptor, Unit>(this){
                        final /* synthetic */ runRemoveParameter.1 this$0;

                        public final void invoke(@NotNull KotlinMutableMethodDescriptor descriptor2) {
                            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
                            int index2 = descriptor2.getReceiver() != null ? this.this$0.$parameterDescriptor.getIndex() + 1 : this.this$0.$parameterDescriptor.getIndex();
                            descriptor2.removeParameter(index2);
                        }
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }
                    }));
                }

                public boolean performSilently(@NotNull Collection<? extends PsiElement> affectedFunctions) {
                    Intrinsics.checkParameterIsNotNull(affectedFunctions, (String)"affectedFunctions");
                    return true;
                }

                public boolean forcePerformForSelectedFunctionOnly() {
                    return false;
                }
                {
                    this.$parameterDescriptor = $captured_local_variable$0;
                }
            }, context, "Remove parameter '" + parameterDescriptor.getName().asString() + '\'');
        }

        private Companion() {
            super(null, 1, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\"\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeFunctionSignatureFix$Companion$RemoveParameterFix;", "Lorg/jetbrains/kotlin/idea/quickfix/ChangeFunctionSignatureFix;", "element", "Lcom/intellij/psi/PsiElement;", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "parameterToRemove", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "(Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;)V", "getText", "", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "idea"})
        private static final class RemoveParameterFix
        extends ChangeFunctionSignatureFix {
            private final ValueParameterDescriptor parameterToRemove;

            @NotNull
            public String getText() {
                return "Remove parameter '" + this.parameterToRemove.getName().asString() + '\'';
            }

            @Override
            protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                Object t = this.getElement();
                if (t == null) {
                    return;
                }
                Companion.runRemoveParameter(this.parameterToRemove, (PsiElement)t);
            }

            public RemoveParameterFix(@NotNull PsiElement element3, @NotNull FunctionDescriptor functionDescriptor2, @NotNull ValueParameterDescriptor parameterToRemove) {
                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                Intrinsics.checkParameterIsNotNull((Object)functionDescriptor2, (String)"functionDescriptor");
                Intrinsics.checkParameterIsNotNull((Object)parameterToRemove, (String)"parameterToRemove");
                super(element3, functionDescriptor2);
                this.parameterToRemove = parameterToRemove;
            }
        }
    }
}

