/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.nodejs.protractor;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.autotest.ToggleAutoTestAction;
import com.intellij.execution.testframework.sm.SMCustomMessagesParsing;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.javascript.HelperFilesLocator;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.debug.NodeLocalDebugRunProfileState;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.protractor.ProtractorConsoleFilter;
import com.intellij.javascript.protractor.ProtractorOutputToGeneralTestEventsConverter;
import com.intellij.javascript.protractor.ProtractorUtil;
import com.intellij.javascript.testFramework.navigation.JSTestLocationProvider;
import com.intellij.lang.javascript.buildTools.base.JsbtUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.PathUtil;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.execution.ParametersListUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.nodejs.protractor.KotlinProtractorRunConfiguration;
import org.jetbrains.kotlin.idea.nodejs.protractor.KotlinProtractorRunSettings;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001f2\u00020\u00012\u00020\u0002:\u0002\u001f B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0012\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/idea/nodejs/protractor/KotlinProtractorRunState;", "Lcom/intellij/execution/configurations/RunProfileState;", "Lcom/intellij/javascript/nodejs/debug/NodeLocalDebugRunProfileState;", "runConfiguration", "Lorg/jetbrains/kotlin/idea/nodejs/protractor/KotlinProtractorRunConfiguration;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "protractorPackage", "Lcom/intellij/javascript/nodejs/util/NodePackage;", "(Lorg/jetbrains/kotlin/idea/nodejs/protractor/KotlinProtractorRunConfiguration;Lcom/intellij/execution/runners/ExecutionEnvironment;Lcom/intellij/javascript/nodejs/util/NodePackage;)V", "project", "Lcom/intellij/openapi/project/Project;", "runSettings", "Lorg/jetbrains/kotlin/idea/nodejs/protractor/KotlinProtractorRunSettings;", "createCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "interpreter", "Lcom/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter;", "debugPort", "", "createSmtRunnerConsoleView", "Lcom/intellij/execution/ui/ConsoleView;", "workingDirectory", "Ljava/io/File;", "execute", "Lcom/intellij/execution/ExecutionResult;", "foldCommandLine", "", "consoleView", "processHandler", "Lcom/intellij/execution/process/ProcessHandler;", "Companion", "ProtractorConsoleProperties", "ultimate"})
public final class KotlinProtractorRunState
implements RunProfileState,
NodeLocalDebugRunProfileState {
    private final Project project;
    private final KotlinProtractorRunSettings runSettings;
    private final KotlinProtractorRunConfiguration runConfiguration;
    private final ExecutionEnvironment environment;
    private final NodePackage protractorPackage;
    @NotNull
    private static final String FRAMEWORK_NAME = "KotlinProtractorJavaScriptTestRunner";
    private static final String INTELLIJ_CONFIG_FILE_PATH = "protractor-intellij/lib/protractor-intellij-config.js";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public ExecutionResult execute(int debugPort) {
        NodeJsLocalInterpreter nodeJsLocalInterpreter = this.runSettings.getInterpreterRef().resolveAsLocal(this.project);
        Intrinsics.checkExpressionValueIsNotNull((Object)nodeJsLocalInterpreter, (String)"runSettings.interpreterRef.resolveAsLocal(project)");
        NodeJsLocalInterpreter interpreter = nodeJsLocalInterpreter;
        GeneralCommandLine commandLine = this.createCommandLine(interpreter, debugPort);
        OSProcessHandler oSProcessHandler = NodeCommandLineUtil.createProcessHandler((GeneralCommandLine)commandLine, (boolean)false);
        Intrinsics.checkExpressionValueIsNotNull((Object)oSProcessHandler, (String)"NodeCommandLineUtil.crea\u2026ndler(commandLine, false)");
        OSProcessHandler processHandler = oSProcessHandler;
        ConsoleView consoleView2 = this.createSmtRunnerConsoleView(commandLine.getWorkDirectory());
        ProcessTerminatedListener.attach((ProcessHandler)((ProcessHandler)processHandler));
        consoleView2.attachToProcess((ProcessHandler)processHandler);
        this.foldCommandLine(consoleView2, (ProcessHandler)processHandler);
        DefaultExecutionResult executionResult = new DefaultExecutionResult((ExecutionConsole)consoleView2, (ProcessHandler)processHandler);
        executionResult.setRestartActions(new AnAction[]{(AnAction)new ToggleAutoTestAction()});
        return (ExecutionResult)executionResult;
    }

    private final ConsoleView createSmtRunnerConsoleView(File workingDirectory) {
        Executor executor = this.environment.getExecutor();
        Intrinsics.checkExpressionValueIsNotNull((Object)executor, (String)"environment.executor");
        ProtractorConsoleProperties testConsoleProperties = new ProtractorConsoleProperties(this.runConfiguration, executor, (SMTestLocator)new JSTestLocationProvider());
        BaseTestsOutputConsoleView baseTestsOutputConsoleView = SMTestRunnerConnectionUtil.createConsole((String)FRAMEWORK_NAME, (TestConsoleProperties)((TestConsoleProperties)testConsoleProperties));
        Intrinsics.checkExpressionValueIsNotNull((Object)baseTestsOutputConsoleView, (String)"SMTestRunnerConnectionUt\u2026E, testConsoleProperties)");
        BaseTestsOutputConsoleView consoleView2 = baseTestsOutputConsoleView;
        consoleView2.addMessageFilter((Filter)new ProtractorConsoleFilter(this.project, workingDirectory));
        Disposer.register((Disposable)((Disposable)this.environment), (Disposable)((Disposable)consoleView2));
        return (ConsoleView)consoleView2;
    }

    public void foldCommandLine(@NotNull ConsoleView consoleView2, @NotNull ProcessHandler processHandler) {
        ArrayList<String> arrayList;
        Intrinsics.checkParameterIsNotNull((Object)consoleView2, (String)"consoleView");
        Intrinsics.checkParameterIsNotNull((Object)processHandler, (String)"processHandler");
        String string = PathUtil.getFileName((String)this.runSettings.getConfigFileSystemDependentPath());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"PathUtil.getFileName(run\u2026gFileSystemDependentPath)");
        String configFileName = string;
        String string2 = PathUtil.getFileName((String)this.runSettings.getTestFileSystemDependentPath());
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"PathUtil.getFileName(run\u2026tFileSystemDependentPath)");
        String testFileName = string2;
        String seleniumAddress = this.runSettings.getSeleniumAddress();
        ArrayList<String> $receiver = arrayList = new ArrayList<String>();
        $receiver.add("protractor");
        CharSequence charSequence = configFileName;
        if (!StringsKt.isBlank((CharSequence)charSequence)) {
            $receiver.add(configFileName);
        }
        if (!StringsKt.isBlank((CharSequence)(charSequence = (CharSequence)testFileName))) {
            $receiver.add("--specs=" + testFileName);
        }
        if (!StringsKt.isBlank((CharSequence)(charSequence = (CharSequence)seleniumAddress))) {
            $receiver.add("--seleniumAddress=" + seleniumAddress);
        }
        charSequence = this.runSettings.getExtraOptions();
        ArrayList<String> arrayList2 = $receiver;
        CharSequence charSequence2 = charSequence;
        if (charSequence2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String string3 = ((Object)StringsKt.trim((CharSequence)charSequence2)).toString();
        arrayList2.addAll(ParametersListUtil.parse((String)string3));
        ArrayList<String> parameters2 = arrayList;
        String string4 = ParametersListUtil.join((List)parameters2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"ParametersListUtil.join(parameters)");
        String foldedCommandLine = string4;
        JsbtUtil.foldCommandLine((ConsoleView)consoleView2, (ProcessHandler)processHandler, (String)foldedCommandLine);
    }

    private final GeneralCommandLine createCommandLine(NodeJsLocalInterpreter interpreter, int debugPort) {
        String string;
        File file;
        GeneralCommandLine generalCommandLine;
        GeneralCommandLine $receiver = generalCommandLine = new GeneralCommandLine();
        $receiver.setCharset(StandardCharsets.UTF_8);
        GeneralCommandLine commandLine = generalCommandLine;
        this.runSettings.getEnvData().configureCommandLine(commandLine, true);
        String originalConfigFilePath = this.runSettings.getConfigFileSystemDependentPath();
        String testFilePath = this.runSettings.getTestFileSystemDependentPath();
        String seleniumAddress = this.runSettings.getSeleniumAddress();
        CharSequence charSequence = originalConfigFilePath;
        boolean withConfigFile = !StringsKt.isBlank((CharSequence)charSequence);
        commandLine.setWorkDirectory(this.project.getBasePath());
        commandLine.setExePath(interpreter.getInterpreterSystemDependentPath());
        NodeCommandLineUtil.addNodeOptionsForDebugging((GeneralCommandLine)commandLine, (List)CollectionsKt.emptyList(), (int)debugPort, (boolean)true, (NodeJsInterpreter)((NodeJsInterpreter)interpreter), (boolean)true);
        NodeCommandLineUtil.configureUsefulEnvironment((GeneralCommandLine)commandLine);
        File file2 = ProtractorUtil.getProtractorMainJsFile((NodePackage)this.protractorPackage);
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"ProtractorUtil.getProtra\u2026JsFile(protractorPackage)");
        commandLine.addParameter(file2.getAbsolutePath());
        try {
            file = HelperFilesLocator.getFileRelativeToHelpersDir((String)INTELLIJ_CONFIG_FILE_PATH);
        }
        catch (IOException e) {
            throw (Throwable)new ExecutionException("Cannot locate wrapper config file", (Throwable)e);
        }
        File file3 = file;
        Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"try {\n            Helper\u2026onfig file\", e)\n        }");
        File intellijConfigFile = file3;
        commandLine.addParameter(intellijConfigFile.getAbsolutePath());
        if (withConfigFile) {
            string = originalConfigFilePath;
        } else {
            File tempConfigFile;
            File file4 = tempConfigFile = File.createTempFile("protractor", "conf.js");
            Intrinsics.checkExpressionValueIsNotNull((Object)file4, (String)"tempConfigFile");
            FilesKt.writeText$default((File)file4, (String)"exports.config = {}", null, (int)2, null);
            string = tempConfigFile.getAbsolutePath();
        }
        String actualConfigFilePath = string;
        commandLine.addParameter("--intellijOriginalConfigFile=" + actualConfigFilePath);
        CharSequence charSequence2 = testFilePath;
        if (!StringsKt.isBlank((CharSequence)charSequence2)) {
            commandLine.addParameter("--specs=" + testFilePath);
        }
        if (!StringsKt.isBlank((CharSequence)(charSequence2 = (CharSequence)seleniumAddress))) {
            commandLine.addParameter("--seleniumAddress=" + seleniumAddress);
        }
        charSequence2 = this.runSettings.getExtraOptions();
        GeneralCommandLine generalCommandLine2 = commandLine;
        CharSequence charSequence3 = charSequence2;
        if (charSequence3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String string2 = ((Object)StringsKt.trim((CharSequence)charSequence3)).toString();
        generalCommandLine2.addParameters(ParametersListUtil.parse((String)string2));
        commandLine.addParameter("--disableChecks");
        return commandLine;
    }

    public KotlinProtractorRunState(@NotNull KotlinProtractorRunConfiguration runConfiguration, @NotNull ExecutionEnvironment environment, @NotNull NodePackage protractorPackage) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)runConfiguration), (String)"runConfiguration");
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        Intrinsics.checkParameterIsNotNull((Object)protractorPackage, (String)"protractorPackage");
        this.runConfiguration = runConfiguration;
        this.environment = environment;
        this.protractorPackage = protractorPackage;
        Project project = this.runConfiguration.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"runConfiguration.project");
        this.project = project;
        this.runSettings = this.runConfiguration.getRunSettings();
    }

    static {
        FRAMEWORK_NAME = FRAMEWORK_NAME;
        INTELLIJ_CONFIG_FILE_PATH = INTELLIJ_CONFIG_FILE_PATH;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\bH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/nodejs/protractor/KotlinProtractorRunState$ProtractorConsoleProperties;", "Lcom/intellij/execution/testframework/sm/runner/SMTRunnerConsoleProperties;", "Lcom/intellij/execution/testframework/sm/SMCustomMessagesParsing;", "configuration", "Lorg/jetbrains/kotlin/idea/nodejs/protractor/KotlinProtractorRunConfiguration;", "executor", "Lcom/intellij/execution/Executor;", "myLocator", "Lcom/intellij/execution/testframework/sm/runner/SMTestLocator;", "(Lorg/jetbrains/kotlin/idea/nodejs/protractor/KotlinProtractorRunConfiguration;Lcom/intellij/execution/Executor;Lcom/intellij/execution/testframework/sm/runner/SMTestLocator;)V", "createTestEventsConverter", "Lcom/intellij/javascript/protractor/ProtractorOutputToGeneralTestEventsConverter;", "testFrameworkName", "", "consoleProperties", "Lcom/intellij/execution/testframework/TestConsoleProperties;", "getTestLocator", "ultimate"})
    private static final class ProtractorConsoleProperties
    extends SMTRunnerConsoleProperties
    implements SMCustomMessagesParsing {
        private final SMTestLocator myLocator;

        @NotNull
        public SMTestLocator getTestLocator() {
            return this.myLocator;
        }

        @NotNull
        public ProtractorOutputToGeneralTestEventsConverter createTestEventsConverter(@NotNull String testFrameworkName, @NotNull TestConsoleProperties consoleProperties) {
            Intrinsics.checkParameterIsNotNull((Object)testFrameworkName, (String)"testFrameworkName");
            Intrinsics.checkParameterIsNotNull((Object)consoleProperties, (String)"consoleProperties");
            return new ProtractorOutputToGeneralTestEventsConverter(testFrameworkName, consoleProperties.isEditable());
        }

        public ProtractorConsoleProperties(@NotNull KotlinProtractorRunConfiguration configuration2, @NotNull Executor executor, @NotNull SMTestLocator myLocator) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)configuration2), (String)"configuration");
            Intrinsics.checkParameterIsNotNull((Object)executor, (String)"executor");
            Intrinsics.checkParameterIsNotNull((Object)myLocator, (String)"myLocator");
            super((RunConfiguration)configuration2, Companion.getFRAMEWORK_NAME(), executor);
            this.myLocator = myLocator;
            this.setUsePredefinedMessageFilter(false);
            this.setIfUndefined((AbstractProperty)TestConsoleProperties.HIDE_PASSED_TESTS, false);
            this.setIfUndefined((AbstractProperty)TestConsoleProperties.HIDE_IGNORED_TEST, true);
            this.setIfUndefined((AbstractProperty)TestConsoleProperties.SCROLL_TO_SOURCE, true);
            this.setIfUndefined((AbstractProperty)TestConsoleProperties.SELECT_FIRST_DEFECT, true);
            this.setIdBasedTestTree(true);
            this.setPrintTestingStartedTime(false);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/nodejs/protractor/KotlinProtractorRunState$Companion;", "", "()V", "FRAMEWORK_NAME", "", "getFRAMEWORK_NAME", "()Ljava/lang/String;", "INTELLIJ_CONFIG_FILE_PATH", "ultimate"})
    public static final class Companion {
        @NotNull
        public final String getFRAMEWORK_NAME() {
            return FRAMEWORK_NAME;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

