/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.collections;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a*\u0010\u0000\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u0006\u001a\n\u0010\b\u001a\u00020\u0001*\u00020\u0007\u00a8\u0006\t"}, d2={"hasLastFunctionalParameterWithResult", "", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "predicate", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/types/KotlinType;", "isFunctionOfAnyKind", "idea"})
public final class FunctionUtilsKt {
    public static final boolean isFunctionOfAnyKind(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        ClassifierDescriptor classifierDescriptor = $receiver.getConstructor().getDeclarationDescriptor();
        return (classifierDescriptor != null ? FunctionTypesKt.getFunctionalClassKind(classifierDescriptor) : null) != null;
    }

    public static final boolean hasLastFunctionalParameterWithResult(@NotNull ResolvedCall<?> $receiver, @NotNull BindingContext context, @NotNull Function1<? super KotlinType, Boolean> predicate2) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull(predicate2, (String)"predicate");
        Object obj = $receiver.getResultingDescriptor();
        Intrinsics.checkExpressionValueIsNotNull(obj, (String)"resultingDescriptor");
        List<ValueParameterDescriptor> list2 = obj.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"resultingDescriptor.valueParameters");
        ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)CollectionsKt.lastOrNull(list2);
        if (valueParameterDescriptor == null) {
            return false;
        }
        ValueParameterDescriptor lastParameter = valueParameterDescriptor;
        Object object = $receiver.getValueArguments().get(lastParameter);
        if (object == null || (object = object.getArguments()) == null || (object = (ValueArgument)CollectionsKt.singleOrNull((List)object)) == null) {
            return false;
        }
        Object lastArgument = object;
        Object object2 = lastArgument.getArgumentExpression();
        if (object2 == null || (object2 = CallUtilKt.getType((KtExpression)object2, context)) == null) {
            return false;
        }
        Object functionalType = object2;
        if (!FunctionUtilsKt.isFunctionOfAnyKind((KotlinType)functionalType)) {
            return false;
        }
        Object object3 = (TypeProjection)CollectionsKt.lastOrNull(((KotlinType)functionalType).getArguments());
        if (object3 == null || (object3 = object3.getType()) == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"functionalType.arguments\u2026l()?.type ?: return false");
        Object resultType = object3;
        return (Boolean)predicate2.invoke(resultType);
    }
}

