/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.inspections.AbstractApplicabilityBasedInspection;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u000e\u0010\u0016\u001a\u0004\u0018\u00010\u0017*\u00020\u0018H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/SimplifyNegatedBinaryExpressionInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractApplicabilityBasedInspection;", "Lorg/jetbrains/kotlin/psi/KtPrefixExpression;", "()V", "defaultFixText", "", "getDefaultFixText", "()Ljava/lang/String;", "applyTo", "", "element", "Lcom/intellij/psi/PsiElement;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "fixText", "inspectionTarget", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "inspectionText", "isApplicable", "", "negate", "Lorg/jetbrains/kotlin/lexer/KtSingleValueToken;", "Lcom/intellij/psi/tree/IElementType;", "idea"})
public final class SimplifyNegatedBinaryExpressionInspection
extends AbstractApplicabilityBasedInspection<KtPrefixExpression> {
    @NotNull
    private final String defaultFixText = "Simplify negated operation";

    private final KtSingleValueToken negate(@NotNull IElementType $receiver) {
        IElementType iElementType = $receiver;
        return Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.IN_KEYWORD)) ? (KtSingleValueToken)KtTokens.NOT_IN : (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.NOT_IN)) ? (KtSingleValueToken)KtTokens.IN_KEYWORD : (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.IS_KEYWORD)) ? (KtSingleValueToken)KtTokens.NOT_IS : (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.NOT_IS)) ? (KtSingleValueToken)KtTokens.IS_KEYWORD : (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.EQEQ)) ? KtTokens.EXCLEQ : (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.EXCLEQ)) ? KtTokens.EQEQ : (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.LT)) ? KtTokens.GTEQ : (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.GTEQ)) ? KtTokens.LT : (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.GT)) ? KtTokens.LTEQ : (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.LTEQ)) ? KtTokens.GT : null)))))))));
    }

    @NotNull
    public KtSimpleNameExpression inspectionTarget(@NotNull KtPrefixExpression element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        KtSimpleNameExpression ktSimpleNameExpression = element3.getOperationReference();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktSimpleNameExpression, (String)"element.operationReference");
        return ktSimpleNameExpression;
    }

    @Override
    @NotNull
    public String inspectionText(@NotNull KtPrefixExpression element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        return "Negated operation should be simplified";
    }

    @Override
    @NotNull
    public String getDefaultFixText() {
        return this.defaultFixText;
    }

    @Override
    @NotNull
    public String fixText(@NotNull KtPrefixExpression element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        KtExpression ktExpression = KtPsiUtil.deparenthesize(element3.getBaseExpression());
        if (!(ktExpression instanceof KtOperationExpression)) {
            ktExpression = null;
        }
        KtOperationExpression ktOperationExpression = (KtOperationExpression)ktExpression;
        if (ktOperationExpression == null) {
            return this.getDefaultFixText();
        }
        KtOperationExpression expression2 = ktOperationExpression;
        IElementType iElementType = expression2.getOperationReference().getReferencedNameElementType();
        if (!(iElementType instanceof KtSingleValueToken)) {
            iElementType = null;
        }
        KtSingleValueToken ktSingleValueToken = (KtSingleValueToken)iElementType;
        if (ktSingleValueToken == null) {
            return this.getDefaultFixText();
        }
        KtSingleValueToken operation = ktSingleValueToken;
        KtSingleValueToken ktSingleValueToken2 = this.negate(operation);
        if (ktSingleValueToken2 == null) {
            return this.getDefaultFixText();
        }
        KtSingleValueToken negatedOperation = ktSingleValueToken2;
        return "Replace negated '" + operation.getValue() + "' operation with '" + negatedOperation.getValue() + '\'';
    }

    @Override
    public boolean isApplicable(@NotNull KtPrefixExpression element3) {
        IElementType iElementType;
        KtOperationExpression expression2;
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        if (Intrinsics.areEqual((Object)element3.getOperationToken(), (Object)((Object)KtTokens.EXCL)) ^ true) {
            return false;
        }
        KtExpression ktExpression = KtPsiUtil.deparenthesize(element3.getBaseExpression());
        if (!(ktExpression instanceof KtOperationExpression)) {
            ktExpression = null;
        }
        KtOperationExpression ktOperationExpression = (KtOperationExpression)ktExpression;
        if (ktOperationExpression == null) {
            return false;
        }
        KtOperationExpression ktOperationExpression2 = expression2 = ktOperationExpression;
        if (ktOperationExpression2 instanceof KtIsExpression) {
            if (((KtIsExpression)expression2).getTypeReference() == null) {
                return false;
            }
        } else if (ktOperationExpression2 instanceof KtBinaryExpression) {
            if (((KtBinaryExpression)expression2).getLeft() == null || ((KtBinaryExpression)expression2).getRight() == null) {
                return false;
            }
        } else {
            return false;
        }
        if (!((iElementType = expression2.getOperationReference().getReferencedNameElementType()) instanceof KtSingleValueToken)) {
            iElementType = null;
        }
        KtSingleValueToken ktSingleValueToken = (KtSingleValueToken)iElementType;
        return (ktSingleValueToken != null ? this.negate(ktSingleValueToken) : null) != null;
    }

    @Override
    public void applyTo(@NotNull PsiElement element3, @NotNull Project project, @Nullable Editor editor) {
        KtExpression ktExpression;
        KtExpression expression2;
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        PsiElement psiElement2 = element3.getParent();
        if (!(psiElement2 instanceof KtPrefixExpression)) {
            psiElement2 = null;
        }
        KtPrefixExpression ktPrefixExpression = (KtPrefixExpression)psiElement2;
        if (ktPrefixExpression == null) {
            return;
        }
        KtPrefixExpression prefixExpression = ktPrefixExpression;
        KtExpression ktExpression2 = KtPsiUtil.deparenthesize(prefixExpression.getBaseExpression());
        if (ktExpression2 == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"KtPsiUtil.deparenthesize\u2026baseExpression) ?: return");
        KtExpression ktExpression3 = expression2 = ktExpression2;
        if (ktExpression3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtOperationExpression");
        }
        Object object = this.negate(((KtOperationExpression)ktExpression3).getOperationReference().getReferencedNameElementType());
        if (object == null || (object = object.getValue()) == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"(expression as KtOperati\u2026negate()?.value ?: return");
        Object operation = object;
        KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)expression2, false, 2, null);
        KtExpression ktExpression4 = expression2;
        if (ktExpression4 instanceof KtIsExpression) {
            Object[] objectArray = new Object[3];
            KtExpression ktExpression5 = ((KtIsExpression)expression2).getLeftHandSide();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression5, (String)"expression.leftHandSide");
            objectArray[0] = ktExpression5;
            objectArray[1] = operation;
            KtTypeReference ktTypeReference = ((KtIsExpression)expression2).getTypeReference();
            if (ktTypeReference == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)ktTypeReference, (String)"expression.typeReference!!");
            objectArray[2] = ktTypeReference;
            ktExpression = CreateByPatternKt.createExpressionByPattern$default(psiFactory, "$0 $1 $2", objectArray, false, 4, null);
        } else if (ktExpression4 instanceof KtBinaryExpression) {
            Object[] objectArray = new Object[3];
            KtExpression ktExpression6 = ((KtBinaryExpression)expression2).getLeft();
            if (ktExpression6 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression6, (String)"expression.left!!");
            objectArray[0] = ktExpression6;
            objectArray[1] = operation;
            KtExpression ktExpression7 = ((KtBinaryExpression)expression2).getRight();
            if (ktExpression7 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression7, (String)"expression.right!!");
            objectArray[2] = ktExpression7;
            ktExpression = CreateByPatternKt.createExpressionByPattern$default(psiFactory, "$0 $1 $2", objectArray, false, 4, null);
        } else {
            throw (Throwable)new IllegalArgumentException();
        }
        KtExpression newExpression2 = ktExpression;
        prefixExpression.replace((PsiElement)newExpression2);
    }

    public SimplifyNegatedBinaryExpressionInspection() {
        super(KtPrefixExpression.class);
    }
}

