/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.codegen.ClassBuilderMode;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.psi.KtDelegatedSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.org.objectweb.asm.Type;

public class DelegationFieldsInfo {
    private final Type classAsmType;
    private final ClassDescriptor classDescriptor;
    private final GenerationState state;
    private final KotlinTypeMapper typeMapper;
    private final BindingContext bindingContext;
    private final Map<KtDelegatedSuperTypeEntry, Field> fields = new HashMap<KtDelegatedSuperTypeEntry, Field>();

    public DelegationFieldsInfo(@NotNull Type type2, @NotNull ClassDescriptor descriptor2, @NotNull GenerationState state, @NotNull BindingContext context) {
        this.classAsmType = type2;
        this.classDescriptor = descriptor2;
        this.state = state;
        this.typeMapper = state.getTypeMapper();
        this.bindingContext = context;
    }

    @Nullable
    public Field getInfo(KtDelegatedSuperTypeEntry specifier) {
        Field field2 = this.fields.get(specifier);
        assert (field2 != null || this.state.getClassBuilderMode() == ClassBuilderMode.LIGHT_CLASSES) : "No field for " + specifier.getText();
        return field2;
    }

    private void addField(KtDelegatedSuperTypeEntry specifier, PropertyDescriptor propertyDescriptor) {
        this.fields.put(specifier, new Field(this.typeMapper.mapType(propertyDescriptor), propertyDescriptor.getName().asString(), false));
    }

    private void addField(KtDelegatedSuperTypeEntry specifier, Type type2, String name2) {
        this.fields.put(specifier, new Field(type2, name2, true));
    }

    @NotNull
    public DelegationFieldsInfo getDelegationFieldsInfo(@NotNull List<KtSuperTypeListEntry> delegationSpecifiers) {
        DelegationFieldsInfo result2 = new DelegationFieldsInfo(this.classAsmType, this.classDescriptor, this.state, this.bindingContext);
        int n = 0;
        for (KtSuperTypeListEntry specifier : delegationSpecifiers) {
            KtExpression expression2;
            if (!(specifier instanceof KtDelegatedSuperTypeEntry) || (expression2 = ((KtDelegatedSuperTypeEntry)specifier).getDelegateExpression()) == null) continue;
            PropertyDescriptor propertyDescriptor = CodegenUtil.getDelegatePropertyIfAny(expression2, this.classDescriptor, this.bindingContext);
            if (CodegenUtil.isFinalPropertyWithBackingField(propertyDescriptor, this.bindingContext)) {
                result2.addField((KtDelegatedSuperTypeEntry)specifier, propertyDescriptor);
            } else {
                Type asmType;
                KotlinType expressionType = this.bindingContext.getType(expression2);
                ClassDescriptor superClass = JvmCodegenUtil.getSuperClass(specifier, this.state, this.bindingContext);
                Type type2 = expressionType != null ? this.typeMapper.mapType(expressionType) : (asmType = superClass != null ? this.typeMapper.mapType(superClass) : null);
                if (asmType == null) continue;
                result2.addField((KtDelegatedSuperTypeEntry)specifier, asmType, "$$delegate_" + n);
            }
            ++n;
        }
        return result2;
    }

    public class Field {
        public final Type type;
        public final String name;
        public final boolean generateField;

        private Field(Type type2, String name2, boolean generateField) {
            this.type = type2;
            this.name = name2;
            this.generateField = generateField;
        }

        @NotNull
        public StackValue getStackValue() {
            return StackValue.field(this.type, DelegationFieldsInfo.this.classAsmType, this.name, false, StackValue.none());
        }
    }
}

