/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.openshift.cloud.view;

import com.intellij.javaee.openshift.cloud.OS3TemplateParameterDefinitionImpl;
import com.intellij.javaee.openshift.cloud.view.OS3TemplateParameterConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.remoteServer.util.Column;
import com.intellij.remoteServer.util.JTableWrapper;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTable;

public class OS3TemplateParametersEditor {
    private final JTableWrapper<OS3TemplateParameterDefinitionImpl, ColumnBase> myTableWrapper;
    private final JPanel myPanel;
    private final JBTable myTable = new JBTable();
    private List<OS3TemplateParameterDefinitionImpl> myItems;

    public OS3TemplateParametersEditor() {
        this.myTableWrapper = new JTableWrapper(this.myTable, (Column[])new ColumnBase[]{new NameColumn(), new DescriptionColumn(), new ValueColumn(), new RequiredColumn()});
        this.myPanel = ToolbarDecorator.createDecorator((JTable)this.myTable).setEditAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                OS3TemplateParametersEditor.this.editItem();
            }
        }).setEditActionUpdater(e -> true).createPanel();
    }

    private void editItem() {
        int selectedIndex = this.myTable.getSelectedRow();
        if (selectedIndex == -1) {
            return;
        }
        OS3TemplateParameterDefinitionImpl selectedItem = this.myItems.get(selectedIndex);
        OS3TemplateParameterDefinitionImpl editedItem = OS3TemplateParametersEditor.cloneItem(selectedItem);
        if (!ShowSettingsUtil.getInstance().editConfigurable((Component)this.myPanel, OS3TemplateParametersEditor.createItemConfigurable(editedItem))) {
            return;
        }
        this.myItems.set(selectedIndex, editedItem);
        this.update(selectedIndex);
    }

    private static Configurable createItemConfigurable(OS3TemplateParameterDefinitionImpl item) {
        return new OS3TemplateParameterConfigurable(item);
    }

    private static OS3TemplateParameterDefinitionImpl cloneItem(OS3TemplateParameterDefinitionImpl item) {
        return new OS3TemplateParameterDefinitionImpl(item);
    }

    private void update(int selectedIndex) {
        this.update();
        this.myTable.getSelectionModel().setSelectionInterval(selectedIndex, selectedIndex);
    }

    public JPanel getPanel() {
        return this.myPanel;
    }

    private void update() {
        this.myTableWrapper.setInputRows(this.myItems);
    }

    public void setItems(List<OS3TemplateParameterDefinitionImpl> items) {
        this.myItems = new ArrayList<OS3TemplateParameterDefinitionImpl>(items);
        this.update();
    }

    public List<OS3TemplateParameterDefinitionImpl> getItems() {
        return this.myItems;
    }

    private static class RequiredColumn
    extends ColumnBase {
        RequiredColumn() {
            super("Required");
        }

        public Class<?> getValueClass() {
            return Boolean.class;
        }

        public Object getColumnValue(OS3TemplateParameterDefinitionImpl row) {
            return row.isRequired();
        }
    }

    private static class ValueColumn
    extends ColumnBase {
        ValueColumn() {
            super("Value");
        }

        public Object getColumnValue(OS3TemplateParameterDefinitionImpl row) {
            return row.getValue();
        }
    }

    private static class DescriptionColumn
    extends ColumnBase {
        DescriptionColumn() {
            super("Description");
        }

        public Object getColumnValue(OS3TemplateParameterDefinitionImpl row) {
            return row.getDescription();
        }
    }

    private static class NameColumn
    extends ColumnBase {
        NameColumn() {
            super("Name");
        }

        public Object getColumnValue(OS3TemplateParameterDefinitionImpl row) {
            return row.getName();
        }
    }

    public static abstract class ColumnBase
    extends Column<OS3TemplateParameterDefinitionImpl> {
        public ColumnBase(String name) {
            super(name);
        }
    }
}

