/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.openshift.cloud;

import com.intellij.icons.AllIcons;
import com.intellij.javaee.openshift.agent.cloud.os3.OS3CloudAgent;
import com.intellij.javaee.openshift.agent.cloud.os3.OS3Project;
import com.intellij.javaee.openshift.agent.cloud.os3.OS3ProjectRequestConfig;
import com.intellij.javaee.openshift.agent.cloud.os3.OS3TemplateParameterDefinition;
import com.intellij.javaee.openshift.cloud.OS3CloudConfiguration;
import com.intellij.javaee.openshift.cloud.OS3ServerRuntimeInstance;
import com.intellij.javaee.openshift.cloud.OS3TemplateParameterDefinitionImpl;
import com.intellij.javaee.openshift.cloud.OSBundle;
import com.intellij.javaee.openshift.cloud.OSDeploymentConfiguration;
import com.intellij.javaee.openshift.cloud.action.CreateProjectAction;
import com.intellij.javaee.openshift.cloud.view.OS3TemplateParametersEditor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.remoteServer.runtime.ServerConnectionManager;
import com.intellij.remoteServer.runtime.ServerConnector;
import com.intellij.remoteServer.runtime.deployment.ServerRuntimeInstance;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashSet;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TemplateDeploymentEditorBase
extends SettingsEditor<OSDeploymentConfiguration> {
    private static final int RELOAD_SERVER_DATA_DELAY = 500;
    private String myStoredProjectName;
    private boolean myProjectsLoaded;
    private OS3TemplateParametersEditor myTemplateParametersEditor;
    private JTextArea myErrorMessageTextArea;
    private final Project myProject;
    private final RemoteServer<OS3CloudConfiguration> myServer;
    private final Alarm myAlarm;

    protected TemplateDeploymentEditorBase(@NotNull Project project, @NotNull RemoteServer<OS3CloudConfiguration> server) {
        if (project == null) {
            TemplateDeploymentEditorBase.$$$reportNull$$$0(0);
        }
        if (server == null) {
            TemplateDeploymentEditorBase.$$$reportNull$$$0(1);
        }
        this.myProjectsLoaded = false;
        this.myAlarm = new Alarm((Disposable)this);
        this.myProject = project;
        this.myServer = server;
    }

    protected void setupComponents() {
        this.setupErrorMessagePanel();
        this.getProjectsComboBox().setEnabled(false);
        this.getProjectsComboBox().addItem(this.getLoadingText());
        this.myTemplateParametersEditor = new OS3TemplateParametersEditor();
        this.getTemplateParametersEditorPlaceHolder().add(this.myTemplateParametersEditor.getPanel());
    }

    protected void setupErrorMessagePanel() {
        this.myErrorMessageTextArea = new JTextArea();
        this.myErrorMessageTextArea.setEditable(false);
        this.myErrorMessageTextArea.setOpaque(false);
        this.myErrorMessageTextArea.setLineWrap(true);
        this.getErrorMessagePlaceholder().add((Component)new JLabel(AllIcons.General.Error), "West");
        this.getErrorMessagePlaceholder().add((Component)this.myErrorMessageTextArea, "Center");
    }

    protected void setTemplateParameters(List<? extends OS3TemplateParameterDefinition> parameters) {
        this.myTemplateParametersEditor.setItems(ContainerUtil.map(parameters, OS3TemplateParameterDefinitionImpl::new));
    }

    protected List<OS3TemplateParameterDefinitionImpl> getTemplateParameters() {
        List<OS3TemplateParameterDefinitionImpl> items = this.myTemplateParametersEditor.getItems();
        return items == null ? Collections.emptyList() : ContainerUtil.map(items, OS3TemplateParameterDefinitionImpl::new);
    }

    protected void checkRequiredParameters() throws ConfigurationException {
        for (OS3TemplateParameterDefinitionImpl parameter : this.getTemplateParameters()) {
            if (!parameter.isRequired() || !StringUtil.isEmpty((String)parameter.getValue())) continue;
            throw new ConfigurationException(OSBundle.getText("OSDeploymentConfiguration.os3.parameter.required", parameter.getName()));
        }
    }

    private void loadProjects(@NotNull OS3ServerRuntimeInstance os3ServerRuntimeInstance) throws ServerRuntimeException {
        if (os3ServerRuntimeInstance == null) {
            TemplateDeploymentEditorBase.$$$reportNull$$$0(2);
        }
        HashSet projectNames = new HashSet();
        os3ServerRuntimeInstance.getProjects().forEach(arg_0 -> TemplateDeploymentEditorBase.lambda$loadProjects$0((Set)projectNames, arg_0));
        ApplicationManager.getApplication().invokeLater(() -> this.lambda$loadProjects$2((Set)projectNames), ModalityState.any());
    }

    protected String getLoadingText() {
        return OSBundle.getText("OSDeploymentConfiguration.os3.state.loading", new Object[0]);
    }

    protected String getSelectedItem(@NotNull JComboBox comboBox, @NotNull String message, @Nullable Runnable quickFix) throws ConfigurationException {
        Object selectedItem;
        if (comboBox == null) {
            TemplateDeploymentEditorBase.$$$reportNull$$$0(3);
        }
        if (message == null) {
            TemplateDeploymentEditorBase.$$$reportNull$$$0(4);
        }
        if ((selectedItem = comboBox.getSelectedItem()) == null) {
            throw TemplateDeploymentEditorBase.createItemRequiredException(message, quickFix);
        }
        String selected = selectedItem.toString();
        if (StringUtil.isEmpty((String)selected) || StringUtil.equals((CharSequence)selected, (CharSequence)this.getLoadingText())) {
            throw TemplateDeploymentEditorBase.createItemRequiredException(message, quickFix);
        }
        return selected;
    }

    private static ConfigurationException createItemRequiredException(@NotNull String item, @Nullable Runnable quickFix) {
        if (item == null) {
            TemplateDeploymentEditorBase.$$$reportNull$$$0(5);
        }
        ConfigurationException exception = new ConfigurationException(OSBundle.getText("OSDeploymentConfiguration.os3.selection.required", item));
        exception.setQuickFix(quickFix);
        return exception;
    }

    protected String getProjectName(@NotNull JComboBox projectsComboBox) throws ConfigurationException {
        if (projectsComboBox == null) {
            TemplateDeploymentEditorBase.$$$reportNull$$$0(6);
        }
        return this.getSelectedItem(projectsComboBox, "Project", () -> {
            ModalityState modalityState = ModalityState.current();
            this.connectToServer(os3ServerRuntimeInstance -> CreateProjectAction.createOS3ProjectRequestConfig(this.myProject, modalityState, config -> this.executeTask((OS3ServerRuntimeInstance)((Object)((Object)os3ServerRuntimeInstance)), () -> {
                ((OS3CloudAgent)os3ServerRuntimeInstance.getAgent()).createProject((OS3ProjectRequestConfig)config);
                ApplicationManager.getApplication().invokeLater(() -> this.myAlarm.addRequest(() -> this.loadServerData(), 500), ModalityState.any());
            })));
        });
    }

    private void connectToServer(final @NotNull Consumer<OS3ServerRuntimeInstance> consumer) {
        if (consumer == null) {
            TemplateDeploymentEditorBase.$$$reportNull$$$0(7);
        }
        ServerConnection connection = ServerConnectionManager.getInstance().createTemporaryConnection(this.myServer);
        connection.connectIfNeeded(new ServerConnector.ConnectionCallback(){

            public void connected(@NotNull ServerRuntimeInstance serverRuntimeInstance) {
                if (serverRuntimeInstance == null) {
                    1.$$$reportNull$$$0(0);
                }
                consumer.accept((OS3ServerRuntimeInstance)serverRuntimeInstance);
            }

            public void errorOccurred(@NotNull String error) {
                if (error == null) {
                    1.$$$reportNull$$$0(1);
                }
                TemplateDeploymentEditorBase.this.showError(error);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "serverRuntimeInstance";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "error";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/javaee/openshift/cloud/TemplateDeploymentEditorBase$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "connected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "errorOccurred";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void executeTask(@NotNull OS3ServerRuntimeInstance os3ServerRuntimeInstance, @NotNull Task task) {
        if (os3ServerRuntimeInstance == null) {
            TemplateDeploymentEditorBase.$$$reportNull$$$0(8);
        }
        if (task == null) {
            TemplateDeploymentEditorBase.$$$reportNull$$$0(9);
        }
        os3ServerRuntimeInstance.getTaskExecutor().submit(() -> {
            if (task == null) {
                TemplateDeploymentEditorBase.$$$reportNull$$$0(12);
            }
            try {
                task.execute();
            }
            catch (ServerRuntimeException e) {
                this.showError(e.getMessage());
            }
        });
    }

    protected void showError(@NotNull String errorMessage) {
        if (errorMessage == null) {
            TemplateDeploymentEditorBase.$$$reportNull$$$0(10);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (errorMessage == null) {
                TemplateDeploymentEditorBase.$$$reportNull$$$0(11);
            }
            this.myErrorMessageTextArea.setText(errorMessage);
            this.getErrorMessagePlaceholder().setVisible(true);
        }, ModalityState.any());
    }

    protected final void loadServerData() {
        this.connectToServer(os3ServerRuntimeInstance -> this.executeTask((OS3ServerRuntimeInstance)((Object)os3ServerRuntimeInstance), () -> this.doLoadServerData((OS3ServerRuntimeInstance)((Object)os3ServerRuntimeInstance))));
    }

    protected void doLoadServerData(OS3ServerRuntimeInstance os3ServerRuntimeInstance) throws ServerRuntimeException {
        this.loadProjects(os3ServerRuntimeInstance);
    }

    protected String getStoredProjectName() {
        return this.myStoredProjectName;
    }

    protected void setStoredProjectName(String storedProjectName) {
        this.myStoredProjectName = storedProjectName;
    }

    protected final boolean areProjectsLoaded() {
        return this.myProjectsLoaded;
    }

    protected abstract void updateLoadingState();

    protected abstract JComboBox<String> getProjectsComboBox();

    protected abstract JPanel getErrorMessagePlaceholder();

    protected abstract JPanel getTemplateParametersEditorPlaceHolder();

    private /* synthetic */ void lambda$loadProjects$2(Set projectNames) {
        this.getProjectsComboBox().removeAllItems();
        projectNames.forEach(projectName -> this.getProjectsComboBox().addItem((String)projectName));
        this.myProjectsLoaded = true;
        this.updateLoadingState();
        if (!StringUtil.isEmpty((String)this.getStoredProjectName())) {
            this.getProjectsComboBox().setSelectedItem(this.getStoredProjectName());
        }
    }

    private static /* synthetic */ void lambda$loadProjects$0(Set projectNames, OS3Project project) {
        projectNames.add(project.getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "os3ServerRuntimeInstance";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comboBox";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectsComboBox";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javaee/openshift/cloud/TemplateDeploymentEditorBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "loadProjects";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getSelectedItem";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createItemRequiredException";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getProjectName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "connectToServer";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "executeTask";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "showError";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$showError$10";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$executeTask$9";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @FunctionalInterface
    private static interface Task {
        public void execute() throws ServerRuntimeException;
    }
}

