/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.model.jam;

import com.intellij.jam.JamElement;
import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamClassMeta;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMember;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.ws.rest.model.jam.RSHttpMethod;
import com.intellij.ws.rest.model.jam.RSJamPsiClassPath;
import com.intellij.ws.rest.model.jam.RSJamPsiMethodPath;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RSJamModel {
    @NotNull
    private final Project myProject;

    public static RSJamModel getModel(@NotNull Project project) {
        if (project == null) {
            RSJamModel.$$$reportNull$$$0(0);
        }
        return (RSJamModel)ServiceManager.getService((Project)project, RSJamModel.class);
    }

    public RSJamModel(@NotNull Project project) {
        if (project == null) {
            RSJamModel.$$$reportNull$$$0(1);
        }
        this.myProject = project;
    }

    public List<RSJamPsiClassPath> getPsiClassPaths(@NotNull Project project) {
        if (project == null) {
            RSJamModel.$$$reportNull$$$0(2);
        }
        return this.getPsiClassPaths(this.getProjectScope(project, true));
    }

    public List<RSJamPsiClassPath> getPsiClassPaths(@NotNull Module module) {
        if (module == null) {
            RSJamModel.$$$reportNull$$$0(3);
        }
        return this.getPsiClassPaths(this.getModuleScope(module, true));
    }

    public List<RSJamPsiClassPath> getPsiClassPaths(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            RSJamModel.$$$reportNull$$$0(4);
        }
        return this.getJamClassElements(RSJamPsiClassPath.META, "javax.ws.rs.Path", scope);
    }

    public boolean hasPathAnnotatedElements(@NotNull Module module) {
        PsiClass aClass;
        if (module == null) {
            RSJamModel.$$$reportNull$$$0(5);
        }
        if ((aClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass("javax.ws.rs.Path", GlobalSearchScope.allScope((Project)this.myProject))) != null) {
            return AnnotatedElementsSearch.searchElements((PsiClass)aClass, (SearchScope)this.getModuleScope(module, true), (Class[])new Class[]{PsiMember.class}).findFirst() != null;
        }
        return false;
    }

    public List<RSHttpMethod> getHttpMethods(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            RSJamModel.$$$reportNull$$$0(6);
        }
        JamService service = JamService.getJamService((Project)this.myProject);
        return service.getAnnotatedMembersList(psiClass, RSHttpMethod.RS_HTTP_METHOD_JAM_KEY, true, true, true, true);
    }

    public List<RSJamPsiMethodPath> getPsiMethodPaths(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            RSJamModel.$$$reportNull$$$0(7);
        }
        JamService service = JamService.getJamService((Project)this.myProject);
        return service.getJamMethodElements(RSJamPsiMethodPath.META, "javax.ws.rs.Path", scope);
    }

    public <T extends JamElement> List<T> getJamClassElements(JamClassMeta<T> clazz, String anno, @NotNull GlobalSearchScope scope) {
        if (scope == null) {
            RSJamModel.$$$reportNull$$$0(8);
        }
        JamService service = JamService.getJamService((Project)this.myProject);
        return service.getJamClassElements(clazz, anno, scope);
    }

    public GlobalSearchScope getModuleScope(@NotNull Module module, boolean showFromLibraries) {
        if (module == null) {
            RSJamModel.$$$reportNull$$$0(9);
        }
        return showFromLibraries ? GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module) : GlobalSearchScope.moduleWithDependenciesScope((Module)module);
    }

    public GlobalSearchScope getProjectScope(@NotNull Project project, boolean showFromLibraries) {
        if (project == null) {
            RSJamModel.$$$reportNull$$$0(10);
        }
        return showFromLibraries ? GlobalSearchScope.allScope((Project)project) : GlobalSearchScope.projectScope((Project)project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ws/rest/model/jam/RSJamModel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getPsiClassPaths";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "hasPathAnnotatedElements";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getHttpMethods";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getPsiMethodPaths";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getJamClassElements";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getModuleScope";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "getProjectScope";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

