/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.ws.rest.constants.RSConstants;
import com.intellij.ws.rest.utils.RSUtils;
import org.jetbrains.annotations.NotNull;

public class RestCustomMimeCompletion
extends CompletionContributor {
    private static final PsiJavaElementPattern.Capture<PsiLiteralExpression> MIME_ANNO_VALUE = (PsiJavaElementPattern.Capture)PsiJavaPatterns.literalExpression().insideAnnotationParam((ElementPattern)PsiJavaPatterns.string().oneOf(new String[]{"javax.ws.rs.ProduceMime", "javax.ws.rs.Produces", "javax.ws.rs.ConsumeMime", "javax.ws.rs.Consumes"}), "value");

    public RestCustomMimeCompletion() {
        this.extend(CompletionType.BASIC, (ElementPattern)PsiJavaPatterns.psiElement().withParent(MIME_ANNO_VALUE), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
                PsiElement psiElement;
                PsiElement originalPosition;
                if (parameters == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (result == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((originalPosition = parameters.getOriginalPosition()) != null && (psiElement = originalPosition.getContext()) instanceof PsiLiteralExpression) {
                    String[] mimes;
                    for (String mime : mimes = RSUtils.getAllMimes(originalPosition.getProject())) {
                        if (mime.equals(((PsiLiteralExpression)psiElement).getValue()) || ArrayUtil.contains((String)mime, (String[])RSConstants.PREDEFINED_MIME_TYPES)) continue;
                        result.addElement((LookupElement)LookupElementBuilder.create((String)mime));
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ws/rest/completion/RestCustomMimeCompletion$1";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }
}

