/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.nettyjarjar.channel.Channel;
import io.nettyjarjar.channel.ChannelFuture;
import io.nettyjarjar.channel.ChannelPromise;
import java.util.ArrayDeque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;

class WriteQueue {
    @VisibleForTesting
    static final int DEQUE_CHUNK_SIZE = 128;
    private final Runnable later = new Runnable(){

        @Override
        public void run() {
            WriteQueue.this.flush();
        }
    };
    private final Channel channel;
    private final BlockingQueue<QueuedCommand> queue;
    private final AtomicBoolean scheduled = new AtomicBoolean();
    private final ArrayDeque<QueuedCommand> writeChunk = new ArrayDeque(128);

    public WriteQueue(Channel channel) {
        this.channel = (Channel)Preconditions.checkNotNull((Object)channel, (Object)"channel");
        this.queue = new LinkedBlockingQueue<QueuedCommand>();
    }

    void scheduleFlush() {
        if (this.scheduled.compareAndSet(false, true)) {
            this.channel.eventLoop().execute(this.later);
        }
    }

    ChannelFuture enqueue(QueuedCommand command, boolean flush) {
        return this.enqueue(command, this.channel.newPromise(), flush);
    }

    ChannelFuture enqueue(QueuedCommand command, ChannelPromise promise, boolean flush) {
        Preconditions.checkArgument((command.promise() == null ? 1 : 0) != 0, (Object)"promise must not be set on command");
        command.promise(promise);
        this.queue.add(command);
        if (flush) {
            this.scheduleFlush();
        }
        return promise;
    }

    private void flush() {
        try {
            boolean flushed = false;
            while (this.queue.drainTo(this.writeChunk, 128) > 0) {
                while (this.writeChunk.size() > 0) {
                    QueuedCommand cmd = this.writeChunk.poll();
                    this.channel.write(cmd, cmd.promise());
                }
                flushed = true;
                this.channel.flush();
            }
            if (!flushed) {
                this.channel.flush();
            }
        }
        finally {
            this.scheduled.set(false);
            if (!this.queue.isEmpty()) {
                this.scheduleFlush();
            }
        }
    }

    static interface QueuedCommand {
        public ChannelPromise promise();

        public void promise(ChannelPromise var1);
    }

    static abstract class AbstractQueuedCommand
    implements QueuedCommand {
        private ChannelPromise promise;

        AbstractQueuedCommand() {
        }

        @Override
        public final void promise(ChannelPromise promise) {
            this.promise = promise;
        }

        @Override
        public final ChannelPromise promise() {
            return this.promise;
        }
    }
}

