/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.local;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.NonNullApi;
import org.gradle.api.file.EmptyFileVisitor;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.internal.file.collections.MinimalFileTree;
import org.gradle.api.internal.file.collections.SingleIncludePatternFileTree;
import org.gradle.internal.FileUtils;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.resource.local.DefaultLocallyAvailableResource;
import org.gradle.internal.resource.local.FileStoreAddActionException;
import org.gradle.internal.resource.local.FileStoreException;
import org.gradle.internal.resource.local.LocallyAvailableResource;
import org.gradle.internal.resource.local.PathKeyFileStore;
import org.gradle.util.GFileUtils;
import org.gradle.util.RelativePathUtil;

@NonNullApi
public class DefaultPathKeyFileStore
implements PathKeyFileStore {
    public static final String IN_PROGRESS_MARKER_FILE_SUFFIX = ".fslck";
    private File baseDir;

    public DefaultPathKeyFileStore(File baseDir) {
        this.baseDir = baseDir;
    }

    protected File getBaseDir() {
        return this.baseDir;
    }

    private File getFile(String path) {
        return new File(this.baseDir, path);
    }

    private File getFileWhileCleaningInProgress(String path) {
        File file = this.getFile(path);
        File markerFile = this.getInProgressMarkerFile(file);
        if (markerFile.exists()) {
            DefaultPathKeyFileStore.deleteFileQuietly(file);
            DefaultPathKeyFileStore.deleteFileQuietly(markerFile);
        }
        return file;
    }

    @Override
    public LocallyAvailableResource add(final String path, final Action<File> addAction) {
        try {
            return this.doAdd(path, new Action<File>(){

                @Override
                public void execute(File file) {
                    try {
                        addAction.execute(file);
                    }
                    catch (Throwable e) {
                        throw new FileStoreAddActionException(String.format("Failed to add into filestore '%s' at '%s' ", DefaultPathKeyFileStore.this.getBaseDir().getAbsolutePath(), path), e);
                    }
                }
            });
        }
        catch (FileStoreAddActionException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new FileStoreException(String.format("Failed to add into filestore '%s' at '%s' ", this.getBaseDir().getAbsolutePath(), path), e);
        }
    }

    @Override
    public LocallyAvailableResource move(String path, final File source) {
        if (!source.exists()) {
            throw new FileStoreException(String.format("Cannot move '%s' into filestore @ '%s' as it does not exist", source, path));
        }
        try {
            return this.doAdd(path, new Action<File>(){

                @Override
                public void execute(File file) {
                    if (source.isDirectory()) {
                        GFileUtils.moveExistingDirectory(source, file);
                    } else {
                        GFileUtils.moveExistingFile(source, file);
                    }
                }
            });
        }
        catch (Throwable e) {
            throw new FileStoreException(String.format("Failed to move file '%s' into filestore at '%s' ", source, path), e);
        }
    }

    private LocallyAvailableResource doAdd(String path, Action<File> action) {
        File destination = this.getFile(path);
        this.doAdd(destination, action);
        return this.entryAt(path);
    }

    protected void doAdd(File destination, Action<File> action) {
        GFileUtils.parentMkdirs(destination);
        File inProgressMarkerFile = this.getInProgressMarkerFile(destination);
        GFileUtils.touch(inProgressMarkerFile);
        try {
            org.gradle.internal.impldep.org.apache.commons.io.FileUtils.deleteQuietly((File)destination);
            action.execute(destination);
        }
        catch (Throwable t) {
            org.gradle.internal.impldep.org.apache.commons.io.FileUtils.deleteQuietly((File)destination);
            throw UncheckedException.throwAsUncheckedException(t);
        }
        finally {
            DefaultPathKeyFileStore.deleteFileQuietly(inProgressMarkerFile);
        }
    }

    @Override
    public Set<? extends LocallyAvailableResource> search(String pattern) {
        if (!this.getBaseDir().exists()) {
            return Collections.emptySet();
        }
        final HashSet entries = new HashSet();
        this.findFiles(pattern).visit(new EmptyFileVisitor(){

            @Override
            public void visitFile(FileVisitDetails fileDetails) {
                File file = fileDetails.getFile();
                if (!DefaultPathKeyFileStore.this.isInProgressMarkerFile(file) && !DefaultPathKeyFileStore.this.isInProgressFile(file)) {
                    entries.add(DefaultPathKeyFileStore.this.entryAt(file));
                }
            }
        });
        return entries;
    }

    private File getInProgressMarkerFile(File file) {
        return new File(file.getParent(), file.getName() + IN_PROGRESS_MARKER_FILE_SUFFIX);
    }

    private boolean isInProgressMarkerFile(File file) {
        return FileUtils.hasExtension(file, IN_PROGRESS_MARKER_FILE_SUFFIX);
    }

    private boolean isInProgressFile(File file) {
        return this.getInProgressMarkerFile(file).exists();
    }

    private MinimalFileTree findFiles(String pattern) {
        return new SingleIncludePatternFileTree(this.baseDir, pattern);
    }

    protected LocallyAvailableResource entryAt(File file) {
        return this.entryAt(RelativePathUtil.relativePath(this.baseDir, file));
    }

    protected LocallyAvailableResource entryAt(String path) {
        return new DefaultLocallyAvailableResource(this.getFile(path));
    }

    @Override
    public LocallyAvailableResource get(String key) {
        File file = this.getFileWhileCleaningInProgress(key);
        if (file.exists()) {
            return new DefaultLocallyAvailableResource(this.getFile(key));
        }
        return null;
    }

    private static void deleteFileQuietly(File file) {
        file.delete();
    }
}

