/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.testing;

import groovy.lang.Closure;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.StartParameter;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.JavaVersion;
import org.gradle.api.NonNullApi;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.classpath.ModuleRegistry;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.initialization.loadercache.ClassLoaderCache;
import org.gradle.api.internal.tasks.testing.JvmTestExecutionSpec;
import org.gradle.api.internal.tasks.testing.NoMatchingTestsReporter;
import org.gradle.api.internal.tasks.testing.TestExecuter;
import org.gradle.api.internal.tasks.testing.TestFramework;
import org.gradle.api.internal.tasks.testing.detection.DefaultTestExecuter;
import org.gradle.api.internal.tasks.testing.filter.DefaultTestFilter;
import org.gradle.api.internal.tasks.testing.junit.JUnitTestFramework;
import org.gradle.api.internal.tasks.testing.junit.result.TestClassResult;
import org.gradle.api.internal.tasks.testing.junit.result.TestResultSerializer;
import org.gradle.api.internal.tasks.testing.junitplatform.JUnitPlatformTestFramework;
import org.gradle.api.internal.tasks.testing.testng.TestNGTestFramework;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.gradle.api.tasks.testing.AbstractTestTask;
import org.gradle.api.tasks.testing.TestFilter;
import org.gradle.api.tasks.testing.TestFrameworkOptions;
import org.gradle.api.tasks.testing.junit.JUnitOptions;
import org.gradle.api.tasks.testing.junitplatform.JUnitPlatformOptions;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.internal.Actions;
import org.gradle.internal.Cast;
import org.gradle.internal.actor.ActorFactory;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.jvm.UnsupportedJavaRuntimeException;
import org.gradle.internal.jvm.inspection.JvmVersionDetector;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.time.Clock;
import org.gradle.internal.work.WorkerLeaseRegistry;
import org.gradle.process.CommandLineArgumentProvider;
import org.gradle.process.JavaForkOptions;
import org.gradle.process.ProcessForkOptions;
import org.gradle.process.internal.DefaultJavaForkOptions;
import org.gradle.process.internal.worker.WorkerProcessFactory;
import org.gradle.util.CollectionUtils;
import org.gradle.util.ConfigureUtil;
import org.gradle.util.SingleMessageLogger;

@NonNullApi
@CacheableTask
public class Test
extends AbstractTestTask
implements JavaForkOptions,
PatternFilterable {
    private final DefaultJavaForkOptions forkOptions;
    private FileCollection testClassesDirs;
    private PatternFilterable patternSet = this.getFileResolver().getPatternSetFactory().create();
    private FileCollection classpath;
    private TestFramework testFramework;
    private boolean scanForTestClasses = true;
    private long forkEvery;
    private int maxParallelForks = 1;
    private TestExecuter<JvmTestExecutionSpec> testExecuter;

    public Test() {
        this.forkOptions = new DefaultJavaForkOptions(this.getFileResolver());
        this.forkOptions.setEnableAssertions(true);
        String singleTest = this.getTestSingleSystemPropertyValue();
        if (singleTest == null) {
            this.getInputs().files(new Callable<FileTree>(){

                @Override
                public FileTree call() throws Exception {
                    return Test.this.getCandidateClassFiles();
                }
            }).withPropertyName("nonEmptyCandidateClassFiles").withPathSensitivity(PathSensitivity.RELATIVE).skipWhenEmpty();
        } else {
            this.addTestListener(new NoMatchingTestsReporter("Could not find matching test for pattern: " + singleTest));
        }
    }

    @Inject
    protected ActorFactory getActorFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected ClassLoaderCache getClassLoaderCache() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected WorkerProcessFactory getProcessBuilderFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected FileResolver getFileResolver() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected ModuleRegistry getModuleRegistry() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Internal
    public File getWorkingDir() {
        return this.forkOptions.getWorkingDir();
    }

    @Override
    public void setWorkingDir(File dir) {
        this.forkOptions.setWorkingDir(dir);
    }

    @Override
    public void setWorkingDir(Object dir) {
        this.forkOptions.setWorkingDir(dir);
    }

    @Override
    public Test workingDir(Object dir) {
        this.forkOptions.workingDir(dir);
        return this;
    }

    @Input
    public JavaVersion getJavaVersion() {
        return this.getServices().get(JvmVersionDetector.class).getJavaVersion(this.getExecutable());
    }

    @Override
    @Internal
    public String getExecutable() {
        return this.forkOptions.getExecutable();
    }

    @Override
    public Test executable(Object executable) {
        this.forkOptions.executable(executable);
        return this;
    }

    @Override
    public void setExecutable(String executable) {
        this.forkOptions.setExecutable(executable);
    }

    @Override
    public void setExecutable(Object executable) {
        this.forkOptions.setExecutable(executable);
    }

    @Override
    public Map<String, Object> getSystemProperties() {
        return this.forkOptions.getSystemProperties();
    }

    @Override
    public void setSystemProperties(Map<String, ?> properties) {
        this.forkOptions.setSystemProperties(properties);
    }

    @Override
    public Test systemProperties(Map<String, ?> properties) {
        this.forkOptions.systemProperties(properties);
        return this;
    }

    @Override
    public Test systemProperty(String name, Object value) {
        this.forkOptions.systemProperty(name, value);
        return this;
    }

    @Override
    public FileCollection getBootstrapClasspath() {
        return this.forkOptions.getBootstrapClasspath();
    }

    @Override
    public void setBootstrapClasspath(FileCollection classpath) {
        this.forkOptions.setBootstrapClasspath(classpath);
    }

    @Override
    public Test bootstrapClasspath(Object ... classpath) {
        this.forkOptions.bootstrapClasspath(classpath);
        return this;
    }

    @Override
    public String getMinHeapSize() {
        return this.forkOptions.getMinHeapSize();
    }

    @Override
    public String getDefaultCharacterEncoding() {
        return this.forkOptions.getDefaultCharacterEncoding();
    }

    @Override
    public void setDefaultCharacterEncoding(String defaultCharacterEncoding) {
        this.forkOptions.setDefaultCharacterEncoding(defaultCharacterEncoding);
    }

    @Override
    public void setMinHeapSize(String heapSize) {
        this.forkOptions.setMinHeapSize(heapSize);
    }

    @Override
    public String getMaxHeapSize() {
        return this.forkOptions.getMaxHeapSize();
    }

    @Override
    public void setMaxHeapSize(String heapSize) {
        this.forkOptions.setMaxHeapSize(heapSize);
    }

    @Override
    public List<String> getJvmArgs() {
        return this.forkOptions.getJvmArgs();
    }

    @Override
    public List<CommandLineArgumentProvider> getJvmArgumentProviders() {
        return this.forkOptions.getJvmArgumentProviders();
    }

    @Override
    public void setJvmArgs(List<String> arguments) {
        this.forkOptions.setJvmArgs(arguments);
    }

    @Override
    public void setJvmArgs(Iterable<?> arguments) {
        this.forkOptions.setJvmArgs(arguments);
    }

    @Override
    public Test jvmArgs(Iterable<?> arguments) {
        this.forkOptions.jvmArgs(arguments);
        return this;
    }

    @Override
    public Test jvmArgs(Object ... arguments) {
        this.forkOptions.jvmArgs(arguments);
        return this;
    }

    @Override
    public boolean getEnableAssertions() {
        return this.forkOptions.getEnableAssertions();
    }

    @Override
    public void setEnableAssertions(boolean enabled) {
        this.forkOptions.setEnableAssertions(enabled);
    }

    @Override
    public boolean getDebug() {
        this.checkBackwardsCompatibilitySystemPropertyDebugFlag();
        return this.forkOptions.getDebug();
    }

    @Override
    @Option(option="debug-jvm", description="Enable debugging for the test process. The process is started suspended and listening on port 5005. [INCUBATING]")
    public void setDebug(boolean enabled) {
        this.forkOptions.setDebug(enabled);
    }

    @Override
    @Option(option="fail-fast", description="Stops test execution after the first failed test.")
    public void setFailFast(boolean failFast) {
        super.setFailFast(failFast);
    }

    @Override
    public boolean getFailFast() {
        return super.getFailFast();
    }

    @Override
    public List<String> getAllJvmArgs() {
        return this.forkOptions.getAllJvmArgs();
    }

    @Override
    public void setAllJvmArgs(List<String> arguments) {
        this.forkOptions.setAllJvmArgs(arguments);
    }

    @Override
    public void setAllJvmArgs(Iterable<?> arguments) {
        this.forkOptions.setAllJvmArgs(arguments);
    }

    @Override
    @Internal
    public Map<String, Object> getEnvironment() {
        return this.forkOptions.getEnvironment();
    }

    @Override
    public Test environment(Map<String, ?> environmentVariables) {
        this.forkOptions.environment(environmentVariables);
        return this;
    }

    @Override
    public Test environment(String name, Object value) {
        this.forkOptions.environment(name, value);
        return this;
    }

    @Override
    public void setEnvironment(Map<String, ?> environmentVariables) {
        this.forkOptions.setEnvironment(environmentVariables);
    }

    @Override
    public Test copyTo(ProcessForkOptions target) {
        this.forkOptions.copyTo(target);
        return this;
    }

    @Override
    public Test copyTo(JavaForkOptions target) {
        this.forkOptions.copyTo(target);
        return this;
    }

    @Override
    protected JvmTestExecutionSpec createTestExecutionSpec() {
        DefaultJavaForkOptions javaForkOptions = new DefaultJavaForkOptions(this.getFileResolver());
        this.copyTo(javaForkOptions);
        return new JvmTestExecutionSpec(this.getTestFramework(), this.getClasspath(), this.getCandidateClassFiles(), this.isScanForTestClasses(), this.getTestClassesDirs(), this.getPath(), this.getIdentityPath(), this.getForkEvery(), javaForkOptions, this.getMaxParallelForks(), this.getPreviousFailedTestClasses());
    }

    private Set<String> getPreviousFailedTestClasses() {
        TestResultSerializer serializer = new TestResultSerializer(this.getBinResultsDir());
        if (serializer.isHasResults()) {
            final HashSet<String> previousFailedTestClasses = new HashSet<String>();
            serializer.read((Action<? super TestClassResult>)new Action<TestClassResult>(){

                @Override
                public void execute(TestClassResult testClassResult) {
                    if (testClassResult.getFailuresCount() > 0) {
                        previousFailedTestClasses.add(testClassResult.getClassName());
                    }
                }
            });
            return previousFailedTestClasses;
        }
        return Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @TaskAction
    public void executeTests() {
        JavaVersion javaVersion = this.getJavaVersion();
        if (!javaVersion.isJava6Compatible()) {
            throw new UnsupportedJavaRuntimeException("Support for test execution using Java 5 or earlier was removed in Gradle 3.0.");
        }
        if (this.getDebug()) {
            this.getLogger().info("Running tests for remote debugging.");
        }
        try {
            super.executeTests();
        }
        finally {
            this.testFramework = null;
        }
    }

    protected TestExecuter<JvmTestExecutionSpec> createTestExecuter() {
        if (this.testExecuter == null) {
            return new DefaultTestExecuter(this.getProcessBuilderFactory(), this.getActorFactory(), this.getModuleRegistry(), this.getServices().get(WorkerLeaseRegistry.class), this.getServices().get(BuildOperationExecutor.class), this.getServices().get(StartParameter.class).getMaxWorkerCount(), this.getServices().get(Clock.class), this.getServices().get(DocumentationRegistry.class), (DefaultTestFilter)this.getFilter());
        }
        return this.testExecuter;
    }

    @Override
    protected List<String> getNoMatchingTestErrorReasons() {
        ArrayList reasons = Lists.newArrayList();
        if (!this.getIncludes().isEmpty()) {
            reasons.add(this.getIncludes() + "(include rules)");
        }
        if (!this.getExcludes().isEmpty()) {
            reasons.add(this.getExcludes() + "(exclude rules)");
        }
        reasons.addAll(super.getNoMatchingTestErrorReasons());
        return reasons;
    }

    @Override
    public Test include(String ... includes) {
        this.patternSet.include(includes);
        return this;
    }

    @Override
    public Test include(Iterable<String> includes) {
        this.patternSet.include(includes);
        return this;
    }

    @Override
    public Test include(Spec<FileTreeElement> includeSpec) {
        this.patternSet.include(includeSpec);
        return this;
    }

    @Override
    public Test include(Closure includeSpec) {
        this.patternSet.include(includeSpec);
        return this;
    }

    @Override
    public Test exclude(String ... excludes) {
        this.patternSet.exclude(excludes);
        return this;
    }

    @Override
    public Test exclude(Iterable<String> excludes) {
        this.patternSet.exclude(excludes);
        return this;
    }

    @Override
    public Test exclude(Spec<FileTreeElement> excludeSpec) {
        this.patternSet.exclude(excludeSpec);
        return this;
    }

    @Override
    public Test exclude(Closure excludeSpec) {
        this.patternSet.exclude(excludeSpec);
        return this;
    }

    @Override
    public Test setTestNameIncludePatterns(List<String> testNamePattern) {
        super.setTestNameIncludePatterns(testNamePattern);
        return this;
    }

    @Deprecated
    @Internal
    @Nullable
    public File getTestClassesDir() {
        SingleMessageLogger.nagUserOfReplacedMethod("getTestClassesDir()", "getTestClassesDirs()");
        if (this.testClassesDirs == null || this.testClassesDirs.isEmpty()) {
            return null;
        }
        return this.getProject().file(CollectionUtils.first(this.testClassesDirs));
    }

    @Deprecated
    public void setTestClassesDir(File testClassesDir) {
        SingleMessageLogger.nagUserOfReplacedMethod("setTestClassesDir(File)", "setTestClassesDirs(FileCollection)");
        this.setTestClassesDirs(this.getProject().files(testClassesDir));
    }

    @Internal
    public FileCollection getTestClassesDirs() {
        return this.testClassesDirs;
    }

    public void setTestClassesDirs(FileCollection testClassesDirs) {
        this.testClassesDirs = testClassesDirs;
    }

    @Override
    @Internal
    public Set<String> getIncludes() {
        return this.patternSet.getIncludes();
    }

    @Override
    public Test setIncludes(Iterable<String> includes) {
        this.patternSet.setIncludes(includes);
        return this;
    }

    @Override
    @Internal
    public Set<String> getExcludes() {
        return this.patternSet.getExcludes();
    }

    @Override
    public Test setExcludes(Iterable<String> excludes) {
        this.patternSet.setExcludes(excludes);
        return this;
    }

    @Internal
    public TestFramework getTestFramework() {
        return this.testFramework(null);
    }

    public TestFramework testFramework(@Nullable Closure testFrameworkConfigure) {
        if (this.testFramework == null) {
            this.useJUnit(testFrameworkConfigure);
        }
        return this.testFramework;
    }

    @Nested
    public TestFrameworkOptions getOptions() {
        return this.getTestFramework().getOptions();
    }

    public TestFrameworkOptions options(Closure testFrameworkConfigure) {
        return ConfigureUtil.configure(testFrameworkConfigure, this.getOptions());
    }

    public TestFrameworkOptions options(Action<? super TestFrameworkOptions> testFrameworkConfigure) {
        TestFrameworkOptions options = this.getOptions();
        testFrameworkConfigure.execute(options);
        return options;
    }

    TestFramework useTestFramework(TestFramework testFramework) {
        return this.useTestFramework(testFramework, null);
    }

    private <T extends TestFrameworkOptions> TestFramework useTestFramework(TestFramework testFramework, @Nullable Action<? super T> testFrameworkConfigure) {
        if (testFramework == null) {
            throw new IllegalArgumentException("testFramework is null!");
        }
        this.testFramework = testFramework;
        if (testFrameworkConfigure != null) {
            testFrameworkConfigure.execute(Cast.uncheckedCast(this.testFramework.getOptions()));
        }
        return this.testFramework;
    }

    public void useJUnit() {
        this.useJUnit(Actions.doNothing());
    }

    public void useJUnit(@Nullable Closure testFrameworkConfigure) {
        this.useJUnit(ConfigureUtil.configureUsing(testFrameworkConfigure));
    }

    public void useJUnit(Action<? super JUnitOptions> testFrameworkConfigure) {
        this.useTestFramework(new JUnitTestFramework(this, (DefaultTestFilter)this.getFilter()), testFrameworkConfigure);
    }

    @Incubating
    public void useJUnitPlatform() {
        this.useJUnitPlatform(Actions.doNothing());
    }

    @Incubating
    public void useJUnitPlatform(Action<? super JUnitPlatformOptions> testFrameworkConfigure) {
        this.useTestFramework(new JUnitPlatformTestFramework((DefaultTestFilter)this.getFilter()), testFrameworkConfigure);
    }

    public void useTestNG() {
        this.useTestNG(Actions.doNothing());
    }

    public void useTestNG(Closure testFrameworkConfigure) {
        this.useTestNG(ConfigureUtil.configureUsing(testFrameworkConfigure));
    }

    public void useTestNG(Action<? super TestFrameworkOptions> testFrameworkConfigure) {
        this.useTestFramework(new TestNGTestFramework(this, (DefaultTestFilter)this.getFilter(), this.getInstantiator(), this.getClassLoaderCache()), testFrameworkConfigure);
    }

    @Classpath
    public FileCollection getClasspath() {
        return this.classpath;
    }

    public void setClasspath(FileCollection classpath) {
        this.classpath = classpath;
    }

    @Input
    public boolean isScanForTestClasses() {
        return this.scanForTestClasses;
    }

    public void setScanForTestClasses(boolean scanForTestClasses) {
        this.scanForTestClasses = scanForTestClasses;
    }

    @Internal
    public long getForkEvery() {
        return this.forkEvery;
    }

    public void setForkEvery(@Nullable Long forkEvery) {
        if (forkEvery != null && forkEvery < 0L) {
            throw new IllegalArgumentException("Cannot set forkEvery to a value less than 0.");
        }
        this.forkEvery = forkEvery == null ? 0L : forkEvery;
    }

    @Internal
    public int getMaxParallelForks() {
        return this.getDebug() ? 1 : this.maxParallelForks;
    }

    public void setMaxParallelForks(int maxParallelForks) {
        if (maxParallelForks < 1) {
            throw new IllegalArgumentException("Cannot set maxParallelForks to a value less than 1.");
        }
        this.maxParallelForks = maxParallelForks;
    }

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    public FileTree getCandidateClassFiles() {
        this.checkBackwardsCompatibilitySystemPropertySingleTest();
        return this.getTestClassesDirs().getAsFileTree().matching(this.patternSet);
    }

    @Incubating
    public void filter(Action<TestFilter> action) {
        action.execute(this.getFilter());
    }

    void setTestExecuter(TestExecuter<JvmTestExecutionSpec> testExecuter) {
        this.testExecuter = testExecuter;
    }

    private void checkBackwardsCompatibilitySystemPropertyDebugFlag() {
        String debugProp = this.getTaskPrefixedProperty("debug", "Use --debug-jvm to enable remote debugging of tests.");
        if (debugProp != null) {
            this.setDebug(true);
        }
    }

    private void checkBackwardsCompatibilitySystemPropertySingleTest() {
        String singleTest = this.getTestSingleSystemPropertyValue();
        if (singleTest != null) {
            this.setIncludes(Collections.singletonList("**/" + singleTest + "*.class"));
        }
    }

    @Nullable
    private String getTestSingleSystemPropertyValue() {
        return this.getTaskPrefixedProperty("single", "Use --tests to filter which tests to run instead.");
    }

    @Nullable
    private String getTaskPrefixedProperty(String propertyName, String replacement) {
        String suffix = '.' + propertyName;
        String value = this.getPrefixedProperty(this.getPath() + suffix, replacement);
        if (value == null) {
            return this.getPrefixedProperty(this.getName() + suffix, replacement);
        }
        return value;
    }

    @Nullable
    private String getPrefixedProperty(String propertyName, String replacement) {
        String value = System.getProperty(propertyName);
        if (value != null) {
            SingleMessageLogger.nagUserWithDeprecatedBuildInvocationFeature("System property '" + propertyName + "'", replacement);
        }
        return value;
    }
}

