/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.quality;

import java.io.File;
import java.util.concurrent.Callable;
import org.apache.tools.ant.Main;
import org.gradle.api.Action;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.plugins.quality.CodeQualityExtension;
import org.gradle.api.plugins.quality.JDepend;
import org.gradle.api.plugins.quality.JDependExtension;
import org.gradle.api.plugins.quality.internal.AbstractCodeQualityPlugin;
import org.gradle.api.reporting.SingleFileReport;
import org.gradle.api.tasks.SourceSet;
import org.gradle.internal.impldep.com.google.common.util.concurrent.Callables;

public class JDependPlugin
extends AbstractCodeQualityPlugin<JDepend> {
    public static final String DEFAULT_JDEPEND_VERSION = "2.9.1";
    private JDependExtension extension;

    @Override
    protected String getToolName() {
        return "JDepend";
    }

    @Override
    protected Class<JDepend> getTaskType() {
        return JDepend.class;
    }

    @Override
    protected void configureConfiguration(Configuration configuration) {
        this.configureDefaultDependencies(configuration);
    }

    @Override
    protected CodeQualityExtension createExtension() {
        this.extension = this.project.getExtensions().create("jdepend", JDependExtension.class, new Object[0]);
        this.extension.setToolVersion(DEFAULT_JDEPEND_VERSION);
        return this.extension;
    }

    @Override
    protected void configureTaskDefaults(JDepend task, String baseName) {
        Configuration configuration = this.project.getConfigurations().getAt(this.getConfigurationName());
        this.configureTaskConventionMapping(configuration, task);
        this.configureReportsConventionMapping(task, baseName);
    }

    private void configureDefaultDependencies(Configuration configuration) {
        configuration.defaultDependencies((Action<? super DependencySet>)new Action<DependencySet>(){

            @Override
            public void execute(DependencySet dependencies) {
                dependencies.add(JDependPlugin.this.project.getDependencies().create("jdepend:jdepend:" + JDependPlugin.this.extension.getToolVersion()));
                Class<Main> antMain = Main.class;
                String antVersion = antMain.getPackage().getImplementationVersion();
                dependencies.add(JDependPlugin.this.project.getDependencies().create("org.apache.ant:ant-jdepend:" + antVersion));
            }
        });
    }

    private void configureTaskConventionMapping(Configuration configuration, JDepend task) {
        JDependPlugin.conventionMappingOf(task).map("jdependClasspath", Callables.returning((Object)configuration));
    }

    private void configureReportsConventionMapping(JDepend task, final String baseName) {
        task.getReports().all(new Action<SingleFileReport>(){

            @Override
            public void execute(final SingleFileReport report) {
                ConventionMapping reportMapping = JDependPlugin.conventionMappingOf(report);
                reportMapping.map("enabled", new Callable<Boolean>(){

                    @Override
                    public Boolean call() {
                        return report.getName().equals("xml");
                    }
                });
                reportMapping.map("destination", new Callable<File>(){

                    @Override
                    public File call() {
                        String fileSuffix = report.getName().equals("text") ? "txt" : report.getName();
                        return new File(JDependPlugin.this.extension.getReportsDir(), baseName + "." + fileSuffix);
                    }
                });
            }
        });
    }

    @Override
    protected void configureForSourceSet(SourceSet sourceSet, JDepend task) {
        task.dependsOn(sourceSet.getOutput());
        task.setDescription("Run JDepend analysis for " + sourceSet.getName() + " classes");
        task.setClassesDirs(sourceSet.getOutput().getClassesDirs());
    }
}

