/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.copy;

import groovy.lang.Closure;
import java.io.File;
import java.io.FilterReader;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.gradle.api.Transformer;
import org.gradle.api.file.ContentFilterable;
import org.gradle.api.file.DuplicatesStrategy;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.AbstractFileTreeElement;
import org.gradle.api.internal.file.CopyActionProcessingStreamAction;
import org.gradle.api.internal.file.copy.CopyAction;
import org.gradle.api.internal.file.copy.CopyActionProcessingStream;
import org.gradle.api.internal.file.copy.FileCopyDetailsInternal;
import org.gradle.api.tasks.WorkResult;
import org.gradle.internal.impldep.com.google.common.collect.ArrayListMultimap;
import org.gradle.internal.impldep.com.google.common.collect.ListMultimap;
import org.gradle.internal.nativeintegration.filesystem.Chmod;

public class NormalizingCopyActionDecorator
implements CopyAction {
    private final CopyAction delegate;
    private final Chmod chmod;

    public NormalizingCopyActionDecorator(CopyAction delegate, Chmod chmod) {
        this.delegate = delegate;
        this.chmod = chmod;
    }

    @Override
    public WorkResult execute(final CopyActionProcessingStream stream) {
        final HashSet visitedDirs = new HashSet();
        ArrayListMultimap pendingDirs = ArrayListMultimap.create();
        WorkResult result = this.delegate.execute(new CopyActionProcessingStream((ListMultimap)pendingDirs){
            final /* synthetic */ ListMultimap val$pendingDirs;
            {
                this.val$pendingDirs = listMultimap;
            }

            @Override
            public void process(final CopyActionProcessingStreamAction action) {
                stream.process(new CopyActionProcessingStreamAction(){

                    @Override
                    public void processFile(FileCopyDetailsInternal details) {
                        if (details.isDirectory()) {
                            RelativePath path = details.getRelativePath();
                            if (!visitedDirs.contains(path)) {
                                val$pendingDirs.put((Object)path, (Object)details);
                            }
                        } else {
                            this.maybeVisit(details.getRelativePath().getParent(), details.isIncludeEmptyDirs(), action);
                            action.processFile(details);
                        }
                    }
                });
                for (RelativePath path : new LinkedHashSet(this.val$pendingDirs.keySet())) {
                    ArrayList detailsList = new ArrayList(this.val$pendingDirs.get((Object)path));
                    for (FileCopyDetailsInternal details : detailsList) {
                        if (!details.isIncludeEmptyDirs()) continue;
                        this.maybeVisit(path, details.isIncludeEmptyDirs(), action);
                    }
                }
                visitedDirs.clear();
                this.val$pendingDirs.clear();
            }

            private void maybeVisit(RelativePath path, boolean includeEmptyDirs, CopyActionProcessingStreamAction delegateAction) {
                if (path == null || path.getParent() == null || !visitedDirs.add(path)) {
                    return;
                }
                this.maybeVisit(path.getParent(), includeEmptyDirs, delegateAction);
                List detailsForPath = this.val$pendingDirs.removeAll((Object)path);
                FileCopyDetailsInternal dir = detailsForPath.isEmpty() ? new StubbedFileCopyDetails(path, includeEmptyDirs, NormalizingCopyActionDecorator.this.chmod) : (FileCopyDetailsInternal)detailsForPath.get(0);
                delegateAction.processFile(dir);
            }
        });
        return result;
    }

    private static class StubbedFileCopyDetails
    extends AbstractFileTreeElement
    implements FileCopyDetailsInternal {
        private final RelativePath path;
        private final boolean includeEmptyDirs;
        private long lastModified = System.currentTimeMillis();

        private StubbedFileCopyDetails(RelativePath path, boolean includeEmptyDirs, Chmod chmod) {
            super(chmod);
            this.path = path;
            this.includeEmptyDirs = includeEmptyDirs;
        }

        @Override
        public boolean isIncludeEmptyDirs() {
            return this.includeEmptyDirs;
        }

        @Override
        public String getDisplayName() {
            return this.path.toString();
        }

        @Override
        public File getFile() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isDirectory() {
            return !this.path.isFile();
        }

        @Override
        public long getLastModified() {
            return this.lastModified;
        }

        @Override
        public long getSize() {
            throw new UnsupportedOperationException();
        }

        @Override
        public InputStream open() {
            throw new UnsupportedOperationException();
        }

        @Override
        public RelativePath getRelativePath() {
            return this.path;
        }

        @Override
        public void exclude() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setName(String name) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPath(String path) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setRelativePath(RelativePath path) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setMode(int mode) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setDuplicatesStrategy(DuplicatesStrategy strategy) {
            throw new UnsupportedOperationException();
        }

        @Override
        public DuplicatesStrategy getDuplicatesStrategy() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getSourceName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getSourcePath() {
            throw new UnsupportedOperationException();
        }

        @Override
        public RelativePath getRelativeSourcePath() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ContentFilterable filter(Map<String, ?> properties, Class<? extends FilterReader> filterType) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ContentFilterable filter(Class<? extends FilterReader> filterType) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ContentFilterable filter(Closure closure) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ContentFilterable filter(Transformer<String, String> transformer) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ContentFilterable expand(Map<String, ?> properties) {
            throw new UnsupportedOperationException();
        }
    }
}

