/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.collections;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.file.collections.DirectoryFileTree;
import org.gradle.api.internal.file.collections.FileCollectionAdapter;
import org.gradle.api.internal.file.collections.FileCollectionContainer;
import org.gradle.api.internal.file.collections.FileCollectionResolveContext;
import org.gradle.api.internal.file.collections.FileTreeAdapter;
import org.gradle.api.internal.file.collections.ListBackedFileSet;
import org.gradle.api.internal.file.collections.MinimalFileCollection;
import org.gradle.api.internal.file.collections.MinimalFileSet;
import org.gradle.api.internal.file.collections.MinimalFileTree;
import org.gradle.api.internal.file.collections.ResolvableFileCollectionResolveContext;
import org.gradle.api.internal.file.collections.SingletonFileTree;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.api.tasks.TaskOutputs;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.Cast;
import org.gradle.internal.Factory;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.nativeintegration.services.FileSystems;
import org.gradle.util.GUtil;

public class DefaultFileCollectionResolveContext
implements ResolvableFileCollectionResolveContext {
    protected final PathToFileResolver fileResolver;
    private final List<Object> queue = new LinkedList<Object>();
    private List<Object> addTo = this.queue;
    private final Converter<? extends FileCollectionInternal> fileCollectionConverter;
    private final Converter<? extends FileTreeInternal> fileTreeConverter;

    public DefaultFileCollectionResolveContext(FileResolver fileResolver) {
        this(fileResolver, new FileCollectionConverter(fileResolver.getPatternSetFactory()), new FileTreeConverter(fileResolver.getPatternSetFactory()));
    }

    private DefaultFileCollectionResolveContext(PathToFileResolver fileResolver, Converter<? extends FileCollectionInternal> fileCollectionConverter, Converter<? extends FileTreeInternal> fileTreeConverter) {
        this.fileResolver = fileResolver;
        this.fileCollectionConverter = fileCollectionConverter;
        this.fileTreeConverter = fileTreeConverter;
    }

    @Override
    public FileCollectionResolveContext add(Object element) {
        this.addTo.add(element);
        return this;
    }

    @Override
    public FileCollectionResolveContext push(PathToFileResolver fileResolver) {
        ResolvableFileCollectionResolveContext nestedContext = this.newContext(fileResolver);
        this.add(nestedContext);
        return nestedContext;
    }

    protected ResolvableFileCollectionResolveContext newContext(PathToFileResolver fileResolver) {
        return new DefaultFileCollectionResolveContext(fileResolver, this.fileCollectionConverter, this.fileTreeConverter);
    }

    @Override
    public final ResolvableFileCollectionResolveContext newContext() {
        return this.newContext(this.fileResolver);
    }

    @Override
    public List<FileTreeInternal> resolveAsFileTrees() {
        return this.doResolve(this.fileTreeConverter);
    }

    @Override
    public List<FileCollectionInternal> resolveAsFileCollections() {
        return this.doResolve(this.fileCollectionConverter);
    }

    public List<MinimalFileCollection> resolveAsMinimalFileCollections() {
        return this.doResolve(new MinimalFileCollectionConverter());
    }

    private <T> List<T> doResolve(Converter<? extends T> converter) {
        ArrayList result = new ArrayList();
        while (!this.queue.isEmpty()) {
            Object element = this.queue.remove(0);
            if (element instanceof DefaultFileCollectionResolveContext) {
                DefaultFileCollectionResolveContext nestedContext = (DefaultFileCollectionResolveContext)element;
                converter.convertInto(nestedContext, result, this.fileResolver);
                continue;
            }
            if (element instanceof FileCollectionContainer) {
                FileCollectionContainer fileCollection = (FileCollectionContainer)element;
                this.resolveNested(fileCollection, result, converter);
                continue;
            }
            if (element instanceof FileCollection || element instanceof MinimalFileCollection) {
                converter.convertInto(element, result, this.fileResolver);
                continue;
            }
            if (element instanceof Task) {
                Task task = (Task)element;
                this.queue.add(0, task.getOutputs().getFiles());
                continue;
            }
            if (element instanceof TaskOutputs) {
                TaskOutputs outputs = (TaskOutputs)element;
                this.queue.add(0, outputs.getFiles());
                continue;
            }
            if (element instanceof Callable) {
                Callable callable = (Callable)element;
                Object callableResult = GUtil.uncheckedCall(callable);
                if (callableResult == null) continue;
                this.queue.add(0, callableResult);
                continue;
            }
            if (element instanceof Provider) {
                Provider provider = (Provider)element;
                Object providerResult = provider.get();
                this.queue.add(0, providerResult);
                continue;
            }
            if (element instanceof Path) {
                this.queue.add(0, ((Path)element).toFile());
                continue;
            }
            if (element instanceof Iterable) {
                Iterable iterable = (Iterable)element;
                GUtil.addToCollection(this.queue.subList(0, 0), iterable);
                continue;
            }
            if (element instanceof Object[]) {
                Object[] array = (Object[])element;
                GUtil.addToCollection(this.queue.subList(0, 0), Arrays.asList(array));
                continue;
            }
            converter.convertInto(element, result, this.fileResolver);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> void resolveNested(FileCollectionContainer fileCollection, List<T> result, Converter<? extends T> converter) {
        this.addTo = this.queue.subList(0, 0);
        try {
            fileCollection.visitContents(this);
        }
        finally {
            this.addTo = this.queue;
        }
    }

    public static class MinimalFileCollectionConverter
    implements Converter<MinimalFileCollection> {
        @Override
        public void convertInto(Object element, Collection<? super MinimalFileCollection> result, PathToFileResolver resolver) {
            if (element instanceof DefaultFileCollectionResolveContext) {
                DefaultFileCollectionResolveContext nestedContext = (DefaultFileCollectionResolveContext)element;
                result.addAll(nestedContext.resolveAsMinimalFileCollections());
            } else if (element instanceof MinimalFileCollection) {
                MinimalFileCollection collection = (MinimalFileCollection)element;
                result.add(collection);
            } else {
                if (element instanceof FileCollection) {
                    throw new UnsupportedOperationException(String.format("Cannot convert instance of %s to MinimalFileCollection", element.getClass().getSimpleName()));
                }
                if (element instanceof TaskDependency) {
                    return;
                }
                result.add(new ListBackedFileSet(resolver.resolve(element)));
            }
        }
    }

    public static class FileTreeConverter
    implements Converter<FileTreeInternal> {
        private final Factory<PatternSet> patternSetFactory;

        public FileTreeConverter(Factory<PatternSet> patternSetFactory) {
            this.patternSetFactory = patternSetFactory;
        }

        @Override
        public void convertInto(Object element, Collection<? super FileTreeInternal> result, PathToFileResolver fileResolver) {
            if (element instanceof DefaultFileCollectionResolveContext) {
                DefaultFileCollectionResolveContext nestedContext = (DefaultFileCollectionResolveContext)element;
                result.addAll(nestedContext.resolveAsFileTrees());
            } else if (element instanceof FileTree) {
                FileTree fileTree = (FileTree)element;
                result.add(Cast.cast(FileTreeInternal.class, fileTree));
            } else if (element instanceof MinimalFileTree) {
                MinimalFileTree fileTree = (MinimalFileTree)element;
                result.add(new FileTreeAdapter(fileTree, this.patternSetFactory));
            } else if (element instanceof MinimalFileSet) {
                MinimalFileSet fileSet = (MinimalFileSet)element;
                for (File file : fileSet.getFiles()) {
                    this.convertFileToFileTree(file, result);
                }
            } else if (element instanceof FileCollection) {
                FileCollection fileCollection = (FileCollection)element;
                for (File file : fileCollection) {
                    this.convertFileToFileTree(file, result);
                }
            } else {
                if (element instanceof MinimalFileCollection) {
                    throw new UnsupportedOperationException(String.format("Cannot convert instance of %s to FileTree", element.getClass().getSimpleName()));
                }
                if (element instanceof TaskDependency) {
                    return;
                }
                this.convertFileToFileTree(fileResolver.resolve(element), result);
            }
        }

        private void convertFileToFileTree(File file, Collection<? super FileTreeInternal> result) {
            if (file.isDirectory()) {
                result.add(new FileTreeAdapter(new DirectoryFileTree(file, this.patternSetFactory.create(), FileSystems.getDefault()), this.patternSetFactory));
            } else if (file.isFile()) {
                result.add(new FileTreeAdapter(new SingletonFileTree(file), this.patternSetFactory));
            }
        }
    }

    public static class FileCollectionConverter
    implements Converter<FileCollectionInternal> {
        private final Factory<PatternSet> patternSetFactory;

        public FileCollectionConverter(Factory<PatternSet> patternSetFactory) {
            this.patternSetFactory = patternSetFactory;
        }

        @Override
        public void convertInto(Object element, Collection<? super FileCollectionInternal> result, PathToFileResolver fileResolver) {
            if (element instanceof DefaultFileCollectionResolveContext) {
                DefaultFileCollectionResolveContext nestedContext = (DefaultFileCollectionResolveContext)element;
                result.addAll(nestedContext.resolveAsFileCollections());
            } else if (element instanceof FileCollection) {
                FileCollection fileCollection = (FileCollection)element;
                result.add(Cast.cast(FileCollectionInternal.class, fileCollection));
            } else if (element instanceof MinimalFileTree) {
                MinimalFileTree fileTree = (MinimalFileTree)element;
                result.add(new FileTreeAdapter(fileTree, this.patternSetFactory));
            } else if (element instanceof MinimalFileSet) {
                MinimalFileSet fileSet = (MinimalFileSet)element;
                result.add(new FileCollectionAdapter(fileSet));
            } else {
                if (element instanceof MinimalFileCollection) {
                    throw new UnsupportedOperationException(String.format("Cannot convert instance of %s to FileTree", element.getClass().getSimpleName()));
                }
                if (element instanceof TaskDependency) {
                    return;
                }
                result.add(new FileCollectionAdapter(new ListBackedFileSet(fileResolver.resolve(element))));
            }
        }
    }

    protected static interface Converter<T> {
        public void convertInto(Object var1, Collection<? super T> var2, PathToFileResolver var3);
    }
}

