/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.collections;

import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.internal.collections.PendingSource;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.internal.impldep.com.google.common.collect.Lists;

public class DefaultPendingSource<T>
implements PendingSource<T> {
    private final List<ProviderInternal<? extends T>> pending = Lists.newArrayList();
    private Action<T> flushAction;

    @Override
    public void realizePending() {
        if (!this.pending.isEmpty()) {
            ArrayList copied = Lists.newArrayList(this.pending);
            this.realize(copied);
        }
    }

    @Override
    public void realizePending(Class<?> type) {
        if (!this.pending.isEmpty()) {
            ArrayList copied = Lists.newArrayList();
            for (ProviderInternal<T> provider : this.pending) {
                if (provider.getType() != null && !type.isAssignableFrom(provider.getType())) continue;
                copied.add(provider);
            }
            this.realize(copied);
        }
    }

    private void realize(Iterable<ProviderInternal<? extends T>> elements) {
        for (ProviderInternal<T> provider : elements) {
            if (this.flushAction != null) {
                this.pending.remove(provider);
                this.flushAction.execute(provider.get());
                continue;
            }
            throw new IllegalStateException("Cannot realize pending elements when realize action is not set");
        }
    }

    @Override
    public boolean addPending(ProviderInternal<? extends T> provider) {
        return this.pending.add(provider);
    }

    @Override
    public boolean removePending(ProviderInternal<? extends T> provider) {
        return this.pending.remove(provider);
    }

    @Override
    public void onRealize(Action<T> action) {
        this.flushAction = action;
    }

    @Override
    public void realizeExternal(ProviderInternal<? extends T> provider) {
        this.removePending(provider);
    }

    @Override
    public boolean isEmpty() {
        return this.pending.isEmpty();
    }

    @Override
    public int size() {
        return this.pending.size();
    }

    @Override
    public void clear() {
        this.pending.clear();
    }
}

