/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.index;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.lang.Language;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSImplicitElementProvider;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElementStructure;
import com.intellij.lang.javascript.psi.stubs.impl.JSElementIndexingDataImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.angular2.Angular2DecoratorUtil;
import org.angular2.entities.Angular2Component;
import org.angular2.entities.Angular2EntitiesProvider;
import org.angular2.entities.Angular2EntityUtils;
import org.angular2.index.Angular2SourceDirectiveIndex;
import org.angular2.index.Angular2SourcePipeIndex;
import org.angular2.index.Angular2TemplateUrlIndex;
import org.angular2.lang.expr.Angular2Language;
import org.angular2.lang.html.Angular2HtmlLanguage;
import org.angularjs.index.AngularIndexUtil;
import org.angularjs.index.AngularSymbolIndex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Angular2IndexingHandler
extends FrameworkIndexingHandler {
    public static final String TEMPLATE_URL = "templateUrl";
    public static final String TEMPLATE = "template";
    public static final String STYLE_URLS = "styleUrls";
    public static final String STYLES = "styles";
    public static final String REQUIRE = "require";
    private static final String ANGULAR2_TEMPLATE_URLS_INDEX_USER_STRING = "a2tui";
    private static final String ANGULAR2_PIPE_INDEX_USER_STRING = "a2pi";
    private static final String ANGULAR2_DIRECTIVE_INDEX_USER_STRING = "a2di";
    private static final String PIPE_TYPE = "P;;;";
    private static final String DIRECTIVE_TYPE = "D;;;";
    private static final String STYLESHEET_INDEX_PREFIX = "ss/";
    private static final Map<String, StubIndexKey<String, JSImplicitElementProvider>> INDEX_MAP = new HashMap<String, StubIndexKey<String, JSImplicitElementProvider>>();

    public static boolean isPipe(@NotNull JSImplicitElement element) {
        if (element == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(0);
        }
        return PIPE_TYPE.equals(element.getTypeString());
    }

    public static boolean isDirective(@NotNull JSImplicitElement element) {
        String type;
        if (element == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(1);
        }
        if ((type = element.getTypeString()) == null) {
            return false;
        }
        return type.startsWith(DIRECTIVE_TYPE);
    }

    public int getVersion() {
        return 7;
    }

    @Nullable
    public JSElementIndexingDataImpl processDecorator(@NotNull ES6Decorator decorator, @Nullable JSElementIndexingDataImpl data) {
        TypeScriptClass enclosingClass;
        if (decorator == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(2);
        }
        if ((enclosingClass = (TypeScriptClass)PsiTreeUtil.getContextOfType((PsiElement)decorator, (Class[])new Class[]{TypeScriptClass.class})) != null) {
            String decoratorName = decorator.getDecoratorName();
            boolean isComponent = false;
            if ("Pipe".equals(decoratorName)) {
                if (data == null) {
                    data = new JSElementIndexingDataImpl();
                }
                Angular2IndexingHandler.addPipe(enclosingClass, (Consumer<JSImplicitElement>)((Consumer)arg_0 -> ((JSElementIndexingDataImpl)data).addImplicitElement(arg_0)), Angular2DecoratorUtil.getPropertyValue(decorator, "name"));
            } else if ("Directive".equals(decoratorName) || (isComponent = "Component".equals(decoratorName))) {
                if (data == null) {
                    data = new JSElementIndexingDataImpl();
                }
                Angular2IndexingHandler.addDirective(enclosingClass, (Consumer<JSImplicitElement>)((Consumer)arg_0 -> ((JSElementIndexingDataImpl)data).addImplicitElement(arg_0)), Angular2DecoratorUtil.getPropertyValue(decorator, "selector"));
                if (isComponent) {
                    Angular2IndexingHandler.addComponentExternalFilesRefs(decorator, "", (Consumer<JSImplicitElement>)((Consumer)arg_0 -> ((JSElementIndexingDataImpl)data).addImplicitElement(arg_0)), ContainerUtil.packNullables((Object[])new String[]{Angular2IndexingHandler.getTemplateFileUrl(decorator)}));
                    Angular2IndexingHandler.addComponentExternalFilesRefs(decorator, STYLESHEET_INDEX_PREFIX, (Consumer<JSImplicitElement>)((Consumer)arg_0 -> ((JSElementIndexingDataImpl)data).addImplicitElement(arg_0)), Angular2IndexingHandler.getStylesUrls(decorator));
                }
            }
        }
        return data;
    }

    private static void addDirective(@NotNull TypeScriptClass directiveClass, @NotNull Consumer<JSImplicitElement> processor, @Nullable String selector) {
        Set<Object> indexNames;
        if (directiveClass == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(3);
        }
        if (processor == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(4);
        }
        if (selector == null) {
            selector = "<null>";
            indexNames = Collections.emptySet();
        } else {
            indexNames = Angular2EntityUtils.getDirectiveIndexNames(selector.trim());
        }
        JSImplicitElementImpl directive = new JSImplicitElementImpl.Builder((String)ObjectUtils.notNull((Object)directiveClass.getName(), (Object)selector), (PsiElement)directiveClass).setType(JSImplicitElement.Type.Class).setTypeString(DIRECTIVE_TYPE + StringUtil.join(indexNames, (String)"/")).setUserString(ANGULAR2_DIRECTIVE_INDEX_USER_STRING).toImplicitElement();
        processor.consume((Object)directive);
    }

    public boolean indexImplicitElement(@NotNull JSImplicitElementStructure element, @Nullable IndexSink sink) {
        StubIndexKey<String, JSImplicitElementProvider> index;
        if (element == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(5);
        }
        if (sink == null) {
            return false;
        }
        String userID = element.getUserString();
        StubIndexKey<String, JSImplicitElementProvider> stubIndexKey = index = userID != null ? INDEX_MAP.get(userID) : null;
        if (index == Angular2SourceDirectiveIndex.KEY) {
            String type = element.toImplicitElement(null).getTypeString();
            if (type != null && type.startsWith(DIRECTIVE_TYPE)) {
                type = type.substring(DIRECTIVE_TYPE.length());
                StringUtil.split((String)type, (String)"/").forEach(name -> sink.occurrence(index, name));
            }
            return true;
        }
        if (index != null) {
            sink.occurrence(index, (Object)element.getName());
            if (index == Angular2SourcePipeIndex.KEY) {
                sink.occurrence(AngularSymbolIndex.KEY, (Object)element.getName());
            } else {
                return true;
            }
        }
        return false;
    }

    private static void addComponentExternalFilesRefs(@NotNull ES6Decorator decorator, @NotNull String namePrefix, @NotNull Consumer<JSImplicitElement> processor, @NotNull List<String> fileUrls) {
        if (decorator == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(6);
        }
        if (namePrefix == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(7);
        }
        if (processor == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(8);
        }
        if (fileUrls == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(9);
        }
        for (String fileUrl : fileUrls) {
            int lastSlash = fileUrl.lastIndexOf(47);
            String name = fileUrl.substring(lastSlash + 1);
            if ((lastSlash <= 0 || lastSlash == 1 && fileUrl.charAt(0) == '.') && FileUtil.getNameWithoutExtension((String)name).equals(FileUtil.getNameWithoutExtension((String)decorator.getContainingFile().getOriginalFile().getName()))) continue;
            JSImplicitElementImpl.Builder elementBuilder = new JSImplicitElementImpl.Builder(namePrefix + name, (PsiElement)decorator).setUserString(ANGULAR2_TEMPLATE_URLS_INDEX_USER_STRING);
            processor.consume((Object)elementBuilder.toImplicitElement());
        }
    }

    private static void addPipe(@NotNull TypeScriptClass pipeClass, @NotNull Consumer<JSImplicitElement> processor, @Nullable String pipe) {
        if (pipeClass == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(10);
        }
        if (processor == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(11);
        }
        if (pipe == null) {
            pipe = "<unnamed>";
        }
        JSImplicitElementImpl pipeElement = new JSImplicitElementImpl.Builder(pipe, (PsiElement)pipeClass).setUserString(ANGULAR2_PIPE_INDEX_USER_STRING).setTypeString(PIPE_TYPE).setType(JSImplicitElement.Type.Class).toImplicitElement();
        processor.consume((Object)pipeElement);
    }

    @Nullable
    public static TypeScriptClass findComponentClass(@NotNull PsiElement context) {
        if (context == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(12);
        }
        return (TypeScriptClass)ContainerUtil.getFirstItem(Angular2IndexingHandler.findComponentClasses(context));
    }

    @NotNull
    public static List<TypeScriptClass> findComponentClasses(@NotNull PsiElement context) {
        PsiFile file;
        if (context == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(13);
        }
        if ((file = context.getContainingFile()) == null || !file.getLanguage().is((Language)Angular2HtmlLanguage.INSTANCE) && !file.getLanguage().is((Language)Angular2Language.INSTANCE) && !Angular2IndexingHandler.isStylesheet(file)) {
            List<TypeScriptClass> list = Collections.emptyList();
            if (list == null) {
                Angular2IndexingHandler.$$$reportNull$$$0(14);
            }
            return list;
        }
        PsiFile hostFile = Angular2IndexingHandler.getHostFile(context);
        if (hostFile == null) {
            List<TypeScriptClass> list = Collections.emptyList();
            if (list == null) {
                Angular2IndexingHandler.$$$reportNull$$$0(15);
            }
            return list;
        }
        if (!file.getOriginalFile().equals(hostFile) && DialectDetector.isTypeScript((PsiElement)hostFile)) {
            List list = ContainerUtil.packNullables((Object[])new TypeScriptClass[]{(TypeScriptClass)PsiTreeUtil.getContextOfType((PsiElement)InjectedLanguageManager.getInstance((Project)context.getProject()).getInjectionHost((PsiElement)file), (Class[])new Class[]{TypeScriptClass.class})});
            if (list == null) {
                Angular2IndexingHandler.$$$reportNull$$$0(16);
            }
            return list;
        }
        SmartList result = new SmartList(Angular2IndexingHandler.resolveComponentsFromSimilarFile(hostFile));
        if (!result.isEmpty() && !Angular2IndexingHandler.isStylesheet(file)) {
            SmartList smartList = result;
            if (smartList == null) {
                Angular2IndexingHandler.$$$reportNull$$$0(17);
            }
            return smartList;
        }
        result.addAll(Angular2IndexingHandler.resolveComponentsFromIndex(hostFile));
        SmartList smartList = result;
        if (smartList == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(18);
        }
        return smartList;
    }

    @NotNull
    private static List<TypeScriptClass> resolveComponentsFromSimilarFile(@NotNull PsiFile file) {
        PsiFile directiveFile;
        if (file == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(19);
        }
        String name = file.getViewProvider().getVirtualFile().getNameWithoutExtension();
        PsiDirectory dir = file.getParent();
        PsiFile psiFile = directiveFile = dir != null ? dir.findFile(name + ".ts") : null;
        if (directiveFile != null) {
            List list = ((StreamEx)StreamEx.of((Stream)JSStubBasedPsiTreeUtil.getFileOrModuleChildrenStream(directiveFile)).select(TypeScriptClass.class).filter(cls -> {
                if (file == null) {
                    Angular2IndexingHandler.$$$reportNull$$$0(33);
                }
                ES6Decorator dec = Angular2DecoratorUtil.findDecorator((JSAttributeListOwner)cls, "Component");
                return Angular2IndexingHandler.hasFileReference(dec, file);
            })).toList();
            if (list == null) {
                Angular2IndexingHandler.$$$reportNull$$$0(20);
            }
            return list;
        }
        List<TypeScriptClass> list = Collections.emptyList();
        if (list == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(21);
        }
        return list;
    }

    @NotNull
    private static List<TypeScriptClass> resolveComponentsFromIndex(@NotNull PsiFile file) {
        if (file == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(22);
        }
        String name = (Angular2IndexingHandler.isStylesheet(file) ? STYLESHEET_INDEX_PREFIX : "") + file.getViewProvider().getVirtualFile().getName();
        SmartList result = new SmartList();
        AngularIndexUtil.multiResolve(file.getProject(), Angular2TemplateUrlIndex.KEY, name, (Processor<? super JSImplicitElement>)((Processor)arg_0 -> Angular2IndexingHandler.lambda$resolveComponentsFromIndex$2(file, (List)result, arg_0)));
        SmartList smartList = result;
        if (smartList == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(23);
        }
        return smartList;
    }

    private static boolean hasFileReference(@Nullable ES6Decorator componentDecorator, @NotNull PsiFile file) {
        Angular2Component component;
        if (file == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(24);
        }
        if ((component = Angular2EntitiesProvider.getComponent((PsiElement)componentDecorator)) != null) {
            return Angular2IndexingHandler.isStylesheet(file) ? component.getCssFiles().contains(file) : file.equals(component.getTemplateFile());
        }
        return false;
    }

    private static boolean isStylesheet(@NotNull PsiFile file) {
        if (file == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(25);
        }
        return file instanceof StylesheetFile;
    }

    @Nullable
    private static String getTemplateFileUrl(@NotNull ES6Decorator decorator) {
        String templateUrl;
        if (decorator == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(26);
        }
        if ((templateUrl = Angular2DecoratorUtil.getPropertyValue(decorator, TEMPLATE_URL)) != null) {
            return templateUrl;
        }
        JSProperty property = Angular2DecoratorUtil.getProperty(decorator, TEMPLATE);
        if (property != null) {
            return Angular2IndexingHandler.getExprReferencedFileUrl(property.getValue());
        }
        return null;
    }

    @NotNull
    private static List<String> getStylesUrls(@NotNull ES6Decorator decorator) {
        if (decorator == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(27);
        }
        SmartList result = new SmartList();
        BiConsumer<String, Function> urlsGetts = (arg_0, arg_1) -> Angular2IndexingHandler.lambda$getStylesUrls$4(decorator, (List)result, arg_0, arg_1);
        urlsGetts.accept(STYLE_URLS, Angular2DecoratorUtil::getExpressionStringValue);
        urlsGetts.accept(STYLES, Angular2IndexingHandler::getExprReferencedFileUrl);
        SmartList smartList = result;
        if (smartList == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(28);
        }
        return smartList;
    }

    @Nullable
    public static String getExprReferencedFileUrl(@Nullable JSExpression expression) {
        if (expression instanceof JSReferenceExpression) {
            for (PsiElement resolvedElement : AngularIndexUtil.resolveLocally((JSReferenceExpression)expression)) {
                ES6FromClause from;
                if (!(resolvedElement instanceof ES6ImportedBinding) || (from = (ES6FromClause)ObjectUtils.doIfNotNull((Object)((ES6ImportedBinding)resolvedElement).getDeclaration(), ES6ImportExportDeclaration::getFromClause)) == null) continue;
                return (String)ObjectUtils.doIfNotNull((Object)from.getReferenceText(), StringUtil::unquoteString);
            }
        } else if (expression instanceof JSCallExpression) {
            JSReferenceExpression referenceExpression = (JSReferenceExpression)ObjectUtils.tryCast((Object)((JSCallExpression)expression).getMethodExpression(), JSReferenceExpression.class);
            JSExpression[] arguments = ((JSCallExpression)expression).getArguments();
            if (arguments.length == 1 && arguments[0] instanceof JSLiteralExpression && ((JSLiteralExpression)arguments[0]).isQuotedLiteral() && referenceExpression != null && referenceExpression.getQualifier() == null && REQUIRE.equals(referenceExpression.getReferenceName())) {
                return ((JSLiteralExpression)arguments[0]).getStringValue();
            }
        }
        return null;
    }

    @Nullable
    private static PsiFile getHostFile(@NotNull PsiElement context) {
        PsiElement original;
        if (context == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(29);
        }
        PsiFile hostFile = FileContextUtil.getContextFile((PsiElement)((original = CompletionUtil.getOriginalOrSelf((PsiElement)context)) != context ? original : context.getContainingFile().getOriginalFile()));
        return hostFile != null ? hostFile.getOriginalFile() : null;
    }

    private static /* synthetic */ void lambda$getStylesUrls$4(@NotNull ES6Decorator decorator, List result, String name, Function func) {
        if (decorator == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(30);
        }
        List cfr_ignored_0 = (List)StreamEx.of((Object)name).map(prop -> {
            if (decorator == null) {
                Angular2IndexingHandler.$$$reportNull$$$0(31);
            }
            return Angular2DecoratorUtil.getProperty(decorator, prop);
        }).nonNull().map(JSProperty::getValue).select(JSArrayLiteralExpression.class).flatArray(JSArrayLiteralExpression::getExpressions).map(func).nonNull().into((Collection)result);
    }

    private static /* synthetic */ boolean lambda$resolveComponentsFromIndex$2(@NotNull PsiFile file, List result, JSImplicitElement el) {
        PsiElement componentDecorator;
        if (file == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(32);
        }
        if (el != null && (componentDecorator = el.getParent()) instanceof ES6Decorator && Angular2IndexingHandler.hasFileReference((ES6Decorator)componentDecorator, file)) {
            ContainerUtil.addIfNotNull((Collection)result, (Object)PsiTreeUtil.getContextOfType((PsiElement)componentDecorator, (Class[])new Class[]{TypeScriptClass.class}));
        }
        return true;
    }

    static {
        INDEX_MAP.put(ANGULAR2_TEMPLATE_URLS_INDEX_USER_STRING, Angular2TemplateUrlIndex.KEY);
        INDEX_MAP.put(ANGULAR2_DIRECTIVE_INDEX_USER_STRING, Angular2SourceDirectiveIndex.KEY);
        INDEX_MAP.put(ANGULAR2_PIPE_INDEX_USER_STRING, Angular2SourcePipeIndex.KEY);
        for (String key : INDEX_MAP.keySet()) {
            JSImplicitElement.ourUserStringsRegistry.registerUserString(key);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 6: 
            case 26: 
            case 27: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decorator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directiveClass";
                break;
            }
            case 4: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namePrefix";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileUrls";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pipeClass";
                break;
            }
            case 12: 
            case 13: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/angular2/index/Angular2IndexingHandler";
                break;
            }
            case 19: 
            case 22: 
            case 24: 
            case 25: 
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/angular2/index/Angular2IndexingHandler";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "findComponentClasses";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveComponentsFromSimilarFile";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveComponentsFromIndex";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getStylesUrls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isPipe";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isDirective";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processDecorator";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addDirective";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "indexImplicitElement";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addComponentExternalFilesRefs";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addPipe";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findComponentClass";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findComponentClasses";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 28: {
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "resolveComponentsFromSimilarFile";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "resolveComponentsFromIndex";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "hasFileReference";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isStylesheet";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getTemplateFileUrl";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getStylesUrls";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getHostFile";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getStylesUrls$4";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$3";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "lambda$resolveComponentsFromIndex$2";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "lambda$resolveComponentsFromSimilarFile$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

