/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.fileDependency;

import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.TreeExpander;
import com.intellij.javascript.trace.TraceBundle;
import com.intellij.javascript.trace.execution.common.TraceContext;
import com.intellij.javascript.trace.execution.fileDependency.FileDependencyTree;
import com.intellij.javascript.trace.execution.fileDependency.FileNode;
import com.intellij.javascript.trace.execution.fileDependency.RuntimeDependencyEdge;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.treeStructure.SimpleTree;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileDependencyDetailsPanel
extends JPanel {
    private final JScrollPane myPane;
    private FileDependencyTree myTree;
    private final TraceContext myTraceContext;
    private final JComponent myParent;
    private final JPanel myDetailsToolbar;
    private JComponent myToolbar;

    public FileDependencyDetailsPanel(@NotNull TraceContext traceContext, @NotNull JComponent parent, @NotNull JPanel detailsToolbar) {
        if (traceContext == null) {
            FileDependencyDetailsPanel.$$$reportNull$$$0(0);
        }
        if (parent == null) {
            FileDependencyDetailsPanel.$$$reportNull$$$0(1);
        }
        if (detailsToolbar == null) {
            FileDependencyDetailsPanel.$$$reportNull$$$0(2);
        }
        super(new BorderLayout());
        this.myTraceContext = traceContext;
        this.myParent = parent;
        this.myDetailsToolbar = detailsToolbar;
        this.myPane = ScrollPaneFactory.createScrollPane();
        this.add(this.myPane);
        this.createEmptyTree();
        this.updateToolbar();
    }

    private void updateToolbar() {
        ActionManager actionManager = ActionManager.getInstance();
        this.myToolbar = actionManager.createActionToolbar("SpyJsFileDependencyDetails", FileDependencyDetailsPanel.getDetailsToolbarActionGroup(this.myTree, this.myParent), true).getComponent();
        this.myDetailsToolbar.add((Component)this.myToolbar, "Center");
    }

    private void createEmptyTree() {
        this.resetDetails();
        this.myTree = new FileDependencyTree(this.myTraceContext);
        this.myPane.setViewportView((Component)((Object)this.myTree));
        this.updateToolbar();
    }

    public void displayNodeDetails(@NotNull String streamId, @Nullable FileNode node) {
        if (streamId == null) {
            FileDependencyDetailsPanel.$$$reportNull$$$0(3);
        }
        if (node == null) {
            this.createEmptyTree();
            return;
        }
        this.updateTree(streamId, node, null);
    }

    public void displayEdgeDetails(@NotNull String streamId, @Nullable RuntimeDependencyEdge edge) {
        if (streamId == null) {
            FileDependencyDetailsPanel.$$$reportNull$$$0(4);
        }
        if (edge == null) {
            this.createEmptyTree();
            return;
        }
        this.updateTree(streamId, edge.getSource(), edge);
    }

    private void updateTree(@NotNull String streamId, @NotNull FileNode source, @Nullable RuntimeDependencyEdge edge) {
        if (streamId == null) {
            FileDependencyDetailsPanel.$$$reportNull$$$0(5);
        }
        if (source == null) {
            FileDependencyDetailsPanel.$$$reportNull$$$0(6);
        }
        this.resetDetails();
        this.myTree = new FileDependencyTree(this.myTraceContext, streamId, source, edge);
        this.myPane.setViewportView((Component)((Object)this.myTree));
        this.updateToolbar();
    }

    private void resetDetails() {
        this.myPane.setViewportView(null);
        if (this.myTree != null) {
            Disposer.dispose((Disposable)this.myTree);
        }
        if (this.myToolbar != null) {
            this.myDetailsToolbar.remove(this.myToolbar);
        }
    }

    private static ActionGroup getDetailsToolbarActionGroup(@NotNull SimpleTree tree, @NotNull JComponent parent) {
        if (tree == null) {
            FileDependencyDetailsPanel.$$$reportNull$$$0(7);
        }
        if (parent == null) {
            FileDependencyDetailsPanel.$$$reportNull$$$0(8);
        }
        DefaultTreeExpander treeExpander = new DefaultTreeExpander((JTree)tree);
        DefaultActionGroup actionGroup = new DefaultActionGroup(null, false);
        CommonActionsManager actionsManager = CommonActionsManager.getInstance();
        AnAction action = actionsManager.createExpandAllAction((TreeExpander)treeExpander, parent);
        action.getTemplatePresentation().setDescription(TraceBundle.message("fileDependency.details.toolbar.expand", new Object[0]));
        actionGroup.add(action);
        action = actionsManager.createCollapseAllAction((TreeExpander)treeExpander, parent);
        action.getTemplatePresentation().setDescription(TraceBundle.message("fileDependency.details.toolbar.collapse", new Object[0]));
        actionGroup.add(action);
        return actionGroup;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "traceContext";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detailsToolbar";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "streamId";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/trace/execution/fileDependency/FileDependencyDetailsPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "displayNodeDetails";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "displayEdgeDetails";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "updateTree";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getDetailsToolbarActionGroup";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

