/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.common;

import com.intellij.javascript.trace.execution.Utils;
import com.intellij.javascript.trace.execution.code.CodeElement;
import com.intellij.javascript.trace.execution.code.CodeRange;
import com.intellij.javascript.trace.execution.code.MappedCodePosition;
import com.intellij.javascript.trace.execution.code.StaticAnotherStatement;
import com.intellij.javascript.trace.execution.code.StaticCodeElement;
import com.intellij.javascript.trace.execution.code.StaticConditionalAlternate;
import com.intellij.javascript.trace.execution.code.StaticConditionalConsequent;
import com.intellij.javascript.trace.execution.code.StaticElementVisitor;
import com.intellij.javascript.trace.execution.code.StaticLogicalLeft;
import com.intellij.javascript.trace.execution.code.StaticLogicalRight;
import com.intellij.javascript.trace.execution.code.StaticReturn;
import com.intellij.javascript.trace.execution.code.StaticSwitch;
import com.intellij.javascript.trace.execution.code.StaticTest;
import com.intellij.javascript.trace.execution.common.RuntimeFunctionArgument;
import com.intellij.javascript.trace.execution.common.RuntimeFunctionScope;
import com.intellij.javascript.trace.execution.common.RuntimeReturnStatement;
import com.intellij.javascript.trace.execution.common.RuntimeStatement;
import com.intellij.javascript.trace.execution.common.TraceVirtualFile;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSCatchBlock;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSDoWhileStatement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSWhileStatement;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MappedTraceVirtualFile
extends TraceVirtualFile {
    private static final Logger LOG = Logger.getInstance(MappedTraceVirtualFile.class);
    private final boolean myIsCoffeeScript;

    public MappedTraceVirtualFile(String url, String content, VirtualFile localFile, String streamId) {
        super(url, content, localFile, streamId);
        String extension = MappedTraceVirtualFile.getFileNameExtension(url);
        this.myIsCoffeeScript = "coffee".equals(extension);
        JavaScriptFileType fileType = extension != null ? FileTypeRegistry.getInstance().getFileTypeByExtension(extension) : JavaScriptFileType.INSTANCE;
        this.setFileType((FileType)fileType);
        if (fileType instanceof LanguageFileType && !JavaScriptFileType.INSTANCE.equals(fileType)) {
            this.setLanguage(((LanguageFileType)fileType).getLanguage());
        } else {
            this.setLanguage((Language)JavaScriptSupportLoader.ECMA_SCRIPT_6);
        }
    }

    @Nullable
    private static String getFileNameExtension(String url) {
        String name = Utils.getFileNameWithExtension(url);
        if (StringUtil.isEmpty((String)name)) {
            return null;
        }
        int index = name.lastIndexOf(46);
        if (index < 0) {
            return null;
        }
        return name.substring(index + 1);
    }

    @Override
    @NotNull
    public TextRange getFunctionRange(@NotNull Editor editor, @NotNull RuntimeFunctionScope functionScope) {
        if (editor == null) {
            MappedTraceVirtualFile.$$$reportNull$$$0(0);
        }
        if (functionScope == null) {
            MappedTraceVirtualFile.$$$reportNull$$$0(1);
        }
        TextRange textRange = MappedTraceVirtualFile.findRange(editor, functionScope, (Function<PsiElement, PsiElement>)((Function)elementAtOffset -> {
            if (functionScope == null) {
                MappedTraceVirtualFile.$$$reportNull$$$0(29);
            }
            if (functionScope.isProgram().booleanValue()) {
                return elementAtOffset.getContainingFile();
            }
            PsiElement function = PsiTreeUtil.findChildOfType((PsiElement)elementAtOffset.getParent(), JSFunction.class);
            return function != null ? function : PsiTreeUtil.findFirstParent((PsiElement)elementAtOffset, element -> element instanceof JSFunction);
        }));
        if (textRange == null) {
            MappedTraceVirtualFile.$$$reportNull$$$0(2);
        }
        return textRange;
    }

    @Override
    @NotNull
    public TextRange getStatementRange(final @NotNull Editor editor, @NotNull RuntimeFunctionScope functionScope, final @NotNull StaticCodeElement element) {
        if (editor == null) {
            MappedTraceVirtualFile.$$$reportNull$$$0(3);
        }
        if (functionScope == null) {
            MappedTraceVirtualFile.$$$reportNull$$$0(4);
        }
        if (element == null) {
            MappedTraceVirtualFile.$$$reportNull$$$0(5);
        }
        if (this.myIsCoffeeScript && functionScope.getStatements().length == 1 && functionScope.isProgram().booleanValue()) {
            TextRange textRange = TextRange.EMPTY_RANGE;
            if (textRange == null) {
                MappedTraceVirtualFile.$$$reportNull$$$0(6);
            }
            return textRange;
        }
        final TextRange[] range = new TextRange[]{TextRange.EMPTY_RANGE};
        StaticElementVisitor statementVisitor = new StaticElementVisitor(){

            @Override
            public void visit(StaticConditionalAlternate element2) {
                range[0] = MappedTraceVirtualFile.this.findLastExpressionRangeWithinBlockBeforeParentOfType(editor, element2, new Class[]{JSConditionalExpression.class, JSIfStatement.class});
            }

            @Override
            public void visit(StaticConditionalConsequent element2) {
                range[0] = MappedTraceVirtualFile.this.findLastExpressionRangeWithinBlockBeforeParentOfType(editor, element2, new Class[]{JSConditionalExpression.class, JSIfStatement.class});
            }

            @Override
            public void visit(StaticTest element2) {
                range[0] = MappedTraceVirtualFile.this.findLastExpressionRangeWithinBlockBeforeParentOfType(editor, element2, new Class[]{JSIfStatement.class, JSForStatement.class, JSDoWhileStatement.class, JSWhileStatement.class});
            }

            @Override
            public void visit(StaticSwitch element2) {
                range[0] = MappedTraceVirtualFile.this.findLastExpressionRangeWithinBlockBeforeParentOfType(editor, element2, new Class[]{JSSwitchStatement.class});
            }

            @Override
            public void visit(StaticLogicalLeft element2) {
                this.setLogicalExpressionPartRange();
            }

            @Override
            public void visit(StaticLogicalRight element2) {
                this.setLogicalExpressionPartRange();
            }

            @Override
            public void visit(StaticReturn element2) {
                this.setStandardStatementRange();
            }

            @Override
            public void visit(StaticAnotherStatement element2) {
                this.setStandardStatementRange();
            }

            private void setStandardStatementRange() {
                range[0] = MappedTraceVirtualFile.this.findParentWithinBlock(editor, element, (Condition<PsiElement>)element1 -> element1 instanceof JSStatement);
            }

            private void setLogicalExpressionPartRange() {
                range[0] = MappedTraceVirtualFile.this.findParentWithinBlock(editor, element, (Condition<PsiElement>)element12 -> {
                    PsiElement parent = element12.getParent();
                    if (parent == null) {
                        return false;
                    }
                    if (!(element12 instanceof JSExpression)) {
                        return false;
                    }
                    if (!(parent instanceof JSBinaryExpression)) {
                        return false;
                    }
                    JSBinaryExpression binaryExpression = (JSBinaryExpression)parent;
                    IElementType opType = binaryExpression.getOperationSign();
                    return JSTokenTypes.OROR == opType || JSTokenTypes.ANDAND == opType;
                });
            }
        };
        element.accept(statementVisitor);
        TextRange textRange = range[0];
        if (textRange == null) {
            MappedTraceVirtualFile.$$$reportNull$$$0(7);
        }
        return textRange;
    }

    @Override
    @NotNull
    public TextRange getReturnStatementRange(@NotNull Editor editor, @NotNull RuntimeReturnStatement returnStatement) {
        TextRange returnRange;
        if (editor == null) {
            MappedTraceVirtualFile.$$$reportNull$$$0(8);
        }
        if (returnStatement == null) {
            MappedTraceVirtualFile.$$$reportNull$$$0(9);
        }
        if ((returnRange = this.getReturnRange(editor, returnStatement, false)) != TextRange.EMPTY_RANGE) {
            TextRange textRange = returnRange;
            if (textRange == null) {
                MappedTraceVirtualFile.$$$reportNull$$$0(10);
            }
            return textRange;
        }
        returnRange = this.getReturnRange(editor, returnStatement.getInReturnStatement(), true);
        if (returnRange != TextRange.EMPTY_RANGE) {
            TextRange textRange = returnRange;
            if (textRange == null) {
                MappedTraceVirtualFile.$$$reportNull$$$0(11);
            }
            return textRange;
        }
        TextRange textRange = this.getReturnRange(editor, returnStatement.getInReturnStatement(), false);
        if (textRange == null) {
            MappedTraceVirtualFile.$$$reportNull$$$0(12);
        }
        return textRange;
    }

    private TextRange findParentWithinBlock(Editor editor, CodeElement element, Condition<PsiElement> condition) {
        return MappedTraceVirtualFile.findRange(editor, element, (Function<PsiElement, PsiElement>)((Function)elementAtOffset -> MappedTraceVirtualFile.getFirstParent(elementAtOffset, condition, (Condition<PsiElement>)((Condition)element1 -> element1 instanceof JSBlockStatement || element1 instanceof JSFunction || this.myIsCoffeeScript && (element1 instanceof JSCatchBlock || element1 instanceof JSCaseClause)))));
    }

    private TextRange findLastExpressionRangeWithinBlockBeforeParentOfType(Editor editor, CodeElement element, Class ... classes) {
        return this.findParentWithinBlock(editor, element, (Condition<PsiElement>)((Condition)element1 -> (element1 instanceof JSExpression || this.myIsCoffeeScript && element1 instanceof JSExpressionStatement) && element1.getParent() != null && ContainerUtil.find((Object[])classes, aClass -> aClass.isAssignableFrom(element1.getParent().getClass())) != null));
    }

    private TextRange getReturnRange(Editor editor, RuntimeStatement returnStatement, boolean arrowFunction) {
        return this.findParentWithinBlock(editor, returnStatement, (Condition<PsiElement>)((Condition)element -> arrowFunction ? (element instanceof JSExpression || this.myIsCoffeeScript && element instanceof JSExpressionStatement) && element.getParent() != null && element.getParent() instanceof JSFunctionExpression : element instanceof JSReturnStatement || this.myIsCoffeeScript && element instanceof JSExpressionStatement));
    }

    @Override
    @NotNull
    public TextRange getParamRange(@NotNull Editor editor, @NotNull RuntimeFunctionArgument argument) {
        if (editor == null) {
            MappedTraceVirtualFile.$$$reportNull$$$0(13);
        }
        if (argument == null) {
            MappedTraceVirtualFile.$$$reportNull$$$0(14);
        }
        TextRange textRange = MappedTraceVirtualFile.findRange(editor, argument, (Function<PsiElement, PsiElement>)((Function)elementAtOffset -> MappedTraceVirtualFile.getFirstParent(elementAtOffset, (Condition<PsiElement>)((Condition)element -> element instanceof JSParameter), (Condition<PsiElement>)((Condition)element -> element instanceof JSArgumentList))));
        if (textRange == null) {
            MappedTraceVirtualFile.$$$reportNull$$$0(15);
        }
        return textRange;
    }

    @Nullable
    private static PsiElement getFirstParent(@NotNull PsiElement start, @NotNull Condition<PsiElement> elementFinder, @NotNull Condition<PsiElement> limitChecker) {
        if (start == null) {
            MappedTraceVirtualFile.$$$reportNull$$$0(16);
        }
        if (elementFinder == null) {
            MappedTraceVirtualFile.$$$reportNull$$$0(17);
        }
        if (limitChecker == null) {
            MappedTraceVirtualFile.$$$reportNull$$$0(18);
        }
        boolean[] foundMatch = new boolean[]{false};
        PsiElement foundElement = PsiTreeUtil.findFirstParent((PsiElement)start, element -> {
            boolean found;
            if (elementFinder == null) {
                MappedTraceVirtualFile.$$$reportNull$$$0(27);
            }
            if (limitChecker == null) {
                MappedTraceVirtualFile.$$$reportNull$$$0(28);
            }
            if (!(found = elementFinder.value(element))) {
                return limitChecker.value(element);
            }
            foundMatch[0] = true;
            return true;
        });
        return foundMatch[0] ? foundElement : null;
    }

    @NotNull
    private static TextRange findRange(@NotNull Editor editor, @NotNull CodeElement codeElement, @NotNull Function<PsiElement, PsiElement> psiElementLocator) {
        TextRange textRange;
        Project project;
        if (editor == null) {
            MappedTraceVirtualFile.$$$reportNull$$$0(19);
        }
        if (codeElement == null) {
            MappedTraceVirtualFile.$$$reportNull$$$0(20);
        }
        if (psiElementLocator == null) {
            MappedTraceVirtualFile.$$$reportNull$$$0(21);
        }
        if ((project = editor.getProject()) == null) {
            TextRange textRange2 = TextRange.EMPTY_RANGE;
            if (textRange2 == null) {
                MappedTraceVirtualFile.$$$reportNull$$$0(22);
            }
            return textRange2;
        }
        PsiFile psiFile = PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)project);
        if (psiFile == null) {
            TextRange textRange3 = TextRange.EMPTY_RANGE;
            if (textRange3 == null) {
                MappedTraceVirtualFile.$$$reportNull$$$0(23);
            }
            return textRange3;
        }
        Document document = editor.getDocument();
        CodeRange range = codeElement.getCodeRange();
        MappedCodePosition mappedCodePosition = range.getMappedCodePosition();
        if (mappedCodePosition == null) {
            TextRange textRange4 = TextRange.EMPTY_RANGE;
            if (textRange4 == null) {
                MappedTraceVirtualFile.$$$reportNull$$$0(24);
            }
            return textRange4;
        }
        int rowStart = mappedCodePosition.getRow();
        int colStart = mappedCodePosition.getColumn();
        try {
            PsiElement elementAtOffset = PsiUtilCore.getElementAtOffset((PsiFile)psiFile, (int)(document.getLineStartOffset(rowStart - 1) + colStart));
            PsiElement psiElement = (PsiElement)psiElementLocator.fun((Object)elementAtOffset);
            textRange = psiElement == null ? TextRange.EMPTY_RANGE : psiElement.getTextRange();
        }
        catch (Exception ex) {
            LOG.warn((Throwable)ex);
            TextRange textRange5 = TextRange.EMPTY_RANGE;
            if (textRange5 == null) {
                MappedTraceVirtualFile.$$$reportNull$$$0(26);
            }
            return textRange5;
        }
        if (textRange == null) {
            MappedTraceVirtualFile.$$$reportNull$$$0(25);
        }
        return textRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 4: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionScope";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/trace/execution/common/MappedTraceVirtualFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnStatement";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 17: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementFinder";
                break;
            }
            case 18: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "limitChecker";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeElement";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElementLocator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/trace/execution/common/MappedTraceVirtualFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionRange";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatementRange";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getReturnStatementRange";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getParamRange";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "findRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionRange";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getStatementRange";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getReturnStatementRange";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getParamRange";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getFirstParent";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findRange";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getFirstParent$10";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getFunctionRange$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

