/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.themes;

import com.intellij.codeInsight.daemon.GutterIconDescriptor;
import com.intellij.codeInsight.daemon.LineMarkerSettings;
import com.intellij.json.psi.JsonElementGenerator;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.ColorChooser;
import com.intellij.ui.ColorLineMarkerProvider;
import com.intellij.ui.ColorUtil;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.themes.ThemeJsonSchemaProviderFactory;

public class ThemeColorAnnotator
implements Annotator,
DumbAware {
    private static final Pattern COLOR_HEX_PATTERN_RGB = Pattern.compile("^#([A-Fa-f0-9]{6})$");
    private static final Pattern COLOR_HEX_PATTERN_RGBA = Pattern.compile("^#([A-Fa-f0-9]{8})$");
    private static final int HEX_COLOR_LENGTH_RGB = 7;
    private static final int HEX_COLOR_LENGTH_RGBA = 9;

    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            ThemeColorAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            ThemeColorAnnotator.$$$reportNull$$$0(1);
        }
        if (!ThemeColorAnnotator.isColorLineMarkerProviderEnabled() || !ThemeColorAnnotator.isTargetElement(element)) {
            return;
        }
        Annotation annotation = holder.createInfoAnnotation(element, null);
        JsonStringLiteral literal = (JsonStringLiteral)element;
        annotation.setGutterIconRenderer((GutterIconRenderer)new MyRenderer(literal.getValue(), literal));
    }

    private static boolean isColorLineMarkerProviderEnabled() {
        return LineMarkerSettings.getSettings().isEnabled((GutterIconDescriptor)ColorLineMarkerProvider.INSTANCE);
    }

    private static boolean isTargetElement(@NotNull PsiElement element) {
        if (element == null) {
            ThemeColorAnnotator.$$$reportNull$$$0(2);
        }
        if (!(element instanceof JsonStringLiteral)) {
            return false;
        }
        if (!ThemeJsonSchemaProviderFactory.isAllowedFileName(element.getContainingFile().getName())) {
            return false;
        }
        String text = ((JsonStringLiteral)element).getValue();
        return ThemeColorAnnotator.isColorCode(text);
    }

    private static boolean isColorCode(@Nullable String text) {
        if (!StringUtil.startsWithChar((CharSequence)text, (char)'#')) {
            return false;
        }
        if (text.length() != 7 && text.length() != 9) {
            return false;
        }
        return COLOR_HEX_PATTERN_RGB.matcher(text).matches() || COLOR_HEX_PATTERN_RGBA.matcher(text).matches();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/devkit/themes/ThemeColorAnnotator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "annotate";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isTargetElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyRenderer
    extends GutterIconRenderer {
        private static final int ICON_SIZE = 8;
        private final String myColorHex;
        private final JsonStringLiteral myLiteral;

        private MyRenderer(@NotNull String colorHex, @NotNull JsonStringLiteral literal) {
            if (colorHex == null) {
                MyRenderer.$$$reportNull$$$0(0);
            }
            if (literal == null) {
                MyRenderer.$$$reportNull$$$0(1);
            }
            this.myColorHex = colorHex;
            this.myLiteral = literal;
        }

        @NotNull
        public Icon getIcon() {
            Color color = MyRenderer.getColor(this.myColorHex);
            if (color != null) {
                JBUI.JBIcon jBIcon = JBUI.scale((JBUI.JBIcon)new ColorIcon(8, color));
                if (jBIcon == null) {
                    MyRenderer.$$$reportNull$$$0(2);
                }
                return jBIcon;
            }
            JBUI.JBIcon jBIcon = JBUI.scale((JBUI.JBIcon)EmptyIcon.create((int)8));
            if (jBIcon == null) {
                MyRenderer.$$$reportNull$$$0(3);
            }
            return jBIcon;
        }

        @Nullable
        public AnAction getClickAction() {
            return new AnAction(){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    Editor editor;
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((editor = (Editor)CommonDataKeys.EDITOR.getData(e.getDataContext())) == null) {
                        return;
                    }
                    Color currentColor = MyRenderer.getColor(myColorHex);
                    if (currentColor == null) {
                        return;
                    }
                    boolean withAlpha = MyRenderer.isRgbaColorHex(myColorHex);
                    Color newColor = ColorChooser.chooseColor((Project)editor.getProject(), (Component)editor.getComponent(), (String)DevKitBundle.message("theme.choose.color.dialog.title", new Object[0]), (Color)currentColor, (boolean)withAlpha);
                    if (newColor == null || newColor.equals(currentColor)) {
                        return;
                    }
                    String newColorHex = "#" + ColorUtil.toHex((Color)newColor, (boolean)withAlpha);
                    Project project = myLiteral.getProject();
                    JsonStringLiteral newLiteral = new JsonElementGenerator(project).createStringLiteral(newColorHex);
                    WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{myLiteral.getContainingFile()}).run(() -> myLiteral.replace((PsiElement)newLiteral));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/idea/devkit/themes/ThemeColorAnnotator$MyRenderer$1", "actionPerformed"));
                }
            };
        }

        @Nullable
        private static Color getColor(@NotNull String colorHex) {
            boolean isRgba;
            if (colorHex == null) {
                MyRenderer.$$$reportNull$$$0(4);
            }
            if (!(isRgba = MyRenderer.isRgbaColorHex(colorHex)) && !MyRenderer.isRgbColorHex(colorHex)) {
                return null;
            }
            try {
                String alpha = isRgba ? colorHex.substring(7) : null;
                String colorHexWithoutAlpha = isRgba ? colorHex.substring(0, 7) : colorHex;
                Color color = Color.decode(colorHexWithoutAlpha);
                if (isRgba) {
                    color = ColorUtil.toAlpha((Color)color, (int)Integer.parseInt(alpha, 16));
                }
                return color;
            }
            catch (NumberFormatException ignored) {
                return null;
            }
        }

        private static boolean isRgbaColorHex(@NotNull String colorHex) {
            if (colorHex == null) {
                MyRenderer.$$$reportNull$$$0(5);
            }
            return colorHex.length() == 9;
        }

        private static boolean isRgbColorHex(@NotNull String colorHex) {
            if (colorHex == null) {
                MyRenderer.$$$reportNull$$$0(6);
            }
            return colorHex.length() == 7;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            MyRenderer renderer = (MyRenderer)((Object)o);
            return this.myColorHex.equals(renderer.myColorHex) && this.myLiteral.equals(renderer.myLiteral);
        }

        public int hashCode() {
            return Objects.hash(this.myColorHex, this.myLiteral);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "colorHex";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "literal";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/devkit/themes/ThemeColorAnnotator$MyRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/devkit/themes/ThemeColorAnnotator$MyRenderer";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getColor";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isRgbaColorHex";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "isRgbColorHex";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

