/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFixBase;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.ui.JBUI;
import org.jetbrains.annotations.NotNull;

public class ConvertToJBInsetsQuickFix
extends LocalQuickFixBase {
    public ConvertToJBInsetsQuickFix() {
        super("Convert to JBUI.insets(...)");
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            ConvertToJBInsetsQuickFix.$$$reportNull$$$0(0);
        }
        if (descriptor == null) {
            ConvertToJBInsetsQuickFix.$$$reportNull$$$0(1);
        }
        PsiNewExpression newExpression = (PsiNewExpression)descriptor.getPsiElement();
        PsiExpressionList list = newExpression.getArgumentList();
        String text = null;
        if (list != null && list.getExpressionCount() == 4) {
            String right;
            String bottom;
            String left;
            String top = list.getExpressions()[0].getText();
            text = ConvertToJBInsetsQuickFix.isZero(top, left = list.getExpressions()[1].getText(), bottom = list.getExpressions()[2].getText(), right = list.getExpressions()[3].getText()) ? "emptyInsets()" : (ConvertToJBInsetsQuickFix.isZero(left, bottom, right) ? "insetsTop(" + top + ")" : (ConvertToJBInsetsQuickFix.isZero(top, bottom, right) ? "insetsLeft(" + left + ")" : (ConvertToJBInsetsQuickFix.isZero(top, left, right) ? "insetsBottom(" + bottom + ")" : (ConvertToJBInsetsQuickFix.isZero(top, left, bottom) ? "insetsRight(" + right + ")" : (top.equals(left) && left.equals(bottom) && bottom.equals(right) && right.equals(top) ? "insets(" + top + ")" : (top.equals(bottom) && right.equals(left) ? String.format("insets(%s, %s)", top, left) : String.format("insets(%s, %s, %s, %s)", top, left, bottom, right)))))));
            text = JBUI.class.getName() + "." + text;
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
            PsiExpression expression = factory.createExpressionFromText(text, newExpression.getContext());
            PsiElement newElement = newExpression.replace((PsiElement)expression);
            PsiElement el = JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(newElement);
            int offset = el.getTextOffset() + el.getText().length() - 2;
            Editor editor = PsiUtilBase.findEditor((PsiElement)el);
            if (editor != null) {
                editor.getCaretModel().moveToOffset(offset);
            }
        }
    }

    private static boolean isZero(String ... args) {
        if (args.length == 0) {
            return false;
        }
        for (String arg : args) {
            if ("0".equals(arg)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "descriptor";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/idea/devkit/inspections/quickfix/ConvertToJBInsetsQuickFix";
        objectArray[2] = "applyFix";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

