/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.startup;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.rider.model.loggers.LogEntry;
import com.jetbrains.rider.model.loggers.LogEntryType;
import com.jetbrains.rider.model.loggers.LoggerModel;
import com.jetbrains.rider.util.reactive.ISignal;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.log4j.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001c\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J5\u0010\f\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\u000e\"\u00020\tH\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0012\u0010\u0010\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u001c\u0010\u0010\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J$\u0010\u0013\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u001c\u0010\u0019\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/rdserver/startup/RdLogger;", "Lcom/intellij/openapi/diagnostic/Logger;", "loggerModel", "Lcom/jetbrains/rider/model/loggers/LoggerModel;", "ideaLogger", "(Lcom/jetbrains/rider/model/loggers/LoggerModel;Lcom/intellij/openapi/diagnostic/Logger;)V", "debug", "", "message", "", "t", "", "error", "details", "", "(Ljava/lang/String;Ljava/lang/Throwable;[Ljava/lang/String;)V", "info", "isDebugEnabled", "", "sendToFrontend", "severity", "Lcom/jetbrains/rider/model/loggers/LogEntryType;", "setLevel", "level", "Lorg/apache/log4j/Level;", "warn", "intellij.platform.commercial.rdserver"})
public final class RdLogger
extends Logger {
    private final LoggerModel loggerModel;
    private final Logger ideaLogger;

    public boolean isDebugEnabled() {
        return this.ideaLogger.isDebugEnabled();
    }

    public void debug(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        this.ideaLogger.debug(message);
        this.sendToFrontend(message, null, LogEntryType.VERBOSE);
    }

    public void debug(@Nullable Throwable t) {
        this.ideaLogger.debug(t);
        this.sendToFrontend(null, t, LogEntryType.VERBOSE);
    }

    public void debug(@Nullable String message, @Nullable Throwable t) {
        this.ideaLogger.debug(message, t);
        this.sendToFrontend(message, t, LogEntryType.VERBOSE);
    }

    public void info(@Nullable String message) {
        this.ideaLogger.info(message);
        this.sendToFrontend(message, null, LogEntryType.INFO);
    }

    public void info(@Nullable String message, @Nullable Throwable t) {
        this.ideaLogger.info(message, t);
        this.sendToFrontend(message, t, LogEntryType.INFO);
    }

    public void warn(@Nullable String message, @Nullable Throwable t) {
        this.ideaLogger.warn(message, t);
        this.sendToFrontend(message, t, LogEntryType.WARN);
    }

    public void error(@Nullable String message, @Nullable Throwable t, String ... details) {
        Intrinsics.checkParameterIsNotNull((Object)details, (String)"details");
        this.ideaLogger.error(message, t, Arrays.copyOf(details, details.length));
        this.sendToFrontend(Intrinsics.stringPlus((String)message, (Object)ArraysKt.joinToString$default((Object[])details, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null)), t, LogEntryType.ERROR);
    }

    public void setLevel(@NotNull Level level) {
        Intrinsics.checkParameterIsNotNull((Object)level, (String)"level");
        this.ideaLogger.setLevel(level);
    }

    private final void sendToFrontend(String message, Throwable t, LogEntryType severity) {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(this, message, t, severity){
            final /* synthetic */ RdLogger this$0;
            final /* synthetic */ String $message;
            final /* synthetic */ Throwable $t;
            final /* synthetic */ LogEntryType $severity;

            public final void run() {
                Object object;
                String string;
                LogEntry logEntry;
                LogEntry logEntry2;
                ISignal iSignal;
                block5: {
                    block4: {
                        LogEntry logEntry3;
                        iSignal = RdLogger.access$getLoggerModel$p(this.this$0).getMessage();
                        logEntry2 = logEntry3;
                        logEntry = logEntry3;
                        string = this.$message;
                        if (string == null) {
                            string = "";
                        }
                        if ((object = this.$t) == null) break block4;
                        Throwable throwable = object;
                        String string2 = string;
                        LogEntry logEntry4 = logEntry2;
                        LogEntry logEntry5 = logEntry;
                        ISignal iSignal2 = iSignal;
                        Throwable it = throwable;
                        String string3 = ExceptionUtil.getThrowableText((Throwable)it);
                        iSignal = iSignal2;
                        logEntry = logEntry5;
                        logEntry2 = logEntry4;
                        string = string2;
                        object = string3;
                        if (object != null) break block5;
                    }
                    object = "";
                }
                logEntry2(string, (String)object, this.$severity);
                iSignal.fire((Object)logEntry);
            }
            {
                this.this$0 = rdLogger;
                this.$message = string;
                this.$t = throwable;
                this.$severity = logEntryType;
            }
        });
    }

    public RdLogger(@NotNull LoggerModel loggerModel, @NotNull Logger ideaLogger) {
        Intrinsics.checkParameterIsNotNull((Object)loggerModel, (String)"loggerModel");
        Intrinsics.checkParameterIsNotNull((Object)ideaLogger, (String)"ideaLogger");
        this.loggerModel = loggerModel;
        this.ideaLogger = ideaLogger;
    }

    @NotNull
    public static final /* synthetic */ LoggerModel access$getLoggerModel$p(RdLogger $this) {
        return $this.loggerModel;
    }
}

