/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.startup;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationStarter;
import com.intellij.openapi.application.ApplicationStarterEx;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.ui.DialogWrapperPeerFactory;
import com.intellij.openapi.ui.messages.MessagesService;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.jetbrains.ide.model.RdExistingSolution;
import com.jetbrains.ide.model.RdSolutionDescription;
import com.jetbrains.ide.model.RdVirtualSolution;
import com.jetbrains.ide.model.Solution;
import com.jetbrains.ide.model.SolutionModel;
import com.jetbrains.rdserver.ActionsHost;
import com.jetbrains.rdserver.BackendTestHost;
import com.jetbrains.rdserver.HighlighterRegistrationsHost;
import com.jetbrains.rdserver.RdProgressManager;
import com.jetbrains.rdserver.RiderExKt;
import com.jetbrains.rdserver.editors.RdCommandListener;
import com.jetbrains.rdserver.startup.EdtScheduler;
import com.jetbrains.rdserver.startup.IdeaProjectGeneratorKt;
import com.jetbrains.rdserver.startup.RdAppStarter;
import com.jetbrains.rdserver.startup.RdLoggerFactory;
import com.jetbrains.rdserver.ui.NotificationsHost;
import com.jetbrains.rdserver.ui.PopupsHost;
import com.jetbrains.rdserver.ui.RdDialogWrapperPeerFactory;
import com.jetbrains.rdserver.ui.RdMessagesService;
import com.jetbrains.rdserver.ui.RdPopupFactory;
import com.jetbrains.rider.framework.IIdentities;
import com.jetbrains.rider.framework.IProtocol;
import com.jetbrains.rider.framework.ISerializers;
import com.jetbrains.rider.framework.IWire;
import com.jetbrains.rider.framework.Identities;
import com.jetbrains.rider.framework.Protocol;
import com.jetbrains.rider.framework.Serializers;
import com.jetbrains.rider.framework.SocketWire;
import com.jetbrains.rider.util.CommonsLoggingLoggerFactory;
import com.jetbrains.rider.util.ILoggerFactory;
import com.jetbrains.rider.util.Statics;
import com.jetbrains.rider.util.lifetime.Lifetime;
import com.jetbrains.rider.util.reactive.IScheduler;
import com.jetbrains.rider.util.reactive.IViewableMap;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\u0005H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u001b\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010J\u001f\u0010\u0011\u001a\u00020\r2\u0010\u0010\u000e\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0005\u0018\u00010\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rdserver/startup/RdAppStarter;", "Lcom/intellij/openapi/application/ApplicationStarterEx;", "()V", "solutions", "", "", "Lcom/jetbrains/ide/model/Solution;", "getSolutions", "()Ljava/util/Map;", "getCommandName", "isHeadless", "", "main", "", "args", "", "([Ljava/lang/String;)V", "premain", "Companion", "intellij.platform.commercial.rdserver"})
public final class RdAppStarter
extends ApplicationStarterEx {
    @NotNull
    private final Map<String, Solution> solutions;
    @NotNull
    private static final Logger LOG;
    public static final Companion Companion;

    @NotNull
    public final Map<String, Solution> getSolutions() {
        return this.solutions;
    }

    @NotNull
    public String getCommandName() {
        return "rdserver";
    }

    public void premain(@Nullable String[] args) {
    }

    public void main(@NotNull String[] args) {
        String portStr;
        String string;
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        if (args.length == 2) {
            string = args[1];
        } else if (System.getenv().containsKey("RIDER_SERVER_PORT")) {
            string = System.getenv("rider.server.port");
            if (string == null) {
                Intrinsics.throwNpe();
            }
        } else {
            String string2 = "Usage: idea.sh rdserver <port> (or set 'RIDER_SERVER_PORT' environment variable)";
            System.out.println((Object)string2);
            System.exit(1);
            string = Unit.INSTANCE;
        }
        String string3 = portStr = string;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
        }
        int port = Integer.parseInt(string3);
        try {
            Statics.Companion this_$iv = Statics.Companion;
            this_$iv.of(Reflection.getOrCreateKotlinClass(ILoggerFactory.class)).push((Object)CommonsLoggingLoggerFactory.INSTANCE);
            org.apache.log4j.Logger logger = LogManager.getLogger((String)"protocol");
            Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LogManager.getLogger(\"protocol\")");
            logger.setLevel(Level.TRACE);
            org.apache.log4j.Logger logger2 = LogManager.getLogger((String)"protocol.INIT");
            Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"LogManager.getLogger(\"protocol.INIT\")");
            logger2.setLevel(Level.TRACE);
            LOG.info("RdServer connecting to Rider on port " + port);
            SocketWire.Client wireServer = new SocketWire.Client(Lifetime.Companion.getEternal(), (IScheduler)EdtScheduler.INSTANCE, port, null, 8, null);
            Protocol protocol = new Protocol((ISerializers)new Serializers(), (IIdentities)new Identities(null, 1, null), (IScheduler)EdtScheduler.INSTANCE, (IWire)wireServer);
            EdtScheduler.INSTANCE.queue((Function0<Unit>)((Function0)new Function0<Unit>(this, protocol){
                final /* synthetic */ RdAppStarter this$0;
                final /* synthetic */ Protocol $protocol;

                public final void invoke() {
                    NotificationsHost notificationsHost;
                    Application app;
                    RdLoggerFactory.Companion.install((IProtocol)this.$protocol);
                    new ActionsHost((IProtocol)this.$protocol);
                    PopupsHost popupsHost = PopupsHost.Companion.getInstance();
                    popupsHost.attach((IProtocol)this.$protocol);
                    new BackendTestHost((IProtocol)this.$protocol).attach();
                    Application application = app = ApplicationManager.getApplication();
                    Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"app");
                    RiderExKt.registerServiceInstance((ComponentManager)application, JBPopupFactory.class, new RdPopupFactory(popupsHost.getPopupInteractionModel()));
                    RiderExKt.registerServiceInstance((ComponentManager)app, DialogWrapperPeerFactory.class, new RdDialogWrapperPeerFactory((IProtocol)this.$protocol));
                    new HighlighterRegistrationsHost(Lifetime.Companion.getEternal(), (IProtocol)this.$protocol);
                    app.getMessageBus().connect().subscribe(CommandListener.TOPIC, (Object)new RdCommandListener());
                    NotificationsHost $receiver = notificationsHost = new NotificationsHost(this.$protocol);
                    $receiver.attach();
                    NotificationsHost notificationsHost2 = notificationsHost;
                    RiderExKt.registerServiceInstance((ComponentManager)app, MessagesService.class, new RdMessagesService(notificationsHost2));
                    RiderExKt.registerServiceInstance((ComponentManager)app, ProgressManager.class, new RdProgressManager(notificationsHost2));
                    SolutionModel solutionModel = SolutionModel.Companion.create(Lifetime.Companion.getEternal(), (IProtocol)this.$protocol);
                    RdAppStarter.Companion.getLOG().info("Attached solution model to protocol");
                    solutionModel.getSolutions().advise(Lifetime.Companion.getEternal(), (Function1)new Function1<IViewableMap.Event<Integer, Solution>, Unit>(this){
                        final /* synthetic */ main.1 this$0;

                        public final void invoke(@NotNull IViewableMap.Event<Integer, Solution> event) {
                            String string;
                            Intrinsics.checkParameterIsNotNull(event, (String)"event");
                            Solution solution = (Solution)event.getNewValueOpt();
                            if (solution == null) {
                                return;
                            }
                            Solution solution2 = solution;
                            RdSolutionDescription solutionDescription = solution2.getSolutionOpenStrategy().getDescription();
                            Object object = solutionDescription;
                            if (object instanceof RdExistingSolution) {
                                String string2 = new File(((RdExistingSolution)solutionDescription).getSolutionFilePath()).getParent();
                                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"File(solutionDescription.solutionFilePath).parent");
                                string = IdeaProjectGeneratorKt.generateIdeaProject(string2, false);
                            } else if (object instanceof RdVirtualSolution) {
                                string = IdeaProjectGeneratorKt.generateIdeaProject(((RdVirtualSolution)solutionDescription).getSolutionDirectory(), true);
                            } else {
                                return;
                            }
                            String ideaProjectPath = string;
                            RdAppStarter.Companion.getLOG().info("Generated IDEA project in " + ideaProjectPath);
                            object = this.this$0.this$0.getSolutions();
                            Solution solution3 = solution2;
                            object.put(ideaProjectPath, solution3);
                            solution2.isLoading().set((Object)true);
                            RdAppStarter.Companion.getLOG().info("Opening IDEA project");
                            try {
                                ProjectManagerEx.getInstanceEx().loadAndOpenProject(ideaProjectPath);
                            }
                            catch (Exception e) {
                                RdAppStarter.Companion.getLOG().error("Project open failed", (Throwable)e);
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }
                    });
                }
                {
                    this.this$0 = rdAppStarter;
                    this.$protocol = protocol;
                    super(0);
                }
            }));
            LOG.info("RdServer connected to Rider on port " + port);
        }
        catch (Exception e) {
            LOG.error("rdserver startup failed", (Throwable)e);
            String string4 = "rdserver startup failed";
            System.out.println((Object)string4);
            e.printStackTrace();
            System.exit(1);
        }
    }

    public boolean isHeadless() {
        return true;
    }

    public RdAppStarter() {
        Map map;
        RdAppStarter rdAppStarter = this;
        rdAppStarter.solutions = map = (Map)new LinkedHashMap();
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(RdAppStarter.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(RdAppStarter::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/startup/RdAppStarter$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/jetbrains/rdserver/startup/RdAppStarter;", "intellij.platform.commercial.rdserver"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        @NotNull
        public final RdAppStarter getInstance() {
            Object object = ApplicationStarter.EP_NAME.findExtensionOrFail(RdAppStarter.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ApplicationStarter.EP_NA\u2026RdAppStarter::class.java)");
            return (RdAppStarter)((Object)object);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

