/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.editors;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.ide.model.BackendDaemonStateEnum;
import com.jetbrains.ide.model.EditableEntity;
import com.jetbrains.ide.model.EditableEntityId;
import com.jetbrains.ide.model.RdMarkupModel;
import com.jetbrains.ide.model.Solution;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/editors/DaemonStatusHost;", "", "project", "Lcom/intellij/openapi/project/Project;", "solution", "Lcom/jetbrains/ide/model/Solution;", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/ide/model/Solution;)V", "updateDaemonStatus", "", "fileEditors", "", "Lcom/intellij/openapi/fileEditor/FileEditor;", "status", "Lcom/jetbrains/ide/model/BackendDaemonStateEnum;", "intellij.platform.commercial.rdserver"})
public final class DaemonStatusHost {
    private final Solution solution;

    private final void updateDaemonStatus(Collection<? extends FileEditor> fileEditors, BackendDaemonStateEnum status) {
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileDocumentManager, (String)"FileDocumentManager.getInstance()");
        FileDocumentManager fileDocumentManager2 = fileDocumentManager;
        block0: for (FileEditor fileEditor : fileEditors) {
            VirtualFile vFile;
            TextEditor textEditor;
            FileEditor fileEditor2 = fileEditor;
            if (!(fileEditor2 instanceof TextEditor)) {
                fileEditor2 = null;
            }
            if ((TextEditor)fileEditor2 == null) {
                continue;
            }
            Editor editor = textEditor.getEditor();
            Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"textEditor.editor");
            if (fileDocumentManager2.getFile(editor.getDocument()) == null) {
                continue;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)vFile, (String)"fileDocumentManager.getF\u2026tor.document) ?: continue");
            Map map = (Map)this.solution.getEditors().getDocuments();
            for (Map.Entry document : map.entrySet()) {
                RdMarkupModel markupModel;
                if (!Intrinsics.areEqual((Object)((EditableEntityId)document.getKey()).getFilePath(), (Object)vFile.getPath())) continue;
                EditableEntity editableEntity = (EditableEntity)document.getValue();
                Object object = editableEntity.getMarkup().getValueOrNull();
                if (!(object instanceof RdMarkupModel)) {
                    object = null;
                }
                if ((RdMarkupModel)object == null) {
                    continue block0;
                }
                markupModel.getDaemon().getState().set((Object)status);
            }
        }
    }

    public DaemonStatusHost(@NotNull Project project, @NotNull Solution solution) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)solution, (String)"solution");
        this.solution = solution;
        project.getMessageBus().connect().subscribe(DaemonCodeAnalyzer.DAEMON_EVENT_TOPIC, (Object)new DaemonCodeAnalyzer.DaemonListener(){

            public void daemonStarting(@NotNull Collection<? extends FileEditor> files) {
                Intrinsics.checkParameterIsNotNull(files, (String)"files");
                this.updateDaemonStatus(files, BackendDaemonStateEnum.IN_PROGRESS_LOCAL);
            }

            public void daemonFinished(@NotNull Collection<? extends FileEditor> files) {
                Intrinsics.checkParameterIsNotNull(files, (String)"files");
                this.updateDaemonStatus(files, BackendDaemonStateEnum.UP_TO_DATE);
            }
        });
    }
}

