/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver;

import com.intellij.application.options.colors.ColorSettingsUtil;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.options.colors.AttributesDescriptor;
import com.intellij.openapi.options.colors.ColorAndFontDescriptorsProvider;
import com.intellij.openapi.options.colors.ColorSettingsPage;
import com.jetbrains.ide.model.RgbColor;
import com.jetbrains.rdserver.HighlighterRegistrationsHostKt;
import com.jetbrains.rdserver.ProtocolConversionsKt;
import com.jetbrains.rider.framework.IProtocol;
import com.jetbrains.rider.model.highlighterRegistration.AbstractRegistryModel;
import com.jetbrains.rider.model.highlighterRegistration.ColorsSchemeEntry;
import com.jetbrains.rider.model.highlighterRegistration.ColorsSchemeModel;
import com.jetbrains.rider.model.highlighterRegistration.DefaultRegistryModel;
import com.jetbrains.rider.model.highlighterRegistration.GreedySide;
import com.jetbrains.rider.model.highlighterRegistration.HighlighterKind;
import com.jetbrains.rider.model.highlighterRegistration.HighlighterProperties;
import com.jetbrains.rider.model.highlighterRegistration.HighlighterRegistrationHostModel;
import com.jetbrains.rider.model.highlighterRegistration.HighlighterRegistrationPack;
import com.jetbrains.rider.model.highlighterRegistration.HighlighterSeverity;
import com.jetbrains.rider.model.highlighterRegistration.IdeaEffectType;
import com.jetbrains.rider.model.highlighterRegistration.IdeaHighlightInfoType;
import com.jetbrains.rider.model.highlighterRegistration.IdeaTextAttributes;
import com.jetbrains.rider.model.highlighterRegistration.IdeaTextAttributesKey;
import com.jetbrains.rider.util.lifetime.Lifetime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000  2\u00020\u0001:\u0001 B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\f0\u001cH\u0002J\u0012\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001c*\u00020\u001fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006!"}, d2={"Lcom/jetbrains/rdserver/HighlighterRegistrationsHost;", "", "lifetime", "Lcom/jetbrains/rider/util/lifetime/Lifetime;", "protocol", "Lcom/jetbrains/rider/framework/IProtocol;", "(Lcom/jetbrains/rider/util/lifetime/Lifetime;Lcom/jetbrains/rider/framework/IProtocol;)V", "getLifetime", "()Lcom/jetbrains/rider/util/lifetime/Lifetime;", "getProtocol", "()Lcom/jetbrains/rider/framework/IProtocol;", "createPackForDummyAttribute", "Lcom/jetbrains/rider/model/highlighterRegistration/HighlighterRegistrationPack;", "attributeId", "", "isBulkUpdatable", "", "createPackForHighlightInfoType", "infoType", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfoType;", "createPackForTextAttributesKey", "textAttributesKey", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "severity", "Lcom/intellij/lang/annotation/HighlightSeverity;", "getColorSchemesModel", "Lcom/jetbrains/rider/model/highlighterRegistration/ColorsSchemeModel;", "getHighlighterRegistrations", "", "convertEntries", "Lcom/jetbrains/rider/model/highlighterRegistration/ColorsSchemeEntry;", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "Companion", "intellij.platform.commercial.rdserver"})
public final class HighlighterRegistrationsHost {
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final IProtocol protocol;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Map<HighlightSeverity, HighlighterSeverity> severityToProtocol;
    @NotNull
    private static final Map<EffectType, IdeaEffectType> effectTypeToProtocol;
    private static final Set<String> _allRegisteredAttributeIds;
    @NotNull
    private static final String LINE_MARKER_ID = "IJ.LINE_MARKER";
    @NotNull
    private static final String FOLD_REGION_ID = "IJ.FOLD_REGION";
    @NotNull
    private static final String CUSTOM_HIGHLIGHTING_ID = "IJ.CUSTOM_HIGHLIGHTING";
    public static final Companion Companion;

    private final List<HighlighterRegistrationPack> getHighlighterRegistrations() {
        Map result = new LinkedHashMap();
        Function1<HighlighterRegistrationPack, Unit> add$ = new Function1<HighlighterRegistrationPack, Unit>(result){
            final /* synthetic */ Map $result;

            public final void invoke(@NotNull HighlighterRegistrationPack pack) {
                Intrinsics.checkParameterIsNotNull((Object)pack, (String)"pack");
                Map map = this.$result;
                String string = pack.getAttributeId();
                Map map2 = map;
                if (!map2.containsKey(string)) {
                    map = this.$result;
                    string = pack.getAttributeId();
                    map2 = pack;
                    map.put(string, map2);
                }
            }
            {
                this.$result = map;
                super(1);
            }
        };
        SeverityRegistrar severityRegistrar = SeverityRegistrar.getSeverityRegistrar(null);
        Intrinsics.checkExpressionValueIsNotNull((Object)severityRegistrar, (String)"SeverityRegistrar.getSeverityRegistrar(null)");
        SeverityRegistrar severityRegistrar2 = severityRegistrar;
        for (HighlightSeverity severity : severityRegistrar2.getAllSeverities()) {
            HighlightInfoType.HighlightInfoTypeImpl highlightInfoType;
            Intrinsics.checkExpressionValueIsNotNull((Object)severityRegistrar2.getHighlightInfoTypeBySeverity(severity), (String)"severityRegistrar.getHig\u2026oTypeBySeverity(severity)");
            add$.invoke(this.createPackForHighlightInfoType((HighlightInfoType)highlightInfoType));
        }
        HighlightInfoType highlightInfoType = HighlightInfoType.ELEMENT_UNDER_CARET_READ;
        Intrinsics.checkExpressionValueIsNotNull((Object)highlightInfoType, (String)"HighlightInfoType.ELEMENT_UNDER_CARET_READ");
        add$.invoke(this.createPackForHighlightInfoType(highlightInfoType));
        HighlightInfoType highlightInfoType2 = HighlightInfoType.ELEMENT_UNDER_CARET_WRITE;
        Intrinsics.checkExpressionValueIsNotNull((Object)highlightInfoType2, (String)"HighlightInfoType.ELEMENT_UNDER_CARET_WRITE");
        add$.invoke(this.createPackForHighlightInfoType(highlightInfoType2));
        ExtensionPointName extensionPointName = ColorSettingsPage.EP_NAME;
        Intrinsics.checkExpressionValueIsNotNull((Object)extensionPointName, (String)"ColorSettingsPage.EP_NAME");
        for (ColorSettingsPage colorSettingsPage : (ColorSettingsPage[])extensionPointName.getExtensions()) {
            Iterator iterator = ColorSettingsUtil.getAllAttributeDescriptors((ColorAndFontDescriptorsProvider)((ColorAndFontDescriptorsProvider)colorSettingsPage)).iterator();
            while (iterator.hasNext()) {
                AttributesDescriptor descriptor;
                AttributesDescriptor attributesDescriptor = descriptor = (AttributesDescriptor)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)attributesDescriptor, (String)"descriptor");
                TextAttributesKey textAttributesKey = attributesDescriptor.getKey();
                Intrinsics.checkExpressionValueIsNotNull((Object)textAttributesKey, (String)"descriptor.key");
                HighlightSeverity highlightSeverity = HighlightSeverity.INFORMATION;
                Intrinsics.checkExpressionValueIsNotNull((Object)highlightSeverity, (String)"HighlightSeverity.INFORMATION");
                add$.invoke(this.createPackForTextAttributesKey(textAttributesKey, highlightSeverity));
            }
        }
        add$.invoke(this.createPackForDummyAttribute(LINE_MARKER_ID, false));
        add$.invoke(this.createPackForDummyAttribute(FOLD_REGION_ID, true));
        add$.invoke(this.createPackForDummyAttribute(CUSTOM_HIGHLIGHTING_ID, false));
        return CollectionsKt.toList((Iterable)result.values());
    }

    private final HighlighterRegistrationPack createPackForDummyAttribute(String attributeId, boolean isBulkUpdatable) {
        _allRegisteredAttributeIds.add(attributeId);
        return new HighlighterRegistrationPack(attributeId, "", null, new HighlighterProperties(HighlighterKind.USUAL, true, GreedySide.NONE, true, isBulkUpdatable, true));
    }

    private final HighlighterRegistrationPack createPackForHighlightInfoType(HighlightInfoType infoType) {
        TextAttributesKey textAttributesKey = infoType.getAttributesKey();
        Intrinsics.checkExpressionValueIsNotNull((Object)textAttributesKey, (String)"infoType.attributesKey");
        HighlightSeverity highlightSeverity = infoType.getSeverity(null);
        Intrinsics.checkExpressionValueIsNotNull((Object)highlightSeverity, (String)"infoType.getSeverity(null)");
        return this.createPackForTextAttributesKey(textAttributesKey, highlightSeverity);
    }

    private final HighlighterRegistrationPack createPackForTextAttributesKey(TextAttributesKey textAttributesKey, HighlightSeverity severity) {
        String attributeId = HighlighterRegistrationsHostKt.toAttributeId(textAttributesKey);
        _allRegisteredAttributeIds.add(attributeId);
        LOG.info("Registered highlighter with ID " + attributeId);
        HighlighterSeverity highlighterSeverity = severityToProtocol.get(severity);
        if (highlighterSeverity == null) {
            highlighterSeverity = HighlighterSeverity.INFO;
        }
        String string = textAttributesKey.getExternalName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"textAttributesKey.externalName");
        TextAttributesKey textAttributesKey2 = textAttributesKey.getFallbackAttributeKey();
        return new HighlighterRegistrationPack(attributeId, "", new IdeaHighlightInfoType(highlighterSeverity, new IdeaTextAttributesKey(string, textAttributesKey2 != null ? textAttributesKey2.getExternalName() : null)), new HighlighterProperties(HighlighterKind.USUAL, true, GreedySide.NONE, true, false, true));
    }

    private final ColorsSchemeModel getColorSchemesModel() {
        EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)editorColorsManager, (String)"EditorColorsManager.getInstance()");
        EditorColorsScheme editorColorsScheme = editorColorsManager.getGlobalScheme();
        Intrinsics.checkExpressionValueIsNotNull((Object)editorColorsScheme, (String)"EditorColorsManager.getInstance().globalScheme");
        EditorColorsScheme scheme = editorColorsScheme;
        String string = scheme.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"scheme.name");
        return new ColorsSchemeModel(string, this.convertEntries(scheme));
    }

    private final List<ColorsSchemeEntry> convertEntries(@NotNull EditorColorsScheme $receiver) {
        List result = new ArrayList();
        ExtensionPointName extensionPointName = ColorSettingsPage.EP_NAME;
        Intrinsics.checkExpressionValueIsNotNull((Object)extensionPointName, (String)"ColorSettingsPage.EP_NAME");
        ColorSettingsPage[] colorSettingsPageArray = (ColorSettingsPage[])extensionPointName.getExtensions();
        int n = colorSettingsPageArray.length;
        for (int i = 0; i < n; ++i) {
            ColorSettingsPage colorSettingsPage;
            ColorSettingsPage colorSettingsPage2 = colorSettingsPage = colorSettingsPageArray[i];
            Intrinsics.checkExpressionValueIsNotNull((Object)colorSettingsPage2, (String)"colorSettingsPage");
            AttributesDescriptor[] attributesDescriptorArray = colorSettingsPage2.getAttributeDescriptors();
            int n2 = attributesDescriptorArray.length;
            for (int j = 0; j < n2; ++j) {
                AttributesDescriptor descriptor;
                AttributesDescriptor attributesDescriptor = descriptor = attributesDescriptorArray[j];
                Intrinsics.checkExpressionValueIsNotNull((Object)attributesDescriptor, (String)"descriptor");
                TextAttributesKey textAttributesKey = attributesDescriptor.getKey();
                Intrinsics.checkExpressionValueIsNotNull((Object)textAttributesKey, (String)"descriptor.key");
                String string = HighlighterRegistrationsHostKt.toAttributeId(textAttributesKey);
                TextAttributes textAttributes = $receiver.getAttributes(descriptor.getKey());
                Intrinsics.checkExpressionValueIsNotNull((Object)textAttributes, (String)"getAttributes(descriptor.key)");
                result.add(new ColorsSchemeEntry(string, false, Companion.convertAttributes(textAttributes)));
            }
        }
        return result;
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @NotNull
    public final IProtocol getProtocol() {
        return this.protocol;
    }

    public HighlighterRegistrationsHost(@NotNull Lifetime lifetime, @NotNull IProtocol protocol) {
        Intrinsics.checkParameterIsNotNull((Object)lifetime, (String)"lifetime");
        Intrinsics.checkParameterIsNotNull((Object)protocol, (String)"protocol");
        this.lifetime = lifetime;
        this.protocol = protocol;
        LOG.info("Preparing highlighter registrations");
        HighlighterRegistrationHostModel model = HighlighterRegistrationHostModel.Companion.create(this.lifetime, this.protocol);
        model.getRegistry().advise(this.lifetime, (Function1)new Function1<AbstractRegistryModel, Unit>(){

            public final void invoke(@NotNull AbstractRegistryModel registry) {
                Intrinsics.checkParameterIsNotNull((Object)registry, (String)"registry");
                if (!(registry instanceof DefaultRegistryModel)) {
                    return;
                }
                ((DefaultRegistryModel)registry).getRegistrationPacks().fire((Object)this.getHighlighterRegistrations());
                ((DefaultRegistryModel)registry).getColorsScheme().fire((Object)this.getColorSchemesModel());
            }
        });
        model.getBackendReady().set((Object)true);
        LOG.info("Submitted highlighter registrations");
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(HighlighterRegistrationsHost.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(Highl\u2026trationsHost::class.java)");
        LOG = logger;
        severityToProtocol = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)HighlightSeverity.ERROR, (Object)HighlighterSeverity.ERROR), TuplesKt.to((Object)HighlightSeverity.WARNING, (Object)HighlighterSeverity.WARNING), TuplesKt.to((Object)HighlightSeverity.WEAK_WARNING, (Object)HighlighterSeverity.WEAK_WARNING), TuplesKt.to((Object)HighlightSeverity.INFORMATION, (Object)HighlighterSeverity.INFO), TuplesKt.to((Object)HighlightInfoType.ELEMENT_UNDER_CARET_SEVERITY, (Object)HighlighterSeverity.ELEMENT_UNDER_CARET)});
        effectTypeToProtocol = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)EffectType.LINE_UNDERSCORE, (Object)IdeaEffectType.LINE_UNDERSCORE), TuplesKt.to((Object)EffectType.WAVE_UNDERSCORE, (Object)IdeaEffectType.WAVE_UNDERSCORE), TuplesKt.to((Object)EffectType.BOXED, (Object)IdeaEffectType.BOXED), TuplesKt.to((Object)EffectType.STRIKEOUT, (Object)IdeaEffectType.STRIKEOUT), TuplesKt.to((Object)EffectType.BOLD_LINE_UNDERSCORE, (Object)IdeaEffectType.BOLD_LINE_UNDERSCORE), TuplesKt.to((Object)EffectType.BOLD_DOTTED_LINE, (Object)IdeaEffectType.BOLD_DOTTED_LINE)});
        _allRegisteredAttributeIds = new LinkedHashSet();
        LINE_MARKER_ID = LINE_MARKER_ID;
        FOLD_REGION_ID = FOLD_REGION_ID;
        CUSTOM_HIGHLIGHTING_ID = CUSTOM_HIGHLIGHTING_ID;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001d\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR%\u0010\u001b\u001a\u0016\u0012\f\u0012\n \u001d*\u0004\u0018\u00010\u001c0\u001c\u0012\u0004\u0012\u00020\u001e0\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001a\u00a8\u0006$"}, d2={"Lcom/jetbrains/rdserver/HighlighterRegistrationsHost$Companion;", "", "()V", "CUSTOM_HIGHLIGHTING_ID", "", "getCUSTOM_HIGHLIGHTING_ID", "()Ljava/lang/String;", "FOLD_REGION_ID", "getFOLD_REGION_ID", "LINE_MARKER_ID", "getLINE_MARKER_ID", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "_allRegisteredAttributeIds", "", "allRegisteredAttributeIds", "", "getAllRegisteredAttributeIds", "()Ljava/util/Set;", "effectTypeToProtocol", "", "Lcom/intellij/openapi/editor/markup/EffectType;", "Lcom/jetbrains/rider/model/highlighterRegistration/IdeaEffectType;", "getEffectTypeToProtocol", "()Ljava/util/Map;", "severityToProtocol", "Lcom/intellij/lang/annotation/HighlightSeverity;", "kotlin.jvm.PlatformType", "Lcom/jetbrains/rider/model/highlighterRegistration/HighlighterSeverity;", "getSeverityToProtocol", "convertAttributes", "Lcom/jetbrains/rider/model/highlighterRegistration/IdeaTextAttributes;", "textAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "intellij.platform.commercial.rdserver"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        @NotNull
        public final Map<HighlightSeverity, HighlighterSeverity> getSeverityToProtocol() {
            return severityToProtocol;
        }

        @NotNull
        public final Map<EffectType, IdeaEffectType> getEffectTypeToProtocol() {
            return effectTypeToProtocol;
        }

        @NotNull
        public final Set<String> getAllRegisteredAttributeIds() {
            return _allRegisteredAttributeIds;
        }

        @NotNull
        public final String getLINE_MARKER_ID() {
            return LINE_MARKER_ID;
        }

        @NotNull
        public final String getFOLD_REGION_ID() {
            return FOLD_REGION_ID;
        }

        @NotNull
        public final String getCUSTOM_HIGHLIGHTING_ID() {
            return CUSTOM_HIGHLIGHTING_ID;
        }

        @NotNull
        public final IdeaTextAttributes convertAttributes(@NotNull TextAttributes textAttributes) {
            Intrinsics.checkParameterIsNotNull((Object)textAttributes, (String)"textAttributes");
            RgbColor rgbColor = ProtocolConversionsKt.toRgbColor(textAttributes.getForegroundColor());
            RgbColor rgbColor2 = ProtocolConversionsKt.toRgbColor(textAttributes.getBackgroundColor());
            RgbColor rgbColor3 = ProtocolConversionsKt.toRgbColor(textAttributes.getEffectColor());
            RgbColor rgbColor4 = ProtocolConversionsKt.toRgbColor(textAttributes.getErrorStripeColor());
            IdeaEffectType ideaEffectType = this.getEffectTypeToProtocol().get(textAttributes.getEffectType());
            if (ideaEffectType == null) {
                ideaEffectType = IdeaEffectType.LINE_UNDERSCORE;
            }
            return new IdeaTextAttributes(rgbColor, rgbColor2, rgbColor3, rgbColor4, ideaEffectType, textAttributes.getFontType());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

