/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdcommon;

import com.intellij.codeInsight.daemon.impl.VisibleHighlightingPassFactory;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SoftWrap;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.util.ProperTextRange;
import com.jetbrains.ide.model.DocOffsetAndVirtualModel;
import com.jetbrains.ide.model.ScrollKind;
import com.jetbrains.ide.model.SelectionRange;
import com.jetbrains.ide.model.VisibleRange;
import com.jetbrains.rdcommon.TextControlsUtilsKt$WhenMappings;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000F\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a \u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u0005\u001a \u0010\r\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u0007H\u0002\u001a\n\u0010\u000f\u001a\u00020\u0003*\u00020\u0010\u001a\u0014\u0010\u0011\u001a\u00020\n*\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u000eH\u0002\u001a\f\u0010\u0013\u001a\u00020\u0014*\u00020\u0010H\u0002\u001a\n\u0010\u0015\u001a\u00020\u0016*\u00020\u0017\u00a8\u0006\u0018"}, d2={"applyTo", "", "selectionModel", "Lcom/jetbrains/ide/model/SelectionRange;", "editor", "Lcom/intellij/openapi/editor/Editor;", "calcVirtualDelta", "", "offset", "visualPosition", "Lcom/intellij/openapi/editor/VisualPosition;", "calculateVisibleRange", "Lcom/jetbrains/ide/model/VisibleRange;", "createModelPosition", "Lcom/jetbrains/ide/model/DocOffsetAndVirtualModel;", "createSelectionRange", "Lcom/intellij/openapi/editor/CaretModel;", "docOffsetAndVirtualToVisualPosition", "pos", "getCaretToSync", "Lcom/intellij/openapi/editor/Caret;", "toScrollType", "Lcom/intellij/openapi/editor/ScrollType;", "Lcom/jetbrains/ide/model/ScrollKind;", "intellij.platform.commercial.rdcommon"})
public final class TextControlsUtilsKt {
    private static final Caret getCaretToSync(@NotNull CaretModel $receiver) {
        Iterable $receiver$iv;
        List list = $receiver.getAllCarets();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"this.allCarets");
        Iterable iterable = $receiver$iv = (Iterable)list;
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                Caret it;
                Caret caret = it = (Caret)a;
                Intrinsics.checkExpressionValueIsNotNull((Object)caret, (String)"it");
                it = (Caret)b;
                Comparable comparable = Integer.valueOf(caret.getOffset());
                Caret caret2 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)caret2, (String)"it");
                Integer n = caret2.getOffset();
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)n);
            }
        };
        Object object = CollectionsKt.first((List)CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator));
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"this.allCarets.sortedBy { it.offset }.first()");
        return (Caret)object;
    }

    @NotNull
    public static final ScrollType toScrollType(@NotNull ScrollKind $receiver) {
        ScrollType scrollType;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        switch (TextControlsUtilsKt$WhenMappings.$EnumSwitchMapping$0[$receiver.ordinal()]) {
            case 1: {
                scrollType = ScrollType.MAKE_VISIBLE;
                break;
            }
            case 2: {
                scrollType = ScrollType.RELATIVE;
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("this");
            }
        }
        return scrollType;
    }

    private static final VisualPosition docOffsetAndVirtualToVisualPosition(@NotNull Editor $receiver, DocOffsetAndVirtualModel pos) {
        boolean bl;
        boolean bl2 = bl = pos.getVirtualDelta() >= 0;
        if (!bl) {
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        VisualPosition visualPosition = $receiver.offsetToVisualPosition(pos.getOffset());
        Intrinsics.checkExpressionValueIsNotNull((Object)visualPosition, (String)"offsetToVisualPosition(pos.offset)");
        VisualPosition vPos = visualPosition;
        return pos.getVirtualDelta() == 0 ? vPos : new VisualPosition(vPos.line, vPos.column + pos.getVirtualDelta(), vPos.leansRight);
    }

    @NotNull
    public static final SelectionRange createSelectionRange(@NotNull CaretModel $receiver) {
        DocOffsetAndVirtualModel docOffsetAndVirtualModel;
        DocOffsetAndVirtualModel activePos;
        DocOffsetAndVirtualModel docOffsetAndVirtualModel2;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Caret caret = TextControlsUtilsKt.getCaretToSync($receiver);
        Editor editor = caret.getEditor();
        Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"caret.editor");
        Editor editor2 = editor;
        Document document = editor2.getDocument();
        if (!(document instanceof DocumentEx)) {
            document = null;
        }
        DocumentEx documentEx = (DocumentEx)document;
        boolean isInBulkUpdate = documentEx != null ? documentEx.isInBulkUpdate() : false;
        int caretOffset = caret.getOffset();
        if (isInBulkUpdate) {
            docOffsetAndVirtualModel2 = TextControlsUtilsKt.createModelPosition(caretOffset);
        } else {
            VisualPosition visualPosition = caret.getVisualPosition();
            Intrinsics.checkExpressionValueIsNotNull((Object)visualPosition, (String)"caret.visualPosition");
            docOffsetAndVirtualModel2 = activePos = TextControlsUtilsKt.createModelPosition(editor2, caretOffset, visualPosition);
        }
        if (!caret.hasSelection()) {
            return new SelectionRange(activePos, activePos);
        }
        int selMin = Math.min(caret.getSelectionStart(), caret.getSelectionEnd());
        int selMax = Math.max(caret.getSelectionStart(), caret.getSelectionEnd());
        if (selMin < caretOffset && caretOffset < selMax) {
            DocOffsetAndVirtualModel docOffsetAndVirtualModel3;
            int offset;
            boolean isSelStartActivePos = caret.getLeadSelectionOffset() != caret.getSelectionStart();
            int n = offset = isSelStartActivePos ? caret.getSelectionStart() : caret.getSelectionEnd();
            if (isInBulkUpdate) {
                docOffsetAndVirtualModel3 = TextControlsUtilsKt.createModelPosition(offset);
            } else {
                VisualPosition visualPosition = isSelStartActivePos ? caret.getSelectionStartPosition() : caret.getSelectionEndPosition();
                Intrinsics.checkExpressionValueIsNotNull((Object)visualPosition, (String)"if (isSelStartActivePos)\u2026aret.selectionEndPosition");
                VisualPosition visualPosition2 = visualPosition;
                docOffsetAndVirtualModel3 = activePos = TextControlsUtilsKt.createModelPosition(editor2, offset, visualPosition2);
            }
        }
        if (isInBulkUpdate) {
            docOffsetAndVirtualModel = TextControlsUtilsKt.createModelPosition(caret.getLeadSelectionOffset());
        } else {
            int n = caret.getLeadSelectionOffset();
            VisualPosition visualPosition = caret.getLeadSelectionPosition();
            Intrinsics.checkExpressionValueIsNotNull((Object)visualPosition, (String)"caret.leadSelectionPosition");
            docOffsetAndVirtualModel = TextControlsUtilsKt.createModelPosition(editor2, n, visualPosition);
        }
        DocOffsetAndVirtualModel anchorPos = docOffsetAndVirtualModel;
        return new SelectionRange(anchorPos, activePos);
    }

    private static final DocOffsetAndVirtualModel createModelPosition(int offset) {
        return new DocOffsetAndVirtualModel(offset, 0);
    }

    private static final DocOffsetAndVirtualModel createModelPosition(Editor editor, int offset, VisualPosition visualPosition) {
        int virtualDelta = TextControlsUtilsKt.calcVirtualDelta(editor, offset, visualPosition);
        return new DocOffsetAndVirtualModel(offset, virtualDelta);
    }

    private static final int calcVirtualDelta(Editor editor, int offset, VisualPosition visualPosition) {
        int lineEndColumnNumber;
        int delta;
        Document document = editor.getDocument();
        Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"editor.document");
        Document document2 = document;
        LogicalPosition logicalPosition = editor.visualToLogicalPosition(visualPosition);
        Intrinsics.checkExpressionValueIsNotNull((Object)logicalPosition, (String)"editor.visualToLogicalPosition(visualPosition)");
        LogicalPosition logicalPosition2 = logicalPosition;
        int lineNumber = logicalPosition2.line;
        int columnNumber = logicalPosition2.column;
        if (lineNumber >= document2.getLineCount()) {
            return columnNumber;
        }
        int anchorLineEndOffset = document2.getLineEndOffset(lineNumber);
        List list = editor.getSoftWrapModel().getSoftWrapsForLine(logicalPosition2.line);
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"editor.softWrapModel.get\u2026ine(logicalPosition.line)");
        List softWraps = list;
        for (SoftWrap softWrap : softWraps) {
            boolean visuallyBeforeSoftWrap;
            if (!editor.getSoftWrapModel().isVisible(softWrap)) continue;
            SoftWrap softWrap2 = softWrap;
            Intrinsics.checkExpressionValueIsNotNull((Object)softWrap2, (String)"softWrap");
            int softWrapOffset = softWrap2.getStart();
            if (softWrapOffset == offset) {
                VisualPosition position;
                Intrinsics.checkExpressionValueIsNotNull((Object)editor.offsetToVisualPosition(offset - 1), (String)"editor.offsetToVisualPosition(offset - 1)");
                if (position.line == visualPosition.line) {
                    int delta2 = visualPosition.column - position.column - 1;
                    return delta2 < 0 ? 0 : delta2;
                }
            }
            if (softWrapOffset > offset) {
                anchorLineEndOffset = softWrapOffset;
                break;
            }
            if (softWrapOffset != offset || !(visuallyBeforeSoftWrap = visualPosition.line < editor.offsetToVisualPosition((int)offset).line)) continue;
            anchorLineEndOffset = softWrapOffset;
            break;
        }
        return (delta = columnNumber - (lineEndColumnNumber = editor.offsetToLogicalPosition((int)anchorLineEndOffset).column)) < 0 ? 0 : delta;
    }

    @NotNull
    public static final VisibleRange calculateVisibleRange(@NotNull Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        ProperTextRange properTextRange = VisibleHighlightingPassFactory.calculateVisibleRange((Editor)editor);
        Intrinsics.checkExpressionValueIsNotNull((Object)properTextRange, (String)"VisibleHighlightingPassF\u2026ulateVisibleRange(editor)");
        ProperTextRange visibleRange = properTextRange;
        return new VisibleRange(visibleRange.getStartOffset(), visibleRange.getEndOffset());
    }

    /*
     * WARNING - void declaration
     */
    public static final void applyTo(@NotNull SelectionRange selectionModel, @NotNull Editor editor) {
        void activePosOffset;
        void anchorPosOffset;
        Intrinsics.checkParameterIsNotNull((Object)selectionModel, (String)"selectionModel");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        CaretModel caretModel = editor.getCaretModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"editor.caretModel");
        Caret caretToSync = TextControlsUtilsKt.getCaretToSync(caretModel);
        DocOffsetAndVirtualModel docOffsetAndVirtualModel = selectionModel.getSelectionAnchor();
        int n = docOffsetAndVirtualModel.component1();
        int anchorVDelta = docOffsetAndVirtualModel.component2();
        DocOffsetAndVirtualModel docOffsetAndVirtualModel2 = selectionModel.getActivePosition();
        int n2 = docOffsetAndVirtualModel2.component1();
        int activePosVDelta = docOffsetAndVirtualModel2.component2();
        if (Intrinsics.areEqual((Object)selectionModel.getActivePosition(), (Object)selectionModel.getSelectionAnchor())) {
            if (caretToSync.hasSelection()) {
                caretToSync.removeSelection();
            }
        } else if (anchorVDelta > 0 || activePosVDelta > 0) {
            VisualPosition anchorVPos = TextControlsUtilsKt.docOffsetAndVirtualToVisualPosition(editor, selectionModel.getSelectionAnchor());
            VisualPosition activeVPos = TextControlsUtilsKt.docOffsetAndVirtualToVisualPosition(editor, selectionModel.getActivePosition());
            caretToSync.setSelection(anchorVPos, (int)anchorPosOffset, activeVPos, (int)activePosOffset);
        } else {
            caretToSync.setSelection((int)anchorPosOffset, (int)activePosOffset);
        }
        if (activePosVDelta > 0) {
            VisualPosition activeVPos = TextControlsUtilsKt.docOffsetAndVirtualToVisualPosition(editor, selectionModel.getActivePosition());
            caretToSync.moveToVisualPosition(activeVPos);
        } else {
            caretToSync.moveToOffset((int)activePosOffset);
        }
    }
}

