/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.references;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.jsf.references.JsfResourceDirectoryReference;
import com.intellij.jsf.resources.FacesBundle;
import com.intellij.jsf.utils.JsfCommonUtils;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.util.ArrayUtil;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsfLibraryDirectoryReference
extends PsiPolyVariantReferenceBase<PsiElement>
implements EmptyResolveMessageProvider,
LocalQuickFixProvider {
    public JsfLibraryDirectoryReference(PsiElement psiElement) {
        super(psiElement);
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        HashSet<PsiElementResolveResult> resolvResultSet = new HashSet<PsiElementResolveResult>();
        for (PsiDirectory psiDirectory : JsfCommonUtils.getResourceLibraryDirectories(ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getElement()), this.getValue())) {
            resolvResultSet.add(new PsiElementResolveResult((PsiElement)psiDirectory));
        }
        ResolveResult[] resolveResultArray = resolvResultSet.toArray(ResolveResult.EMPTY_ARRAY);
        if (resolveResultArray == null) {
            JsfLibraryDirectoryReference.$$$reportNull$$$0(0);
        }
        return resolveResultArray;
    }

    @NotNull
    public Object[] getVariants() {
        HashSet<PsiDirectory> variants = new HashSet<PsiDirectory>();
        HashSet<String> added = new HashSet<String>();
        Set<PsiDirectory> directories = JsfCommonUtils.getTopLevelLibraryDirectories(ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getElement()));
        for (PsiDirectory directory : directories) {
            for (PsiDirectory subDirectory : directory.getSubdirectories()) {
                if (added.contains(subDirectory.getName())) continue;
                variants.add(subDirectory);
                added.add(subDirectory.getName());
            }
        }
        Object[] objectArray = ArrayUtil.toObjectArray(variants);
        if (objectArray == null) {
            JsfLibraryDirectoryReference.$$$reportNull$$$0(1);
        }
        return objectArray;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = FacesBundle.message("cannot.resolve.library", new Object[0]);
        if (string == null) {
            JsfLibraryDirectoryReference.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public LocalQuickFix[] getQuickFixes() {
        Set<PsiDirectory> context = JsfCommonUtils.getTopLevelLibraryDirectories(ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getElement()));
        for (PsiDirectory psiDirectory : context) {
            if (!psiDirectory.isWritable() || !psiDirectory.getVirtualFile().getFileSystem().isValidName(this.getValue())) continue;
            return new LocalQuickFix[]{JsfResourceDirectoryReference.createSubDirectoryLocalQuickFix(psiDirectory, this.getValue())};
        }
        return LocalQuickFix.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/jsf/references/JsfLibraryDirectoryReference";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

