/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.highlighting.xml;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.jsf.highlighting.FacesHighlightingVisitor;
import com.intellij.jsf.highlighting.xml.JsfDomModelInspection;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementsAnnotator;

public class FacesElementsAnnotator
implements DomElementsAnnotator {
    public void annotate(DomElement element, DomElementAnnotationHolder problemsHolder) {
        HighlightDisplayLevel displayLevel = FacesElementsAnnotator.getHighlightDisplayLevel(DomUtil.getFile((DomElement)element));
        if (displayLevel.equals(HighlightDisplayLevel.DO_NOT_SHOW)) {
            return;
        }
        element.accept((DomElementVisitor)new FacesHighlightingVisitor(problemsHolder));
    }

    private static HighlightDisplayLevel getHighlightDisplayLevel(XmlFile file) {
        JsfDomModelInspection inspectionTool = new JsfDomModelInspection();
        HighlightDisplayKey key = HighlightDisplayKey.find((String)inspectionTool.getShortName());
        InspectionProfileImpl profile = InspectionProjectProfileManager.getInstance((Project)file.getProject()).getCurrentProfile();
        HighlightDisplayLevel level = !profile.isToolEnabled(key, (PsiElement)file) ? HighlightDisplayLevel.DO_NOT_SHOW : profile.getErrorLevel(key, (PsiElement)file);
        return level;
    }
}

