/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.composite.references;

import com.intellij.jsf.composite.CompositeUtil;
import com.intellij.jsf.references.JsfXmlAttributeReferencesProvider;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCompositeVariantsReferenceProvider
extends JsfXmlAttributeReferencesProvider {
    private static final String NAME_ATTRIBUTE = "name";
    private final Function<XmlFile, Map<String, PsiElement>>[] myVariantsMapFunction;
    protected static final Function<XmlFile, Map<String, PsiElement>> VALUE_HOLDERS_FUNCTION = xmlFile -> AbstractCompositeVariantsReferenceProvider.getValueHoldersByNameMap(xmlFile);
    protected static final Function<XmlFile, Map<String, PsiElement>> ACTION_SOURCE_HOLDERS_FUNCTION = xmlFile -> AbstractCompositeVariantsReferenceProvider.getActionSourcesByNameMap(xmlFile);

    protected AbstractCompositeVariantsReferenceProvider(Function<XmlFile, Map<String, PsiElement>> ... variantsMap) {
        this.myVariantsMapFunction = variantsMap;
    }

    @Override
    protected PsiReference[] createReferences(@NotNull XmlAttributeValue xmlAttributeValue, ProcessingContext context) {
        if (xmlAttributeValue == null) {
            AbstractCompositeVariantsReferenceProvider.$$$reportNull$$$0(0);
        }
        return new PsiReference[]{this.createCompositeComponentValueHolderReference(xmlAttributeValue, context)};
    }

    private PsiReference createCompositeComponentValueHolderReference(final XmlAttributeValue xmlAttributeValue, ProcessingContext context) {
        return new PsiReferenceBase<PsiElement>((PsiElement)xmlAttributeValue){

            public PsiElement resolve() {
                String value = xmlAttributeValue.getValue();
                if (StringUtil.isEmptyOrSpaces((String)value)) {
                    return null;
                }
                XmlFile file = AbstractCompositeVariantsReferenceProvider.this.getCompositeComponentXmlFile((PsiElement)xmlAttributeValue);
                if (file == null) {
                    return null;
                }
                return (PsiElement)AbstractCompositeVariantsReferenceProvider.this.getVariansMap(file).get(value);
            }

            public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
                if (newElementName == null) {
                    1.$$$reportNull$$$0(0);
                }
                return super.handleElementRename(newElementName);
            }

            @NotNull
            public Object[] getVariants() {
                XmlFile file = AbstractCompositeVariantsReferenceProvider.this.getCompositeComponentXmlFile((PsiElement)xmlAttributeValue);
                if (file == null) {
                    if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return ArrayUtil.EMPTY_OBJECT_ARRAY;
                }
                Set set = AbstractCompositeVariantsReferenceProvider.this.getVariansMap(file).keySet();
                Object[] objectArray = ArrayUtil.toStringArray(set);
                if (objectArray == null) {
                    1.$$$reportNull$$$0(2);
                }
                return objectArray;
            }

            public boolean isSoft() {
                return AbstractCompositeVariantsReferenceProvider.this.isSoftRefrence();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "newElementName";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/jsf/composite/references/AbstractCompositeVariantsReferenceProvider$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/jsf/composite/references/AbstractCompositeVariantsReferenceProvider$1";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getVariants";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "handleElementRename";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @NotNull
    private Map<String, PsiElement> getVariansMap(@NotNull XmlFile file) {
        if (file == null) {
            AbstractCompositeVariantsReferenceProvider.$$$reportNull$$$0(1);
        }
        HashMap<String, PsiElement> results = new HashMap<String, PsiElement>();
        for (Function<XmlFile, Map<String, PsiElement>> xmlFileMapFunction : this.myVariantsMapFunction) {
            results.putAll((Map)xmlFileMapFunction.fun((Object)file));
        }
        HashMap<String, PsiElement> hashMap = results;
        if (hashMap == null) {
            AbstractCompositeVariantsReferenceProvider.$$$reportNull$$$0(2);
        }
        return hashMap;
    }

    protected boolean isSoftRefrence() {
        return false;
    }

    @NotNull
    private static Map<String, PsiElement> getValueHoldersByNameMap(@NotNull XmlFile file) {
        if (file == null) {
            AbstractCompositeVariantsReferenceProvider.$$$reportNull$$$0(3);
        }
        HashMap<String, PsiElement> map = new HashMap<String, PsiElement>();
        Set<XmlTag> tags = CompositeUtil.getValueHolderCompositeComponentInterfaceTags(file);
        for (XmlTag tag : tags) {
            String value;
            XmlAttribute attribute = tag.getAttribute(NAME_ATTRIBUTE);
            if (attribute == null || StringUtil.isEmptyOrSpaces((String)(value = attribute.getValue()))) continue;
            map.put(value, (PsiElement)attribute.getValueElement());
        }
        HashMap<String, PsiElement> hashMap = map;
        if (hashMap == null) {
            AbstractCompositeVariantsReferenceProvider.$$$reportNull$$$0(4);
        }
        return hashMap;
    }

    @NotNull
    private static Map<String, PsiElement> getActionSourcesByNameMap(@NotNull XmlFile file) {
        if (file == null) {
            AbstractCompositeVariantsReferenceProvider.$$$reportNull$$$0(5);
        }
        HashMap<String, PsiElement> map = new HashMap<String, PsiElement>();
        Set<XmlTag> tags = CompositeUtil.getActionSourceCompositeComponentInterfaceTags(file);
        for (XmlTag tag : tags) {
            String value;
            XmlAttribute attribute = tag.getAttribute(NAME_ATTRIBUTE);
            if (attribute == null || StringUtil.isEmptyOrSpaces((String)(value = attribute.getValue()))) continue;
            map.put(value, (PsiElement)attribute.getValueElement());
        }
        HashMap<String, PsiElement> hashMap = map;
        if (hashMap == null) {
            AbstractCompositeVariantsReferenceProvider.$$$reportNull$$$0(6);
        }
        return hashMap;
    }

    @Nullable
    protected abstract XmlFile getCompositeComponentXmlFile(PsiElement var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlAttributeValue";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jsf/composite/references/AbstractCompositeVariantsReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jsf/composite/references/AbstractCompositeVariantsReferenceProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariansMap";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueHoldersByNameMap";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionSourcesByNameMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createReferences";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getVariansMap";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getValueHoldersByNameMap";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getActionSourcesByNameMap";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

